/****************************************************************************/
/* SCREEN                                                                   */
/*--------------------------------------------------------------------------*/
/* Microsoft Windows-related functions                                      */
/*--------------------------------------------------------------------------*/
/* Author      : DELPRAT Jean-Pierre                                        */
/* Crated on   : 01/27/97                                                   */
/****************************************************************************/

#include "Compat.h"

#include "Mouse.h"
#include "Screen.h"

#include "Windows.h"


/*ͻ*/
/*                                 CONSTANTS                              */
/*ͼ*/

// Video interrupt

#define INT_MULTIPLEXER 0x2F

/*ͻ*/
/*                                 FONCTIONS                              */
/*ͼ*/

/****************************************************************************/
/* RunningUnderWindows                                            	    */
/*--------------------------------------------------------------------------*/
/* Is the program running under Windows ?				    */
/****************************************************************************/

boolean RunningUnderWindows()
{
  __dpmi_regs regs;

  regs.x.ax = 0x160A;
  __dpmi_int(INT_MULTIPLEXER, &regs);

  return((boolean)(regs.x.ax==0));
}

/****************************************************************************/
/* SetDosBoxMode                                                            */
/*--------------------------------------------------------------------------*/
/* Configures JPTUI to be ran in a DOS box under Windows                    */
/****************************************************************************/

void SetDosBoxMode()
{
  SetMousePointerAspect(MPA_MOUSE_DRIVER);
  SetFont(FONT_STANDARD);
}

/****************************************************************************/
/* SetFullScreenMode							    */
/*--------------------------------------------------------------------------*/
/* Configures JPTUI to be ran in full screen mode (under Windows or not)    */
/* If the application is running in a window, it is forced to full screen   */
/****************************************************************************/

void SetFullScreenMode()
{
  __dpmi_regs regs;

  // Passe en plein ecran

  if (RunningUnderWindows())
    {

      regs.x.ax = 0x168B;
      regs.x.bx = 0;
      __dpmi_int(INT_MULTIPLEXER, &regs);
    }


  // Configure JPTUI

  SetMousePointerAspect(MPA_GRAPHICAL);
  SetFont(FONT_JPTUI);
}
