/****************************************************************************/
/* TWINDOW                                                                  */
/*--------------------------------------------------------------------------*/
/* Objet TWindow (fentre)                                                  */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 10/01/96                                                    */
/****************************************************************************/

#include <dos.h>
#include <stdlib.h>

#include "Const.h"
#include "JPDebug.h"

#include "JPAppli.h"

#include "Callback.h"
#include "Cursor.h"
#include "Mouse.h"
#include "Screen.h"
#include "SpChars.h"
#include "Strings.h"

#include "TApplica.h"
#include "TPushBut.h"

#include "TWindow.h"

/*ͻ*/
/*                           METHODES PUBLIQUES                           */
/*ͼ*/

/****************/
/* Constructeur */
/* ------------ */
/****************************************************************************/
/* style            : Style de la fentre                                   */
/* x,y              : Position de la fentre dans l'cran                   */
/* width,height     : Dimensions de la fentre                              */
/* caption          : Lgende de la fentre                                 */
/* info_bar         : Il y a une barre d'information ou pas                 */
/* modal            : Fentre modale ou non                                 */
/* movable          : Fentre dplaable ou non				    */
/****************************************************************************/

TWindow::TWindow(unsigned style,
		 int x,int y,
		 int width,int height,
		 char *caption,
		 boolean info_bar,
		 boolean modal,
		 boolean movable)
	:TGroup(NULL,
		OBJ_WINDOW,
		0,0,
		width,height,
		style,
		caption,
		ENABLED,
		(boolean)(caption[0]!=0),  // FOCUS_DEPENDING_ASPECT
		TRUE,  // CAN_BE_ENABLED
		TRUE)  // NEED_FOCUSED_ELEMENT
{
  // Application auquel appartient la fentre

  JPDEBUG_TEST(DEBUG_ERROR_10,JPApplication!=NULL);

  // Position de la fentre dans l'cran

  f_x=x;
  f_y=y;

  // Il y a une barre d'information

  f_info_bar=info_bar;
  f_info_message=NULL;

  // La fentre est modale

  f_modal=modal;

  // La fentre est dplaable

  f_movable=movable;

  // La fentre est active

  f_active=FALSE;

  // Objet qui gre les acclrateurs de la fentre

  f_short_cut_handler=NULL;

  // Boutons spciaux de la fentre

  f_default_button=NULL;
  f_ok_button=NULL;
  f_cancel_button=NULL;

  // Couleur de fond du titre quand il a le focus

  f_title_attribute=(WHITE<<4)+(unsigned)BLUE;

  // Couleur d'affichage de la bordure

  f_border_attribute=(f_background<<4)+(unsigned)WHITE;

  // Contenu de la fentre

  f_window_content=NULL;

  // Le contenu a chang depuis le dernier rafrachissement

  f_content_changed=FALSE;
  f_changed_zone.x1=0;
  f_changed_zone.y1=0;
  f_changed_zone.x2=0;
  f_changed_zone.y2=0;

  // Limites d'affichage du texte

  m_reset_clip_window();

  // attribut d'affichage

  m_set_normal_attr(f_background);

  // Curseur de la fentre

  f_cursor_ptr=NULL;
  f_x_cursor=0;
  f_y_cursor=0;

  // Objet de la fentre qui avait le focus avant que le focus ne change
  // d'objet dans la fentre

  f_previous_focused_object=NULL;

  // Callbacks

  InitCallback(f_close_button_pressed_action,f_close_button_pressed_argument);

  // Numro de la fentre dans l'application

  f_window_number=(JPApplication->m_add_window(this));
}

/***************/
/* Destructeur */
/* ----------- */
/***************/

TWindow::~TWindow()
{
  JPDEBUG_TEST(DEBUG_ERROR_11,!f_open);

  // Suppression de la fentre de l'application

  JPApplication->m_del_window(f_window_number);

  // Destruction des variables dynamiques

  DestroyCallback(f_close_button_pressed_action,f_close_button_pressed_argument);

  if (f_window_content!=NULL)
    {
      delete []f_window_content;
      f_window_content=NULL;
    }

  if (f_info_message!=NULL)
    {
      delete []f_info_message;
      f_info_message=NULL;
    }
}

/****************************************************************************/
/* m_set_pos                                                                */
/*--------------------------------------------------------------------------*/
/* Fixe la position de la fentre (si elle est ferme et les coord. valides.*/
/****************************************************************************/

void TWindow::m_set_pos(int x,int y)
{
  if (   (f_open)
      && ((x!=f_x)||(y!=f_y)))
    {
      JPApplication->m_add_zone_to_refresh(MIN(x,f_x),
                                           MIN(y,f_y),
                                           MAX(x,f_x)+f_width+1, // Ombre de 2 !
                                           MAX(y,f_y)+f_height,  // Ombre de 1 !
                                           JPApplication->m_window_nb_to_height(f_window_number));

      SetTextCursorAt(GetXTextCursor()+x-f_x,
		      GetYTextCursor()+y-f_y);
    }

  f_x=x;
  f_y=y;
}

/************************************************/
/* m_set_default_button : Dfinit le PushButton */
/* --------------------   par dfaut            */
/************************************************/

void TWindow::m_set_default_button(PPushButton button)
{
  f_default_button=button;

  if (f_ok_button==NULL)
    m_set_ok_button(button);
}

/***********************************************/
/* m_set_cancel_button : Dfinit le PushButton */
/* -------------------   activable par ESC     */
/***********************************************/

void TWindow::m_set_cancel_button(PPushButton button)
{
  if (f_cancel_button!=NULL)
    f_cancel_button->m_lose_cancel();
  f_cancel_button=button;
  if (f_cancel_button!=NULL)
    f_cancel_button->m_take_cancel();
}

/**********************************************************/
/* m_set_focus : Donne le focus  la fentre, ie au       */
/* -----------   premier objet possible qu'elle contient. */
/*               Retourne TRUE en cas de russite         */
/*               (IMPORTANT : toujours pour la fentre)   */
/**********************************************************/

boolean TWindow::m_set_focus()
{
  boolean focus_taken=FALSE;


  // Si bouton par dfaut -> devient en mme temps le ok_button

  if (f_default_button!=NULL)
    focus_taken=f_default_button->m_set_focus();

  // Le focus est pris par le premier object possible

  if (!focus_taken)
    {
      // Cas des fentres dont aucun objet ne veut le focus
      if (!TGroup::m_set_focus())
	{
	  // La fentre n'est contenue par aucun groupe

	  m_take_focus();
          f_focused_element=NULL;
        }
    }

  return(TRUE);
}

/*************************************************************************/
/* m_set_focus_to_last_element : Donne le focus  la fentre, ie au       */
/* --------------------------   dernier objet possible qu'elle contient. */
/*                              Retourne TRUE en cas de russite         */
/*                              (IMPORTANT : toujours pour la fentre)   */
/*************************************************************************/

boolean TWindow::m_set_focus_to_last_element()
{
  if (!TGroup::m_set_focus_to_last_element())
    {
      // La fentre n'est contenue par aucun groupe

      m_take_focus();
      f_focused_element=NULL;
    }

  return(TRUE);
}

/****************************************************************************/
/* m_activate                                                               */
/*--------------------------------------------------------------------------*/
/* Rend la fentre active (si possible)                                     */
/****************************************************************************/

boolean TWindow::m_activate()
{
  return(JPApplication->m_set_active_window(f_window_number));
}

/*************************/
/* m_open : Ouverture de */
/* ------   la fentre   */
/*************************/

void TWindow::m_open()
{
  m_open_as_object_element(NULL);
}

void TWindow::m_open_as_object_element(PObject object)
{
  JPApplication->m_open_window(f_window_number,object);
}

/****************************************************************************/
/* m_close								    */
/*--------------------------------------------------------------------------*/
/* Fermeture de la fentre 		                                    */
/****************************************************************************/

void TWindow::m_close()
{
  if (!f_open)
    return;

  JPApplication->m_close_window(f_window_number);
}


/****************************************************************************/
/* m_set_info_message                                                       */
/*--------------------------------------------------------------------------*/
/* Modification du message d'information (si la barre d'information existe) */
/****************************************************************************/

void TWindow::m_set_info_message(char *message)
{
  if (!f_info_bar)
    return;

  if (f_info_message!=NULL)
    delete []f_info_message;

  f_info_message=new char [strlen(message)+1];
  strcpy(f_info_message,message);

  m_display_info_bar();
}

/****************************************************************************/
/* m_get_info_message                                                       */
/*--------------------------------------------------------------------------*/
/* Returns the info message                                                 */
/****************************************************************************/

char *TWindow::m_get_info_message()
{
  return((f_info_message==NULL)?"":f_info_message);
}



/*******************************************/
/* m_gotoxy : Dplace le curseur de la     */
/* --------   fentre en x,y (p/r au coin  */
/*            haut-gauche de la fentre)   */
/*******************************************/

void TWindow::m_gotoxy(int x,int y)
{
  if (!f_open)
    return;

  f_cursor_ptr=f_window_content+(y*f_width)+x;

  f_x_cursor=x;
  f_y_cursor=y;
}

/***********************************************/
/* m_textattr : Dfinit l'attribut d'affichage */
/* ----------   du texte dans la fentre       */
/***********************************************/

void TWindow::m_textattr(unsigned attribute)
{
  f_text_attribute=attribute;
}

/****************************************************************************/
/* m_get_..._attr                                                           */
/*--------------------------------------------------------------------------*/
/* Retourne un attribut d'affichage du texte dans un style prdfini en     */
/* fonction du style de la fentre                                          */
/****************************************************************************/

unsigned TWindow::m_get_normal_attr(unsigned background)
{
  if (background <=LIGHTBLUE)
    return((background<<4)+(unsigned)WHITE);
  return((background<<4)+(unsigned)BLACK);
}

unsigned TWindow::m_get_inverse_attr(unsigned /*background*/)
{
  return((BLACK<<4)+(unsigned)WHITE);
}

unsigned TWindow::m_get_bright_attr(unsigned background)
{
  if (background<=LIGHTBLUE)
    return((background<<4)+(unsigned)YELLOW);
  return((background<<4)+(unsigned)LIGHTBLUE);
}

unsigned TWindow::m_get_inverse_bright_attr(unsigned background)
{
  if (background<=LIGHTBLUE)
    return((BLACK<<4)+(unsigned)YELLOW);
  return((BLACK<<4)+(unsigned)LIGHTBLUE);

}

unsigned TWindow::m_get_inactive_attr(unsigned background)
{
  return((background<<4)+(unsigned)LIGHTGRAY);
}

unsigned TWindow::m_get_inverse_inactive_attr(unsigned /*background*/)
{
  return((BLACK<<4)+(unsigned)LIGHTGRAY);
}

/**********************************************************/
/* m_set_clip_window : Dfinition des limites d'affichage */
/* -----------------   du texte dans la fentre           */
/**********************************************************/

void TWindow::m_set_clip_window(int x,int y,int width,int height)
{
  // Valeurs invalides -> on corrige

  if (x<0)
    x=0;

  if (y<0)
    y=0;

  if (width<0)
    width=0;

  if (height<0)
    height=0;

  if ((x+width)>f_width)
    width=f_width-x;

  if ((y+height)>f_height)
    height=f_height-y;

  f_clip_window.x1=x;
  f_clip_window.y1=y;
  f_clip_window.x2=x+width-1;
  f_clip_window.y2=y+height-1;

}

/*****************************************************************/
/* m_reset_clip_window : Remet les limites d'affichages du texte */
/* -------------------   dans la fentre  la fentre complte   */
/*****************************************************************/

void TWindow::m_reset_clip_window()
{
  m_set_clip_window(0,0,f_width,f_height);
}

/****************************************************************************/
/* m_cls                                                                    */
/*--------------------------------------------------------------------------*/
/* Efface le contenu de la fentre                                          */
/****************************************************************************/

void TWindow::m_cls(unsigned background)
{
  register word *ptr,y;
  word character;
  word *start_ptr,*end_ptr;

  if (!f_open)
    return;

  character=(background<<12)+(u_char)' ';
  start_ptr=f_window_content+(f_clip_window.y1*f_width)+f_clip_window.x1;
  end_ptr=start_ptr+f_clip_window.x2-f_clip_window.x1;

  for (y=f_clip_window.y1;y<=f_clip_window.y2;y++,start_ptr+=f_width,end_ptr+=f_width)
    for (ptr=start_ptr;ptr<=end_ptr;)
      (*ptr++)=character;

  if (f_content_changed)
    {
      f_changed_zone.x1=MIN(f_changed_zone.x1,f_clip_window.x1);
      f_changed_zone.y1=MIN(f_changed_zone.y1,f_clip_window.y1);
      f_changed_zone.x2=MAX(f_changed_zone.x2,f_clip_window.x2);
      f_changed_zone.y2=MAX(f_changed_zone.y2,f_clip_window.y2);
    }
  else
    {
      f_content_changed=TRUE;
      f_changed_zone.x1=f_clip_window.x1;
      f_changed_zone.y1=f_clip_window.y1;
      f_changed_zone.x2=f_clip_window.x2;
      f_changed_zone.y2=f_clip_window.y2;
    }

}

/**************************************/
/* m_putch : Affichage d'un caractre */
/* -------   dans la fentre          */
/**************************************/

void TWindow::m_putch(u_char character)
{
  if (!f_open)
    return;

  // On veut afficher au-dessus ou en-dessous de la ClipWindow

  if (   (f_y_cursor<f_clip_window.y1)
      || (f_y_cursor>f_clip_window.y2))
    {
      f_x_cursor++;
      f_cursor_ptr++;
      return;
    }

  // On veut afficher  gauche ou  droite de la ClipWindow

  if (   (f_x_cursor<f_clip_window.x1)
      || (f_x_cursor>f_clip_window.x2))
    {
      f_x_cursor++;
      f_cursor_ptr++;
      return;
    }

  // Sinon, on affiche

  (*f_cursor_ptr)=(f_text_attribute<<8)+character;

  if (f_content_changed)
    {
      f_changed_zone.x1=MIN(f_changed_zone.x1,f_x_cursor);
      f_changed_zone.y1=MIN(f_changed_zone.y1,f_y_cursor);
      f_changed_zone.x2=MAX(f_changed_zone.x2,f_x_cursor);
      f_changed_zone.y2=MAX(f_changed_zone.y2,f_y_cursor);
    }
  else
    {
      f_content_changed=TRUE;
      f_changed_zone.x1=f_x_cursor;
      f_changed_zone.y1=f_y_cursor;
      f_changed_zone.x2=f_x_cursor;
      f_changed_zone.y2=f_y_cursor;
    }

  f_x_cursor++;
  f_cursor_ptr++;
}

/****************************************************************************/
/* m_putnch                                                                 */
/*--------------------------------------------------------------------------*/
/* Affichage plusieurs caractres identiques dans la fentre                */
/****************************************************************************/

void TWindow::m_putnch(int nb_chars,u_char character)
{
  word *last_char_ptr,
       *ptr;

  int  x_first_char,
       x_last_char;

  int  clip_window_width;

  int  nb_lost_chars;
  int  nb_chars_to_put;

  word ch=(f_text_attribute<<8)+character;

  if (!f_open)
    return;

  if (nb_chars<=0)
    return;

  // On veut afficher au-dessus ou en-dessous de la ClipWindow

  if (   (f_y_cursor<f_clip_window.y1)
      || (f_y_cursor>f_clip_window.y2))
    {
      f_x_cursor+=nb_chars;
      f_cursor_ptr+=nb_chars;
      return;
    }

  // L'affichage de la chane commence  gauche de la ClipWindow

  if (f_x_cursor<f_clip_window.x1)
    {
      // Tout est  gauche -> rien  afficher

      nb_lost_chars=f_clip_window.x1-f_x_cursor;

      if (nb_chars<=nb_lost_chars)
	{
	  f_x_cursor+=nb_chars;
	  f_cursor_ptr+=nb_chars;
	  return;
	}

      // Sinon, on laisse tomber ce qui est  gauche

      nb_chars-=nb_lost_chars;
      f_cursor_ptr+=nb_lost_chars;
      f_x_cursor+=nb_lost_chars;
    }

  // On affiche ce qui tient dans la ClipWindow

  clip_window_width=f_clip_window.x2-f_x_cursor+1;
  nb_chars_to_put=MIN(clip_window_width,nb_chars);
  last_char_ptr=f_cursor_ptr+nb_chars_to_put;

  x_first_char=f_x_cursor;

  for (ptr=f_cursor_ptr;ptr<last_char_ptr;ptr++)
    (*ptr)=ch;

  x_last_char=f_x_cursor+(int)(last_char_ptr-f_cursor_ptr)-1;

  f_x_cursor+=nb_chars;
  f_cursor_ptr+=nb_chars;

  // Mise  jour de la zone  rafrachir

  if (f_content_changed)
    {
      f_changed_zone.x1=MIN(f_changed_zone.x1,x_first_char);
      f_changed_zone.x2=MAX(f_changed_zone.x2,x_last_char);

      f_changed_zone.y1=MIN(f_changed_zone.y1,f_y_cursor);
      f_changed_zone.y2=MAX(f_changed_zone.y2,f_y_cursor);
    }

  else
    {
      f_content_changed=TRUE;
      f_changed_zone.x1=x_first_char;
      f_changed_zone.x2=x_last_char;
      f_changed_zone.y1=f_y_cursor;
      f_changed_zone.y2=f_y_cursor;
    }
}

/********************************************************************/
/* m_puts : Affichage d'une chane de caractres                    */
/* ------   dans la fentre (sans caractres spciaux (CrLf,Tab...) */
/********************************************************************/

void TWindow::m_puts(char *string)
{
  word *last_char_ptr,
       *ptr;

  int  x_first_char,
       x_last_char;

  int  string_length;
  int  clip_window_width;

  int  nb_lost_chars;
  int  nb_chars_to_put;

  if (!f_open)
    return;

  string_length=strlen(string);

  // On veut afficher au-dessus ou en-dessous de la ClipWindow

  if (   (f_y_cursor<f_clip_window.y1)
      || (f_y_cursor>f_clip_window.y2))
    {
      f_x_cursor+=string_length;
      f_cursor_ptr+=string_length;
      return;
    }

  // L'affichage de la chane commence  gauche de la ClipWindow

  if (f_x_cursor<f_clip_window.x1)
    {
      // Tout est  gauche -> rien  afficher

      nb_lost_chars=f_clip_window.x1-f_x_cursor;

      if (string_length<=nb_lost_chars)
	{
	  f_x_cursor+=string_length;
	  f_cursor_ptr+=string_length;
	  return;
	}

      // Sinon, on laisse tomber ce qui est  gauche

      string+=nb_lost_chars;
      string_length-=nb_lost_chars;
      f_cursor_ptr+=nb_lost_chars;
      f_x_cursor+=nb_lost_chars;
    }

  // On affiche ce qui tient dans la ClipWindow

  clip_window_width=f_clip_window.x2-f_x_cursor+1;
  nb_chars_to_put=MIN(clip_window_width,string_length);
  last_char_ptr=f_cursor_ptr+nb_chars_to_put;

  x_first_char=f_x_cursor;

  for (ptr=f_cursor_ptr;ptr<last_char_ptr;ptr++,string++)
    (*ptr)=(f_text_attribute<<8)+(u_char)(*string);

  x_last_char=f_x_cursor+(int)(last_char_ptr-f_cursor_ptr)-1;

  f_x_cursor+=string_length;
  f_cursor_ptr+=string_length;

  // Mise  jour de la zone  rafrachir

  if (f_content_changed)
    {
      f_changed_zone.x1=MIN(f_changed_zone.x1,x_first_char);
      f_changed_zone.x2=MAX(f_changed_zone.x2,x_last_char);

      f_changed_zone.y1=MIN(f_changed_zone.y1,f_y_cursor);
      f_changed_zone.y2=MAX(f_changed_zone.y2,f_y_cursor);
    }

  else
    {
      f_content_changed=TRUE;
      f_changed_zone.x1=x_first_char;
      f_changed_zone.x2=x_last_char;
      f_changed_zone.y1=f_y_cursor;
      f_changed_zone.y2=f_y_cursor;
    }
}

/*********************************************************/
/* m_put_caption : Affiche une chane dans la fentre en */
/* -------------   tenant compte de la hot-key, et en    */
/*                 l'ajustant  la taille indique       */
/*********************************************************/
/* Seul le premier caractre prcd de ~ apparat       */
/* en vidence (la hot-key)                              */
/* Pour afficher le signe ~ -> ~~ ou ~ en fin de chaine  */
/* length est la longueur d'affichage de l'ensemble      */
/* position est la position de la chane (cf .h)         */
/* Si show_hot_key est FALSE, la hot-key                 */
/* n'est pas mise en vidence                            */
/*********************************************************/

void TWindow::m_put_caption(char *main_string,
			    boolean show_hot_key,
			    int length,int position)

{
  int normal_attribute=f_text_attribute;

  boolean hot_key_shown;

  int main_length;

  int nb_spaces;

  int nb_spaces_before=0,
      nb_spaces_after;

  int nb_chars_put;

  if (!f_open)
    return;

  hot_key_shown=FALSE;
  main_length=DisplayLength(main_string);
  nb_spaces=length-main_length;
  nb_chars_put=0;

  switch (position)
    {
      case CENTERED_LEFT : if (nb_spaces>=0)
			     position=CENTERED;
			   else
			     position=LEFT;
			   break;

      case CENTERED_RIGHT: if (nb_spaces>=0)
			     position=CENTERED;
			   else
			     position=RIGHT;
			   break;
    }

  switch (position)
    {
      case CENTERED        : nb_spaces_before=nb_spaces>>1;
			     break;

      case JUSTIFIED_LEFT  : nb_spaces_before=0;
			     break;

      case JUSTIFIED_RIGHT : nb_spaces_before=nb_spaces;
			     break;
    }


  nb_spaces_after=nb_spaces-nb_spaces_before;

  // Espaces affichs avant

  while (nb_spaces_before>0)
    {
      m_putch(' ');
      nb_chars_put++;
      nb_spaces_before--;
    }


  // Chane principale

  if (nb_spaces_before<0)
    main_string-=nb_spaces_before;

  while (((*main_string)!=0) && (nb_chars_put<length))
    {
      if (*main_string=='~')
	{

	  main_string++;

          switch (*main_string) // Caractre qui suit le ~
            {
              case 0  : m_putch('~');
                        nb_chars_put++;
                        break;

              case '~': m_putch('~');
                        nb_chars_put++;
                        main_string++;
                        break;

	      default :if ( (show_hot_key) && (!hot_key_shown))
	                  f_text_attribute=(f_text_attribute & 0xF8)+RED;

	                m_putch(*main_string);
	                hot_key_shown=TRUE;
	                nb_chars_put++;
	                f_text_attribute=normal_attribute;
	                main_string++;
            }
	}
      else
	{
	  m_putch(*main_string);
	  main_string++;
	  nb_chars_put++;
	}
    }

  // Espaces affichs aprs

  while (nb_spaces_after>0)
    {
      m_putch(' ');
      nb_chars_put++;
      nb_spaces_after--;
    }
}

/*********************************************************/
/* m_put_text : Affiche le texte contenu dans une chaine */
/* ----------   en tenant compte des caractres spciaux */
/*              (cf Strings.h)                           */
/*********************************************************/

void TWindow::m_put_text(char *text)
{
  boolean  done;

  char     *end_of_line;
  char      end_character;

  char     *ptr;

  int       x,y;

  // Fentre non ouverte

  if (!f_open)
    return;

  // Parcours sur toutes les lignes  afficher

  if (text[0]==0)
    return;

  done=FALSE;
  x=f_x_cursor;
  y=f_y_cursor;

  while (!done)
    {
      end_of_line=strchr(text,'\n');
      if (end_of_line==NULL)
	{
	  done=TRUE;
	  end_of_line=strchr(text,0);
	}
      end_character=(*end_of_line);
      (*end_of_line)=0;


      /*-----------------------*/
      /* Affichage d'une ligne */
      /*-----------------------*/

      m_gotoxy(x,y);
      while ((*text)!=0)
	{
          // Caractres spciaux

	  if ((*text)=='[')
	    {
	      switch (text[1])
                {
                  case 0  : m_putch('[');
                            break;

                  case '[': m_putch('[');
                            text++;
                            break;


                  default : ptr=strchr(text,']');
                            if (ptr==NULL)  // Squence incomplte,
                              {             // on affiche ses caractres
                                m_putch('[');
                                text++;
                              }
                            else
                              {
                                switch (text[1])
                                  {
                                    case 'c' : f_text_attribute=
                                                  (f_text_attribute & 0xF0)
				                + (HexaToInt(text[2]));
                                               break;
                                    case 'a' : f_text_attribute=
						 HexaToInt(text[2])*16
                                                +HexaToInt(text[3]);
                                               break;
                                  }
                                text=ptr;
                              }
                            break;
                }
            }
	  else
	    m_putch(*text);

	  text++;
	}

      /*------------------------------*/
      /* On passe  la ligne suivante */
      /*------------------------------*/

      (*end_of_line)=end_character;
      text=end_of_line+1;
      y++;
      if (y>f_clip_window.y2)
	done=TRUE;
   }
}

/***************************************/
/* m_draw_frame : Affichage d'un cadre */
/* ------------   avec sa lgende      */
/***************************************/

void TWindow::m_draw_frame(int x1,int y1,int x2,int y2,unsigned background,char *caption,boolean enabled)
{
  register int i;
  int          caption_length=DisplayLength(caption);
  int          chars_put;

  char         char_left,char_right;

  if (!f_open)
    return;

  if (!enabled)
    m_set_inactive_attr(background);
  else
    m_set_normal_attr(background);

  m_gotoxy(x1,y1);

  m_putch('');

  if (caption_length!=0)
    {
      chars_put=x2-x1-3;
      chars_put=MIN(chars_put,caption_length);
      m_putch(' ');
      if (enabled)
	m_set_bright_attr(background);
      m_put_caption(caption,
		    enabled,
		    chars_put,
		    JUSTIFIED_LEFT);
      if (enabled)
	m_set_normal_attr(background);
      m_putch(' ');
      chars_put+=2;
    }
  else
    chars_put=0;

  m_putnch(x2-x1-1-chars_put,'');

  m_putch(SPECIAL_CHAR(SCH_FRAME_UP_RIGHT));

  char_left = SPECIAL_CHAR(SCH_FRAME_LEFT);
  char_right= SPECIAL_CHAR(SCH_FRAME_RIGHT);
  for (i=y1+1;i<y2;i++)
    {
      m_gotoxy(x1,i);
      m_putch(char_left);
      m_gotoxy(x2,i);
      m_putch(char_right);
    };

  m_gotoxy(x1,i);
  m_putch(SPECIAL_CHAR(SCH_FRAME_BOTTOM_LEFT));
  m_putnch(x2-x1-1,SPECIAL_CHAR(SCH_FRAME_BOTTOM));
  m_putch(SPECIAL_CHAR(SCH_FRAME_BOTTOM_RIGHT));
}

/********************************************/
/* m_display_arrow : Affichage d'une flche */
/* ---------------   (types dans le .h)     */
/********************************************/

void TWindow::m_display_arrow(int arrow_type)
{
  char *arrow;

  switch (arrow_type)
    {
      case ARROW_UP    : arrow=SPECIAL_STRING(SST_ARROW_UP);break;
      case ARROW_DOWN  : arrow=SPECIAL_STRING(SST_ARROW_DOWN);break;
      case ARROW_LEFT  : arrow=SPECIAL_STRING(SST_ARROW_LEFT);break;
      case ARROW_RIGHT : arrow=SPECIAL_STRING(SST_ARROW_RIGHT);break;
      default : return;
    }

  m_puts(arrow);
}

/*************************************************************************/
/* m_set_close_button_pressed_callback : Dfinition du callback associ  */
/* -----------------------------------   au clic sur l'icone de fermeture*/
/*************************************************************************/

void TWindow::m_set_close_button_pressed_callback(void (*close_button_pressed_action)(PObject,char *),
						  char *close_button_pressed_argument)
{

  // Une fentre sans titre ne peut pas avoir
  // d'icone de fermeture.

  if (f_caption[0]==0)
    return;

  SetCallback(f_close_button_pressed_action,f_close_button_pressed_argument,
              close_button_pressed_action,close_button_pressed_argument);

  m_display_close_button(FALSE);
}

/*ͻ*/
/*                           METHODES PROTEGEES                           */
/*ͼ*/

/****************************/
/* m_display : Affichage de */
/* ---------   la fentre   */
/****************************/

void TWindow::m_display()
{
  register int i;
  int  rel_x2,rel_y2;
  char char_left,char_right;

  if (!f_open)
    return;

  rel_x2=f_width-1;
  rel_y2=f_height-1;

  // On efface le contenu

  m_clear();

  // Partie dpendant du focus

  m_display_caption();

  m_textattr(f_border_attribute);

  // On n'affiche la barre du haut que s'il n'y a pas de titre

  if (f_caption[0]==0)
    {
      m_gotoxy(0,0);
      m_putch(SPECIAL_CHAR(SCH_WINDOW_UP_LEFT));
      m_putnch(f_width-2,SPECIAL_CHAR(SCH_WINDOW_UP));
      m_putch(SPECIAL_CHAR(SCH_WINDOW_UP_RIGHT));
    }

  char_left=SPECIAL_CHAR(SCH_WINDOW_LEFT);
  char_right=SPECIAL_CHAR(SCH_WINDOW_RIGHT);

  for (i=1;i<rel_y2;i++)
    {
      m_gotoxy(0,i);
      m_putch(char_left);
      m_gotoxy(rel_x2,i);
      m_putch(char_right);
    };

  // On n'affiche la barre du bas que s'il n'y a pas de barre d'information

  if (!f_info_bar)
    {
      m_gotoxy(0,rel_y2);
      m_putch(SPECIAL_CHAR(SCH_WINDOW_BOTTOM_LEFT));
      m_putnch(f_width-2,SPECIAL_CHAR(SCH_WINDOW_BOTTOM));
      m_putch(SPECIAL_CHAR(SCH_WINDOW_BOTTOM_RIGHT));
    }

  // Affichage ventuel de la barre d'information

  m_display_info_bar();

  // Affichage du contenu de la fentre

  TGroup::m_display();
}

/**********************************************************************/
/* m_display_focus_depending_part : Affichage de la partie de l'objet */
/* ------------------------------   dont l'aspect dpend du focus     */
/**********************************************************************/

void TWindow::m_display_focus_depending_part()
{
  m_display_caption();
}

/****************************************************************************/
/* m_display_caption                                                        */
/*--------------------------------------------------------------------------*/
/* Affichage de la lgende de l'objet                                       */
/****************************************************************************/

void TWindow::m_display_caption()
{
  if (!f_open)
    return;


  // S'il y a un titre

  if (f_caption[0]!=0)
    {
      m_gotoxy(0,0);
      if ((f_focused) && (f_active))
	m_textattr(f_title_attribute);
      else
	m_textattr((LIGHTGRAY<<4)+(unsigned)BLACK);

      m_put_caption(f_caption,
		    TRUE,
		    f_width,
		    CENTERED_LEFT);

      // S'il y a un icone de fermeture et si la fenetre est active

      m_display_close_button(FALSE);
    }

  // Fentre sans titre : rien  changer


}

/*********************************************************/
/* m_display_close_button : Affiche l'icone de fermeture */
/* ----------------------   de la fentre (press ou non)*/
/*********************************************************/

void TWindow::m_display_close_button(boolean pressed)
{
  if (   (!f_open) || (!f_active)
      || (f_close_button_pressed_action==NULL))
    return;

  m_gotoxy(0,0);
  if (!pressed)
    m_textattr((BLACK<<4)+(unsigned)WHITE);
  else
    m_textattr((WHITE<<4)+(unsigned)BLACK);

  m_puts(SPECIAL_STRING(SST_WINDOW_CLOSE_BUTTON));
}

/****************************************************************************/
/* m_display_info_bar                                                       */
/*--------------------------------------------------------------------------*/
/* Affiche la barre d'information 					    */
/****************************************************************************/

void TWindow::m_display_info_bar()
{
  if ((!f_open) || (!f_info_bar))
    return;

  m_gotoxy(0,f_height-1);
  m_textattr((WHITE<<4)+(unsigned)BLACK);
  m_putch(' ');
  m_put_caption(m_get_info_message(),
		FALSE,f_width-1,JUSTIFIED_LEFT);

}


/*********************************************************************/
/* m_left_button_pressed_event : L'utilisateur a cliqu dans l'objet */
/* ---------------------------   avec le bouton gauche               */
/*                               (l'objet tant activable).          */
/*                               Retourne TRUE si l'objet est        */
/*                               intress par cet vnement.        */
/*********************************************************************/

boolean TWindow::m_left_button_pressed_event(int x,int y)
{
  int new_x,new_y,new_button_state;
  boolean cursor_was_visible;

  if (TGroup::m_left_button_pressed_event(x,y))
    return(TRUE);

  // Clic sur la premire ligne de la fentre

  if (y==f_y)
    {
      // On regarde si on a clique sur l'icone de fermeture

      if (   (f_close_button_pressed_action!=NULL)
	  && (x>=f_x) && (x<=f_x+1))
	return(m_close_button_pressed_event());

      // On regarde si on a cliqu sur le titre
      // ou du moins la ligne du haut
      // -> Dplacement de la fentre

      if (f_movable)
	{
	  cursor_was_visible=TextCursorIsVisible();
	  if (cursor_was_visible)
	    HideTextCursor();

	  GetMouseState(new_x,new_y,new_button_state);

	  while (new_button_state==LEFT_BUTTON_PRESSED)
	    {
	      if ((x!=new_x)||(y!=new_y))
		{
		  m_set_pos(f_x+new_x-x,f_y+new_y-y);
		  JPRefresh();
		  x=new_x;
		  y=new_y;
		}
	      GetMouseState(new_x,new_y,new_button_state);
	    }
	  if (cursor_was_visible)
	    ShowTextCursor();
	  return(TRUE);
	}
      return(TRUE);
    }
  return(FALSE);
}

/************************************************************************/
/* m_key_pressed_event : L'utilisateur a appuy sur une touche          */
/* -------------------   qui est propose  l'objet (qui est activable) */
/*                       Retourne TRUE si l'objet est                   */
/*                       intress par cette touche.                    */
/************************************************************************/

boolean TWindow::m_key_pressed_event(TKey key)
{
  boolean event;

  if (   (f_close_button_pressed_action!=NULL)
      && (key.character==ALT_F4))
    {
      m_display_close_button(TRUE);
      JPRefresh();
      delay(PRESSURE_TIME_LENGTH);
      WaitKeyRelease();
      m_display_close_button(FALSE);
      JPRefresh();

      if (f_close_button_pressed_action!=NULL)
	CallCallback(this,f_close_button_pressed_action,f_close_button_pressed_argument);

      return(TRUE);
    }


  event = TGroup::m_key_pressed_event(key);

  if (!event)
    {
      if (f_short_cut_handler!=NULL)
	{
	  if (f_short_cut_handler->m_is_enabled())
	    {
	      if (m_short_cut_pressed_event_on(f_short_cut_handler,key.character))
		return(TRUE);
	    }
	}
    }

  return(event);
}

/*ͻ*/
/*                            METHODES PRIVEES                            */
/*ͼ*/

/****************************************************/
/* m_set_ok_button : Dfinition du bouton activable */
/* ---------------   par RETURN                     */
/****************************************************/

void TWindow::m_set_ok_button(PPushButton button)
{

  m_unset_ok_button();

  f_ok_button=button;
  if (f_ok_button!=NULL)
    f_ok_button->m_take_ok();
}

/***********************************************************/
/* m_set_ok_button_to_default : C'est le bouton par dfaut */
/* --------------------------   qui devient le ok_button   */
/***********************************************************/

void TWindow::m_set_ok_button_to_default()
{
  m_set_ok_button(f_default_button);
}

/****************************************/
/* m_unset_ok_button : Ote au ok_button */
/* -----------------   son statut       */
/****************************************/

void TWindow::m_unset_ok_button()
{
  if (f_ok_button!=NULL)
    {
      f_ok_button->m_lose_ok();
      f_ok_button=NULL;
    }
}

/****************************************************************************/
/* m_button_destructed							    */
/*--------------------------------------------------------------------------*/
/* Appele quand un bouton de la fentre est dtruit			    */
/****************************************************************************/

void TWindow::m_button_destructed(PPushButton button)
{
  if (f_default_button==button)
    f_default_button=NULL;

  if (f_ok_button==button)
    f_ok_button=NULL;

  if (f_cancel_button==button)
    f_cancel_button=NULL;
}

/******************************************/
/* m_clear : Effacement de la fentre     */
/* -------   (redessine aussi les ombres)*/
/******************************************/

void TWindow::m_clear()
{
  register word *ptr;
  word *end_ptr;
  word character;

  if (!f_open)
    return;

  ptr=f_window_content;
  end_ptr=f_window_content+((f_height-1)*f_width)+f_width;
  character=(f_background<<12)+(u_char)' ';

  while (ptr<end_ptr)
    (*ptr++)=character;

  // Attention aux ombres (affiches lors du rafrachissement)

  f_content_changed=TRUE;

  f_changed_zone.x1=0;
  f_changed_zone.x2=f_width+1; // -1 +2 pour l'ombre
  f_changed_zone.y1=0;
  f_changed_zone.y2=f_height;  // -1 +1 pour l'ombre
}

/****************************************************************************/
/* m_add_to_refresh_zone                                                    */
/*--------------------------------------------------------------------------*/
/* Rajoute la fentre dans la zone d'cran  rafrachir                     */
/****************************************************************************/

void TWindow::m_add_to_refresh_zone()
{
  JPApplication->m_add_zone_to_refresh(f_x,
				       f_y,
				       f_x+f_width+1, // Ombre de 2 !
				       f_y+f_height,  // Ombre de 1 !
				       JPApplication->m_window_nb_to_height(f_window_number)-1);
}

/********************************************************************/
/* m_part_to_screen : Transfert une partie du contenu de la fentre */
/* ----------------    l'cran (les coordonnes peuvent dborder de*/
/*                    la fentre)                                   */
/********************************************************************/

void TWindow::m_part_to_screen(int x1,int y1,int x2,int y2)
{

  int x1_refresh,
      y1_refresh,
      x2_refresh,
      y2_refresh;

  // Zone principale si on a quelque chose  afficher

  if (   (x2>=0)
      && (y2>=0)
      && (x1<f_width)
      && (y1<f_height))
    {
      x1_refresh=MAX(x1,0);
      y1_refresh=MAX(y1,0);
      x2_refresh=MIN(x2,f_width-1);
      y2_refresh=MIN(y2,f_height-1);

      PartOfBufferToScreen(f_x+x1_refresh,f_y+y1_refresh,
			  f_window_content,
			  x1_refresh,y1_refresh,
			  x2_refresh-x1_refresh+1,
			  y2_refresh-y1_refresh+1,
			  f_width);
    }
}

/**********************************************************************/
/* m_shadows_to_screen : Affiche  l'cran la partie des ombres de la */
/* -------------------   fentre comprise dans la zone indique       */
/**********************************************************************/

void TWindow::m_shadows_to_screen(int x1,int y1,int x2,int y2)
{
  if ((y2>=1) && (y1<=(f_height-1)))
    {
      if ((x1<=f_width) && (x2>=f_width))
       VerticalShadow(f_x+f_width,
		  f_y+MAX(1,y1),
		  f_y+MIN(f_height-1,y2));

      if ((x1<=(f_width+1)) && (x2>=(f_width+1)))
       VerticalShadow(f_x+f_width+1,
		  f_y+MAX(1,y1),
		  f_y+MIN(f_height-1,y2));
    }

  if ((x2>=2) && (x1<=(f_width+1)))
    if ((y1<=f_height) && (y2>=f_height))
      HorizontalShadow(f_x+MAX(2,x1),
		  f_x+MIN(x2,f_width+1),
		  f_y+f_height);

}

/****************************/
/* m_set_open : Ouvre/Ferme */
/* ----------   l'objet     */
/****************************/

void TWindow::m_set_open(boolean open)
{
  if (open==f_open)
    return;

  if (open)
    {
      DEBUG_TEST(f_window_content==NULL);

      f_window_content=new word [f_width*f_height];
      f_cursor_ptr=f_window_content;
      f_x_cursor=0;
      f_y_cursor=0;
      m_reset_clip_window();

      TGroup::m_set_open(open);


//      m_display(); // Affichee en devenant active
    }
  else

    {
      DEBUG_TEST(f_window_content!=NULL);

      TGroup::m_set_open(open);

      delete []f_window_content;
      f_window_content=NULL;

      // Il faut maintenant rafrachir pour que la fentre
      // disparaisse de l'cran

      m_add_to_refresh_zone();
    }
}

/***************************************************/
/* m_set_active : L'objet devient/n'est plus actif */
/* ------------   (ne modifie pas l'affichage)     */
/***************************************************/

void TWindow::m_set_active(boolean active)
{
  if (active!=f_active)
  {
    f_active=active;
    TGroup::m_set_active(active);
  }
}


/*********************************************************/
/* m_close_button_pressed_event : Evnement de clic dans */
/* ----------------------------   l'icone de fermeture   */
/*********************************************************/

boolean TWindow::m_close_button_pressed_event()
{
  int x,y,button_state;
  boolean pressed=TRUE;

  // Si l'objet de la fentre possdant le focus ne veut pas le lacher

//  if (!f_window->m_can_lose_focus())
//    return(TRUE);

  m_display_close_button(pressed);
  JPRefresh();

  GetMouseState(x,y,button_state);

  while (button_state==LEFT_BUTTON_PRESSED)
    {
      if ((y==f_y) && (x>=f_x) && (x<=(f_x+1)))
	{
	  if (!pressed)
	    {
	      pressed=TRUE;
	      m_display_close_button(pressed);
	      JPRefresh();
	    }
	}
      else
	if (pressed)
	  {
	    pressed=FALSE;
	    m_display_close_button(pressed);
	    JPRefresh();
	  }

      GetMouseState(x,y,button_state);
    }

  if (pressed)
    {
      pressed=FALSE;
      m_display_close_button(pressed);
      JPRefresh();

      if (f_close_button_pressed_action!=NULL)
	CallCallback(this,f_close_button_pressed_action,f_close_button_pressed_argument);
    }

  return(TRUE);
}

