/****************************************************************************/
/* TTAB                                                                     */
/*--------------------------------------------------------------------------*/
/* Objet TTab (onglet)                                                      */
/****************************************************************************/

#ifndef _TTAB_H_
#define _TTAB_H_

#include "Types.h"

#include "TGroup.h"

class TTab:public TGroup
{
  /*---------------*/
  /* Classes amies */
  /*---------------*/

  friend TTabGroup;

  /*-----------------*/
  /* Champs protgs */
  /*-----------------*/

  protected:

    // Callback : Fonction appele lorsque l'onglet devient visible
    //            et son argument

    void   (*f_visible_action)(TObject*,char *);
    char   *f_visible_argument;


  /*--------------------*/
  /* Mthodes publiques */
  /*--------------------*/

  public:

    // Constructeur / Destructeur

		    TTab(PTabGroup tab_group,
			 char *caption);
    virtual  	    ~TTab();

    // Mthodes d'accs

    // Rend cet onglet visible

            void    m_set_visible();

    // Dfinition des callbacks

	    void    m_set_visible_callback(void (*visible_action)(TObject *,char *),
					   char *visible_argument);

  /*--------------------*/
  /* Mthodes protges */
  /*--------------------*/

  protected:


    // Affichage

    virtual void    m_display();
    virtual void    m_display_focus_depending_part();
    virtual void    m_display_caption();

    // Prise/Perte du focus

    virtual void    m_take_focus();

  /*------------------*/
  /* Mthodes prives */
  /*------------------*/

    // L'objet peut obtenir le focus lors d'un dplacement
    // avec les touches flches

    virtual boolean m_focus_can_be_set_by_arrow_key() {return(TRUE);};
};

#endif