/****************************************************************************/
/* TFILELB                                                                  */
/*--------------------------------------------------------------------------*/
/* TFileListBox class : locates & lists files according to a specified mask */
/*--------------------------------------------------------------------------*/
/* Author      : DELPRAT Jean-Pierre                                        */
/* Created on  : 20-May-96                                                  */
/****************************************************************************/

#include <direct.h>
#include <ctype.h>
#include <dos.h>
#include <stdio.h>


#include "Compat.h"

#include "Mouse.h"
#include "Strings.h"
#include "Vocab.h"

#include "Callback.h"
#include "MsgBox.h"

#include "TWindow.h"

#include "TFileLb.h"


TFileListBox::TFileListBox(PObject parent,
			   int rel_x, int rel_y,
			   int width, int height,
			   char *dir_mask)
	     :TListBox(parent,
		       rel_x,rel_y,
		       width,height,
		       "",
		       NULL,
		       TRUE)
{
  // Initialisation de f_mask  une valeur existante

  strcpy(f_current_dir,GetCurrentDir());
  strcpy(f_current_mask,"*.*");

  // Callbacks

  InitCallback(f_refresh_done_action,f_refresh_done_argument);
  InitCallback(f_file_chosen_action,f_file_chosen_argument);

  f_init_in_progress=TRUE;
  m_refresh_file_list(dir_mask);
  f_init_in_progress=FALSE;
}


TFileListBox::~TFileListBox()
{
  // Destruction des variables dynamiques

  DestroyCallback(f_file_chosen_action,f_file_chosen_argument);
  DestroyCallback(f_refresh_done_action,f_refresh_done_argument);
}

TFLBError TFileListBox::m_refresh_file_list(char *dir_mask)
{
  boolean add;
  struct ffblk ffblk;
  TMousePointer pointer;

  char correct_dir_mask[MAX_PATH];
  char old_drive_and_dir[MAX_PATH];
  char buffer[MAX_PATH];

  char dir[MAX_DIR];

  int old_disk,disk;
  int current_disk;

  boolean add_mask;

  char *file=NULL;

  int		err;

  int temp;

  boolean   mask_is_file=FALSE;

  char upper_drive_letter;

  TFLBError error_code=FLB_REFRESH_OK_MASK;

  // Curseur sablier

  JPRefresh();
  pointer=GetMousePointer();
  SetMousePointer(MP_HOURGLASS);

  // Initialisations

  old_disk=getdisk();
  current_disk=f_current_dir[0]-'A';

  disk=current_disk;

  // Si le nom du lecteur est indiqu

  if ((dir_mask[0]!=0) && (dir_mask[1]==':'))
    {
      upper_drive_letter=toupper(dir_mask[0]);
      if ((upper_drive_letter>='A') && (upper_drive_letter<='Z'))
	{
	  // Le drive est indiqu
	  disk=upper_drive_letter-'A';
	}
    }

  // Vrifie que le disque est correct

  if (!DriveExists(disk))
    error_code=FLB_INVALID_DRIVE;
  else
    setdisk(disk);

  // Rcupre le chemin courant sur le disque  lire
  // L'erreur critique a t dsactive

  if (error_code==FLB_REFRESH_OK_MASK)
    {
      strcpy(old_drive_and_dir,GetCurrentDir());
      if (old_drive_and_dir[0]==0)
	error_code=FLB_NO_DISK_IN_DRIVE;
    }

  // Ici, le disque existe (avec disque dans lecteur si amovible)

  // Place dans le rpertoire courant si le disque  lire est le
  // disque courant et si le rpertoire courant existe encore,
  // dans la racine sinon

  if (error_code==FLB_REFRESH_OK_MASK)
    {
      if (disk==current_disk)
	{
	  // Dir qui a disparu

	  if (chdir(f_current_dir))
	    chdir("\\");
	}
      else
	chdir("\\");

      // Transforme le chemin du masque fourni en absolu (si relatif)

      FullPath(correct_dir_mask,dir_mask);

      // Dcoupe le masque en lments

      file=strrchr(correct_dir_mask,'\\')+1;
      temp=(int)(file-correct_dir_mask-3);

      if (temp==0)
	temp=1;

      if (temp>(MAX_DIR-1))
	error_code=FLB_INVALID_DIR;

      else
	{
	  strncpy(dir,correct_dir_mask+2,temp);
	  dir[temp]=0;

	  // Vrifie que le chemin est correct

	  if (chdir(dir))
	    error_code=FLB_INVALID_DIR;
	}
    }


  if (error_code==FLB_REFRESH_OK_MASK)
    {
      // file="" ?

      add_mask=FALSE;

      if (file[0]==0)
	add_mask=TRUE;
      else
	{
	  // Au cas ou le nom de fichier serait trop long

	  if (strlen(file)>(MAX_FILE-1))
	    error_code=FLB_INVALID_FILE;
	  else
	    {
	      // Est_ce que file est en fait un rpertoire

	      if (!chdir(file))
		{
		  add_mask=TRUE;
		  if (EndOfString(dir)!='\\')
		    strcat(dir,"\\");
		  strcat(dir,file);
		}
	      else
		{
		  // Non !
		  // Masque ou fichier

		  if ((strchr(file,'*')==NULL) && (strchr(file,'?')==NULL))
		    mask_is_file=TRUE;

		  strcpy(f_current_mask,file);
		}
	    }
	}
    }

  if (error_code==FLB_REFRESH_OK_MASK)
    {
      if (add_mask)
	{
	  if (EndOfString(correct_dir_mask)!='\\')
	    strcat(correct_dir_mask,"\\");
	  strcat(correct_dir_mask,f_current_mask);
	}
    }

  // Rcupration du chemin courant
  if (error_code==FLB_REFRESH_OK_MASK)
    strcpy(f_current_dir,GetCurrentDir());


  if (    (error_code==FLB_REFRESH_OK_MASK)
       && (!f_init_in_progress))
    {
      // Lecture de la liste des fichiers

      m_clear_list();

      // D'abord les fichiers

      err = findfirst(correct_dir_mask, &ffblk, FA_RDONLY|FA_HIDDEN|FA_SYSTEM|FA_ARCH);

      while (!err)
	{
	  sprintf(buffer,"%c %s",FLB_FILE_CHAR,ffblk.ff_name);
	  m_add_item(buffer);
	  err = findnext(&ffblk);
	};

      // Puis les rpertoires

      strcpy(strrchr(correct_dir_mask,'\\')+1,"*.*");

      err = findfirst(correct_dir_mask, &ffblk, FA_DIREC);
      while (!err)
	{
	  // Rpertoire

	  if (ffblk.ff_attrib & FA_DIREC)
	    {
	      add=TRUE;

	      if (strcmp(ffblk.ff_name, "."))
		{
		  if (!strcmp(ffblk.ff_name, ".."))
		    {
		      if (strcmp(dir,"\\"))  // -> lecteurs rseau
			sprintf(buffer,"%c %s",FLB_PARENT_DIR_CHAR,ffblk.ff_name);
		      else
			add=FALSE;
		    }
		  else
		    sprintf(buffer,"%c %s",FLB_SUB_DIR_CHAR,ffblk.ff_name);
		}
	      else
		add=FALSE;

	      if (add)
		m_add_item(buffer);
	    }

	   err = findnext(&ffblk);
	};
    };

  if ((error_code!=FLB_INVALID_DRIVE) && (error_code!=FLB_NO_DISK_IN_DRIVE))
    chdir(old_drive_and_dir);

  setdisk(old_disk);
  SetMousePointer(pointer);

  if (!f_init_in_progress)
    {
      switch (error_code)
	{
	  case FLB_REFRESH_OK_MASK  : CallCallback(this,f_refresh_done_action,f_refresh_done_argument);
				      break;
	  case FLB_INVALID_DRIVE    : m_invalid_drive_error(disk);
				      break;
	  case FLB_NO_DISK_IN_DRIVE : m_no_disk_in_drive_error(disk);
				      break;
	  case FLB_INVALID_DIR      : m_invalid_dir_error(dir_mask);
				      break;
	  case FLB_INVALID_FILE     : m_invalid_file_error(file);
				      break;
          default                   : ;// To avoid warnings
	}
    }

  if ((error_code==FLB_REFRESH_OK_MASK) && (mask_is_file))
    error_code=FLB_REFRESH_OK_FILE;
  return(error_code);
}

/****************************************************************************/
/* m_refresh_file_list_from_item                                            */
/*--------------------------------------------------------------------------*/
/* Change le rpertoire courant en fonction de l'lment indiqu            */
/****************************************************************************/

TFLBError TFileListBox::m_refresh_file_list_from_item(int item_index)
{
  char *item;

  if (item_index==0)
    return(FLB_REFRESH_OK_MASK);

  item=m_get_item(item_index);

  // Rpertoire parent

  if (item[0]==FLB_PARENT_DIR_CHAR)
    {
      return(m_refresh_file_list(".."));
    }

  // Sous-Rpertoire

  if (item[0]==FLB_SUB_DIR_CHAR)
    {
      return(m_refresh_file_list(item+2));
    }

  // Fichier

  return(m_refresh_file_list(item+2));
}


/****************************************************************************/
/* m_set_refresh_done_callback                                              */
/*--------------------------------------------------------------------------*/
/* Dfinition du callback associ au rafrachissement de la liste           */
/****************************************************************************/

void TFileListBox::m_set_refresh_done_callback(void (*refresh_done_action)(PObject,char *),
					      char *refresh_done_argument)
{
  SetCallback(f_refresh_done_action,f_refresh_done_argument,
	      refresh_done_action,refresh_done_argument);
}

void TFileListBox::m_set_file_chosen_callback(void (*file_chosen_action)(PObject,char *),
					      char *file_chosen_argument)
{
  SetCallback(f_file_chosen_action,f_file_chosen_argument,
	      file_chosen_action,file_chosen_argument);
}

/****************************************************************************/
/* m_key_pressed_event                                                      */
/*--------------------------------------------------------------------------*/
/* L'utilisateur a appuy sur une touche qui est propose  l'objet         */
/* (qui est activable).                                                     */
/* Retourne TRUE si l'objet est intress par cette touche.                 */
/****************************************************************************/

boolean TFileListBox::m_key_pressed_event(TKey key)
{
  if (TSimpleList::m_key_pressed_event(key))
    return(TRUE);

  if (!f_focused)
    return(FALSE);

  if (key.character==RETURN)
    {
      if (m_refresh_file_list_from_item(f_selected_item_index)==FLB_REFRESH_OK_FILE)
	CallCallback(this,f_file_chosen_action,f_file_chosen_argument);
      return(TRUE);
    }

  return(TListBox::m_key_pressed_event(key));
}


/****************************************************************************/
/* m_item_dbl_clicked_callback                                              */
/*--------------------------------------------------------------------------*/
/* Fonction appele quand on double-clic sur un lment de la liste.        */
/****************************************************************************/

void TFileListBox::m_item_dbl_clicked_callback(int index)
{
  if (m_refresh_file_list_from_item(index)==FLB_REFRESH_OK_FILE)
    CallCallback(this,f_file_chosen_action,f_file_chosen_argument);
}


void TFileListBox::m_invalid_drive_error(int drive)
{
  char *title="X:";

  title[0]='A'+drive;
  MessageBox(title,GetString(VOC_DRIVE_DOESNT_EXIST),ALERT,MB_ICONEXCLAMATION|MB_OK);
}

void TFileListBox::m_no_disk_in_drive_error(int drive)
{
  char *text=GetString(VOC_NO_DISK_IN_DRIVE);
  char *msg=new char[strlen(text)];   // Pas de +1 car %c: -> X:

  sprintf(msg,text,'A'+drive);
  MessageBox("",msg,ALERT,MB_ICONEXCLAMATION|MB_OK);
  delete []msg;
}

void TFileListBox::m_invalid_dir_error(char *dir)
{
  MessageBox(dir,GetString(VOC_INVALID_DIRECTORY),ALERT,MB_ICONEXCLAMATION|MB_OK);
}

void TFileListBox::m_invalid_file_error(char *file)
{
  MessageBox(file,GetString(VOC_INVALID_FILE),ALERT,MB_ICONEXCLAMATION|MB_OK);
}

