/****************************************************************************/
/* TCHKBOX                                                                  */
/*--------------------------------------------------------------------------*/
/* Objet TCheckBox (Case  cocher)                                          */
/****************************************************************************/

#ifndef _TCHKBOX_H_
#define _TCHKBOX_H_

#include "Types.h"

#include "TObject.h"

class TCheckBox:public TObject
{
  /*-----------------*/
  /* Champs protgs */
  /*-----------------*/

  protected:

    // CheckBox coche ou non

    boolean f_checked;

  /*---------------*/
  /* Champs privs */
  /*---------------*/

  private:

    // Callback : Fonction appele si on coche la checkbox
    //            et son argument

    void (*f_checked_action)(PObject,char *);
    char *f_checked_argument;

    // Callback : Fonction appele si on dcoche la checkbox
    //            et son argument

    void (*f_unchecked_action)(PObject,char *);
    char *f_unchecked_argument;

  /*--------------------*/
  /* Mthodes publiques */
  /*--------------------*/

  public:

    // Constructeur / Destructeur

		    TCheckBox(PObject parent,
			      int rel_x,int rel_y,
			      int width,char *caption,
			      boolean checked=FALSE,
                              boolean enabled=TRUE);

    virtual         ~TCheckBox();

    // Mthodes d'accs

	    boolean m_is_checked() { return(f_checked); };
    virtual void    m_check();
    virtual void    m_uncheck();

    // Dfinition des callbacks

	    void    m_set_checked_callback(void (*checked_action)(PObject,char *),
					  char *checked_argument);
	    void    m_set_unchecked_callback(void (*unchecked_action)(PObject,char *),
					     char *unchecked_argument);

  /*--------------------*/
  /* Mthodes protges */
  /*--------------------*/

    // La case  cocher est coche/dcoche

	    void    m_take_check();
	    void    m_lose_check();

  /*------------------*/
  /* Mthodes prives */
  /*------------------*/

  private:

    // Affichage

    virtual void    m_display_focus_depending_part();
    virtual void    m_display_caption();

    // Evnements

    virtual boolean m_left_button_pressed_event(int x,int y);
    virtual boolean m_key_pressed_event(TKey key);
};

#endif
