// This is disk array library version 1.1 beta release for C++.
// Programmed by Rubtsov Grigorii, 12.14.97.
// This library allows to make arrays on disk.
// See disk_arr.txt for more information

#include "disk_arr.hpp"

template <class T>
disk_arr<T>::disk_arr(char *fname, long x, long y, const T& zero, char type=0, char check=0):
  xsize(x), ysize(y), ftype(type), rcheck(check)
{
   zero_value = new T(zero);
	file_name = new char[strlen(fname)+1];
   strcpy(file_name, fname);
	if (ftype) {
   	memfile = fopen(fname, "r+b");
	 	if (memfile) {
        fstatus = 1;
        return;
      }
   }
  	memfile = fopen(fname, "w+b");
  	if (!memfile) {
     	fstatus = 0;
     	return;
  	}
  	fstatus = 1;
	for(long c1=0; c1<(xsize*ysize); c1++)
 	   fwrite((void *)zero_value, 1, sizeof(T), memfile);
  	return;
}


template <class T>
disk_arr<T>::disk_arr(const disk_arr& a): xsize(0), ysize(0), ftype(a.ftype), rcheck(0)
{
	printf("\a\aError: disk_arr objects cannot be copied, \r\n");
   printf("passed to function by value or returned from\r\n");
   printf("function by value. \r\n");
   printf("Other words: copy constructor can't be called.\r\n");
   fclose(memfile);
   abort();
}


template <class T>
disk_arr<T>::~disk_arr()
{
	fclose(memfile);
   if (!ftype) remove(file_name);
   delete []file_name;
   delete zero_value;
   return;
}

template <class T>
void disk_arr<T>::range_error(long x, long y) const
{
	fprintf(stderr, "Range check error in file %s,\r\n", file_name);
   fprintf(stderr, "X=%li, Y=%li, maxX=%li, maxY=%li.\r\n",x, y, xsize-1, ysize-1);
   abort();
}

template <class T>
disk_arr_element<T> disk_arr_element<T>::operator=(const T& r)
{
	if ((x>=a->xsize)||(x<0)||(y<0)||(y>=a->ysize))
   	if(a->rcheck==1) a->range_error(x, y);
     		else return (*this);
	fseek(a->memfile, sizeof(T)*(a->ysize*x+y), 0);
   fwrite((void *)&r, 1, sizeof(T), a->memfile);
   return (*this);
}

template <class T>
disk_arr_element<T>::operator T() const
{
	if ((x>=a->xsize)||(x<0)||(y<0)||(y>=a->ysize))
   	if(a->rcheck==1) a->range_error(x, y);
      else return *(a->zero_value);
	T r;
	fseek(a->memfile, sizeof(T)*(a->ysize*x+y), 0);
   fread((void *)&r, 1, sizeof(T), a->memfile);
   return r;
}
