;;--------------------------------------------------------------------------
;; ATI VGAWonder 132 column screen drivers for Sprint
;;-------------------------------------------------------------------------- 
;;
;; The ATI VGAWonder card has two 132 column modes. These can be run on 
;; most monitors.  ( I used a NEC MultisyncII to develop
;; these descriptions ).  It used to have three ( a 132x60 mode ) but that
;; was deleted in the latest release I have.  If you still have it and want
;; to use it you should be able to simply copy one of the descriptions below
;; and make the obvious changes in it.
;;
;; To access these modes simply insert this file into an appropriate location
;; in MAIN.SPL ( I inserted just before the line 
;; ';;-------------------- Printers ------------------' 
;; after all the other screen drivers ),
;; change the file names used in 'init' & 'reset' to point to 
;; your copy of VCONFIG, run SP-SETUP, choose monitor installation, select
;; VGAWonder and choose your mode.
;;
;; Each mode will return the card to VGA mode at exit.  If this is not what
;; you desire, just change the parameter passed to VCONFIG in the reset
;; string to the mode you want.
;;
;; Note: 1) the double \'s are needed to produce a single \ in the name.
;;
;; Developed and checked on ATI VGAWonder Bios V3M-1.03 on a 256K card.
;;
;; Inspired by the tecmar.inc file previously uploaded to the Sprint library.
;;
;; Created by Ken Westerback 73547,3520
;;--------------------------------------------------------------------------

screen VGAWonder, root

screen VGAWonder.Color\, 132x25,   ;; name in sp-setup is 'Color, 132x25'
;; ATI VGAWonder (V3M-1.03) 132x25 mode        
;; Set via ATI VCONFIG
     as .Color25,     ;; this driver is the same as .color25
	rows 25,         ;; except we have 25 rows  
	cols 132,        ;; and 132 columns
	init CC:\\ATIVGA2\\VCONFIG 25,
	reset CC:\\ATIVGA2\\VCONFIG VGA COLOR

screen VGAWonder.Color\, 132x44,  ;; name in sp-setup is 'Color, 132x44'
;; ATI VGAWonder (V3M-1.03) 132x44 mode        
;; Set via ATI VCONFIG
     as .Color25,     ;; this driver is the same as .color25
	rows 44,         ;; except we have 24 rows  
	cols 132,        ;; and 132 columns
	init CC:\\ATIVGA2\\VCONFIG 44,
	reset CC:\\ATIVGA2\\VCONFIG VGA COLOR
