


CIO(1)                                                     CIO(1)


NNAAMMEE
       cio - a pair of RCS user interface programs

SSYYNNOOPPSSIISS
       cii [cii options] [ci options] [filename ...] [dirname ...
       ]

       coo [coo options] [co options] [filename ...] [dirname ...
       ]

DDEESSCCRRIIPPTTIIOONN
       _C_i_i  and  _c_o_o are two programs that will provide an inter-
       face to the RCS programs _c_i and _c_o_.  They add:

       Recursively check in/out directory structures

       Store RCS files in a separate directory structure

       Default stores only ASCII files, enabling  program  to  be
       run on directories with both source and binary


       Command line options include:

       --AA   All  files.   Forces  a  "cp"  of files that are non-
            ASCII.

       --HH   Insert RCS header.  If a valid RCS header not  found,
            a  template  header will be inserted at the beginning
            of the file being checked in.

       --NN   No operation.  Causes  _c_i_i  or  _c_o_o  to  display  the
            action that would have resulted. Nothing is executed.

       --RR   Recursively walk down directories to check in/out

       --TT   Force title request at start of program (Default only
            gets title when required.)

       --UU   Update  source  directory.  During a check-in, a copy
            is made  to  the  directory  structure  specified  by
            $RCSSRC.   If  $RCSSRC  is not defined, $HOME will be
            used instead.

       --VV   Verbose.  Be real  talkative  about  the  work  being
            done.

       [[aallll ccii//ccoo ooppttiioonnss]]
            Passes all other options  on to _c_i or _c_o_.

       ffiilleennaammee
            Optional  file  names.  If not provided, the _c_i_i pro-
            gram will take all files in the current directory, or
            _c_o_o  will  take all files saved in the RCS directory.



                                                                1





CIO(1)                                                     CIO(1)


            (Binary files only if -A was also specified.)

       ddiirrnnaammee
            Both programs will take a directory name as an  argu-
            ment,  however:  the -R option must also be specified
            for it to work.





EENNVVIIRROONNMMEENNTT
       RRCCSSDDIIRR
            If defined, names a path that will be used  to  store
            the  RCS  files. Default is $HOME/RCS.  Final path is
            computed by removing $HOME and/or $RCSWORK from  cur-
            rent path.


       RRCCSSWWOORRKK
            If  defined,  an alternate prefix for current working
            directory.  Allows having multiple  directory  struc-
            tures with different prefix's.


       HHOOMMEE Must be defined as the users home directory.


       RRCCSSSSRRCC
            If  defined  and  -U  flag is specified, during a _c_i_i
            procedure, a copy of what's being checked in will  be
            made  in the directory structure starting at $RCSSRC.
            If not specified, _c_i_i uses $HOME instead.


       RRCCSSHHEEAADD
            If -H flag is specified, _c_i_i  finds  template  header
            from $RCSHEAD directory.


SSAAMMPPLLEESS
       A  user with a home directory of /usr/bog, has a directory
       structure called sample/arix.  He want's to store  all  of
       the files in /usr/bog/sample/arix into the RCS system.  If
       neither  RCSDIR  or  RCSWORK  is  defined,  the  RCS  path
       defaults  to his home directory, followed by RCS, followed
       by the current path.  So:

               Current directory   :  /usr/bog/sample/arix
               Home directory      :  /usr/bog
               RCSDIR              :
               RCSWORK             :
               RCSSRC              :




                                                                2





CIO(1)                                                     CIO(1)


               Final RCS storage   :  /usr/bog/RCS/sample/arix
               Final source storage:  /usr/bog/sample/arix

       The net effect of this command is to create the RCS direc-
       tory,  then  to  duplicate  the  directory  structure in a
       defined place.  In this case, since  the  RCSDIR  was  not
       defined, it defaulted to the users home directory.

       It  is  not necessary to build the directories in RCS, the
       program will build all  necessary  directories  (Including
       the RCS dir, if needed).

       Another example:  All RCS files should reside in /usr/RCS,
       so the above example turns into:

               Current directory   :  /usr/bog/sample/arix
               Home directory      :  /usr/bog
               RCSDIR              :  /usr/RCS
               RCSWORK             :
               RCSSRC              :

               Final RCS storage   :  /usr/RCS/sample/arix
               Final source storage:  /usr/bog/sample/arix

       Here is an example showing use of  the  RCSWORK  variable.
       Some  systems  may  have  more  than one person working on
       file.  In this case, the path names will have to be  simi-
       lar, but only to a point.  Example, /usr/tog is also work-
       ing in a directory, called sample/arix.  His system  would
       look like:

               Current directory   :  /usr/tog/sample/arix
               Home directory      :  /usr/tog
               RCSDIR              :  /usr/RCS
               RCSWORK             :
               RCSSRC              :

               Final RCS storage   :  /usr/RCS/sample/arix
               Final source storage:  /usr/tog/sample/arix

       Note  that  the  RCS  dir is the same for him.  Now, let's
       take a user who has decided to work somewhere  other  than
       his home directory.

               Current directory   :  /usr/src/rog/sample/arix
               Home directory      :  /usr/rog
               RCSDIR              :  /usr/RCS
               RCSWORK             :  /usr/src/rog
               RCSSRC              :

               Final RCS storage   :  /usr/RCS/sample/arix
               Final source storage:  /usr/rog/sample/arix

       If  RCSSRC  is  specified to keep the current source (very



                                                                3





CIO(1)                                                     CIO(1)


       useful to when one wants to  browse  through  the  current
       source files) in a directory other than his HOME.

               Current directory   :  /usr/src/rog/sample/arix
               Home directory      :  /usr/rog
               RCSDIR              :  /usr/RCS
               RCSWORK             :  /usr/src/rog
               RCSSRC              :  /usr/group

               Final RCS storage   :  /usr/RCS/sample/arix
               Final source storage:  /usr/group/sample/arix

       The  RCSWORK  variable  was removed from the current path,
       before the directory structure was defined.  Thus,  it  is
       possible  to be working in just about anywhere on the sys-
       tem and still use the same  directory  structure  and  RCS
       files.


       If you want to recover a directory (or multiple ones) into
       a new working directory, simply create  whatever  part  of
       the  path  you  need,  set  the RCSWORK variable to be the
       first part of the path, and type "coo [-R]".

       Example:  A new user (/usr/log) has decided to examine the
       sample/* files.  Here are the steps:

             Current working directory: /usr/llog
             mkdir sample
             chdir sample
             RCSDIR=/usr/RCS  export RCSDIR
             RCSWORK=/usr/log  export RCSWORK

       This is the final setup:

             Current directory:  /usr/log/sample
             Home directory   :  /usr/llog
             RCSDIR           :  /usr/RCS
             RCSWORK          :  /usr/log

             Final RCS storage:  /usr/RCS/sample/arix


SSEECCUURRIITTYY
                            Secure archives

       _C_i_i_/_c_o_o  will also secure archives.  Changing ownership of
       the cii or coo program to root, and making  it  suid  will
       allow  private  archives.  With this option, an additional
       environment variable is searched for: "RCSOWN".   If  this
       is  not  found, the default name "rcsfiles" is used in the
       following step.

       The user name is searched for in  the  /etc/password.   If



                                                                4





CIO(1)                                                     CIO(1)


       not  found,  the  real users UID will be used instead.  In
       this fashion, the ci and co programs will be  called  with
       the  appropriate uses abilities to create directories, and
       save files.  Only the user who  owns  the  RCS  files  has
       write  ability  without  going through the cii or coo pro-
       grams.

       The only condition that allows the program  to  remain  in
       the  root  owned  mode is to have the rcsfiles have a root
       account.  Otherwise, it moves out of the root as  soon  as
       it's found the user.


OOTTHHEERR NNOOTTEESS
       _C_i_i  will  not  unlink  files not owned by the user who is
       checking in the files.  This prevents users from  deleting
       files  not  owned  by  them, possibly causing harm. (I.E.,
       checking in the /etc/passwd file.)  _c_o_o does  not  run  as
       root, it runs as the real user.  Hence, it is not possible
       for a user to overwrite files or directories they normally
       do not have write access to.

       _C_i_i_/_c_o_o only will allow extraction of code by the users in
       the same group as the user who checked the sources in.


       We highly suggest that you exmine the code in the security
       area  if  you  plan  on running it secure.  We've tried it
       secure, and it seems to work.  However...  We  are  by  no
       means  the "great U*IX hackers", so there is probably some
       way to run the program that we missed that can allow  oth-
       ers access to restricted files.  Check it out! If you *do*
       find something we missed, please send us mail.


EEDDIITTOORR CCOOMMMMAANNDDSS
       The input editor for the logfile entries  and  title  file
       entries  have  tilde (~) command options available.  These
       are:
               ?  -  Print a help menu.
               .  -  End of input.
               !  -  Invoke a user shell.  Note: Shell is invoked
                     as the real user-id; No arguments are passed
                     or allowed.  The ENV variable "SHELL" is
                     searched for, if not present /bin/sh will be
                     invoked.
               e  -  Edit the message using a default editor.
                     Searches for the ENV variable VISUAL or
                     EDITOR.  If not found, /usr/bin/vi is the
                     default editor.
               p  -  Print message buffer.  Displays the current
                     contents of the message buffer.
               r  -  Read in a file.  Requires file name as an
                     argument.  Named file will be appended to



                                                                5





CIO(1)                                                     CIO(1)


                     current buffer.
               w  -  Write message to a file.  Requires file name
                     as an argument.  Appends message buffer to
                     file name given.  If file does not exist,
                     creates file.  Does not create  directories.



AAUUTTHHOORRSS
       Jason  P.  Winters  (jason@grinch.uucp)  and  Craig J. Kim
       (cjkim@aeras.uucp)

FFIILLEESS
       The following template files can be created to insert  RCS
       header  into  source  files  during  _c_i_i  process  with -H
       option.  The location for these files is specified by set-
       ting  $RCSHEAD  environment  variable.  If $RCSHEAD is not
       set, $HOME will be used instead.  File  types  are  deter-
       mined  by examining the content via file(1) program and by
       file extensions (e.g. .c for C  programs,  .mk  for  make-
       files, .1 for nroff, and .s for assembly).

               .rcshead       - default template
               .rcshead.c     - C program template
               .rcshead.s     - Assembly source template
               .rcshead.sh    - Shell script template
               .rcshead.f     - Fortran program template
               .rcshead.mk    - makefile template
               .rcshead.h     - C header file template
               .rcshead.roff  - nroff, troff, man file template


DDIIAAGGNNOOSSTTIICCSS
       Linking  cio  to ciitest or cootest will cause the program
       to parse the directory paths,  and  print  out  the  final
       pathnames.   Nothing  else  happens.   Using the -N option
       will cause the program to execute as normal,  except  that
       no files or directories will be created.


BBUUGGSS
       On some systems, the Control-D as end of input to a log or
       title entry can cause problems with STDIN.  We've added  a
       call  to clearerr(), but have not tested if that fixes it.
       ( It doesn't break it, so... )

       Any other bugs we would like to hear about.  We might even
       make a new release, if people actually use this.  :)

AAUUTTHHOORR
       Jason Winters, grinch!jason






                                                                6


