/*	Handle subscription/unsubscription from mailing lists
**	-----------------------------------------------------
*/
#include "listserv.h"
static char rcsid[] = "$Header: /tempf/aem/system/listserv/RCS/subscribe.c,v 1.2 91/06/18 14:08:02 aem Exp $";

extern FILE *msg;
extern FILE *mailer;

subscription(from,command,add)
char *from,*command;
int add;
	{
	FILE *list;
	FILE *listtmp;
	char grp[256];
	char adr[256];
	char tmp[256];
	char buf[BUFSIZ];
	int del = 0;
	int i;

	printf("subscription %s %s %d\n", from, command, add);

	i = sscanf(command,"%s%s%s", tmp, adr, grp);
	if (i < 2 || i > 3)
		{
		callmailer("", from, command);
		fprintf(mailer,"Your command\n");
		fprintf(mailer,"\t%s\n", command);
		fprintf(mailer,"could not be understood.  Correct syntax is\n");
		fprintf(mailer,"\tADD listname\n");
		fprintf(mailer,"\tADD mailbox listname\n");
		fprintf(mailer,"\tDELETE listname\n");
		fprintf(mailer,"\tDELETE mailbox listname\n");
		fflush(mailer);
		pclose(mailer);
		return(-1);
		}

	if (i == 2)
		{
		strcpy(grp, adr);
		strcpy(adr, from);
		}
	
	cleanup(grp);
	cleanup(adr);

	sprintf(tmp,"%s/%s.info", SERVDIR, grp);
	if (access(tmp,R_OK) != 0)
		{
		callmailer("", from, "");
		fprintf(mailer,"The mailing list \"%s\" could not be found.\n",
			grp);
		fprintf(mailer,"You may use the INDEX command to get a listing\n");
		fprintf(mailer,"of available mailing lists.\n");
		fflush(mailer);
		pclose(mailer);
		return(-1);
		}

	strcpy(tmp, SERVDIR);
	strcat(tmp, "/");
	strcat(tmp, grp);
	if (add)
		{
		list = fopen(tmp, "a");
		if (list == NULL)
			{
			callmailer("Postmaster", from, "");
			fprintf(mailer,"Couldn't add per request. (Error[1]) Please try later.\n");
			fprintf(mailer,">%s\n", command);
			fflush(mailer);
			pclose(mailer);
			return(-1);
			}
		flock(fileno(list), LOCK_EX);
		fprintf(list, "%s\n", adr);
		fflush(list);
		flock(fileno(list), LOCK_UN);
		fclose(list);
		}
	else
		{
		del = 0;
		list = fopen(tmp, "r");
		if (list == NULL)
			{
			callmailer("Postmaster", from, "");
			fprintf(mailer,"Couldn't read subscription list.  (Error[2]). Please try later.\n");
			fprintf(mailer,">%s\n", command);
			fflush(mailer);
			pclose(mailer);
			return(-1);
			}
		flock(fileno(list), LOCK_EX);
		fprintf(list, "%s\n", adr);

		strcpy(tmp, SERVDIR);
		strcat(tmp, "/");
		strcat(tmp, grp);
		strcat(tmp, ".tmp");
		listtmp = fopen(tmp, "w");
		if (listtmp == NULL)
			{
			callmailer("Postmaster", from, "");
			fprintf(mailer,"Couldn't write subscription list (Error[3]). Please try later.\n");
			fprintf(mailer,">%s\n", command);
			fflush(mailer);
			pclose(mailer);
			return(-1);
			}
		/* copy the list, omitting the one address */
		while (fgets(buf, sizeof(buf), list))
			{
			buf[strlen(buf)-1] = '\0';
			if (strcasecmp(buf, adr))
				{
				fputs(buf, listtmp);
				fputs("\n", listtmp);
				}
			else
				del++;
			}
		fflush(listtmp);
		fclose(listtmp);

		/* replace the old list with the shortened one */
		strcpy(buf, SERVDIR);
		strcat(buf, "/");
		strcat(buf, grp);
		unlink(buf);	/* delete original file */
		rename(tmp, buf);	/* put updated one in place */
		flock(fileno(list), LOCK_UN);	/* release lock */
		}

	if (strcmp(from, adr))
		{
		callmailer(adr, from, command);
		fprintf(mailer,"Per request by %s\n", from);
		}
	else
		{
		callmailer("", from, command);
		fprintf(mailer,"Per your request\n");
		}
	fprintf(mailer,"\t\"%s\"\n", command);
	if (add)
		fprintf(mailer,"'%s' was ADDED to the '%s' mailing list.\n",
			adr, grp);
	else
		if (del)
			fprintf(mailer,
			"'%s' was DELETED from the '%s' mailing list.\n",
				adr, grp);
		else
			fprintf(mailer,
			"'%s' was NOT FOUND on the '%s' mailing list.\n",
				adr, grp);
	fflush(mailer);
	pclose(mailer);
	}
