/*		Case-independent string comparison
**
**	Version TBL Oct 91 replaces one which modified the strings.
*/
#include <ctype.h>

#ifdef __STDC__
#define CONST const
#else
#define CONST
#endif
	
/*	Strings of any length
**	---------------------
*/
#ifdef __STDC__
int strcasecmp(const char*a, const char *b)
#else
int strcasecmp(a,b)
    char *a, *b;
#endif
/*	Strictly tolower() is undefined unless toupper() is true. (!)
*/
#define TOLOWER(c) (isupper(c) ? tolower(c) : c)
{
	CONST char *p =a;
	CONST char *q =b;
	for(p=a, q=b; *p && *q; p++, q++) {
	    int diff = TOLOWER(*p) - TOLOWER(*q);
	    if (diff) return diff;
	}
	if (*p) return 1;	/* p was longer than q */
	return 0;		/* Exact match */
}


/*	With count limit
**	----------------
*/
#ifdef __STDC__
int strncasecmp(const char*a, const char *b, int n)
#else
int strncasecmp(a,b,n)
    char *a, *b;
    int n;
#endif
{
	CONST char *p =a;
	CONST char *q =b;
	
	for(p=a, q=b;; p++, q++) {
	    int diff;
	    if (p == a+n) return 0;	/*   Match up to n characters */
	    if (!(*p && *q)) return *p - *q;
	    diff = TOLOWER(*p) - TOLOWER(*q);
	    if (diff) return diff;
	}
	/*NOTREACHED*/
}