#include "listserv.h"
static char rcsid[] = "$Header: /tempf/aem/listserv/RCS/main.c,v 1.2 91/06/17 16:45:39 aem Exp $";

FILE *mailer;
FILE *logfile;

#include <time.h>

main(argc,argv)
int argc;
char **argv;
	{
	char from[256];
	char buf[BUFSIZ];
	char grp[64];
	char dat[64];
	char *p;
	int i;
	int gotcommand = 0;
	int inheader;

	/* gotta have some default if the From: line is missing */
	strcpy(from, "Postmaster (no From line)");

	inheader = 1;
	while (fgets(buf,BUFSIZ,stdin) != NULL)
		{
		/* drop trailing newline */
		while (buf[(i=strlen(buf)-1)] == '\n')
			buf[i] = '\0';

		/* drop trailing blanks */
		p = buf + (strlen(buf) - 1);
		while (p && *p && p >= buf && isspace(*p))
			*p-- = '\0';

		/* deblank beginning of line */
		p = buf;
		while (p && *p && isspace(*p))
			p++;
		if (p != buf)
			strcpy(buf, p);

		if (strlen(buf) == 0)	/* blank line ends header */
			{
			inheader = 0;
			continue;
			}
		
		/*
		get the From: line so we can return the answer

		Note that we DON'T check that we're in the header when
		picking up the From: line; that's so that we'll take the
		last from line we encounter which makes it handle
		forwarded messages correctly.
		*/
		if (strncasecmp(buf,"From: ",6) == 0)
			{
			strcpy(from, &buf[6]);
			cleanup(from);
			continue;
			}
		
		/* 
		don't look for commands in the header 
		*/
		if (inheader)
			continue;
		
		/* avoid mail loops - ignore requests from ourself! */
		if (!strncasecmp(from, "listserv", 8)
		||  !strncasecmp(from, "robot", 5))
			{
			printf("I refuse to talk to myself.\n");
			exit(0);
			}

		/* force to lower case and scan for commands */
		/* No!  TBL 921019 */
#ifdef NO_CASE_SIGNIFICANCE
		p = buf;
		while (p && *p)
			{
			if (isupper(*p))
				*p = tolower(*p);
			p++;
			}
#endif

		/* If STOP, ignore this and all following commands */
		if (!strcasecmp(buf,"stop")
		||  !strcasecmp(buf,"end"))
			{
			gotcommand++;
			break;
			}
		
		/* log the request */
		logfile = fopen(LOGFILE,"a");
		if (logfile != NULL)
			{
			long clock = time(0);
			strcpy(dat,ctime(&clock));
			/* drop trailing newline */
			while (dat[(i=strlen(dat)-1)] == '\n')
				dat[i] = '\0';
			printf("logfile: %s|%s|%s\n", dat, from, buf);
			fprintf(logfile,"%s|%s|%s\n", dat, from, buf);
			fflush(logfile);
			fclose(logfile);
			}
		else
			perror(LOGFILE);
		
		if (!strncasecmp(buf,"add ", 4)
		|| !strncasecmp(buf,"subscribe ", 10))
			{
			gotcommand++;
			subscription(from,buf,1);
			continue;
			}
		
		if (!strncasecmp(buf,"delete ", 7)
		|| !strncasecmp(buf,"unsubscribe ", 12))
			{
			gotcommand++;
			subscription(from,buf,0);
			continue;
			}
		
		if (!strcasecmp(buf,"index")
		|| !strcasecmp(buf,"longindex"))
			{
			gotcommand++;
			sendindex(from,buf,!strcasecmp(buf,"longindex"));
			continue;
			}
		
		if (!strncasecmp(buf,"www ", 4)
		|| !strncasecmp(buf,"send ", 5))
			{
			gotcommand++;
			senddoc(from,buf);
			continue;
			}
		
		if (!strcasecmp(buf,"help"))
			{
			gotcommand++;
			sendhelp(from,buf);
			continue;
			}
		
		if (!strncasecmp(buf,"help ",5))
			{
			gotcommand++;
			sscanf(buf,"%*s%s", grp);
			listhelp(from,grp,buf);
			continue;
			}
		}
	if (gotcommand == 0)
		sendhelp(from, "indecipherable");
	}


/*		Invoke MAILER to send reply message
**		-----------------------------------
*/
callmailer(redirect, toaddr, request)
char *redirect, *toaddr, *request;
	{
	char cbuf[BUFSIZ];

	printf("callmailer \"%s\",\"%s\",\"%s\"\n", redirect, toaddr, request);

	strcpy(cbuf, MAILER);
	strcat(cbuf, " -f");
	strcat(cbuf, POSTMASTER);
	strcat(cbuf, " -F\"Mail robot\"");
	strcat(cbuf, " -t -oi"); 
	strcat(cbuf, " "); strcat(cbuf, redirect);
	mailer = popen(cbuf,"w");
	printf("mailer popen '%s'\n", cbuf);
	if (mailer == NULL)
		{
		perror(cbuf);
		exit(1);
		}
	fprintf(mailer,"From: %s (Mail robot)\n",POSTMASTER);
	fprintf(mailer,"To: %s\n", toaddr);
	fprintf(mailer,"Subject: Re: %s\n", request);
	fprintf(mailer,"\n");
	}

mailcat(mfname,prefix)
char *mfname, *prefix;
	{
	FILE *mf;
	char buf[BUFSIZ];

	printf("mailcat \"%s\", \"%s\"\n", mfname, prefix);

	mf = fopen(mfname,"r");
	if (mf == NULL)
		{
		perror(mfname);
		fprintf(mailer,"This should have been the contents of\n");
		fprintf(mailer,"file '%s' but it's missing!\n",mfname);
		return;
		}

	/* copy the message file into the mailer */
	while (fgets(buf,BUFSIZ,mf) != NULL)
		{
		fputs(prefix,mailer);
		fputs(buf,mailer);
		}
	fclose(mf);
	return;
	}

cleanup(from)
char *from;
	{
	char *p, *q;

	printf("cleanup \"%s\"\n", from);

	while (p = index(from,'~'))
		*p = 'X';

	while (p = index(from,'/'))
		*p = 'X';

	while (p = index(from,'|'))
		*p = 'X';

	/* elide stuff in parenthesis */
	if (p = index(from,'('))
		{
		if ( (q=index(from,')')) == NULL)
			{
			/* zap the from line; it's invalid */
			*p = '\0';
			return;
			}
		strcpy(p, q+1);
		}

	if (p = index(from,'<'))
		{
		if ( (q=index(from,'>')) == NULL)
			{
			/* zap the from line; it's invalid */
			*p = '\0';
			return;
			}
		*q = '\0';
		strcpy(from, p+1);
		}

	/* drop trailing blanks */
	p = from + (strlen(from) - 1);
	while (p && *p && p >= from && isspace(*p))
		*p-- = '\0';
	}
