#include "listserv.h"

extern FILE *msg;
extern FILE *mailer;

/*		Return simple HELP file
*/
sendhelp(from,request)
char *from, *request;
	{
	printf("called sendhelp with %s %s\n", from, request);
	callmailer("", from, request);
	mailcat(HELPFILE,"");
	pclose(mailer);
	return;
	}

/*		Send information about mailing lists
*/
listhelp(from,grp,request)
char *from,*grp,*request;
	{
	char tmp[128];
	printf("called listhelp with %s %s %s\n", from,grp,request);

	sprintf(tmp,"%s/%s.info", SERVDIR, grp);
	if (access(tmp,R_OK) != 0)
		{
		callmailer("", from, request);
		fprintf(mailer,"The mailing list \"%s\" could not be found.\n",
			grp);
		fprintf(mailer,"You may use the INDEX command to get a listing\n");
		fprintf(mailer,"of available mailing lists.\n");
		fflush(mailer);
		pclose(mailer);
		return;
		}

	callmailer("", from, request);
	fprintf(mailer,"Mailing list \"%s\":\n", grp);
	mailcat(tmp,"\t");
	pclose(mailer);
	return;
	}


/*		INDEX command
**		-------------
*/
sendindex(from,request,l)
char *from,*request;
int l;
	{
	FILE *ls;
	char tmp[128];
	char buf[128];
	int i;
	printf("called sendindex with %s %s %d\n", from,request,l);

	sprintf(tmp,"cd %s; /bin/ls -1 *.info | sed -e 's/.info//'", SERVDIR);
	ls = popen(tmp,"r");
	if (ls == NULL)
		{
		perror(tmp);
		exit(1);
		}
	callmailer("", from, request);
	fprintf(mailer,"Index of mailing lists\n");

	/* read the result of the ls */
	while (fgets(tmp, sizeof(tmp), ls))
		{
		while (tmp[(i=strlen(tmp)-1)] == '\n')
			tmp[i] = '\0';
		fprintf(mailer, "\t%s\n", tmp);

		/* if he wanted the long listing, cat the .info file */
		if (l)
			{
			sprintf(buf, "%s/%s.info", SERVDIR, tmp);
			mailcat(buf,"\t");
			fprintf(mailer, "\n");
			}
		}
	fprintf(mailer,"That's all.\n");
	pclose(ls);
	pclose(mailer);
	return;
	}

/*		SEND command
**		------------
*/
#define MAX_LINES 1000
char * valid_chars =
  "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789:/._-+@%*()";
senddoc(from,request)
char *from,*request;
	{
	FILE *ls;
	char tmp[1024];
	char buf[1024];
	char udi[1024];
	int i;
	int lines = 0;
	int valid[256];

	/* 	Set up array of valid characters */
	{ int i;
	    char * p;
	    for(i=0; i<256; i++) valid[i]=0;
	    for (p=valid_chars; *p; p++) {
		valid[(int)*p]=1;
	    }
	}
	
	printf("called senddoc with %s %s\n", from,request);

	{
	    int words = sscanf(request, "%s%s%s", tmp, udi);
	    char *p;
	    
	    if (words != 2) goto error;
	    for (p=udi; *p; p++) {
		if (!valid[*p]) goto error;
	    }

	}
	
	/* Start a WWW subprocess to read the info */
	sprintf(tmp,
	"%s -h \"%s\" -w72 -l %s -n -listrefs \"%s\"",
		SECUREWWW, from, SENDLOGFILE, udi);
	ls = popen(tmp,"r");
	if (ls == NULL)
		{
		perror(tmp);
		exit(1);
		}
	callmailer("", from, request);
	fprintf(mailer,
	"The requested document follows. Linked documents may be obtained\n");
	fprintf(mailer,
	"using SEND <address> where the addresses are listed at the end.\n");
	fprintf(mailer,
	"________________________________________________________________________\n");

	/* read the result of the www */
	while (fgets(tmp, sizeof(tmp), ls)) {
	    while (tmp[(i=strlen(tmp)-1)] == '\n')
		    tmp[i] = '\0';
	    fprintf(mailer, "%s\n", tmp);
	    if (lines++ > MAX_LINES) {
	        fprintf(mailer,
		"___________________________\n");
		fprintf(mailer,
		" ** Truncated: Limit of %d lines enforced by w3 listserv\n",
			MAX_LINES);
	    }
	}
	pclose(ls);
	pclose(mailer);
	return;
error:
    {
	callmailer("", from, request);
	fprintf(mailer,"Your command\n\n");
	fprintf(mailer,"\t%s\n", request);
	fprintf(mailer,"could not be processed.\n%s\nCorrect syntax is\n\n");
	fprintf(mailer,"\tSEND doc-address\n\n");
	fprintf(mailer,"Where doc-address is the address of the document you want.\n");
	fprintf(mailer,"(WWW is a synonym for SEND).\n");
	fprintf(mailer,"Valid characters in the doc-address are:\n");
	fprintf(mailer,"\"%s\"\n", valid_chars);
	fprintf(mailer,"There is a limit of %d lines on any returned message.\n",
			MAX_LINES);
	fflush(mailer);
	pclose(mailer);
	return(-1);
    }

}

