!	Make WorldWideWeb line mode hypertext browser under VMS
!       =======================================================
!
! History:
!  14 Aug 91 (TBL)	Reconstituted
!  25 Jun 92 (JFG)	Added TCP socket emulation over DECnet
!
! Bugs:
!	The dependencies are anything but complete - they were
!	just enough to allow the files to be compiled.
!
! Instructions:
!	Use the correct command line for your TCP/IP implementation:
!
!	$ MMS/MACRO=(MULTINET=1)	for Multinet
!	$ MMS/MACRO=(WIN_TCP=1)		for Wollongong TCP/IP
!	$ MMS/MACRO=(UCX=1)		for DEC/UCX
!	$ MMS/MACRO=(DECNET=1)		for socket emulation over DECnet
!
! If you are on HEP net and want to build using the really latest sources on
! PRIAM:: then define an extra macro U=PRIAM::, e.g.
!
!	$ MMS/MACRO=(MULTINET=1, U=PRIAM::)	for Multinet
!
! This will copy the sources from PRIAM as necessary. You can also try
!
!	$ MMS/MACRO=(U=PRIAM::) descrip.mms
!
! to update this file.
!
.IFDEF UCX
LIBS = sys$library:ucx$ipc/lib		! For UCX
OPTION_FILE = 
CFLAGS = /DEBUG/DEFINE=DEBUG
TCP=UCX
.ENDIF
.IFDEF MULTINET
LIBS = multinet.opt/opt			! For Multinet
OPTION_FILE = multinet.opt
CFLAGS = /DEFINE=(DEBUG,MULTINET)
TCP=MULTINET
.ENDIF
.IFDEF WIN_TCP
LIBS = win_tcp.opt/opt			! For Wollongong TCP
OPTION_FILE = win_tcp.opt
CFLAGS = /DEFINE=(DEBUG,WIN_TCP)
TCP=WIN_TCP
.ENDIF
.IFDEF DECNET
LIBS =  disk$c3:[hemmer.unix.usr.lib]libc.opt/opt	! TCP socket library over DECnet
OPTION_FILE = disk$c3:[hemmer.unix.usr.lib]libc.opt
CFLAGS = /DEFINE=(DEBUG,DECNET)
TCP=DECNET
.ENDIF

.IFDEF LIBS
.ELSE
LIBS = multinet.opt/opt			! (Default to multinet)
OPTION_FILE = multinet.opt
CFLAGS = /DEFINE=(DEBUG,MULTINET)
.ENDIF

.INCLUDE Version.make

OBJECTS = HTBrowse.obj, GridText.obj, DefaultStyles.obj

OBJECTS_D = HTBrowse_d.obj, GridText_d.obj, DefaultStyles_d.obj


!___________________________________________________________________
! WWW

WWW_$(TCP).exe :  $(OBJECTS) $(OPTION_FILE) descrip.mms build_$(TCP).com
	define/nolog LNK$LIBRARY SYS$LIBRARY:VAXCRTL.OLB build_$(TCP).com
	link/exe=WWW_$(TCP) $(OBJECTS), [-.library]wwwlib_$(TCP)/lib, $(LIBS)

WWW_d_$(TCP).exe :  $(OBJECTS_D) $(OPTION_FILE) descrip.mms
	define/nolog LNK$LIBRARY SYS$LIBRARY:VAXCRTL.OLB
	link/debug/exe=WWW_d_$(TCP) $(OBJECTS_D), -
		[-.library]wwwlib_$(TCP)/lib, $(LIBS)
! Com file for non-MMS sites
build_$(TCP).com : descrip.mms
	mms/from_sources/out=build_$(TCP).com/macro=($(tcp)=1) www_$(TCP).exe

![-.LIBRARY]WWWLIB_$(TCP).OLB :
!	set def [-.Library]
!.IFEF U
!	mms/macro=($(TCP)=1, u=$(U))
!.ELSE
!	mms/macro=($(TCP)=1)
!.ENDIF
!	set def [-.LineMode]

!____________________________________________________________________

update : www.exe setup.com
	copy www.exe [.works]
	copy setup.com [.works]

!    C O M M O N	M O D U L E S  - Include files


!_____________________________	HTAccess

.IFDEF U
HTAccess.h : $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HTAccess.h"
	     copy $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HTAccess.h" -
             HTAccess.h
.ENDIF
!_____________________________	HTAnchor

.IFDEF U
HTAnchor.h : $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HTAnchor.h"
	     copy $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HTAnchor.h" -
             HTAnchor.h
.ENDIF

!_________________________________ HTFile

.IFDEF U
HTFile.h   : $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HTFile.h"
	     copy $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HTFile.h" -
             HTFile.h
.ENDIF

!_____________________________	HTFormat

.IFDEF U
HTFormat.h : $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HTFormat.h"
	     copy $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HTFormat.h" -
             HTFormat.h
.ENDIF
!__________________________________ HTFTP
.IFDEF DECNET
.ELSE
.IFDEF U
HTFTP.h    : $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HTFTP.h"
             copy $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HTFTP.h" - 
             HTFTP.h
.ENDIF
.ENDIF

!_____________________________	HTGopher
.IFDEF DECNET
.ELSE
HTGopher.obj   : HTGopher.c HTGopher.h HTUtils.h
        cc $(CFLAGS)/obj=$*.obj HTGopher.c
HTGopher_d.obj : HTGopher.c HTGopher.h HTUtils.h
	cc/debug $(CFLAGS)/obj=$*.obj HTGopher.c
.IFDEF U
HTGopher.c : $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HTGopher.c"
	     copy $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HTGopher.c" - 
             HTGopher.c
HTGopher.h : $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HTGopher.h"
	     copy $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HTGopher.h" -
             HTGopher.h
.ENDIF
.ENDIF
!_____________________________	HTHistory

.IFDEF U
HTHistory.h : $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HTHistory.h"
	     copy $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HTHistory.h" -
             HTHistory.h
.ENDIF
!_____________________________	HTNews
.IFDEF DECNET
.ELSE
.IFDEF U
HTNews.h : $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HTNews.h"
	     copy $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HTNews.h" -
             HTNews.h
.ENDIF
.ENDIF
!_____________________________	HTML

.IFDEF U
HTML.h : $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HTML.h"
	     copy $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HTML.h" -
             HTML.h
.ENDIF
!________________________________ HTParse

.IFDEF U
HTParse.h  : $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HTParse.h"
	     copy $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HTParse.h" -
             HTParse.h
.ENDIF

!_____________________________	HTStyle

.IFDEF U
HTStyle.h : $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HTStyle.h"
	     copy $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HTStyle.h" -
             HTStyle.h
.ENDIF
! _________________________________ HTTCP

.IFDEF U
HTTCP.h    : $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HTTCP.h"
	     copy $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HTTCP.h" - 
             HTTCP.h
.ENDIF
!________________________________ HTTP

.IFDEF U
HTTP.h     : $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HTTP.h"
	     copy $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HTTP.h" -
             HTTP.h 
.ENDIF
!_____________________________	SGML

.IFDEF U
SGML.h : $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/SGML.h"
	     copy $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/SGML.h" -
             SGML.h
.ENDIF
!_________________________________ include files only:

.IFDEF U
HTUtils.h  : $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HTUtils.h"
	     copy $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HTUtils.h" -
             HTUtils.h
tcp.h      : $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/tcp.h"
	     copy $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/tcp.h" - 
             tcp.h
HText.h      : $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HText.h"
	     copy $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/HText.h" - 
             HText.h
README      : $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/README"
	     copy $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/README" - 
             README
WWW.h      : $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/WWW.h"
	     copy $(U)"/userd/tbl/hypertext/WWW/Library/Implementation/WWW.h" -
             WWW.h
.ENDIF

!____________________________________________________________________________
!	L I N E   M O D E	M O D U L E S

 
!_____________________________	HTBrowse
!INCS = HTBrowse.h HTUtils.h GridText.h HText.h -
!	HTAnchor.h HTAccess.h HTFormat.h HText.h HTStyle.h WWW.h -
!	HTTCP.h
INCS = -
HTAccess.h      HTFile.h        HTML.h          HTTCP.h         WWW.h -
HTAnchor.h      HTFormat.h      HTNews.h        HTTP.h          tcp.h -
HTAtom.h        HTGopher.h      HTParse.h       HTUtils.h -
HTChunk.h       HTHistory.h     HTString.h      HText.h -
HTFTP.h         HTList.h        HTStyle.h       SGML.h -
HTFont.h

HTBrowse.obj   : HTBrowse.c $(INCS) Version.make
        cc $(CFLAGS)/obj=$*.obj/define=(VL="""$(VL)""") HTBrowse.c
HTBrowse_d.obj : HTBrowse.c  $(INCS) Version.make
	cc/debug $(CFLAGS)/define=(VL="""$(VL)""")/obj=$*.obj HTBrowse.c
.IFDEF U
HTBrowse.c : $(U)"/userd/tbl/hypertext/WWW/LineMode/Implementation/HTBrowse.c"
	     copy $(U)"/userd/tbl/hypertext/WWW/LineMode/Implementation/HTBrowse.c" - 
             HTBrowse.c
HTBrowse.h : $(U)"/userd/tbl/hypertext/WWW/LineMode/Implementation/HTBrowse.h"
	     copy $(U)"/userd/tbl/hypertext/WWW/LineMode/Implementation/HTBrowse.h" - 
             HTBrowse.h
HTFont.h  : $(U)"/userd/tbl/hypertext/WWW/LineMode/Implementation/HTFont.h"
	     copy $(U)"/userd/tbl/hypertext/WWW/LineMode/Implementation/HTFont.h" -
             HTFont.h
.ENDIF
!_____________________________	GridText

GridText.obj   : GridText.c GridText.h HTUtils.h HTBrowse.h
        cc $(CFLAGS)/obj=$*.obj GridText.c
GridText_d.obj : GridText.c GridText.h HTUtils.h HTBrowse.h
	cc/debug $(CFLAGS)/obj=$*.obj GridText.c
.IFDEF U
GridText.c : $(U)"/userd/tbl/hypertext/WWW/LineMode/Implementation/GridText.c"
	     copy $(U)"/userd/tbl/hypertext/WWW/LineMode/Implementation/GridText.c" - 
             GridText.c
GridText.h : $(U)"/userd/tbl/hypertext/WWW/LineMode/Implementation/GridText.h"
	     copy $(U)"/userd/tbl/hypertext/WWW/LineMode/Implementation/GridText.h" -
             GridText.h
.ENDIF
!_____________________________	DefaultStyles

DefaultStyles.obj   : DefaultStyles.c HTStyle.h HTUtils.h
        cc $(CFLAGS)/obj=$*.obj DefaultStyles.c
DefaultStyles_d.obj : DefaultStyles.c HTStyle.h HTUtils.h
	cc/debug $(CFLAGS)/obj=$*.obj DefaultStyles.c
.IFDEF U
DefaultStyles.c : $(U)"/userd/tbl/hypertext/WWW/LineMode/Implementation/DefaultStyles.c"
	     copy $(U)"/userd/tbl/hypertext/WWW/LineMode/Implementation/DefaultStyles.c" - 
             DefaultStyles.c
.ENDIF

! ______________________________  The version file


.IFDEF U
Version.make :  $(U)"/userd/tbl/hypertext/WWW/LineMode/Implementation/Version.make"
	copy $(U)"/userd/tbl/hypertext/WWW/LineMode/Implementation/Version.make" - 
             Version.make
	write sys$output: "Please rebuild with new MMS file"
	exit 2	! Error
.ENDIF

! _____________________________VMS SPECIAL FILES:
! latest version of this one:

.IFDEF U
descrip.mms : $(U)"/userd/tbl/hypertext/WWW/LineMode/vms/descrip.mms"
	copy $(U)"/userd/tbl/hypertext/WWW/LineMode/vms/descrip.mms" -
	descrip.mms
	write sys$output: "Please rebuild with new MMS file just fetched"
	exit 2	! Error

setup.com : $(U)"/userd/tbl/hypertext/WWW/LineMode/vms/setup.com"
	copy $(U)"/userd/tbl/hypertext/WWW/LineMode/vms/setup.com" -
	setup.com

multinet.opt  : $(U)"/userd/tbl/hypertext/WWW/LineMode/vms/multinet.opt"
	     copy $(U)"/userd/tbl/hypertext/WWW/LineMode/vms/multinet.opt" - 
             multinet.opt
win_tcp.opt  : $(U)"/userd/tbl/hypertext/WWW/LineMode/vms/win_tcp.opt"
	     copy $(U)"/userd/tbl/hypertext/WWW/LineMode/vms/win_tcp.opt" - 
             win_tcp.opt

.ENDIF


