!	Make WorldWideWeb SERVERS under VMS
!       =======================================================
!
! History:
!  07 Sep 93 	MD	Created for version 2.07 of httpd
!  06 Nov 93	MD	changed to run in [.vms] directory
!  13 Nov 93    MD	Added image part
!
! Bugs:
!	The dependencies are anything but complete - they were
!	just enough to allow the files to be compiled.
!
! Instructions:
!	Use the correct command line for your TCP/IP implementation,
!	inside the [.VMS] directory:
!
!	$ MMS/MACRO=(MULTINET=1)	for Multinet
!	$ MMS/MACRO=(WIN_TCP=1)		for Wollongong TCP/IP
!	$ MMS/MACRO=(UCX=1)		for DEC/UCX
!	$ MMS/MACRO=(DECNET=1)		for socket emulation over DECnet
!
! To compile without rules (default is with rules):
!
!	$ MMS/MACRO=(MULTINET=1, NORULES=1)	for Multinet
!
! To compile with debug mode:
!	
!	$ MMS/MACRO=(MULTINET=1, DEBUG=1)	for Multinet
!
!
! If you are on HEP net and want to build using the really latest sources on
! PRIAM:: then define an extra macro U=PRIAM::, e.g.
!
!	$ MMS/MACRO=(MULTINET=1, U=PRIAM::)	for Multinet
!
! This will copy the sources from PRIAM as necessary. You can also try
!
!	$ MMS/MACRO=(U=PRIAM::) descrip.mms
!
! to update this file.
!

SRC = [-.Implementation]
EXE = []
WWW_INCL = [--.Library.Implementation]
WWW_LIB  = [--.Library.vms]


.INCLUDE $(SRC)Version.make


! debug flags
.IFDEF DEBUG
DEBUGFLAGS = /DEBUG/NOOPT
LFLAGS = /DEBUG
.ENDIF

! extra defines
.IFDEF NORULES
EXTRADEFINES = DEBUG,VD="""$(VD)""",ACCESS_AUTH
.ELSE
EXTRADEFINES = DEBUG,VD="""$(VD)""",RULES,ACCESS_AUTH
.ENDIF


.IFDEF UCX
LIBS = sys$library:ucx$ipc/lib		! For UCX
OPTION_FILE = 
CFLAGS = $(DEBUGFLAGS)/DEFINE=($(EXTRADEFINES))/INC=($(EXE),$(SRC),$(WWW_LIB),$(WWW_INCL))
TCP=UCX
.ENDIF
.IFDEF MULTINET
LIBS = $(WWW_LIB)multinet.opt/opt		! For Multinet
OPTION_FILE = multinet.opt
CFLAGS = $(DEBUGFLAGS)/DEFINE=($(EXTRADEFINES),MULTINET)/INC=($(EXE),$(SRC),$(WWW_LIB),$(WWW_INCL))
TCP=MULTINET
.ENDIF
.IFDEF WIN_TCP
LIBS = win_tcp.opt/opt			! For Wollongong TCP
OPTION_FILE = win_tcp.opt
CFLAGS = $(DEBUGFLAGS)/DEFINE=($(EXTRADEFINES),WIN_TCP)/INC=($(EXE),$(SRC),$(WWW_LIB),$(WWW_INCL))
TCP=WIN_TCP
.ENDIF
.IFDEF DECNET
LIBS =  disk$c3:[hemmer.unix.usr.lib]libc.opt/opt	! TCP socket library over DECnet
OPTION_FILE = disk$c3:[hemmer.unix.usr.lib]libc.opt
CFLAGS = $(DEBUGFLAGS)/DEFINE=($(EXTRADEFINES),DECNET)/INC=($(EXE),$(SRC),$(WWW_LIB),$(WWW_INCL))
TCP=DECNET
.ENDIF

.IFDEF LIBS
.ELSE
LIBS = $(WWW_LIB)multinet.opt/opt		! (Default to multinet)
OPTION_FILE = multinet.opt
CFLAGS = $(DEBUGFLAGS)/DEFINE=($(EXTRADEFINES),MULTINET)/INC=($(EXE),$(SRC),$(WWW_LIB),$(WWW_INCL))
TCP=MULTINET
.ENDIF



WWW_LIBS = $(WWW_LIB)wwwlib_$(TCP)/lib

VMS_FILES = $(EXE)setup.com $(EXE)descrip.mms

HTTPD_OBJECTS = HTDaemon.obj, HTRetrieve.obj, HTScript.obj, HTSInit.obj
          
HTTPD_HEADERS = $(SRC)HTDaemon.h $(SRC)HTScript.h

HTADM_OBJECTS = HTAdm.obj

HTADM_HEADERS =

HTIMAGE_OBJECTS = HTImage.obj

HTIMAGE_HEADERS = 

VMSHELP_OBJECTS = VMSHelpGate.obj, HTDaemon.obj
          
VMSHELP_HEADERS = $(SRC)HTDaemon.h

DCLSERVER_OBJECTS = DCLServer.obj, HTDaemon.obj
          
DCLSERVER_HEADERS = $(SRC)HTDaemon.h

!___________________________________________________________________
! ALL executables
!vmshelpgate dclserver
exe : $(VMS_FILES) httpd htadm htimage $(EXE)build_$(TCP).com
	@ continue

exe_only : httpd htadm htimage
	@ continue

$(EXE)build_$(TCP).com : $(EXE)descrip.mms
	mms/noaction/from_sources/out=$(EXE)build_$(TCP).com/macro=($(tcp)=1) exe_only
	
          
!___________________________________________________________________
! htadm EXE

htadm : $(HTADM_HEADERS) $(EXE)htadm.exe 
 	@ continue

$(EXE)htadm.exe : 	$(HTADM_OBJECTS)
	link $(LFLAGS)/exe=$(EXE)htadm.exe $(HTADM_OBJECTS), $(WWW_LIBS), $(LIBS) 

!___________________________________________________________________
! htimage EXE

htimage : $(HTIMAGE_HEADERS) $(EXE)htimage.exe 
 	@ continue

$(EXE)htimage.exe : 	$(HTIMAGE_OBJECTS)
	link $(LFLAGS)/exe=$(EXE)htimage.exe $(HTIMAGE_OBJECTS), $(WWW_LIBS), $(LIBS) 

!___________________________________________________________________
! httpd EXE

httpd : $(HTTPD_HEADERS) $(EXE)httpd.exe 
 	@ continue

$(EXE)httpd.exe :	$(HTTPD_OBJECTS)
	link $(LFLAGS)/exe=$(EXE)httpd.exe $(HTTPD_OBJECTS), $(WWW_LIBS), $(LIBS) 

!___________________________________________________________________
! VMSHelpGate EXE

vmshelpgate : $(VMSHELP_HEADERS) $(EXE)vmshelpgate.exe 
 	@ continue

$(EXE)vmshelpgate.exe : $(VMSHELP_OBJECTS)
	link $(LFLAGS)/exe=$(EXE)vmshelpgate.exe $(VMSHELP_OBJECTS), $(WWW_LIBS), $(LIBS) 

!___________________________________________________________________
! DCLServer EXE

dclserver : $(DCLSERVER_HEADERS) $(EXE)dclserver.exe 
 	@ continue

$(EXE)dclserver.exe : $(DCLSERVER_OBJECTS)
	link $(LFLAGS)/exe=$(EXE)dclserver.exe $(DCLSERVER_OBJECTS), $(WWW_LIBS), $(LIBS) 

!_____________________________	HTAdm

HTAdm.obj   : $(SRC)HTAdm.c -
		 $(WWW_INCL)HTUtils.h $(WWW_INCL)HTAlert.h -
                 $(WWW_INCL)HTAAUtil.h $(WWW_INCL)HTPasswd.h
        cc $(CFLAGS)/obj=$*.obj $(SRC)HTAdm.c
.IFDEF U
$(SRC)HTAdm.c :    $(U)"/userd/tbl/hypertext/WWW-duns/Daemon/Implementation/HTAdm.c"
	     copy $(U)"/userd/tbl/hypertext/WWW-duns/Daemon/Implementation/HTAdm.c" - 
             $(SRC)HTAdm.c
.ENDIF
!_____________________________	HTImage

HTImage.obj   : $(SRC)HTImage.c -
		 $(WWW_INCL)HTUtils.h $(WWW_INCL)HTString.h -
		 $(WWW_INCL)HTAlert.h $(WWW_INCL)HTAAUtil.h 
        cc $(CFLAGS)/obj=$*.obj $(SRC)HTImage.c
.IFDEF U
$(SRC)HTImage.c :    $(U)"/userd/tbl/hypertext/WWW-duns/Daemon/Implementation/HTImage.c"
	     copy $(U)"/userd/tbl/hypertext/WWW-duns/Daemon/Implementation/HTImage.c" - 
             $(SRC)HTImage.c
.ENDIF
!_____________________________	HTDaemon

HTDaemon.obj   : $(SRC)HTDaemon.c $(SRC)HTDaemon.h -
		 $(WWW_INCL)HTUtils.h $(WWW_INCL)tcp.h -
                 $(WWW_INCL)HTTCP.h $(WWW_LIB)HTVMSUtils.h
        cc $(CFLAGS)/obj=$*.obj $(SRC)HTDaemon.c
.IFDEF U
$(SRC)HTDaemon.c : $(U)"/userd/tbl/hypertext/WWW-duns/Daemon/Implementation/HTDaemon.c"
	     copy $(U)"/userd/tbl/hypertext/WWW-duns/Daemon/Implementation/HTDaemon.c" - 
             $(SRC)HTDaemon.c
$(SRC)HTDaemon.h : $(U)"/userd/tbl/hypertext/WWW-duns/Daemon/Implementation/HTDaemon.h"
	     copy $(U)"/userd/tbl/hypertext/WWW-duns/Daemon/Implementation/HTDaemon.h" -
             $(SRC)HTDaemon.h
.ENDIF
!_____________________________	HTRetrieve

HTRetrieve.obj   : $(SRC)HTRetrieve.c -
		 $(WWW_INCL)HTUtils.h $(WWW_INCL)tcp.h
        cc $(CFLAGS)/obj=$*.obj $(SRC)HTRetrieve.c
.IFDEF U
$(SRC)HTRetrieve.c : $(U)"/userd/tbl/hypertext/WWW-duns/Daemon/Implementation/HTRetrieve.c"
	     copy $(U)"/userd/tbl/hypertext/WWW-duns/Daemon/Implementation/HTRetrieve.c" - 
             $(SRC)HTRetrieve.c
.ENDIF
!_____________________________	HTScript

HTScript.obj   : $(SRC)HTScript.c $(SRC)HTScript.h -
		 $(WWW_INCL)HTUtils.h $(WWW_INCL)tcp.h
        cc $(CFLAGS)/obj=$*.obj $(SRC)HTScript.c
.IFDEF U
$(SRC)HTScript.c : $(U)"/userd/tbl/hypertext/WWW-duns/Daemon/Implementation/HTScript.c"
	     copy $(U)"/userd/tbl/hypertext/WWW-duns/Daemon/Implementation/HTScript.c" - 
             $(SRC)HTScript.c
$(SRC)HTScript.h : $(U)"/userd/tbl/hypertext/WWW-duns/Daemon/Implementation/HTScript.h"
	     copy $(U)"/userd/tbl/hypertext/WWW-duns/Daemon/Implementation/HTScript.h" - 
             $(SRC)HTScript.h
.ENDIF
!_____________________________	HTSInit

HTSInit.obj   : $(SRC)HTSInit.c 
        cc $(CFLAGS)/obj=$*.obj $(SRC)HTSInit.c
.IFDEF U
$(SRC)HTSInit.c : $(U)"/userd/tbl/hypertext/WWW-duns/Daemon/Implementation/HTSInit.c"
	     copy $(U)"/userd/tbl/hypertext/WWW-duns/Daemon/Implementation/HTSInit.c" - 
             $(SRC)HTSInit.c
.ENDIF
!_____________________________	VMSHelpGate

VMSHelpGate.obj   : $(SRC)VMSHelpGate.c -
		 $(WWW_INCL)HTUtils.h $(WWW_INCL)tcp.h -
                 $(WWW_INCL)HTString.h 
        cc $(CFLAGS)/obj=$*.obj $(SRC)VMSHelpGate.c
.IFDEF U
$(SRC)VMSHelpGate.c : $(U)"/userd/tbl/hypertext/WWW-duns/Daemon/Implementation/VMSHelpGate.c"
	     copy $(U)"/userd/tbl/hypertext/WWW-duns/Daemon/Implementation/VMSHelpGate.c" - 
             $(SRC)VMSHelpGate.c
.ENDIF
!_____________________________	DCLServer

DCLServer.obj   : $(SRC)DCLServer.c -
		 $(WWW_INCL)HTUtils.h $(WWW_INCL)tcp.h -
                 $(WWW_INCL)HTString.h 
        cc $(CFLAGS)/obj=$*.obj $(SRC)DCLServer.c
.IFDEF U
$(SRC)DCLServer.c : $(U)"/userd/tbl/hypertext/WWW-duns/Daemon/Implementation/DCLServer.c"
	     copy $(U)"/userd/tbl/hypertext/WWW-duns/Daemon/Implementation/DCLServer.c" - 
             $(SRC)DCLServer.c
.ENDIF
! ______________________________  The version file

.IFDEF U
$(SRC)Version.make :  $(U)"/userd/tbl/hypertext/WWW-duns/Daemon/Implementation/Version.make"
	copy $(U)"/userd/tbl/hypertext/WWW-duns/Daemon/Implementation/Version.make" - 
        $(SRC)Version.make
	@- write sys$output "Please rebuild with new Version file"
	@- exit 2	! Error
.ENDIF

! _____________________________VMS SPECIAL FILES:
! latest version of this one:

.IFDEF U
$(EXE)descrip.mms : $(U)"/userd/tbl/hypertext/WWW-duns/Daemon/vms/descrip.mms"
	copy $(U)"/userd/tbl/hypertext/WWW-duns/Daemon/vms/descrip.mms" -
	$(EXE)descrip.mms
	@- write sys$output "Please rebuild with new MMS file"
	@- exit 2	! Error
                    
$(EXE)setup.com : $(U)"/userd/tbl/hypertext/WWW-duns/Daemon/vms/setup.com"
	copy $(U)"/userd/tbl/hypertext/WWW-duns/Daemon/vms/setup.com" -
	$(EXE)setup.com
                    
.ENDIF


