
#ifndef HTSCRIPT_H
#define HTSCRIPT_H

#include "HTUtils.h"

#ifdef SHORT_NAMES
#define HTCallSc	HTCallScript
#endif /*SHORT_NAMES*/

/* PUBLIC							HTCallScript()
**		CALL A SCRIPT AND SEND RESULTS BACK TO CLIENT
** ON ENTRY:
**	url		translated URL starting "/htbin/".
**			The next component is taken to be the script
**			name, and the rest of it (if there is more)
**			is the first parameter for the script.
**			E.g.
**				/htbin/foo/bar/x/y
**
**			is called as:
**
**			    <HTBinDir>/foo /bar/x/y keywords...
**
**	keywordvec	array of strings, each of which is one
**			keyword (already unescaped).
**			Escapes special characters to protect them
**			from shell special character translations.
**	soc		socket to write the reply.
**
** ON EXIT:
**	returns		HT_LOADED on success.
*/
PUBLIC int HTCallScript PARAMS((CONST char *	url,
			        char **		keywordvec,
			        int		soc));
#endif
