/*
 * Copyright 1990 Pei-Yuan Wei.	All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */
/*
 * This code is cursed and hashly evil. Read it at your own risk.
 */
#include <stdio.h>
#include <ctype.h>
#include "hash.h"
#include "obj.h"
#include "packet.h"
#include "class.h"
#include "slotaccess.h"
#include "mystrings.h"
#include "glib.h"
#include "slib.h"
#include "misc.h"
#include "event.h"
#include "cexec.h"
#include "tfed.h"

MethodInfo defaultKeyBinding[] =
{
	CARRIAGE,	kbf_newline,
	CTRL_QUESTION,	kbf_dump,
	CTRL_a,		kbf_beginning_of_line,
	CTRL_b,		kbf_backward_char,
	CTRL_d,		kbf_delete_char,
	CTRL_e,		kbf_end_of_line,
	CTRL_f,		kbf_forward_char,
	CTRL_h,		kbf_delete_backward_char,
	CTRL_t,		kbf_join_line,
	CTRL_k,		kbf_kill_line,
	CTRL_l,		kbf_open_line_below,
	CTRL_n,		kbf_next_line,
	CTRL_o,		kbf_open_line,
	CTRL_p,		kbf_previous_line,
	CTRL_q,		kbf_scroll_up_line,
	CTRL_u,		kbf_delete_line,
	CTRL_v,		kbf_scroll_up,
	CTRL_w,		kbf_scroll_down,
	CTRL_x,		kbf_scroll_up,
	CTRL_y,		kbf_insert_yank,
	CTRL_z,		kbf_scroll_down_line,
	DELETE,		kbf_delete_backward_char,
/*	ESC,		kbf_esc_prefix,*/
	RETURN,		kbf_newline,
	TAB,		kbf_ident,
	NULL,		NULL
};
int (*kbflookup[128])();
char sbuff[128];
int buffi;

/*  
 * VT100 sequence for reversing and unreverse video 
 */
char enterReverse_vt100[] = {27, 91, 55, 109, 0};
char leaveReverse_vt100[] = {27, 91, 109, 0};

/* used to specify 
 */
#define STAG_OPEN '('
#define STAG_CLOSE ')'

#ifdef tagsnotused
#define STAG_REVERSE		(1<<9)
#define STAG_HIDDEN		(1<<10)
#define STAG_UNDER		(1<<11)
#define STAG_FONT		(1<<12)
#define STAG_BUTTON		(1<<13)
#define STAG_XRULE		(1<<14)
#define STAG_OBJ		(1<<15)
#define STAG_PUSH		(1<<16)
#define STAG_POP		(1<<17)
#define STAG_BOLD		(1<<18)
#define STAG_SCRIPT		(1<<19)
#endif

TFChar TFC_ARRAY_NEWLINE[] = {
	{'\n', 0, 0, 0},
	{'\0', 0, 0, 0}
};

#define TFC_ARRAY_TAB_SIZE 4
TFChar TFC_ARRAY_TAB[] = {
	{' ', 0, 0, 0},
	{' ', 0, 0, 0},
	{' ', 0, 0, 0},
	{' ', 0, 0, 0},
	{'\0', 0, 0, 0}
};
TFChar TFC_ARRAY_SPACES[] = {
	{' ', 0, 0, 0},
	{' ', 0, 0, 0},
	{' ', 0, 0, 0},
	{' ', 0, 0, 0},
	{' ', 0, 0, 0},
	{' ', 0, 0, 0},
	{' ', 0, 0, 0},
	{' ', 0, 0, 0},
	{' ', 0, 0, 0},
	{' ', 0, 0, 0},
	{' ', 0, 0, 0},
	{'\0', 0, 0, 0}
};

/* CHAR=no update, LINE=update line, SCREEN=update screen */
#define CHAR 0
#define LINE 1
#define SCREEN 2
int refreshMode; 
int updateShown; 

#define TFCBUFF_SIZE 100000
TFChar tfcEditStr[TFCBUFF_SIZE];
TFChar tfcYankStr[TFCBUFF_SIZE];
TFChar tfcBuffStr[TFCBUFF_SIZE];
TFLineNode *theEditLN;	/* editing buffer		*/
TFLineNode *theYankLN;	/* cut/paste/kill/yank buffer 	*/
TFLineNode *theBuffLN;	/* very temporary buffer	*/

XTextItem xcharitem;	/* used by drawChar() */

#define cursorWithinField(tf) \
	((tf->csr_py >= 0) && (tf->csr_py <= tf->yLR))

#define TFCCopy(tfcTo, tfcFrom) \
	{(tfcTo)->c = (tfcFrom)->c; \
	 (tfcTo)->tagID = (tfcFrom)->tagID; \
	 (tfcTo)->fontID = (tfcFrom)->fontID; \
	 (tfcTo)->flags = (tfcFrom)->flags;}

#define textPixelWidth(fontID, FontFont) \
        XTextWidth(FontFont(fontID), str, (int)strlen(str))

#define TBUFFSIZE 1024 /*XXX maximum line length. Used by tfed_buildLines() */

/*
 * forward declaration of all procedures refenced only within this file
 */
int TFCstrlen();
int TFCstrcat();
int str2EBuff();
int TFC2StrStrcpy();
int TFCstrcpy();
int TFCstrncpy();
void dumpTFCArray();

int translateCol2Px();
int translatePx2Col();

void placeCursorWithinStr();
void placeCursor();
int joinLine();
int TFCInsertStr();
int moveOffset();
int jumpLine();
int tfed_scroll_delta();
int moveLine();
int moveLineNode();
int tfed_buildLines();
int deleteLineNode();
TFLineNode *insertLineNode();
TFLineNode *insertBelowLineNode();
char *convertNodeLineToStr();
void freeNodeLines();
void dumpNodeLines();
int renderTF();
int TimedDrawCursor();
int TimedEraseCursor();
void invertCursor();
void drawCursor();
void eraseCursor();
void drawChar();
int traverseToRightEdge();
/*int collectCharsToShift();*/
int scrollLineForward();
int scrollLineBackward();
int scrollDownLowerPart();
int scrollDownLowerPartNEW();
int scrollUpLowerPart();
int scrollUpLowerPartNEW();
void drawLine();
int drawLineOffset();
int drawTextFieldCursor();
TFStruct *updateEStrUser();
int TFCShiftStr();
void TFCInsertChar();
int setBreaks();
int setCurrentFontID();
int LogicOrTFCFlag();
int LogicAndTFCFlag();
char *rangeOperation();

/****************************************************************************
 * externally referenable routines: 
 */
/* something... */

/*
 * call on program startup 
 */
int init_tfed()
{
	int i;

	/*
	 * bind key to functions 
	 */
	for (i = 0; i < 128; i++) kbflookup[i] = NULL;
	for (i = 0; defaultKeyBinding[i].id; i++)
		kbflookup[defaultKeyBinding[i].id] = 
			defaultKeyBinding[i].method;

	/*
	 * used by drawChar()
	 */
	xcharitem.chars = (char*)malloc(sizeof(char));
	xcharitem.nchars = 1;
	xcharitem.delta = 0;

	/*
 	 * initialize the editing buffer shared by multiple text fields 
	 */
	theEditLN = (TFLineNode *)malloc(sizeof(struct TFLineNode));
	theEditLN->prev = NULL; /* never used */
	theEditLN->next = NULL; /* never used */
	theEditLN->linep = tfcEditStr;
	theEditLN->maxFontHeight = 0;
	theEditLN->maxFontDescent = 0;
	theEditLN->length = 0;
	theEditLN->breakc = 1;
	bzero(theEditLN->tagInfo, sizeof(int) * TAGINFO_SIZE);

	/*
 	 * initialize the yank buffer shared by multiple text fields 
	 */
	theBuffLN = (TFLineNode *)malloc(sizeof(struct TFLineNode));
	theBuffLN->prev = NULL; /* never used */
	theBuffLN->next = NULL; /* never used */
	theBuffLN->linep = tfcBuffStr;
	theBuffLN->maxFontHeight = 0;
	theBuffLN->maxFontDescent = 0;
	theBuffLN->length = 0;
	theBuffLN->breakc = 1;
	bzero(theBuffLN->tagInfo, sizeof(int) * TAGINFO_SIZE);

	/*
 	 * initialize the yank buffer shared by multiple text fields 
	 */
	theYankLN = (TFLineNode *)malloc(sizeof(struct TFLineNode));
	theYankLN->prev = NULL; /* never used */
	theYankLN->next = NULL; /* never used */
	theYankLN->linep = tfcYankStr;
	theYankLN->maxFontHeight = 0;
	theYankLN->maxFontDescent = 0;
	theYankLN->length = 0;
	theYankLN->breakc = 1;
	bzero(theYankLN->tagInfo, sizeof(int) * TAGINFO_SIZE);

	return 1;
}

/* 
 * initializes and sets up a text field structure 
 */
TFStruct *tfed_setUpTFStruct(self, text)
	VObj *self;
	char *text;
{
	TFStruct *tf = GET__TFStruct(self);

	if (!tf) {
		tf = (TFStruct*)malloc(sizeof(struct TFStruct));
		if (!tf) {
			fprintf(stderr, "malloc failed\n");
			return 0;
		}
		SET__TFStruct(self, tf);

		tf->firstp =
		tf->lastp =
		tf->offsetp =
		tf->currentp = NULL;

		tf->current_col_sticky = tf->current_col = 0;
		tf->current_row = 0;

		tf->csr_px_sticky = tf->csr_px = 0;
		tf->csr_py = 0;

		tf->screen_col_offset =
		tf->screen_row_offset = 0;

		tf->lineNodeCount = 0;
		tf->lineVisibleCount = 0;

		tf->num_of_lines = 0;

		tf->w = NULL;
		tf->xUL = tf->yUL =
		tf->xLR = tf->yLR =
		tf->width = tf->height = 0;

		tf->esc_toggle = 0;
		tf->bufferUsed = 0;
		tf->self = self;
		tf->fontID = 0;
		tf->currentFontID = 0;

		tf->cursorTimeInfo = 0;
		tf->cursorIsVisible = 0;
/*		tf->cursorBlinkDelay = 250;*/
		tf->cursorBlinkDelay = -1; /* means don't blink */
		tf->highLiteFrom_cx = -1;
		tf->highLiteFrom_cy = -1;
		tf->highLiteTo_cx = -1;
		tf->highLiteTo_cy = -1;

		tf->isRenderAble = 0;

		tf->shownPosition = 0;
		tf->shownSize = 0;

		tf->building_maxFontHeight = 0;
		tf->building_maxFontDescent = 0;
		tf->building_vspan = 0;
	}
	tf->wrap = GET_wrap(self);

	tfed_updateTFStruct(self, text);

	if (helper_txtDisp_updateShownInfo(tf)) {
		VObjList *objl;
		for (objl = GET__shownDepend(self); objl; objl = objl->next) {
			if (objl->o) {
				sendMessage1N2int(objl->o,
					"shownInfoV", 
					GET_shownPositionV(self),
					GET_shownSizeV(self));
			}
		}
	}

	return tf;
}

TFStruct *tfed_updateTFStruct(self, text)
	VObj *self;
	char *text;
{
	TFStruct *tf = updateEStrUser(self);
	int fontID = GET__font(self);
	int newWidth, newHeight;
	int geometryChanged = 0;
	TFLineNode *currentp;

	if (!tf) {
/*		printf("tfed_updateTFStruct: tf=NULL!\n");*/
		return NULL;
	}
	/* 
	 * update geometry of the field
	 */
	/* to allow space between border and characters */
	tf->xUL = 1;
	tf->yUL = 1;
	tf->xLR = GET_width(self) - 2;
	tf->yLR = GET_height(self) - 2;
	newWidth = GET_width(self);
	newHeight = GET_height(self);

	if ((newWidth != tf->width) || (newHeight != tf->height)) {
		tf->width = newWidth;
		tf->height = newHeight;
		tf->csr_px = tf->xUL;
		tf->csr_py = tf->yUL;
		geometryChanged = 1;
	}

	tf->wrap = GET_wrap(self);
	tf->w = GET_window(self);
	tf->fontID = fontID;
	tf->currentFontID = fontID;

	/* 
	 * update content of the field, if specified.
	 */
	if (text) {
		TFChar tbuff[TBUFFSIZE];
		int buffTagInfo[TAGINFO_SIZE];
		int tagID = 0;
		int tbuffi = 0;

		tf->building_maxFontHeight = 0;
		tf->building_maxFontDescent = 0;
		tf->building_vspan = 0;

		if (tf->firstp) freeNodeLines(tf);
		currentp = NULL;
		tf->lineNodeCount = 0;
		tf->lineVisibleCount = 0;
		tfed_buildLines(self, &currentp, &(tf->firstp), &text, &fontID,
				&(tf->lineNodeCount), &(tf->lineVisibleCount),
				tbuff, &tbuffi, buffTagInfo, &tagID,
				&(tf->building_maxFontHeight), 
				&(tf->building_maxFontDescent), 
				&(tf->building_vspan), 
				1);
		tf->offsetp = tf->firstp;
		tf->currentp = tf->firstp;
		tf->current_row = 0;
		tf->current_col_sticky = tf->current_col = 0;
		tf->screen_col_offset = 0;
		tf->screen_row_offset = 0;
		tf->csr_px_sticky = tf->csr_px = 0;
		tf->csr_py = 0;
	}
	tf = updateEStrUser(self);
	replaceNodeLine(theEditLN, tf->currentp, 0);

	tf->isRenderAble = (tf->w && newWidth > 2 && newHeight > 2) ? 1 : 0;

	if (geometryChanged && tf->isRenderAble) {
		VObjList *objl;

		scanVerticalMetrics(tf);
		renderTF(tf);
		helper_txtDisp_updateShownInfo(tf);
		for (objl = GET__shownDepend(self); 
			objl; objl = objl->next) {
			if (objl->o)
				sendMessage1N2int(objl->o,
					"shownInfoV", 
					GET_shownPositionV(self),
					GET_shownSizeV(self));
		}
	}
	return tf;
}

TFStruct *tfed_clone(oldtf)
	TFStruct *oldtf;
{
	TFStruct *newtf;
	TFLineNode *prevp, *currentp, *newLN;
	TFChar *newChs;
	char *cp;
	int i, sz;

	if (!oldtf) return NULL;
	
	newtf = (TFStruct*)malloc(sizeof(struct TFStruct));
	if (!newtf) {
		perror("malloc");
		return NULL;
	}
	bcopy(oldtf, newtf, sizeof(struct TFStruct));

	newtf->firstp = NULL;
	newtf->offsetp = NULL;
	newtf->currentp = NULL;

	prevp = NULL;
	if (oldtf->firstp) {
		currentp = oldtf->firstp;
		while (currentp) {
			newLN = (TFLineNode*)malloc(sizeof(TFLineNode));
			if (!newLN) return 0;
			sz = sizeof(TFChar) * (currentp->length + 1);
			newChs = (TFChar*)malloc(sz);
			if (!newChs) return 0;
			bcopy(currentp, newLN, sizeof(TFLineNode));
			newLN->linep = newChs;
			newLN->length = currentp->length;
			bcopy(currentp->linep, newChs, sz);

			if (prevp) {
				prevp->next = newLN;
				newLN->prev = prevp;
			} else {
				newLN->prev = NULL;
			}

			if (currentp == oldtf->firstp) 
				newtf->firstp = newLN; 
			if (currentp == oldtf->offsetp) 
				newtf->offsetp = newLN; 
			if (currentp == oldtf->currentp) 
				newtf->currentp = newLN; 

			for (i = 0; i < TAGINFO_SIZE; i++) {
				cp = (char*)currentp->tagInfo[i];
				if (cp) {
					newLN->tagInfo[i] = 
						(int)saveString(cp);
				}
			}
			prevp = newLN;
			currentp = currentp->next;
		}
	}
	return newtf;
}

/*
 * renderTextField - render text within the param of self.
 * returns: 1 for success, 0 for failure.
 */
int tfed_render(self)
	VObj *self;
{
	TFStruct *tf = updateEStrUser(self);

	if (tf) {
/*		replaceNodeLine(tf->currentp, theEditLN, 1);*/
	  	if (tf->w && tf->isRenderAble) renderTF(tf);
		return 1;
	}
	return 0;
}

int tfed_processMouseInput(self)
	VObj *self;
{
	TFStruct *tf = updateEStrUser(self);
	int rootx, rooty;
	int mx, my;
	int px, py;
	int prev_cx = -1, prev_cy = -1;
	int init_cx, init_cy;
	int cx, cy;
	XEvent e;
	int stat;
	int initColor = 1;
	int doHighLighting;

	if (!tf->w) return 0;
	doHighLighting = GET_cursor(self);

	GLQueryMouse(tf->w, &rootx, &rooty, &mx, &my);
	mapFromPixelToCharPosition(tf, mx, my, &init_cx, &init_cy, &px, &py);
 	init_cy += tf->screen_row_offset;

	for (;;) {
		XNextEvent(display, &e);

		switch (eventType(e)) {
		case ButtonRelease:
			mapFromPixelToCharPosition(tf, mx, my, 
							&cx, &cy, &px, &py);
			cy += tf->screen_row_offset;

			if (cx == init_cx && cy == init_cy) {
				stat = tfed_placeCursor(self, mx, my);
				process_event(&e, ACTION_TOOL);
				return stat;
			} else {
				stat = 1;

/*				printf("clip row,col: %d,%d - %d,%d\n",
					init_cy, init_cx, cy, cx);
*/
				tf->highLiteFrom_cx = init_cx;
				tf->highLiteFrom_cy = init_cy;
				tf->highLiteTo_cx = cx;
				tf->highLiteTo_cy = cy;

				GLSetSelection(self, NULL);

				process_event(&e, ACTION_TOOL);
				return stat;
			}

		case MotionNotify:
/*			if (((XMotionEvent*)&e)->is_hint != NotifyHint) break;*/

			GLQueryMouse(tf->w, &rootx, &rooty, &mx, &my);
			mapFromPixelToCharPosition(tf, mx, my, 
							&cx, &cy, &px, &py);
			cy += tf->screen_row_offset;

			if (initColor) {
				GLClearSelection();

				GLPrepareObjColor(self);
				if (BDPixel == BGPixel) {
					XSetForeground(display, 
						gc_mesh, FGPixel);
					XSetBackground(display, 
						gc_mesh, BGPixel);
					XSetForeground(display, 
						gc_bd, FGPixel);
				} else {
					XSetForeground(display, 
						gc_mesh, BDPixel);
				}
				initColor = 0;
			}

			if (cx != prev_cx || cy != prev_cy) {
/*				printf("range row,col: %d,%d - %d,%d\n",
					init_cy, init_cx, cy, cx);
*/
				if (prev_cx != -1 && prev_cy != -1) 
					rangeOperation(tf, 
						init_cx, init_cy, 
						prev_cx, prev_cy, 
						1, -1, 0);
				rangeOperation(tf, init_cx, init_cy, 
					cx, cy, 1, 1, 0);
				prev_cx = cx;
				prev_cy = cy;
			}
		break;
		default:
			process_event(&e, ACTION_TOOL);
		break;
		}
	}
}

char *tfed_getSelection(self)
	VObj *self;
{
	TFStruct *tf = GET__TFStruct(self);
	extern VObj *xselectionObj;

	if (tf) {
		return rangeOperation(tf, 
				tf->highLiteFrom_cx, tf->highLiteFrom_cy,
				tf->highLiteTo_cx, tf->highLiteTo_cy,
				0, 0, 1);
	} else return NULL;
}

int tfed_clearSelection(self)
	VObj *self;
{
	TFStruct *tf = GET__TFStruct(self);

	if (tf->highLiteFrom_cx != -1) {
		GLPrepareObjColor(self);
		xselectionObj = NULL;
		rangeOperation(tf, 
				tf->highLiteFrom_cx, tf->highLiteFrom_cy,
				tf->highLiteTo_cx, tf->highLiteTo_cy,
				1, -1, 0);
		tf->highLiteFrom_cx = 
		tf->highLiteFrom_cy =
		tf->highLiteTo_cx = 
		tf->highLiteTo_cy = -1;
	}
	return 1;
}

int tfed_placeCursor(self, mx, my)
	VObj *self;
	int mx, my;
{
	TFStruct *tf = updateEStrUser(self);
	TFChar *tfcp;
	int doDrawCursor = GET_cursor(self);

	if (!tf) {
/*		printf("Internal error: tfed_placeCursor(): tf == NULL\n");*/
		return 0;
	}
	if (mx > tf->xUL && mx < tf->xLR) {
		if (my > tf->yUL && my < tf->yLR) {
			int cx, cy, actual_row;

			if (doDrawCursor) TimedEraseCursor(self, NULL, NULL);

			replaceNodeLine(tf->currentp, theEditLN, 1);

			mapFromPixelToCharPosition(tf, mx, my, &cx, &cy, 
						&(tf->csr_px), &(tf->csr_py));

			tf->currentp = tf->offsetp;
			for (actual_row = 0; actual_row < cy; actual_row++) {
				if (tf->currentp->next)
					tf->currentp = tf->currentp->next;
				else
					break; /* stop at final line */
			}
			tf->current_col_sticky = tf->current_col = cx;
			tf->current_row = tf->screen_row_offset + actual_row;

			replaceNodeLine(theEditLN, tf->currentp, 0);

/*			if (cursorWithinField(tf)) placeCursorWithinStr(tf);*/
			if (doDrawCursor) TimedDrawCursor(self, NULL, NULL);

			if (helper_txtDisp_updateShownInfo(tf)) {
				VObjList *objl;
				for (objl = GET__shownDepend(self); 
					objl; objl = objl->next) {
				  	if (objl->o) {
						sendMessage1N2int(objl->o,
						    "shownInfoV", 
						    GET_shownPositionV(self),
						    GET_shownSizeV(self));
					}
				}
			}
			return 1;
		}
	}
	return 0;
}

int tfed_processKeyEvent(self, w, c)
	VObj *self;
	Window w;
	char c;
{
	TFStruct *tf = updateEStrUser(self);
	int doDrawCursor = GET_cursor(self);
	int stat;

	if (!w) doDrawCursor = 0;
	refreshMode = CHAR;
	updateShown = 0;

	if (doDrawCursor) TimedEraseCursor(self, NULL, NULL);

	if (kbflookup[c]) {
		stat = kbflookup[c](tf);
		if (stat == 0) return 0;
	} else if (tf->esc_toggle == 1) {
		switch (c) {
		case CTRL_v:
			/* scroll down one page */
			kbf_scroll_down(tf);
		break;
		}
		((tf->esc_toggle == 0) ? 
			(tf->esc_toggle = 1) : (tf->esc_toggle = 0));
	} else {
		if (c == ESC) {
			/* record escape key "toggling" */
			((tf->esc_toggle == 0) ? 
				(tf->esc_toggle = 1) : (tf->esc_toggle = 0));
		} else if (isprint(c)) {
/*			printf("(%c),%d\n",c,(int)c);*/
			insertKey(tf, c, tf->currentFontID);
		}
		tf->bufferUsed = 1;
	}
/*printf("csr_px=%d csr_py=%d current_row=%d screen_row_offset=%d \n", 
	tf->csr_px, tf->csr_py, tf->current_row, tf->screen_row_offset);*/

	if (refreshMode == LINE) {
		updateShown = 1;
		if (w && cursorWithinField(tf)) {
			drawLineOffset(tf, 
				       tf->current_row - tf->screen_row_offset,
				       1);
		}
	} else if (refreshMode == SCREEN) {
		updateShown = 1;
		if (w && cursorWithinField(tf)) {
			replaceNodeLine(tf->currentp, theEditLN, 1);
			renderTF(tf);
		}
	}
	if (updateShown) {
		if (helper_txtDisp_updateShownInfo(tf)) {
			VObjList *objl;
			for (objl = GET__shownDepend(self); 
				objl; objl = objl->next) {
				if (objl->o) {
					sendMessage1N1int(objl->o, 
						"shownPositionV", 
						GET_shownPositionV(self));
					sendMessage1N1int(objl->o, 
						"shownSizeV", 
						GET_shownSizeV(self));
				}
			}
		}
	}
	if (doDrawCursor) TimedDrawCursor(self, NULL, NULL);
/*
printf(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n");
dumpTFCArray(theEditLN->linep, NULL);
printf("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n");
*/
	refreshMode = 0;
	return 1;
}

int insertKey(tf, c, fontID)
	TFStruct *tf;
	char c;
	int fontID;
{
	static TFChar tfc;
	int width = FontWidths(fontID)[c];

	TFCShiftStr(theEditLN->linep, tf->current_col, 1);
	tfc.c = c;
	tfc.fontID = fontID;
	tfc.tagID = 0; 
	tfc.flags = 0; 
	TFCCopy(theEditLN->linep + tf->current_col, &tfc);

	if (theEditLN->maxFontHeight < FontMaxHeight(fontID))
		theEditLN->maxFontHeight = FontMaxHeight(fontID);
	theEditLN->length++;
	tf->current_col++;
	tf->current_col_sticky = tf->current_col;

	if ((tf->csr_px + width) < tf->width) {
		scrollLineForward(tf, 1, tf->current_col);
	} else {
/*		printf("\n######## cursor wrap ########\n\n");*/
		tf->csr_px = tf->xUL;
		tf->csr_py += tf->currentp->maxFontHeight;
		scrollLineForward(tf, 1, tf->current_col);
/*printf("refreshMode = SCREEN insertken\n");*/
		refreshMode = SCREEN;
		updateShown = 1;
	}
	tf->csr_px += width;

	return 1;
}

/* insert tab character 
 */
int kbf_ident(tf)
	TFStruct *tf;
{
	/*XXX*/
	insertKey(tf, ' ', tf->currentFontID);
	insertKey(tf, ' ', tf->currentFontID);
	insertKey(tf, ' ', tf->currentFontID);
	insertKey(tf, ' ', tf->currentFontID);

	replaceNodeLine(tf->currentp, theEditLN, 1);
	placeCursorWithinStr(tf);
	tf->bufferUsed = 1;
	return 1;
}

/* start of line 
 */
int kbf_beginning_of_line(tf)
	TFStruct *tf;
{
	tf->current_col_sticky = tf->current_col = 0;
	replaceNodeLine(tf->currentp, theEditLN, 1);
	placeCursorWithinStr(tf);
	tf->bufferUsed = 1;
	return 1;
}

/* end of line 
 */
int kbf_end_of_line(tf)
	TFStruct *tf;
{
	tf->current_col_sticky = tf->current_col = theEditLN->length;
	replaceNodeLine(tf->currentp, theEditLN, 1);
	placeCursorWithinStr(tf);
	tf->bufferUsed = 1;
	return 1;
}

/* back_space 
 */
int kbf_backward_char(tf)
	TFStruct *tf;
{
	tf->current_col -= 1;
	tf->current_col_sticky = tf->current_col;
	if (tf->current_col < 0) {
		placeCursor(tf);
	} else {
		tf->csr_px -= TFCWidth(theEditLN->linep + tf->current_col);
		if (tf->csr_px < tf->xUL) placeCursor(tf);
	}
	tf->bufferUsed = 1;
	return 1;
}

/* forward char 
 */
int kbf_forward_char(tf)
	TFStruct *tf;
{
	tf->current_col += 1;
	tf->current_col_sticky = tf->current_col;
	if (tf->current_col > theEditLN->length) {
		placeCursor(tf);
	} else {
		tf->csr_px += TFCWidth(theEditLN->linep + tf->current_col - 1);
		if ((tf->csr_px + TFCWidth(theEditLN->linep + tf->current_col)) >
			tf->xLR) {
			placeCursor(tf);
		}
	}
	tf->bufferUsed = 1;
	return 1;
}

/* pull in from right 
 */
int kbf_delete_char(tf)
	TFStruct *tf;
{
	if (theEditLN->length > 0) {
		--(theEditLN->length);
/*
		printf("kbf_delete_char(): px=%d c=[%d]'%c'\n",
		       tf->csr_px,
		       tf->current_col,
		       TFCChar(theEditLN->linep + tf->current_col));
*/
		scrollLineBackward(tf, 1, tf->current_col);
		TFCShiftStr(theEditLN->linep, tf->current_col, -1);
		
		/* update maxFontHeight */
/*	
	if (FontMaxHeight(TFCFontID(theEditLN->linep + tf->current_col)) 
*/

	}
/*	refreshMode = LINE;*/
	tf->bufferUsed = 1;
	return 1;
}

/* kill rest of line, and put it in buffer 
 */
#define VERBOSE_KBF_KILL_LINE 0
int kbf_kill_line(tf)
	TFStruct *tf;
{
	int lnA_breakc, lnB_breakc, lnAB_breakc;
	int lnB_maxFontHeight;
	int d, i, shiftSpan, eraseSpan, limit, py, probepy;
	TFLineNode *currentp;
	int offset, upper = 0;

	if (!tf->currentp) {
		write(1,"\007",1); /* beep */
		return 0;
	}

	lnA_breakc = countBreaks(theEditLN->linep);

	if (BDPixel == BGPixel) {
		XSetForeground(display, gc_mesh, FGPixel);
		XSetBackground(display, gc_mesh, BGPixel);
		XSetForeground(display, gc_bd, FGPixel);
	} else {
		XSetForeground(display, gc_mesh, BDPixel);
	}
	if (tf->bufferUsed) {
		TFCClear(theYankLN->linep); 
		theYankLN->length = 0;
		tf->bufferUsed = 0;
	}
	if (tf->current_col == theEditLN->length) {
		/* join current and next line, 
		 * since there's nothing to yank */
		/* printf("yank rest of line\n");*/

		if (tf->current_row >= tf->lineNodeCount - 1) {
			SLBell();
			return 0;
		}
		if (!tf->currentp->next) {
			return 0;
		}
		lnB_maxFontHeight = tf->currentp->next->maxFontHeight;
		lnB_breakc = tf->currentp->next->breakc;

		joinLine(tf);

if (VERBOSE_KBF_KILL_LINE) {
printf("@@@ theYankLN -- length=%d---\n", theYankLN->length);
dumpTFCArray(theYankLN->linep, NULL);
printf("---\n");
}
		TFCstrcat(theYankLN->linep, TFC_ARRAY_NEWLINE);
		theYankLN->length++;

if (VERBOSE_KBF_KILL_LINE) {
printf("@@@ theYankLN -- length=%d---\n", theYankLN->length);
dumpTFCArray(theYankLN->linep, NULL);
printf("---\n");
}
		replaceNodeLine(tf->currentp, theEditLN, 1);
		tf->currentp->breakc = theEditLN->breakc;
		if (lnB_maxFontHeight != tf->currentp->maxFontHeight) {
/*printf("refreshMode = SCREEN kill_line\n");*/
			refreshMode = SCREEN;
			return 1;
		}

		lnAB_breakc = theEditLN->breakc;
		d = lnA_breakc + lnB_breakc - lnAB_breakc;

if (VERBOSE_KBF_KILL_LINE) {
printf("***** lnA_breakc = %d   lnB_breakc = %d  lnAB_breakc = %d   d=%d\n",
		lnA_breakc, lnB_breakc, lnAB_breakc, d);
}
		shiftSpan = d * theEditLN->maxFontHeight;
		eraseSpan = d * theEditLN->maxFontHeight;
		offset = tf->current_row;

if (VERBOSE_KBF_KILL_LINE) {
printf("***** shiftSpan = %d  eraseSpan = %d  offset = %d\n", 
	shiftSpan, eraseSpan, offset);
}
		for (currentp = tf->offsetp, i = 0; i < offset; i++) {
			if (!currentp) break;
			upper += currentp->maxFontHeight * currentp->breakc;
			currentp = currentp->next;
		}
		upper += lnA_breakc * theEditLN->maxFontHeight;

		if (shiftSpan > 0) {
			int safety = tf->height - upper - shiftSpan;
			if (safety > 0) {
				XCopyArea(display, tf->w, tf->w, gc_copy, 
					tf->xUL, tf->yUL + upper + shiftSpan,
					tf->width, safety,
					tf->xUL, tf->yUL + upper);
			}
			if (eraseSpan)
				XClearArea(display, tf->w, 
					tf->xUL, tf->yLR - eraseSpan,
					tf->width, eraseSpan, False);
		}
		drawLineOffset(tf, tf->current_row - tf->screen_row_offset, 1);

	} else {
		TFChar *tfcp;
		int yoffset;

		lnB_maxFontHeight = tf->currentp->maxFontHeight;
		lnB_breakc = 0;

		/* beause tagInfo is not transfered, need to clear
		 * out tag bits when a line is copied
		 * (lest we're referencing garbage tagInfo...)
		 */

if (VERBOSE_KBF_KILL_LINE) {
	printf(">>> current_col=%d\n", tf->current_col);
	printf(">>> theYankLN->length=%d\n", theYankLN->length);
	printf(">>> theEditLN->length=%d\n", theEditLN->length);
}
		TFCstrcpy(theYankLN->linep + theYankLN->length,
				theEditLN->linep + tf->current_col);
		for (tfcp = theYankLN->linep + theYankLN->length;
		     TFCChar(tfcp); tfcp++)
			TFCFlags(tfcp) = TFCFlags(tfcp) & MASK_REVERSE;
		TFCClear(theEditLN->linep + tf->current_col);
		theYankLN->length += theEditLN->length - tf->current_col;
		theEditLN->length = tf->current_col;
		setBreaks(tf, theEditLN);

if (VERBOSE_KBF_KILL_LINE) {
	printf(">>>> current_col=%d\n", tf->current_col);
	printf(">>>> theYankLN->length=%d\n", theYankLN->length);
	printf(">>>> theEditLN->length=%d\n", theEditLN->length);
	printf(">>>> currentp->breakc=%d\n", tf->currentp->breakc);
	printf(">>>> theEditLN->breakc=%d\n", theEditLN->breakc);
}
		replaceNodeLine(tf->currentp, theEditLN, 1);
		setBreaks(tf, tf->currentp);

		drawLineOffset(tf, tf->current_row - tf->screen_row_offset, 1);

		lnAB_breakc = theEditLN->breakc;
		d = lnA_breakc + lnB_breakc - lnAB_breakc;

if (VERBOSE_KBF_KILL_LINE) {
printf("***** lnA_breakc = %d   lnB_breakc = %d  lnAB_breakc = %d   d=%d\n",
		lnA_breakc, lnB_breakc, lnAB_breakc, d);
}
		shiftSpan = d * theEditLN->maxFontHeight;
		eraseSpan = d * theEditLN->maxFontHeight;
		offset = tf->current_row;

if (VERBOSE_KBF_KILL_LINE) {
printf("***** shiftSpan = %d  eraseSpan = %d  offset = %d\n", 
	shiftSpan, eraseSpan, offset);
}
		for (currentp = tf->offsetp, i = 0; i < offset; i++) {
			if (!currentp) break;
			upper += currentp->maxFontHeight * currentp->breakc;
			currentp = currentp->next;
		}
		upper += lnAB_breakc * theEditLN->maxFontHeight;

		if (shiftSpan > 0) {
			int safety = tf->height - upper - shiftSpan;

			if (safety > 0) {
				XCopyArea(display, tf->w, tf->w, gc_copy, 
					tf->xUL, tf->yUL + upper + shiftSpan,
					tf->width, safety,
					tf->xUL, tf->yUL + upper);
			}
			if (eraseSpan)
				XClearArea(display, tf->w, 
					tf->xUL, tf->yLR - eraseSpan,
					tf->width, eraseSpan, False);
		}
	}

	if (shiftSpan > 0) {

		py = tf->yUL;
		i = 0;
		for (currentp = tf->offsetp; ; currentp = currentp->next) {
			if (!currentp) return 0;
			if (currentp == tf->currentp) break;
/*printf("***** i=%d py=%d\n", i, py);*/
			py += currentp->maxFontHeight * currentp->breakc;
			++i;
		}
		probepy = 0;
		limit = tf->height - py - eraseSpan;

		if (VERBOSE_KBF_KILL_LINE) {
			printf("***** limit=%d  yLR=%d\n", limit, tf->yLR);
		}

		for (; ; currentp = currentp->next) {
			if (!currentp) break;
			d = currentp->maxFontHeight * currentp->breakc;
			probepy += d;

			if (VERBOSE_KBF_KILL_LINE) {
				printf("***** d=%d probepy=%d\n", d, probepy);
			}
			if (probepy >= limit) break;
			py += d;
			++i;
		}
		for (; currentp; currentp = currentp->next) {
			if (py >= tf->yLR) break;
			if (VERBOSE_KBF_KILL_LINE) {
			  printf("***** drawing line %d, py=%d\n", i, py);
			}
			drawLineOffset(tf, i, 1);
			i++;
			py += currentp->maxFontHeight * currentp->breakc;
		}
	}

	return 1;
}

/* insert buffer */
int kbf_insert_yank(tf)
	TFStruct *tf;
{
	insertStr(tf, tf->current_col, theYankLN);
	tf->bufferUsed = 1;
	return 1;
}

/* delete to left and pull 
 */
int kbf_delete_backward_char(tf)
	TFStruct *tf;
{
	if (theEditLN->length > 0) {
		--(tf->current_col);
		tf->current_col_sticky = tf->current_col;
		--(theEditLN->length);
		tf->csr_px -= TFCWidth(theEditLN->linep + tf->current_col);
/*
		printf("kbf_delete_backward_char(): px=%d c=[%d]'%c'\n",
		       tf->csr_px,
		       tf->current_col,
		       TFCChar(theEditLN->linep + tf->current_col));
*/
		scrollLineBackward(tf, 1, tf->current_col);
		TFCShiftStr(theEditLN->linep, tf->current_col, -1);
	}
	tf->bufferUsed = 1;
	return 1;
}

/* join current and the next lines 
 */
int kbf_join_line(tf)
	TFStruct *tf;
{
	joinLine(tf);
	tf->bufferUsed = 1;
	return 1;
}

/* delete current line 
 */
int kbf_delete_line(tf)
	TFStruct *tf;
{
	int col;

	if (tf->lineNodeCount <= 0) return 0;
	if (!tf->currentp) return 0;

	tf->lineNodeCount--;
	tf->lineVisibleCount -= tf->currentp->breakc;
	deleteLineNode(tf);
	TFCstrcpy(theEditLN->linep, tf->currentp->linep);
	col = TFCstrlen(theEditLN->linep);
	theEditLN->length = col;
/*printf("refreshMode = SCREEN delete_line\n");*/
	refreshMode = SCREEN;
	tf->bufferUsed = 1;

	return 1;
}
		
/* insert line above current line, after pushing the current line 
 * down one line 
 */
int kbf_open_line(tf)
	TFStruct *tf;
{
	replaceNodeLine(tf->currentp, theEditLN, 1);
	tf->currentp = insertLineNode(tf, tf->currentp, 1);
	TFCstrcpy(theEditLN->linep, tf->currentp->linep);
	theEditLN->length = TFCstrlen(theEditLN->linep);
	tf->current_col_sticky = tf->current_col = 0;

	replaceNodeLine(tf->currentp, theEditLN, 1);
	placeCursorWithinStr(tf);

	tf->bufferUsed = 1;
	return 1;
}

/* insert line below cursor
 */
int kbf_open_line_below(tf)
	TFStruct *tf;
{
	insertBelowLineNode(tf, tf->currentp, 1);
	moveLine(tf, 1);
	tf->screen_col_offset = 0;
	tf->current_col_sticky = tf->current_col = 0;
	tf->bufferUsed = 1;
	return 1;
}

/* previous line 
 */
int kbf_previous_line(tf)
	TFStruct *tf;
{
	moveLine(tf, -1);
	tf->bufferUsed = 1;
	updateShown = 1;
	return 1;
}

/* next line 
 */
int kbf_next_line(tf)
	TFStruct *tf;
{
	moveLine(tf, 1);
	tf->bufferUsed = 1;
	updateShown = 1;
	return 1;
}

/* scroll down one page 
 */
int kbf_scroll_down(tf)
	TFStruct *tf;
{
	moveLine(tf, -(tf->num_of_lines + 1));
	tf->bufferUsed = 1;
	updateShown = 1;
	return 1;
}

/* scroll up one page 
 */
int kbf_scroll_up(tf)
	TFStruct *tf;
{
	moveLine(tf, tf->num_of_lines + 1);
	tf->bufferUsed = 1;
	updateShown = 1;
	return 1;
}

/* scroll page up one line 
 */
int kbf_scroll_up_line(tf)
	TFStruct *tf;
{
	moveOffset(tf, -1, &buffi);
	tf->csr_py += buffi;
	moveLine(tf, -1);
printf("refreshMode = SCREEN scroll_up_line\n");
	refreshMode = SCREEN;
	updateShown = 1;
	tf->bufferUsed = 1;
	return 1;
}

/* scroll up down one line 
 */
int kbf_scroll_down_line(tf)
	TFStruct *tf;
{
	moveOffset(tf, 1, &buffi);
	tf->csr_py += buffi;
	moveLine(tf, 1);
/*printf("refreshMode = SCREEN scroll_down_line\n");*/
	refreshMode = SCREEN;
	updateShown = 1;
	tf->bufferUsed = 1;
	return 1;
}

/* dump lines 
 */
int kbf_dump(tf)
	TFStruct *tf;
{
	replaceNodeLine(tf->currentp, theEditLN, 1);
	refreshMode = SCREEN;
	updateShown = 1;
	tf->bufferUsed = 1;
	dumpNodeLines(tf);
	return 1;
}

int kbf_newline(tf)
	TFStruct *tf;
{
	int length, start = tf->current_col;
	int delta;
	TFChar *tfcp;
	int orig_breakc, after1_breakc, after2_breakc;

/*NO GOOD orig_breakc = theEditLN->breakc; */

	/* should not be needed here */
	orig_breakc = countBreaks(theEditLN->linep); 
/*	printf("***2 orig_breakc = %d\n", orig_breakc);*/

	/* this is not correct... loosing tag infomation */
	for (tfcp = theEditLN->linep + start; TFCChar(tfcp); tfcp++)
		if (TFCTagID(tfcp)) {
/*			theEditLN->tagInfo[TFCTagID(tfcp)];*/
			TFCTagID(tfcp) = 0;
		}

	replaceNodeLine2(theBuffLN, theEditLN, 0, start, 0);
	replaceNodeLine(tf->currentp, theBuffLN, 1);
	after1_breakc = tf->currentp->breakc = 
				countBreaks(tf->currentp->linep);
/*
printf("*** after1_breakc = %d\n", after1_breakc);
*/
	if (BDPixel == BGPixel) {
		XSetForeground(display, gc_mesh, FGPixel);
		XSetBackground(display, gc_mesh, BGPixel);
		XSetForeground(display, gc_bd, FGPixel);
	} else {
		XSetForeground(display, gc_mesh, BDPixel);
	}
	drawLineOffset(tf, tf->current_row - tf->screen_row_offset, 1);
/*
printf("1--in editp --\n");
dumpTFCArray(theEditLN->linep, NULL);
printf("\n1--in currentp --\n");
dumpTFCArray(tf->currentp->linep, NULL);
printf("\n1--in buff --\n");
dumpTFCArray(theBuffLN->linep, NULL);
*/
	insertBelowLineNode(tf, tf->currentp, 1);
	if (!moveLineNode(tf, 1)) return 0;

	delta = rowAdjustOffset(tf, 1);

	length = theEditLN->length - start;
	if (length > 0) {
		replaceNodeLine2(tf->currentp, theEditLN, start, length, 1);
	} else if (length < 0) {
/*		printf("kbf_newline length== -1!\n");*/
		length = 0;
	}
	TFCClear(tf->currentp->linep + length);
	if (length == 0) {
		tf->currentp->maxFontHeight = theEditLN->maxFontHeight;
		tf->currentp->maxFontDescent = theEditLN->maxFontDescent;
	}

	TFCShiftStr(theEditLN->linep, 0, -start);
	theEditLN->length -= start;
	theEditLN->breakc = setBreaks(tf, theEditLN);
	after2_breakc = theEditLN->breakc;
/*	printf("*** after2_breakc = %d\n", after2_breakc);*/
/*
printf("2--in editp -- breakc=%d\n", theEditLN->breakc);
dumpTFCArray(theEditLN->linep, NULL);
printf("\n2--in currentp --\n");
dumpTFCArray(tf->currentp->linep, NULL);
printf("\n2--in buff --\n");
dumpTFCArray(theBuffLN->linep, NULL);
printf("\n");
*/
	if (delta == 0) {
		int diff_breakc = after1_breakc + after2_breakc - orig_breakc;
		int i, offset, upper = 0, shiftSpan, eraseSpan;
		TFLineNode *currentp;

/*		printf("******* diff_breakc = %d\n", diff_breakc);*/

		shiftSpan = theEditLN->maxFontHeight * diff_breakc;
		eraseSpan = theEditLN->maxFontHeight * after2_breakc;
		offset = tf->current_row - tf->screen_row_offset;

		tf->currentp->breakc = theEditLN->breakc;
		tf->currentp->maxFontHeight = theEditLN->maxFontHeight;

		for (i = 0, currentp = tf->offsetp; i < offset; i++) {
			if (!currentp) break;
			upper += currentp->maxFontHeight *
					currentp->breakc;
			currentp = currentp->next;
		}
		if (shiftSpan)
			XCopyArea(display, tf->w, tf->w, gc_copy, 
					tf->xUL, 
					tf->yUL + upper,
					tf->width, 
					tf->height - upper - shiftSpan,
					tf->xUL, 
					tf->yUL + upper + shiftSpan);
		if (eraseSpan)
			XClearArea(display, tf->w, tf->xUL, tf->yUL + upper,
					tf->width, eraseSpan, False);

		drawLineOffset(tf, tf->current_row - tf->screen_row_offset, 1);
		refreshMode = 0;
		updateShown = 1;
	} else {
/*printf("refreshMode = SCREEN new_line\n");*/
		refreshMode = SCREEN;
		updateShown = 1;
	}
	tf->screen_col_offset = 0;
	tf->current_col_sticky = tf->current_col = 0;
	placeCursor(tf);

	tf->bufferUsed = 1;

	return 1;
}

int tfed_get_currentChar(tf, c)
	TFStruct *tf;
	char *c;
{
	if (tf->currentp->linep) {
		*c = TFCChar(theEditLN->linep + tf->current_col);
		return 1;
	} else {
		*c = '\0';
		return 0;
	}
}

int tfed_get_currentLine(tf, strBuff)
	TFStruct *tf;
	char *strBuff;
{
	TFChar *tfcp, *tfcArray = theEditLN->linep;
	int i = 0, j = 0;
	
	while (tfcp = &(tfcArray[i++])) {
		if (!TFCChar(tfcp)) break;
		strBuff[j++] = TFCChar(tfcp);
	}
	strBuff[j++] = '\0';

	return j;
}

/* returns the length of the word 
 */
int tfed_get_currentWord(tf, strBuff)
	TFStruct *tf;
	char *strBuff;
{
	TFChar *tfcp, *tfcArray = theEditLN->linep;
	int i = 0, j = 0;

	/* add code to convert shift in/outs... */
	for (i = tf->current_col; i >= 0; i--) {
		tfcp = &(tfcArray[i]);
		if (!isalpha(TFCChar(tfcp))) break;
	}
	while (tfcp = &(tfcArray[++i])) {
		if (!isalpha(TFCChar(tfcp))) break;
		else if (TFCChar(tfcp) == '\0') break;
		strBuff[j++] = TFCChar(tfcp);
	}
	strBuff[j++] = '\0';

	return j;
}

int tfed_get_charMask(tf)
	TFStruct *tf;
{
	TFChar *tfcp = theEditLN->linep + tf->current_col;

	return (int)TFCFlags(tfcp);
}

char *tfed_get_currentTag(tf)
	TFStruct *tf;
{
	TFChar *tfcp = theEditLN->linep + tf->current_col;

	if (TFCTagID(tfcp))
		return (char*)tf->currentp->tagInfo[TFCTagID(tfcp)];

	return NULL;
}

char *tfed_get_previousTag(tf)
	TFStruct *tf;
{
	TFChar *tfcp = theEditLN->linep + tf->current_col;
	int i = tf->current_col;
	
	/* search backward to find an tag */
	for (; i >= 0; tfcp--, i--) {
		if (!TFCChar(tfcp)) break;
		if (TFCTagID(tfcp))
			return (char*)tf->currentp->tagInfo[TFCTagID(tfcp)];
	}
	return NULL;
}

char *tfed_get_nextTag(tf)
	TFStruct *tf;
{
	TFChar *tfcp = theEditLN->linep + tf->current_col;
	/* search forward to find an tag */
	for (; TFCChar(tfcp); tfcp++) {
		if (TFCTagID(tfcp))
			return (char*)tf->currentp->tagInfo[TFCTagID(tfcp)];
	}
	return NULL;
}

int tfed_get_numberOfLinesDisplayed(tf)
	TFStruct *tf;
{
	return tf->num_of_lines;
}

int tfed_get_totalLineCount(tf)
	TFStruct *tf;
{
	return tf->lineNodeCount;
}

int tfed_get_cursorColumn(tf)
	TFStruct *tf;
{
	return tf->current_col;
}

int tfed_get_cursorRow(tf)
	TFStruct *tf;
{
	return tf->current_row;
}

int tfed_get_lineRowOffset(tf)
	TFStruct *tf;
{
	return tf->screen_row_offset;
}

int tfed_set_wrap(tf, wrap)
	TFStruct *tf;
	int wrap;
{
	tf->wrap = wrap;
	return tf->wrap;
}

void TFCInsertChar(tfcArray, col, tfcp)
	TFChar tfcArray[];
	int col;
	TFChar *tfcp;
{
	TFCShiftStr(tfcArray, col, 1);
	TFCCopy(tfcArray + col, tfcp);
}

int tfed_setBuffer(tf, str)
	TFStruct *tf;
	char *str;
{
	int fontID = 0; /* XXX */

	if (str) return str2EBuff(tf, str, &fontID);
	return str2EBuff(tf, "", &fontID);
}

int tfed_getBuffer(str)
	char *str;
{
	if (str) return TFC2StrStrcpy(str, theBuffLN->linep);
	return 0;
}

int tfed_drawCursor(self)
	VObj *self;
{
	TFStruct *tf = updateEStrUser(self);

	if (tf)
		if (tf->isRenderAble) {
			GLPrepareObjColor(self);
			TimedDrawCursor(self, NULL, NULL);
			return 1;
		}
	return 0;
}

/*
int tfed_internalShownPosition(self)
	VObj *self;
{
  return tf->shownPosition;
}
*/

int tfed_setCursorBlinkDelay(self, delay)
	VObj *self;
	long delay;
{
	TFStruct *tf = updateEStrUser(self);

	if (tf) {
		tf->cursorBlinkDelay = delay;
		return 1;
	}
	return 0;
}

int tfed_eraseCursor(self)
	VObj *self;
{
	TimedEraseCursor(self, NULL, NULL);
	return 1;
}

int tfed_jumpToOffsetLine(self, destLine)
	VObj *self;
	int destLine;
{
	int delta;
	TFStruct *tf = updateEStrUser(self);
	Window w = GET_window(self);

	if (!tf) return 0;
	replaceNodeLine(tf->currentp, theEditLN, 1);
	delta = moveOffset(tf, destLine - tf->screen_row_offset, &buffi);
	tf->csr_py += buffi;
	if (w) {
		if (!tfed_scroll_delta(tf, delta)) renderTF(tf);
	}
	return delta;
}

int tfed_jumpToLine(self, destLine)
	VObj *self;
	int destLine;
{
/*
	TFStruct *tf = updateEStrUser(self);
	int i = 0;
	Window w = GET_window(self);
	int fontID = GET__font(self);

	if (tf) i = jumpLine(tf, w, fontID, destLine);
	return i;
*/
}

/*****************************************************************************
 * internal routines
 */
int TFCstrlen(tfcArray)
	TFChar tfcArray[];
{
	int i = 0;

	while (TFCChar(tfcArray + i)) ++i;

	return i;
}

/* 
 * returns length of tfcAttarTo 
 */
int TFCstrcat(tfcArrayTo, tfcArrayFrom)
	TFChar tfcArrayTo[];
	TFChar tfcArrayFrom[];
{
	int i = 0, j = 0;

	while (TFCChar(tfcArrayTo + i)) ++i;
	while (TFCChar(tfcArrayFrom + j)) {
		TFCCopy(tfcArrayTo + i, tfcArrayFrom + j);
		++i; ++j;
	}
	TFCClear(tfcArrayTo + i);

	return i;
}

int str2EBuff(tf, str, fontID)
	TFStruct *tf;
	char *str;
	int fontID;
{
	return NULL; /*XXX*/
}

/* returns length of tfcAttarTo */
int TFC2StrStrcpy(strTo, tfcArrayFrom)
	char *strTo;
	TFChar *tfcArrayFrom;
{
	int i;

	for (i = 0; strTo[i] = TFCChar(tfcArrayFrom + i); i++);
	strTo[i] = '\0';

	return i;
}

/* returns length of tfcAttarTo */
int TFCstrcpy(tfcArrayTo, tfcArrayFrom)
	TFChar *tfcArrayTo;
	TFChar *tfcArrayFrom;
{
	TFChar *tfcArrayTo_orig = tfcArrayTo;

	while (TFCChar(tfcArrayFrom)) {
		TFCCopy(tfcArrayTo, tfcArrayFrom);
		++tfcArrayFrom;
		++tfcArrayTo;
	}
	TFCClear(tfcArrayTo);

	return tfcArrayTo - tfcArrayTo_orig;
}

int TFCstrncpy(tfcArrayTo, tfcArrayFrom, n)
	TFChar *tfcArrayTo;
	TFChar *tfcArrayFrom;
	int n;
{
	TFChar *tfcArrayTo_orig = tfcArrayTo;

	while (n-- > 0) {
		TFCCopy(tfcArrayTo, tfcArrayFrom);
		++tfcArrayFrom;
		++tfcArrayTo;
	}
	return tfcArrayTo - tfcArrayTo_orig;
}

int joinLine(tf)
	TFStruct *tf;
{
	if (!tf->currentp) return 0;

	tf->lineNodeCount--;
	tf->lineVisibleCount--;
	deleteLineNode(tf);
	TFCstrcpy(theEditLN->linep + theEditLN->length, tf->currentp->linep);
	theEditLN->length += tf->currentp->length;
	setBreaks(tf, theEditLN);

	return 1;
}

#define VERBOSE_INSERTSTR 0
int insertStr(tf, split, source)
	TFStruct *tf;
	int split;
	TFLineNode *source;
{
	int i = 0, j = 0, multipleInserts = 0;
	TFChar *tfcp, *tfcLocalBuff;
	TFLineNode *beginp, *endp, *currentp, *newLN;
	int yoffset = tf->csr_py, offset;
	int d, orig_breakc, after_breakc;
	char c;

	orig_breakc = countBreaks(theEditLN->linep);

	/* save right half in theBuffLN
	 */
	theBuffLN->length = theEditLN->length - split;
	replaceNodeLine2(theBuffLN, theEditLN, split, theBuffLN->length, 0);

	TFCClear(theEditLN->linep + split);
	theEditLN->length = split;

if (VERBOSE_INSERTSTR) {
printf("split = %d\n", split);
printf("--source --\n>");
dumpTFCArray(source->linep, NULL);
printf("<\n--buff --\n>");
dumpTFCArray(theBuffLN->linep, NULL);
printf("<\n--edit --\n>");
dumpTFCArray(theEditLN->linep, NULL);
printf("<\n");
}

	/* find line delimeters (i, j) in source
	 */
	for (tfcp = source->linep; c = TFCChar(tfcp); tfcp++)
		if (c == '\n' || c  == '\r') break;
	j = tfcp - source->linep;

	/* append first source-line to the left half of the edit-line 
	 */
	currentp = tf->currentp;
	offset = tf->current_row;

	if (j == source->length) {
		/* the source is a one liner, so just insert it into
		 * the current buffer, and be done with.
		 */

		TFCstrncpy(theEditLN->linep + split, source->linep, j);
		theEditLN->length = split + j;
		TFCClear(theEditLN->linep + theEditLN->length);

if (VERBOSE_INSERTSTR) {
printf("\n--edit --\n>");
dumpTFCArray(theEditLN->linep, NULL);
printf("<\n");
}
		tf->current_col_sticky = tf->current_col = theEditLN->length;

		TFCstrncpy(theEditLN->linep + theEditLN->length, 
				theBuffLN->linep, theBuffLN->length);
		theEditLN->length += theBuffLN->length;
		TFCClear(theEditLN->linep + theEditLN->length);
		setBreaks(tf, theEditLN);
		replaceNodeLine(currentp, theEditLN, 1);

		d = orig_breakc - currentp->breakc;

if (VERBOSE_INSERTSTR) {
printf("\n--edit -- length=%d\n>", theEditLN->length);
dumpTFCArray(theEditLN->linep, NULL);
printf("<\n");
printf("### orig_breakc=%d  currentbreakc=%d  d=%d\n",
	orig_breakc, currentp->breakc, d);
}

		if (d < 0) {
			if (!scrollDownLowerPartNEW(tf, 
				offset - tf->screen_row_offset, 
				currentp->maxFontHeight * -d)) {
				renderTF(tf);
			}
		} else if (d > 0) {
			if (!scrollUpLowerPart(tf, 
				offset - tf->screen_row_offset, 
				currentp->maxFontHeight * d)) {
				renderTF(tf);
			}
		}
		drawLineOffset(tf, offset - tf->screen_row_offset, 1);

	} else {
		/* the source has atleast one carriage return.
		 */
		int diffSpan, oldSpan, newSpan, finish = 0, length;
		int upper = 0, linesToDraw = 0;
if (VERBOSE_INSERTSTR) {
printf("\n--edit -- length=%d\n>", theEditLN->length);
dumpTFCArray(theEditLN->linep, NULL);
printf("<\n");
}
		oldSpan = currentp->maxFontHeight * orig_breakc;
		newSpan = 0;
		beginp = currentp;
		offset = tf->current_row - tf->screen_row_offset;

if (VERBOSE_INSERTSTR) { fprintf(stderr, "** i=%d j=%d \n", i, j);}

		while (j <= source->length) {
			/* find line delimeter in source */
			for (tfcp = source->linep + i; c = TFCChar(tfcp); 
				tfcp++) 
				if (c == '\n' || c  == '\r') break;
			j = tfcp - source->linep;

if (VERBOSE_INSERTSTR) {fprintf(stderr, "**** i=%d j=%d \n", i, j);}

			/*
			** Compute total length of line, and make line
			*/
			if (j >= source->length) {
				finish = 1;
			}
			if (!linesToDraw) {		/* first line */
				newLN = tf->currentp;
				if (currentp->linep) free(currentp->linep);
				length = theEditLN->length + j - i;
			} else {
				newLN = insertBelowLineNode(tf, currentp, 0);
				tf->current_row++;
				length = j - i;
			}
			if (finish) {			/* last line */
				if (theBuffLN->length)
					length += theBuffLN->length;
			}
			newLN->length = length;
			newLN->linep = (TFChar*)malloc(sizeof(struct TFChar) *
							(newLN->length + 1));
			if (!newLN->linep) {
				fprintf(stderr, "malloc failed\n");
				return 0;
			}

			/*
			** Copy data into line
			*/
			if (!linesToDraw) {		/* first line */
				TFCstrcpy(newLN->linep, theEditLN->linep);
				TFCstrncpy(newLN->linep + theEditLN->length,
						source->linep + i, 
						j - i);
				newLN->length = theEditLN->length + j - i;
				TFCClear(newLN->linep + newLN->length);
			} else {
				TFCstrncpy(newLN->linep, 
					source->linep + i, j - i);
				newLN->length = j - i;
				TFCClear(newLN->linep + newLN->length);
			}
			if (finish) {			/* last line */
				tf->current_col_sticky = tf->current_col 
					= newLN->length;
				if (theBuffLN->length) {
					TFCstrcat(newLN->linep, 
						theBuffLN->linep);
					newLN->length += theBuffLN->length;
				}
				setBreaks(tf, newLN);
				replaceNodeLine(theEditLN, newLN, 0);
			} else {
				setBreaks(tf, newLN);
			}
if (VERBOSE_INSERTSTR) {
fprintf(stderr, "i=%d j=%d \n", i, j);
printf("\n--newLN----length=%d breakc=%d---\n>", newLN->length, newLN->breakc);
dumpTFCArray(newLN->linep, NULL);
printf("<\n");
}
			linesToDraw++;
			currentp = newLN;
			tf->currentp = newLN;
			newSpan += currentp->maxFontHeight * currentp->breakc;

			c = TFCChar(source->linep + j);
			if (c == '\0') {
				if (finish) break;
			}
			i = ++j;
		}
		endp = currentp;

		/* Make space for drawing 
		 */
		currentp = tf->offsetp;
		for (i = 0; i < offset; i++) {
			if (!currentp) break;
			upper += currentp->maxFontHeight * currentp->breakc;
			currentp = currentp->next;
		}
		diffSpan = newSpan - oldSpan;
		if (diffSpan > 0) {
			XCopyArea(display, tf->w, tf->w, gc_copy, 
				tf->xUL, tf->yUL + upper,
				tf->width, tf->height - upper - diffSpan,
				tf->xUL, tf->yUL + upper + diffSpan);
		}
		/* Draw the new lines
		 */
		for (; linesToDraw; linesToDraw--, i++) {
			if (VERBOSE_INSERTSTR) {
/*				printf("DRAWING line offset=%d\n", i);*/
			}
			drawLineOffset(tf, i, 1);
		}
	}
	placeCursorWithinStr(tf);

if (VERBOSE_INSERTSTR) {
printf("--3 dump:\n");
dumpNodeLines(tf);
printf("\n--edit----breakc=%d---\n>", theEditLN->breakc);
dumpTFCArray(theEditLN->linep, NULL);
printf("<\n");
}

	return 1;
}

/*
 * change cursor's visual-related variables in reflection of the cursor's line
 * movement.
 *
 * RETURN: lines moved in the signed direction.
 * span accumulates pixel span of scrolle lines
 */
int moveOffset(tf, dir, span)
	TFStruct *tf;
	int dir;
	int *span;
{
	int lineTraversed = 0, linesToTraverse;

	*span = 0;

	if (dir == 0) return 0;
	linesToTraverse = abs(dir);

	if (dir < 0) {
		/* traverse backward */
		while (lineTraversed < linesToTraverse) {
			if (tf->offsetp == NULL) {
				/* whoops! offsetp is NULL! */
				break; 
			}
			if (tf->offsetp->prev == NULL) {
				/* the offsetp line is the first line */
				break;
			} else {
				/* there exists a previous line node. 
				 * move to previous line node 
				 */
				tf->offsetp = tf->offsetp->prev;
				*span += tf->offsetp->maxFontHeight *
						tf->offsetp->breakc;
				--(tf->screen_row_offset);
			}
			++lineTraversed;
		}
		return -lineTraversed;
	} else {
		/* traverse forward */
		while (lineTraversed < linesToTraverse) {
			if (tf->offsetp == NULL) {
				/* whoops! offsetp is NULL! */
				break; 
			}
			if (tf->offsetp->next == NULL) {
				/* the offsetp line is the last line */
				break;
			} else {
				/* there exists a next line node. 
				 * move to next line node 
				 */
				*span -= tf->offsetp->maxFontHeight *
						tf->offsetp->breakc;
				tf->offsetp = tf->offsetp->next;
				tf->screen_row_offset++;
			}
			lineTraversed++;
		}
		return lineTraversed;
	}
}

int jumpLine(tf, w, fontID, destLine)
	TFStruct *tf;
	Window w;
	int fontID;
	int destLine;
{
	int delta = moveLine(tf, destLine - tf->current_row);
	return delta;
}

/*
 * copy node line
 */
int replaceNodeLine(to, from, freeOldSpaceP)
	TFLineNode *to;
	TFLineNode *from;
	int freeOldSpaceP;
{
	if (!from) {
/*		fprintf(stderr, "*** replaceNodeLine: FROM == NULL\n");*/
		return 0;
	}
	if (!from->linep) {
/*		fprintf(stderr, "*** replaceNodeLine: FROM->linep == NULL\n");*/
		return 0;
	}
	if (!to) {
/*		fprintf(stderr, "*** replaceNodeLine: TO == NULL\n");*/
		return 0;
	}
	if (freeOldSpaceP) {
		if (to->linep) free(to->linep);
		to->linep = (TFChar*)malloc(sizeof(struct TFChar) 
					 * (TFCstrlen(from->linep) + 1));
		if (!to->linep) {
			fprintf(stderr, "malloc failed\n");
			return 0;
		}
	}
	TFCstrcpy(to->linep, from->linep);
	to->length = from->length;
	to->breakc = from->breakc;
	to->maxFontHeight = from->maxFontHeight;
	to->maxFontDescent = from->maxFontDescent;
	bcopy(from->tagInfo, to->tagInfo, sizeof(int) * TAGINFO_SIZE);

	return 1;
}

/*
 * copy node line
 */
int replaceNodeLine2(to, from, start, length, freeOldSpaceP)
	TFLineNode *to;
	TFLineNode *from;
	int start, length;
	int freeOldSpaceP;
{
	if (!from->linep) {
/*		fprintf(stderr, "*** replaceNodeLine2: FROM->linep == NULL\n");*/
		return 0;
	}
	if (!to) {
/*		fprintf(stderr, "*** replaceNodeLine2: TO == NULL\n");*/
		return 0;
	}
	if (freeOldSpaceP) {
		if (to->linep) free(to->linep);
		to->linep = (TFChar*)malloc(sizeof(struct TFChar) * 
					(length + 1));
		if (!to->linep) {
			fprintf(stderr, "malloc failed\n");
			return 0;
		}
	}
	TFCstrncpy(to->linep, from->linep + start, length);
	TFCClear(to->linep + length);
	to->length = length;
	to->maxFontHeight = from->maxFontHeight;
	to->maxFontDescent = from->maxFontDescent;
	bcopy(from->tagInfo, to->tagInfo, sizeof(int) * TAGINFO_SIZE);

	return 1;
}

char *probeTagBody(cp)
	char *cp;
{
	int paran = 0;

	while (cp) {
		if (*cp == STAG_OPEN) {
			++paran;
		} else if (*cp == STAG_CLOSE) {
			--paran;
			if (paran == 0) return ++cp;
		}
		++cp;
	}
	return 0;
}


/*
 * Recrusively convert str into TFLineNodes and insert at currentp
 * fontID = current font id
 * retun lineCount
 */
int tfed_buildLines(self, currentp, beginp, strp, fontIDp, 
			lineNodeCountp, lineVisibleCountp, 
			tbuff, tbuffi, buffTagInfo, tagID,
			maxFontHeight, maxFontDescent, vspan,
			makeLinep)
	VObj *self;
	TFLineNode **currentp;
	TFLineNode **beginp;
	char **strp;
	int *fontIDp;
	int *lineNodeCountp;
	int *lineVisibleCountp;
	TFChar *tbuff;
	int *tbuffi;
	int *buffTagInfo;
	int *tagID;
	int *maxFontHeight;
	int *maxFontDescent;
	int *vspan;
	int makeLinep;
{
	char c, *s, *cp;
	int i, j, stat, flags = 0, done = 0;
	int length, size;
	TFChar *tfcp;
	TFLineNode *newp;

/*	printf("tfed_buildLines : \n");*/
	if (!strp) return 0;

	for (;;) {
		tfcp = tbuff + *tbuffi;
		if (*tbuffi == 0) {
			TFCTagID(tfcp) = 0;
			TFCFlags(tfcp) = NULL;
		}
		if (*maxFontHeight < FontMaxHeight(*fontIDp)) 
			*maxFontHeight = FontMaxHeight(*fontIDp);
		if (*maxFontDescent < FontDescent(*fontIDp))
			*maxFontDescent = FontDescent(*fontIDp);

		for (;;) {
		c = **strp;
/*		printf("_%c", c);*/
		switch (c) {
		case '\\':
			if (GET_verbatim(self)) {
				TFCChar(tfcp) = c;
				TFCFontID(tfcp) = *fontIDp;
				TFCTagID(tfcp) = 0;
				TFCFlags(tfcp) |= flags;
				if (++(*tbuffi) > TBUFFSIZE) {
					/* error. lossing info... */
					goto doit;
				}
				++tfcp;
				TFCTagID(tfcp) = 0;
				TFCFlags(tfcp) = NULL;
				++(*strp);
				break;
			}
			switch (*(++(*strp))) {
			case 'e':
			if (*(++(*strp)) == STAG_OPEN) {
				/*
				 * embed string
				 */
				s = probeTagBody(*strp);
				if (!s) {
					printf("tag error.\n");
					break;
				}
				length = s - *strp - 2;
				cp = (char*)malloc(sizeof(char) * length + 1);
				if (!cp) {
					fprintf(stderr, "malloc failed\n");
					return 0;
				}
				strncpy(cp, *strp + 1, length);
				cp[length] = '\0';

				if (*tagID < TAGINFO_SIZE) {
					++(*tagID);
					TFCTagID(tfcp) = *tagID;
					TFCFlags(tfcp) = flags;
					buffTagInfo[*tagID] = (int)cp;
				} else {
					TFCFlags(tfcp) = flags;
					printf("exceeded tag limit\n");
				}
				*strp = s;
			} else {
				*strp -= 2;
			}
			break;

			case 's':
			if (*(++(*strp)) == STAG_OPEN) {
				Packet result;

				/*
				 * script result insert
				 */
				s = probeTagBody(*strp);
				if (!s) {
					printf("tag error.\n");
					break;
				}
				length = s - *strp - 2;
				cp = (char*)malloc(sizeof(char) * length + 1);
				if (!cp) {
					fprintf(stderr, "malloc failed\n");
					return 0;
				}
				strncpy(cp, *strp + 1, length);
				cp[length] = '\0';

				result.info.s = NULL;
				execScript(self, &result, cp);
				free(cp);
				if (!result.info.s) break;
				cp = PkInfo2Str(&result);
				tfed_buildLines(self, currentp, beginp, 
						&cp, fontIDp, 
						lineNodeCountp,
						lineVisibleCountp, 
						tbuff, tbuffi, 
						buffTagInfo, tagID,
						maxFontHeight, 
						maxFontDescent,
						vspan,
						0);
				tfcp = tbuff + *tbuffi;
				*strp = s;
			} else {
				*strp -= 2;
			}
			break;

			case 'f':
			if (*(++(*strp)) == STAG_OPEN) {
				/*
				 * font change
				 */
				s = probeTagBody(*strp);
				if (!s) {
					printf("tag error.\n");
					break;
				}
				length = s - *strp - 2;
				strncpy(sbuff, *strp + 1, length);
				sbuff[length] = '\0';
				*fontIDp = atoi(sbuff);
				if (*maxFontHeight < FontMaxHeight(*fontIDp)) 
					*maxFontHeight = 
						FontMaxHeight(*fontIDp);
				if (*maxFontDescent < FontDescent(*fontIDp))
	 				*maxFontDescent = 
						FontDescent(*fontIDp);
				*strp = s;
			} else {
				*strp -= 2;
			}
			break;

			case 'h':
			if (*(++(*strp)) == STAG_OPEN) {
				/*
				 * highlight
				 */
				s = probeTagBody(*strp);
				if (!s) {
					printf("tag error.\n");
					break;
				}
				length = s - *strp - 2;
				cp = *strp + 1;
				flags |= MASK_REVERSE;
				while (length--) {
					TFCChar(tfcp) = *cp;
					TFCFontID(tfcp) = *fontIDp;
					TFCTagID(tfcp) = 0;
					TFCFlags(tfcp) = flags;
					++cp;
					++tfcp;
				}
				TFCTagID(tfcp) = 0;
				TFCFlags(tfcp) = NULL;
				flags &= ~MASK_REVERSE;
				*strp = s;
			} else {
				*strp -= 2;
			}
			break;

			case 'u':
			if (*(++(*strp)) == STAG_OPEN) {
				/*
				 * underline
				 */
				s = probeTagBody(*strp);
				if (!s) {
					printf("tag error.\n");
					break;
				}
				length = s - *strp - 2;
				cp = *strp + 1;
				flags |= MASK_UNDER;
				while (length--) {
					TFCChar(tfcp) = *cp;
					TFCFontID(tfcp) = *fontIDp;
					TFCTagID(tfcp) = 0;
					TFCFlags(tfcp) = flags;
					++cp;
					++tfcp;
				}
				TFCTagID(tfcp) = 0;
				TFCFlags(tfcp) = NULL;
				flags &= ~MASK_UNDER;
				*strp = s;
			} else {
				*strp -= 2;
			}
			break;

			case 'b':
			if (*(++(*strp)) == STAG_OPEN) {
				/*
				 * button border
				 */
				s = probeTagBody(*strp);
				if (!s) {
					printf("tag error.\n");
					break;
				}
				length = s - *strp - 2;
				cp = *strp + 1;
				flags |= MASK_BUTTON;
				while (length--) {
					TFCChar(tfcp) = *cp;
					TFCFontID(tfcp) = *fontIDp;
					TFCTagID(tfcp) = 0;
					TFCFlags(tfcp) = flags;
					++cp;
					++tfcp;
					++(*tbuffi);
				}
				TFCTagID(tfcp) = 0;
				TFCFlags(tfcp) = NULL;
				flags &= ~MASK_BUTTON;
				*strp = s;
			} else {
				*strp -= 2;
			}
			break;

			case 'x':
			if (*(++(*strp)) == STAG_OPEN) {
				/*
				 * xrule 
				 */
				TFCChar(tfcp) = ' ';
				TFCFontID(tfcp) = *fontIDp;
				TFCTagID(tfcp) = 0;
				TFCFlags(tfcp) |= flags | MASK_XRULE;
				++tfcp;
				TFCTagID(tfcp) = 0;
				TFCFlags(tfcp) = NULL;
				*strp += 2;
			} else {
				*strp -= 2;
			}
			break;

			case '\\':
				TFCChar(tfcp) = '\\';
				TFCFlags(tfcp) |= flags;
				TFCFontID(tfcp) = *fontIDp;
				++tfcp;
				++(*tbuffi);
				TFCTagID(tfcp) = 0;
				TFCFlags(tfcp) = NULL;
				++(*strp);
				break;
			}
		break;

		case '\t':
			for (j = 0; j < TFC_ARRAY_TAB_SIZE; j++) {
				TFCCopy(tfcp, TFC_ARRAY_TAB + j);
				++(*tbuffi);
				++tfcp;
				TFCTagID(tfcp) = 0;
				TFCFlags(tfcp) = NULL;
			}
			++(*strp);
		break;

		case '\n':
			++(*strp);
			goto doit;

		case '\r':
			/* ignore carriage return characters. Is this good? */
			++(*strp);
		break;

		case '\0': {
			if (!makeLinep) {
				return 1;
			}
			done = 1;
			goto doit;
		}

		default:
			TFCChar(tfcp) = c;
			TFCFontID(tfcp) = *fontIDp;
			TFCTagID(tfcp) = 0;
			TFCFlags(tfcp) |= flags;
			if (++(*tbuffi) > TBUFFSIZE) {
				/* error. lossing info... */
				goto doit;
			}
			++tfcp;
			TFCTagID(tfcp) = 0;
			TFCFlags(tfcp) = NULL;
			++(*strp);
		}
		}
doit:
		newp = (TFLineNode *)malloc(sizeof(struct TFLineNode));
		if (!newp) {
			fprintf(stderr, "malloc failed\n");
			return 0;
		}
		bzero(newp->tagInfo, sizeof(int) * TAGINFO_SIZE);
		if (*tagID > 0) {
			int i;
			for (i = *tagID; i > 0; i--) 
				newp->tagInfo[i] = buffTagInfo[i];
		}
		newp->maxPixelExtentX = 0;
		newp->maxPixelExtentY = 0;
		newp->maxFontHeight = *maxFontHeight;
		newp->maxFontDescent = *maxFontDescent;
		newp->breakc = 1;
		newp->length = *tbuffi;
		size = sizeof(struct TFChar) * (*tbuffi + 1);
		newp->linep = (TFChar*)malloc(size);
		if (!newp->linep) {
			fprintf(stderr, "malloc failed\n");
			return 0;
		}
		bcopy(tbuff, newp->linep, size);
		TFCClear(newp->linep + newp->length);
/*
		printf("made line:>> ");
		dumpTFCArray(newp->linep, newp->tagInfo);
		printf("<<\n");
*/
		/*
		 * Link the new line to tf struct
		 */
		if (currentp) {
			if (*currentp) {
				if ((*currentp)->next) 
					(*currentp)->next->prev = newp;
				newp->prev = *currentp;
				newp->next = (*currentp)->next;
				(*currentp)->next = newp;
				*currentp = newp;
			} else {
				*currentp = newp;
				*beginp = newp;
				newp->prev = NULL;
				newp->next = NULL;
			}
		} else {
			printf("Error: tfed_buildLine(): currentp = NULL\n");
			newp->prev = NULL;
			newp->next = NULL;
			*beginp = newp;
		}
		++(*lineNodeCountp);
		++(*lineVisibleCountp);
		*tbuffi = 0;
		*tagID = 0;
		*vspan += *maxFontHeight;
		*maxFontHeight = 0;
		*maxFontDescent = 0;

		if (c == '\0' || done) {
/*			printf("DONE\n");*/
			return 1;
		}
	}
}

int deleteLineNode(tf)
	TFStruct *tf;
{
	TFLineNode *lp; 
	int ret = 0;

	if (tf->currentp) {
		if (tf->currentp->prev) {
			tf->currentp->prev->next = tf->currentp->next;
		} else {
			/* delete first line */
			/* printf("delete >	first line\n");*/
			tf->firstp = tf->currentp->next;
			tf->offsetp = tf->currentp->next;
		}
		if (tf->currentp->next)
			tf->currentp->next->prev = tf->currentp->prev;
		
		lp = tf->currentp;

		if (tf->currentp->next) {
			tf->currentp = tf->currentp->next;
			ret = 0;
		} else {
			tf->currentp = tf->currentp->prev;
			--(tf->current_row);
			ret = -1;
		}
		if (lp == tf->offsetp) tf->offsetp = tf->currentp;

		if (lp->linep) free(lp->linep);
		free(lp);
	}
/*
printf("refreshMode = SCREEN delteLineNode\n");
	refreshMode = SCREEN;
*/
	return ret;
}

/*
 * insert line above current line, 
 * then set current line pointing to the new line
 */
TFLineNode *insertLineNode(tf, currentp, initLineP)
	TFStruct *tf;
	TFLineNode *currentp;
	int initLineP;
{
	TFLineNode *newp = (TFLineNode *)malloc(sizeof(struct TFLineNode));

	if (!newp) {
		fprintf(stderr, "malloc failed\n");
		return 0;
	}
	newp->prev = currentp->prev;
	newp->next = currentp;
	if (currentp->prev) {
/*		printf("insert before line\n");*/
		currentp->prev->next = newp;
	} else {
/*		printf("insert before first line\n");*/
		tf->currentp = newp;
		tf->firstp = newp;
		tf->offsetp = newp;
	}
	currentp->prev = newp;

	/* the new line has only one character (terminating character) */
	if (initLineP) {
		newp->linep = (TFChar*)malloc(sizeof(struct TFChar));
		if (!newp->linep) {
			fprintf(stderr, "malloc failed\n");
			return 0;
		}
		TFCClear(newp->linep);
		TFCFontID(newp->linep) = tf->currentFontID;
		newp->length = 0;
	}
	bzero(newp->tagInfo, sizeof(int) * TAGINFO_SIZE);
	newp->maxFontHeight = FontMaxHeight(tf->currentFontID);
	newp->maxFontDescent = FontDescent(tf->currentFontID);
	newp->breakc = 1;
	tf->lineNodeCount++;
	tf->lineVisibleCount += tf->currentp->breakc;

	return newp;
}

TFLineNode *insertBelowLineNode(tf, currentp, initLineP)
	TFStruct *tf;
	TFLineNode *currentp;
	int initLineP;
{
	TFLineNode *newp = (TFLineNode *)malloc(sizeof(TFLineNode));

	if (!newp) {
		fprintf(stderr, "malloc failed\n");
		return 0;
	}
	newp->prev = currentp;
	if (currentp) {
		newp->next = currentp->next;
		if (currentp->next) {
			currentp->next->prev = newp;
/*			printf("insertBelowLineNode(): insert.\n");*/
		}
		currentp->next = newp;
/*		printf("insertBelowLineNode(): appending to end.\n");*/
	} else {
/*		printf("insertBelowLineNode(): first&only line.\n");*/
		tf->currentp = newp;
		tf->firstp = newp;
		tf->offsetp = newp;
		newp->next = NULL;
	}
	if (initLineP) {
		newp->linep = (TFChar*)malloc(sizeof(struct TFChar));
		if (!newp->linep) {
			fprintf(stderr, "malloc failed\n");
			return 0;
		}
		TFCClear(newp->linep);
		TFCFontID(newp->linep) = tf->currentFontID;
		newp->length = 0;
	}
	bzero(newp->tagInfo, sizeof(int) * TAGINFO_SIZE);
	newp->maxFontHeight = FontMaxHeight(tf->currentFontID);
	newp->maxFontDescent = FontDescent(tf->currentFontID);
	newp->breakc = 1;
	tf->lineNodeCount++;
	tf->lineVisibleCount += tf->currentp->breakc;

	return newp;
}

char *convertNodeLinesToStr(headp)
	TFLineNode *headp;
{
	TFLineNode *savep;
	char *newStrp;
	TFChar *tfcp;
	int cci, ci = 0, totalLength = 1; /* including terminator */
	short oldState, state;

	/* printf("convertNodeLinesToStr : \n");*/

	savep = headp;
	while (headp) {
		totalLength += headp->length + 1; /* +1 for return character */
		/* printf("%d,%d\n",totalLength, headp->length);*/
		headp = headp->next;
	}
	newStrp = (char *)malloc(sizeof(char) * (totalLength + 1));
	if (!newStrp) {
		fprintf(stderr, "malloc failed\n");
		return 0;
	}

	headp = savep;
	oldState = TFCFlags(headp->linep) & MASK_REVERSE;
	while (headp) {
/*
		printf("%d>%s<\n", headp->length, headp->linep);
		printf("%d>", headp->length);
		dumpTFCArray(headp->linep, NULL);
		printf("<\n");
*/
		cci = 0;

		while (tfcp = &(headp->linep[cci++])) {
			if (TFCChar(tfcp) == '\0') break;
			state = TFCFlags(tfcp) & MASK_REVERSE;
			if (state != oldState) {
				if (state == MASK_REVERSE && 
				    oldState == 0) {
/*					newStrp[ci++] = SHIFT_IN;*/
					newStrp[ci++] = TFCChar(tfcp);
				} else if (state == 0 && 
					   oldState == MASK_REVERSE) {
/*					newStrp[ci++] = SHIFT_OUT;*/
					newStrp[ci++] = TFCChar(tfcp);
				} else {
					fprintf(stderr,
						"convertNodeLinesToStr: unknown tag bit val=%d. ignored.\n",
						state);
					newStrp[ci++] = TFCChar(tfcp);
				}
				oldState = state;
			} else {
				newStrp[ci++] = TFCChar(tfcp);
			}
		}
		headp = headp->next;
		if (headp) newStrp[ci++] = '\n';
	}
/*	if (state == MASK_REVERSE) newStrp[ci++] = SHIFT_OUT;*/
	newStrp[ci++] = '\0';

	return newStrp;
}

char *convertNodeLineToStr(nodep)
	TFLineNode *nodep;
{
	char *newStrp;
	TFChar *tfcp;
	int i = 0, j = 0;
	short oldState, state;

	newStrp = (char *)malloc(sizeof(char) * (nodep->length + 2));
	if (!newStrp) {
		fprintf(stderr, "malloc failed\n");
		return 0;
	}

	oldState = TFCFlags(nodep->linep) & MASK_REVERSE;
	/* add code to convert shift in/outs... */
	while (tfcp = &(nodep->linep[i++])) {
		if (TFCChar(tfcp) == '\0') break;
		state = TFCFlags(tfcp) & MASK_REVERSE;
		if (state != oldState) {
			if (state == MASK_REVERSE && oldState == 0) {
				newStrp[j++] = SHIFT_IN;
				newStrp[j++] = TFCChar(tfcp);
			} else if (state == 0 && oldState == MASK_REVERSE) {
				newStrp[j++] = SHIFT_OUT;
				newStrp[j++] = TFCChar(tfcp);
			} else {
				fprintf(stderr, 
					"convertNodeLineToStr: unknown tag val=%d. ignored.\n",
					state);
				newStrp[j++] = TFCChar(tfcp);
			}
			oldState = state;
		} else {
			newStrp[j++] = TFCChar(tfcp);
		}
	}
	if (state == MASK_REVERSE) newStrp[j++] = SHIFT_OUT;
	newStrp[j++] = '\0';

	return newStrp;
}

void freeNodeLines(tf)
	TFStruct *tf;
{
	TFLineNode *nodep, *nextp;

	nodep = tf->firstp;
	while (nodep) {
		nextp = nodep->next;
		if (nodep->linep) free(nodep->linep);
		free(nodep);
		nodep = nextp;
	}

	TFCClear(theEditLN->linep);
	theEditLN->length = 0;

	tf->firstp = NULL;
	tf->currentp = NULL;
	tf->offsetp = NULL;
}

void dumpNodeLines(tf)
	TFStruct *tf;
{
	int length;
	TFLineNode *currentp;
/*	int lines = 0;*/
/*
printf("current_row=%d current_col=%d\n", tf->current_row, tf->current_col);
printf("screen_row_offset=%d\n", tf->screen_row_offset);
*/
	currentp = tf->offsetp;
/*	lines = tf->num_of_lines;*/

	printf("--offset->tail-------------------\n");
	while (currentp) {

/*	while (currentp && (lines >= 0)) {	
	  	--lines;
*/
		printf("%3d %2d %2d>", 
		       currentp->length, currentp->breakc,
		       currentp->maxFontHeight);
		dumpTFCArray(currentp->linep + tf->screen_col_offset,
			     currentp->tagInfo);
		printf("<\n");
		currentp = currentp->next;
	}
	printf("-------------------------------\n");
}

int setBreaks(tf, currentp)
	TFStruct *tf;
	TFLineNode *currentp;
{
	int segpx = tf->xUL;
	TFChar *tfcp = currentp->linep;
	int pwidthlimit = tf->xLR;

	currentp->breakc = 0;
	for (tfcp = currentp->linep; TFCChar(tfcp); tfcp++) {
		segpx += TFCWidth(tfcp);
		TFCFlags(tfcp) &= ~MASK_WRAP;
		if (segpx > pwidthlimit) {
			if (tfcp > currentp->linep) {
				TFCFlags(tfcp - 1) |= MASK_WRAP;
				currentp->breakc++;
			}
			segpx = tf->xUL;
		}
	}
	currentp->breakc++;
	return currentp->breakc;
}

int setCurrentFontID(tf)
	TFStruct *tf;
{
	TFChar *tfcp;

	tfcp = theEditLN->linep + tf->current_col;
	if (tf->current_col > 0) {
		if (TFCChar(tfcp) == '\0') {
			tf->currentFontID = TFCFontID(tfcp-1);
		} else if (TFCChar(tfcp) == ' ') {
			tf->currentFontID = TFCFontID(tfcp-1);
		} else {
			tf->currentFontID = TFCFontID(tfcp);
		}
	} else {
		tf->currentFontID = TFCFontID(tfcp);
	}
	return tf->currentFontID;
}

int TimedDrawCursor(self, argv, argc)
	VObj *self;
	Packet argv[];		/* dummy */
	int argc;		/* dummy */
{
	TFStruct *tf = updateEStrUser(self);

	if (!tf) return 0;
	if (!cursorWithinField(tf)) return 1;

	if (tf->cursorTimeInfo) cancelEvent(tf->cursorTimeInfo);
/*	if (tf->cursorIsVisible == 0) invertCursor(tf);*/
	if (tf->cursorIsVisible == 0) drawCursor(tf);
	tf->cursorIsVisible = 1;
	if (GET_cursor(self) && tf->cursorBlinkDelay != -1)
		tf->cursorTimeInfo = 
			scheduleEvent(tf->cursorBlinkDelay, TimedEraseCursor, 
					self, NULL, NULL);
	else 
		tf->cursorTimeInfo = 0;

	return 1;
}

int TimedEraseCursor(self, argv, argc)
	VObj *self;
	Packet argv[];		/* dummy */
	int argc;		/* dummy */
{
	TFStruct *tf = updateEStrUser(self);

	if (!tf) return 0;
	if (!cursorWithinField(tf)) return 1;

	if (tf->cursorTimeInfo) cancelEvent(tf->cursorTimeInfo);
/*	if (tf->cursorIsVisible == 1) invertCursor(tf);*/
	if (tf->cursorIsVisible == 1) eraseCursor(tf);
	tf->cursorIsVisible = 0;
	if (GET_cursor(self) && tf->cursorBlinkDelay != -1)
		tf->cursorTimeInfo = 
			scheduleEvent(tf->cursorBlinkDelay, TimedDrawCursor,
					self, NULL, NULL);
	else 
		tf->cursorTimeInfo = 0;

	return 1;
}

void invertCursor(tf)
	TFStruct *tf;
{
/*printf(">>>>>>> invertCursor(): col=%d row=%d px=%d py=%d row_offset=%d...\n",
	tf->current_col, tf->current_row, 
	tf->csr_px, tf->csr_py,
	tf->screen_row_offset);
*/
	if (!tf) return;
	if (!cursorWithinField(tf)) {
/*printf("invertCursor(): not within field\n");*/
		return;
	}
	if (!tf->currentp) return;
	setCurrentFontID(tf);

	if (FontMaxHeight(tf->currentFontID) == tf->currentp->maxFontHeight) {
		XDrawLine(display, tf->w, gc_invert, 
			tf->csr_px, tf->csr_py, tf->csr_px, 
			tf->csr_py + tf->currentp->maxFontHeight);
	} else {
		int px, py1, py2;

		px = tf->csr_px;
		py1 = tf->csr_py;
		py2 = py1 + tf->currentp->maxFontHeight -
			FontMaxHeight(tf->currentFontID) -
			tf->currentp->maxFontDescent +
			FontDescent(tf->currentFontID);
		XDrawLine(display, tf->w, gc_invert_dash, px, py1, px, py2);
		py1 = py2 + 1;
		py2 += FontMaxHeight(tf->currentFontID);
		XDrawLine(display, tf->w, gc_invert, px, py1, px, py2);
		py1 = py2 + 1;
		py2 += FontDescent(tf->currentFontID);
		XDrawLine(display, tf->w, gc_invert_dash, px, py1, px, py2);
	}
	XFlush(display);
}

void drawCursor(tf)
	TFStruct *tf;
{
	if (!tf) return;
	if (!cursorWithinField(tf)) return;
	if (!tf->currentp) return;
	setCurrentFontID(tf);

	if (FontMaxHeight(tf->currentFontID) == tf->currentp->maxFontHeight) {
		XDrawLine(display, tf->w, gc_fg, 
			tf->csr_px, tf->csr_py, tf->csr_px, 
			tf->csr_py + tf->currentp->maxFontHeight);
	}
}

void eraseCursor(tf)
	TFStruct *tf;
{
	if (!tf) return;
	if (!cursorWithinField(tf)) return;
	if (!tf->currentp) return;
	setCurrentFontID(tf);

	if (FontMaxHeight(tf->currentFontID) == tf->currentp->maxFontHeight) {
		XDrawLine(display, tf->w, gc_bg, 
			tf->csr_px, tf->csr_py, tf->csr_px, 
			tf->csr_py + tf->currentp->maxFontHeight);
	}
}

void drawChar(tf, tfcp, px, py)
	TFStruct *tf;
	TFChar *tfcp;
	int px, py;
{
	xcharitem.font = FontFont(TFCFontID(tfcp));
	xcharitem.chars[0] = TFCChar(tfcp);
	XDrawText(display, tf->w, gc_fg, px, py, &xcharitem, 1);
	XFlush(display);
}

TFStruct *updateEStrUser(self)
	VObj *self;
{
	static VObj *currentUserObj = NULL;
	static TFStruct *tf = NULL;

	if (self == currentUserObj) {
		return GET__TFStruct(self);
	} else {
		TFStruct *selfTF = GET__TFStruct(self);
		if (currentUserObj) {
			replaceNodeLine(tf->currentp, theEditLN, 1);
		}
		if (selfTF) {
			if (selfTF->currentp) {
				replaceNodeLine(theEditLN, selfTF->currentp,0);
			}
			currentUserObj = self;
			tf = selfTF;
			return selfTF;
		}
	}
	return NULL;
}

int TFCShiftStr(tfcArray, starti, shift)
	TFChar tfcArray[];
	int starti, shift;
{
	int length, shifts = 0;
	int i, j = 0;

	length = TFCstrlen(tfcArray);
	if (shift > 0) {
		TFCClear(tfcArray + length + shift);
		for (i = length - starti; i > 0; i--) {
			++j;
			TFCCopy(tfcArray + length + shift - j, 
				tfcArray + length - j);
			++shifts;
		}
	} else {
		i = length-starti;
		TFCClear(tfcArray + length - shift + j);
		while (i >= 0) {
			TFCCopy(tfcArray + starti + j, 
				tfcArray + starti - shift + j);
			--shifts;
			++j;
			--i;
		}
	}
	return shifts;
}


void dumpTFCArray(tfcbuff, tagInfo)
	TFChar tfcbuff[];
	int *tagInfo;
{
	TFChar *tfcp;
	int j = 0, tagID;

	for (;;) {
		tfcp = tfcbuff + j;
		if (!tfcp) {
			fprintf(stderr, 
				"ierror: malformed tfc array: tfcp = NULL\n");
			break;
		}
		if (!TFCChar(tfcp)) break;
/*
		printf("%c", TFCChar(tfcp));
*/
		if (TFCFlags(tfcp) & MASK_REVERSE ||
			TFCFlags(tfcp) & MASK_BUTTON) {
			printf("%s%c%s", 
				enterReverse_vt100, 
				TFCChar(tfcp), 
				leaveReverse_vt100);
		} else {
/*
			printf("%c", TFCChar(tfcp));
*/
			printf("%c(%d)", TFCChar(tfcp), TFCFontID(tfcp));
		}
/*
		printf("%d", TFCFontID(tfcp));
		printf("fontID=%d, ", TFCFontID(tfcp));
		printf("width=%d, ", TFCWidth(tfcp));
		if (TFCFlags(tfcp) & MASK_WRAP) printf("wrap, ");
		printf("\n");
*/
		if (TFCTagID(tfcp)) {
			if (TFCTagID(tfcp) > TAGINFO_SIZE) {
				printf("Error: tagID > TAGINFO_SIZE(%d)!\n",
					TAGINFO_SIZE);
			} else {
				if (tagInfo) 
					printf("[%d:%s]", 
						TFCTagID(tfcp), 
						tagInfo[TFCTagID(tfcp)]);
				else
					printf("[%d:?]", TFCTagID(tfcp));
			}
		}
		++j;
	}
}

int translateCol2Px(tfcp, col)
	TFChar *tfcp;
	int col;
{
	int px = 0;

	for (; col; col--, tfcp++) {
		if (TFCChar(tfcp)) px += TFCWidth(tfcp);
		else break;
	}
	return px;
}

int translatePx2Col(tfcp, px)
	TFChar *tfcp;
	int px;
{
	int pi = 0, col = 0;

	for (; TFCChar(tfcp); tfcp++) {
		pi += TFCWidth(tfcp);
		if (pi >= px) break;
		++col;
	}
	return col;
}

void placeCursorWithinStr(tf)
	TFStruct *tf;
{
/*	printf("pcws: %d %d\n",tf->current_col,tf->screen_col_offset);*/
	/* make sure current_col is within the string range */
	if (tf->current_col != tf->current_col_sticky) {
		tf->current_col = tf->current_col_sticky;
	}
	if (tf->current_col > theEditLN->length)
		tf->current_col = theEditLN->length;

	if (cursorWithinField(tf)) placeCursor(tf);
}

/* make use of wrap info 
 */
int countBreaks(tfcp)
	TFChar *tfcp;
{
	int n = 0;

	do {
		if (!TFCChar(tfcp)) return ++n;
		if (TFCFlags(tfcp) & MASK_WRAP) ++n;
	} while (++tfcp);
	return n;
}

void placeCursor(tf)
	TFStruct *tf;
{
	TFLineNode *currentp;
	TFChar *tfcp;
	int i, xpos = tf->xUL, ypos = tf->yUL;

	if (tf->current_row == tf->screen_row_offset) {
		currentp = tf->offsetp;
	} else if (tf->current_row < tf->screen_row_offset) {
		for (currentp = tf->offsetp; ; currentp = currentp->prev) {
			if (!currentp) return;
			if (currentp == tf->currentp) break;
			if (!currentp->prev) break;
			i = currentp->maxFontHeight * currentp->breakc;
/*			printf("*****> ypos=%d i=%d\n", ypos, i);*/
			if (ypos - i < tf->yUL) {
				/* cursor is partially obscured at top, try
				 * to scroll page down */
/*			printf("************> ypos=%d ypos+y=%d\n", ypos, i);*/
				moveOffset(tf, -1, &buffi);
				tfed_scroll_delta(tf, -1);
				updateShown = 1;
				placeCursor(tf);
				return;
			}
			ypos -= i;
		}
	} else if (tf->current_row > tf->screen_row_offset) {
		for (currentp = tf->offsetp; ; currentp = currentp->next) {
			if (!currentp) return;
/*			printf("*****> ypos=%d i=%d\n", ypos, i);*/
			i = currentp->maxFontHeight * currentp->breakc;
			if (ypos + i > tf->yLR) {
				/* cursor is partially obscured at bottom, try
				 * to scroll page up */
/*			printf("************> ypos=%d ypos+y=%d\n", ypos, i);*/
				moveOffset(tf, 1, &buffi);
				tfed_scroll_delta(tf, 1);
				updateShown = 1;
				placeCursor(tf);
				return;
			}
			if (currentp == tf->currentp) break;
			if (!currentp->next) break;
			ypos += i;
		}
	}
	for (i = 0, tfcp = currentp->linep; TFCChar(tfcp); i++, tfcp++) {
		if (i >= tf->current_col) break;
		if (TFCFlags(tfcp) & MASK_WRAP) {
			xpos = tf->xUL;
			ypos += currentp->maxFontHeight;
		} else {
			xpos += TFCWidth(tfcp);
		}
	}
/*	printf("@@@@@ i=%d xpos=%d ypos=%d \n", i, xpos, ypos);*/

	tf->csr_px = xpos;
	tf->csr_py = ypos;
}

int moveLine(tf, dir)
	TFStruct *tf;
	int dir;
{
	int delta, actual_delta;
	int cursorWasWithinField = cursorWithinField(tf);

	refreshMode = 0;
/*	printf("moveLine cursor=%d\n", cursorWasWithinField);*/

	replaceNodeLine(tf->currentp, theEditLN, 1);
	delta = moveLineNode(tf, dir);
	replaceNodeLine(theEditLN, tf->currentp, 0);

/*	col = translatePx2Col(theEditLN->linep, tf->current_px_sticky); */
	if (tf->current_col < tf->current_col_sticky)
		tf->current_col = tf->current_col_sticky;

	/* if the cursor was within the field before the move, make sure cursor
	 * is remains visible. Move offset if necessary.
	 */
/*	printf("moveLine delta=%d\n", delta);*/
	if (cursorWasWithinField) {
/*		printf("moveLine 1\n");*/
		if (tf->csr_py < 0) {
/*			printf("moveLine 2\n");*/
			moveOffset(tf, delta, &buffi);
/*			tf->csr_py += buffi;*/

		} else if (tf->csr_py > tf->yLR) {
/*			printf("moveLine 3\n");*/
			moveOffset(tf, delta, &buffi);
/*			tf->csr_py += buffi;*/
		} else {
/*			printf("moveLine inside param.\n");*/
		}
	} else {
/*		printf("moveLine 5\n");*/
	}
	placeCursorWithinStr(tf);

/*	if (tf->w) {
		if (tfed_scroll_delta(tf, actual_offset_delta)) {
			refreshMode = 0;
		} else {
			refreshMode = SCREEN;
		}
	}
*/
	return delta;
}

int rowAdjustOffset(tf, delta)
	TFStruct *tf;
	int delta;
{
	int actual_offset_delta = 0;

	/* if the cursor was within the field before the move, make sure cursor
	 * is remains visible. Move offset if necessary.
	 */
/*	printf("rowPlaceCursor delta=%d\n", delta);*/
	if (tf->csr_py < 0) {
		actual_offset_delta = moveOffset(tf, delta, &buffi);
/*		tf->csr_py += buffi;*/
	} else if (tf->csr_py > tf->yLR) {
		actual_offset_delta = moveOffset(tf, delta, &buffi);
/*		tf->csr_py += buffi;*/
	}
	return actual_offset_delta;
}

int rowAdjustLine(tf, delta)
	TFStruct *tf;
	int delta;
{
	if (tfed_scroll_delta(tf, delta)) {
		refreshMode = 0;
	} else {
printf("refreshMode = SCREEN rowAdjustLine\n");
		refreshMode = SCREEN;
	}
	return delta;
}

int moveLineNode(tf, dir)
	TFStruct *tf;
	int dir;
{
	int lineTraversed = 0, linesToTraverse;

	linesToTraverse = abs(dir);
	if (dir == 0) return 0;
	if (dir < 0) {
		/* traverse backward */
		while (lineTraversed < linesToTraverse) {
			if (tf->currentp == NULL) {
				/* whoops! currentp is NULL! */
				break; 
			}
			if (tf->currentp->prev == NULL) {
				/* the current line is the first line.
				 * stop here. */
				break;
			}
			/* there exists a previous line node. 
			 * move to previous line node */
			tf->currentp = tf->currentp->prev;
			if (tf->currentp == tf->firstp) {
				/* reached the first line. */
				tf->firstp = tf->currentp;
			}
/*XXXXX			--(tf->current_row);*/
			++lineTraversed;
		}
	} else {

		/* traverse forward */
		while (lineTraversed < linesToTraverse) {
			if (tf->currentp == NULL) {
				/* whoops! currentp is NULL! */
				break; 
			}
			if (tf->currentp->next == NULL) {
				/* the current line is the last line.
				 * stop here. */
				break;
			}
			/* there exists a next line node. 
			 * move to next line node */
			tf->currentp = tf->currentp->next;
/*			tf->current_row++;*/
			++lineTraversed;
		}
	}
/*
	if ((tf->current_row < tf->screen_row_offset) ||
	    (tf->current_row > (tf->screen_row_offset + tf->num_of_lines))) {
		refreshMode = SCREEN;
	}
*/
	return dir < 0 ? -lineTraversed : lineTraversed;
}

/*
 * draws a line (string), using the text-field info 
 */
void drawLine(tf, currentp, yoffset)
	TFStruct *tf;
	TFLineNode *currentp;
	int *yoffset;
{
	int fontyoffset, length;

	if (!tf->w) return;
	if (!cursorWithinField(tf)) {
		/*printf("drawLine: cursor not within field... abort\n");*/
		return;
	}
	fontyoffset = *yoffset + currentp->maxFontHeight - 
			currentp->maxFontDescent;
	XClearArea(display, tf->w, tf->xUL, *yoffset, tf->width,
		*yoffset + currentp->maxFontHeight * currentp->breakc - 1,
		False);

	if (BDPixel == BGPixel) {
		XSetForeground(display, gc_mesh, FGPixel);
		XSetBackground(display, gc_mesh, BGPixel);
		XSetForeground(display, gc_bd, FGPixel);
	} else {
		XSetForeground(display, gc_mesh, BDPixel);
	}
	drawLineSeg(tf, currentp, yoffset, &fontyoffset);
}

int drawLineSeg(tf, currentp, yoffset, fontyoffset)
	TFStruct *tf;
	TFLineNode *currentp;
	int *yoffset;
	int *fontyoffset;
{
	TFChar *segheadtfcp = currentp->linep;
	TFChar *tfcp = currentp->linep;
	int segendpx, segpx = tf->xUL;
	int pwidthlimit = tf->xLR;
	int stat, nosegdrawn = 0;
	XTextItem item;
	Window w = tf->w;
	int x1, y1, x2, y2;
	short prevFontID, prevVideo;
	char *buffp;
	GC usegc;

	item.delta = 0;
	item.chars = buff;

	while (TFCChar(tfcp)) {

		/* grab the next segment 
		 */
		segheadtfcp = tfcp;
		segendpx = segpx;

		prevFontID = TFCFontID(tfcp);
		prevVideo = TFCFlags(tfcp) & 
			(MASK_REVERSE | MASK_UNDER | MASK_BUTTON | MASK_XRULE);

		buffp = buff;
		for (;;) {
			if (prevFontID == TFCFontID(tfcp) &&
			    prevVideo == (TFCFlags(tfcp) & 
				(MASK_REVERSE | MASK_UNDER | MASK_BUTTON | 
				 MASK_XRULE))) {

				TFCFlags(tfcp) &= ~MASK_WRAP;
				segendpx += TFCWidth(tfcp);
				if (segendpx > pwidthlimit) {
 					*buffp = '\0';
					TFCFlags(tfcp - 1) |= MASK_WRAP;
					stat = 1;
					break;
				} else {
					if (!(*buffp = TFCChar(tfcp))) {
						stat = 0;
						break;
					}
					buffp++;
					tfcp++;
				}
			} else {
				stat = 2;
				break;
			}
		}

		if (!*buff) {
			if (TFCWidth(tfcp) > pwidthlimit) {
				/* hey, what's the deal? looks like 
				 * problem is a tiny window. so, 
				 * instead of not drawing anything, 
				 * draw obscured character, in the
				 * hope of hinting the user to
				 * enlarges the window.
				 */
				segendpx += TFCWidth(tfcp);
				buff[0] = TFCChar(tfcp);
				tfcp++;
				stat = 1;
			}
		}
		/*
		buff[tfcp - segheadtfcp] = '\0';
		printf(">>drawLineSeg: stat=%d, segment = [%s]\n", stat, buff);
		*/

		/* drawing the segment 
		 */
		if (*buff) {
			item.font = FontFont(TFCFontID(segheadtfcp));
			item.nchars = tfcp - segheadtfcp;

			if (!TFCFlags(segheadtfcp)) {
				XDrawText(display, w, gc_fg, 
					segpx, *fontyoffset, &item, 1);
			} else {
				if (TFCFlags(segheadtfcp) & MASK_BUTTON) {
					x1 = segpx;
					y1 = *yoffset;
					x2 = segendpx; 
					y2 = *yoffset 
						+ currentp->maxFontHeight;

					if (lookAndFeel != LAF_BARE) {
						XDrawRectangle(display, w, 
							gc_mesh, x1, y2-2, 
							x2-x1-2, 1);
						XDrawRectangle(display, w, 
							gc_mesh, x2-2, y1, 
							1, y2-y1-2);
						XDrawLine(display, w, gc_bd, 
							x1, y1, x2-1, y1);
						XDrawLine(display, w, gc_bd, 
							x1, y1, x1, y2-1);
						XDrawLine(display, w, gc_bd, 
							x1+1, y1+1, x1+1,y2-2);
					} else {
						XDrawRectangle(display, w, 
							gc_mesh, x1, y2-2, 
							x2-x1-2, 1);
					}
					usegc = gc_fg;
				}				
				if (TFCFlags(segheadtfcp) & MASK_UNDER) {
					XDrawLine(display, w, gc_fg,
						segpx, *fontyoffset + 1,
						segendpx, *fontyoffset + 1);
					usegc = gc_fg;
				}
				if (TFCFlags(segheadtfcp) & MASK_XRULE) {
					int y = *yoffset 
						+ currentp->maxFontHeight / 2;
					XDrawLine(display, w, gc_fg,
						tf->xUL, y,
						tf->xLR, y);
					usegc = gc_fg;
				}
				if (TFCFlags(segheadtfcp) & MASK_REVERSE) {
					XFillRectangle(display, w, gc_fg,
						segpx, *yoffset, 
						segendpx - segpx, 
						currentp->maxFontHeight);
					usegc = gc_invert;
				}
				XDrawText(display, w, usegc, segpx, 
					*fontyoffset, &item, 1);
			}
		} else {
			/* just in case */
			if (++nosegdrawn > 2) break;
		}

		if (stat == 0) {
			/* end of line */
			break;
		} else if (stat == 1) {
			/* carriage break to next line */
			segpx = tf->xUL;
			*yoffset += currentp->maxFontHeight;
			*fontyoffset += currentp->maxFontHeight;

			if (tf->wrap == 0) break;
		} else {
			/* continue */
			segpx = segendpx;
		}
	}
	return 1;
}

/* draws a line(string), using the text-field info 
 * line linesOffset is offset from first line on screen
 */
int drawLineOffset(tf, linesOffset, clearBG)
	TFStruct *tf;
	int linesOffset;
	int clearBG;
{
	int i, yoffset, fontyoffset;
	TFLineNode *currentp;

	if (!tf->w) return 0;

	yoffset = tf->yUL;

	/* get i'th line from offset */
	currentp = tf->offsetp;
	for (i = 0; i < linesOffset; i++) {
		yoffset += currentp->maxFontHeight * currentp->breakc;
		currentp = currentp->next;
		if (!currentp) return 0;
	}

	fontyoffset = yoffset + currentp->maxFontHeight - 
			currentp->maxFontDescent;

	if (clearBG && tf->isRenderAble) 
		XClearArea(display, tf->w,
				tf->xUL, yoffset, 
				tf->width, 
				currentp->maxFontHeight * currentp->breakc,
				False);

	drawLineSeg(tf, currentp, &yoffset, &fontyoffset);

	return 1;
}

int renderTF(tf)
	TFStruct *tf;
{
	TFLineNode *currentp;
	TFChar *linep, *tfcp;
	int yoffset, fontyoffset, maxFontHeight, maxFontDescent, pwidthlimit;
	int segpx;
	int fontID, lfontID = -1;
	FontInfo *fip;

	if (!tf->w || !tf->isRenderAble) return 0;

	pwidthlimit = tf->xLR;
	currentp = tf->offsetp;
	yoffset = tf->yUL;
	fontyoffset = tf->yUL;

	GLPrepareObjColor(tf->self);

	XClearWindow(display, tf->w);

	if (BDPixel == BGPixel) {
		XSetForeground(display, gc_mesh, FGPixel);
		XSetBackground(display, gc_mesh, BGPixel);
		XSetForeground(display, gc_bd, FGPixel);
	} else {
		XSetForeground(display, gc_mesh, BDPixel);
	}

	while (currentp) {
		linep = currentp->linep;

		if (!linep || (yoffset > tf->height)) break;
/*
printf("renderTF: {\n");
dumpTFCArray(&(currentp->linep[tf->screen_col_offset]), currentp->tagInfo);
printf("}\n");
*/
		/* scan the line to find maxFontHeight */
/*		printf("scan maxFontHeight\n");*/
		segpx = tf->xUL;

		if (!TFCChar(linep)) {
			fip = &fontInfo[TFCFontID(linep)];
			maxFontHeight = currentp->maxFontHeight = 
				fip->maxheight;
			maxFontDescent = currentp->maxFontDescent = 
				fip->descent;
		} else {
			maxFontHeight = 0;
			maxFontDescent = 0;
			lfontID = -1;
			for (tfcp = linep; TFCChar(tfcp); ++tfcp) {
				if (segpx > pwidthlimit) break;
				segpx += TFCWidth(tfcp);
				if (TFCFontID(tfcp) != lfontID) {
					fontID = TFCFontID(tfcp);
					fip = &fontInfo[fontID];
					if (maxFontHeight < fip->maxheight)
						maxFontHeight = fip->maxheight;
					if (maxFontDescent < fip->descent)
						maxFontDescent = fip->descent;
					lfontID = fontID;
				}
			}
			currentp->maxFontHeight = maxFontHeight;
			currentp->maxFontDescent = maxFontDescent;
		}
		fontyoffset = yoffset + maxFontHeight - maxFontDescent;

		/*
		 * extract and draw segments in the current line
		 */
		drawLineSeg(tf, currentp, &yoffset, &fontyoffset);

/*		tf->num_of_lines += currentp->breakc;
*/
		yoffset += maxFontHeight;
/*
		if (doWraping) {
			segpx = tf->xUL;
			yoffset += FontMaxHeight(fontID);
			fontyoffset += FontMaxHeight(fontID);
			doWraping = 0;
		}
*/
		currentp = currentp->next;
	}
	if (tf->currentp) {
		replaceNodeLine(theEditLN, tf->currentp, 0);
	} else {
/*		printf("Internal error: tf->currentp == NULL.\n");*/
	}
	return 1;
}
 
/*
 * scroll lower half page downward,
 * push open `delta' number of lines, beginning at `offset' rows
 */
int scrollDownLowerPart(tf, offset, span)
	TFStruct *tf;
	int offset;
	int span;
{
	TFLineNode *currentp;
	int i, upper = 0;

	currentp = tf->offsetp;
	for (i = 0; i <= offset; i++) {
		if (!currentp) break;
		upper += currentp->maxFontHeight * currentp->breakc;
		currentp = currentp->next;
	}
	XCopyArea(display, tf->w, tf->w, gc_copy, 
		tf->xUL, tf->yUL + upper,
		tf->width, tf->height - upper - span,
		tf->xUL, tf->yUL + upper + span);
	XClearArea(display, tf->w, tf->xUL, tf->yUL + upper,
			tf->width, span, False);
	return 1;
}

int scrollDownLowerPartNEW(tf, offset, span)
	TFStruct *tf;
	int offset;
	int span;
{
	TFLineNode *currentp;
	int i, upper = 0;

	currentp = tf->offsetp;
	for (i = 0; i < offset; i++) {
		if (!currentp) break;
		upper += currentp->maxFontHeight * currentp->breakc;
		currentp = currentp->next;
	}
	XCopyArea(display, tf->w, tf->w, gc_copy, 
		tf->xUL, tf->yUL + upper,
		tf->width, tf->height - upper - span,
		tf->xUL, tf->yUL + upper + span);
	XClearArea(display, tf->w, tf->xUL, tf->yUL + upper,
			tf->width, span, False);
	return 1;
}

int scrollUpLowerPart(tf, offset, span)
	TFStruct *tf;
	int offset;
	int span;
{
	TFLineNode *currentp = tf->offsetp;
	int i, upper = 0;

	for (i = 0; i <= offset; i++) {
		if (!currentp) break;
		upper += currentp->maxFontHeight * currentp->breakc;
		currentp = currentp->next;
	}
	if (span > 0) {
		int safety = tf->height - upper - span;
		if (safety > 0) {
			XCopyArea(display, tf->w, tf->w, gc_copy, 
				tf->xUL, tf->yUL + upper + span,
				tf->width, safety,
				tf->xUL, tf->yUL + upper);
		}
		XClearArea(display, tf->w, 
			tf->xUL, tf->yLR - span,
			tf->width, span, False);
	} else {
		XClearArea(display, tf->w,
			tf->xUL, tf->yUL + upper,
			tf->width, tf->height - upper, False);
	}
	return 1;
}

int scrollUpLowerPartNEW(tf, offset, span)
	TFStruct *tf;
	int offset;
	int span;
{
	TFLineNode *currentp = tf->offsetp;
	int i, upper = 0;

	for (i = 0; i < offset; i++) {
		if (!currentp) break;
		upper += currentp->maxFontHeight * currentp->breakc;
		currentp = currentp->next;
	}
	if (span > 0) {
		int safety = tf->yLR - upper - span;
		if (safety > 0) {
			XCopyArea(display, tf->w, tf->w, gc_copy, 
				tf->xUL, tf->yUL + upper + span,
				tf->width, safety,
				tf->xUL, tf->yUL + upper);
		}
		XClearArea(display, tf->w, 
			tf->xUL, tf->yLR - span,
			tf->width, span, False);
	} else {
		XClearArea(display, tf->w,
			tf->xUL, tf->yUL + upper,
			tf->width, tf->height - upper, False);
	}
	return 1;
}

#ifdef nofnfnfn
/*
 * collect characters to shift to next line
 *
 * start counting characters to shift down to next visible line,
 * all chars until the one with wrap tag (the old wrap sentury) or EOL.
 * results: col, pwidth
 *
 * Returns: 1 if not the end-of-line.
 *          0 if end-of-line is encountered.
 */
int collectCharsToShift(tf, currentp, colp, pwidthp, delta)
	TFStruct *tf;
	TFLineNode *currentp;
	int *colp;
	int *pwidthp;
	int *delta;
{
	TFChar *tfcp = currentp->linep;

	*pwidthp = 0;
	*delta = 0;

	for (tfcp += *colp; TFCChar(tfcp); tfcp++) {
/*		printf("{%c}", TFCChar(tfcp));*/
		*pwidthp += TFCWidth(tfcp);
		++(*delta);
		++(*colp);
		if (TFCFlags(tfcp) & MASK_WRAP) {
			TFCFlags(tfcp) &= ~MASK_WRAP;
			/*printf(" is old sentury\n");*/
			return 1;
		}
	}

	/* push down other lines */
	if (!scrollDownLowerPart(tf, 
		tf->current_row - tf->screen_row_offset + 1,
		currentp->maxFontHeight)){
		renderTF(tf);
		return 0;
	}
	currentp->breakc++;
	return 1;
}
#endif

/* travere to right-side edge of field 
 * move probepx to just one char before crossing the right edge
 */
int traverseToRightEdge(tfcArray, pwidthlimit, pxp, colp)
	TFChar *tfcArray;
	int pwidthlimit;
	int *pxp;
	int *colp;
{
	TFChar *tfcp;
	int probepx = *pxp;
	int probecol = *colp;

	tfcp = tfcArray + probecol;
/*
	printf("*****************************************************\n");
	printf("(%c]", TFCChar(tfcp));
	printf("col=%d px=%d pwidthlimit=%d TFCWidth=%d\n", 
		*colp, *pxp, pwidthlimit, TFCWidth(tfcArray + *colp));
*/
	tfcp = tfcArray + probecol;
	probepx = *pxp;
	for (;;) {
		++probecol;
/*		printf("[%c] tagID=%d  ", TFCChar(tfcp), TFCTagID(tfcp));*/

		probepx += TFCWidth(tfcp);
/*		printf("probecol=%d probepx=%d pwidthlimit=%d TFCWidth=%d\n", 
			probecol, probepx, pwidthlimit, TFCWidth(tfcp));
*/
		if (TFCChar(tfcp) == '\0') {
/*			printf("no need to wrap (EOL).\n");*/
			return 0;
		}
		if (probepx >= pwidthlimit) {
			/* move this and following characters, until the
			 * previous wrapper.
			 * the character right before this is the new 
			 * breaker.
			 */
/*			printf(">>>> new breaker [%c]\n", TFCChar(tfcp - 1));
			printf(">>>>[%c]", TFCChar(tfcp));
			printf("col=%d px=%d pwidthlimit=%d TFCWidth=%d\n", 
				*colp, *pxp, pwidthlimit, TFCWidth(tfcp));
*/
			return 1;
		}
		if (TFCFlags(tfcp) & MASK_WRAP) {
			/*printf("no need to wrap (WRAP).\n");*/
			return 0;
		}
		*pxp = probepx;
		*colp = probecol;
		tfcp = tfcArray + probecol;
	}
}

int scrollLineForward(tf, delta, col)
	TFStruct *tf;
	int delta;
	int col;
{
	int sy;
	int pwidth = 0;
	TFChar *tfcp, *linep;
	int px, py, i, hasMore = 1;
	int exitAfterPatch = 0;
	TFLineNode *currentp = theEditLN;

	linep = currentp->linep;
	px = tf->csr_px;
	py = tf->csr_py;
	sy = py + currentp->maxFontHeight - currentp->maxFontDescent;
	currentp->breakc = 0;

	for (i = 0; i < delta; i++)
		pwidth += TFCWidth(linep + col + i - delta);

	for (i = 0; i < col; i++)
		if (TFCFlags(linep + i) & MASK_WRAP) currentp->breakc++;
	currentp->breakc++;

	while (hasMore) {

		/* shift line forward 
		 */
		if (pwidth == 0) return 1; /* hmm... */
/*		printf("** displace: pwidth=%d px=%d \n", pwidth, px);*/

		if (tf->w) {
			XCopyArea(display, tf->w, tf->w, gc_copy, px, py,
				tf->width - px - pwidth + 1,
				currentp->maxFontHeight, px + pwidth, py);
			XClearArea(display, tf->w, px, py,
				pwidth, currentp->maxFontHeight, False);
		}
		/* patch the void created by shifting line forward
		 */
/*		printf("@@@@@ col=%d delta=%d\n", col, delta);*/
		for (i = col - delta; i < col; i++) {
/*			printf("## (%c) i=%d px=%d sy=%d\n", 
				TFCChar(linep + i), i, px, sy);*/

			drawChar(tf, linep + i, px, sy);
			px += TFCWidth(linep + i);
		}
		if (exitAfterPatch) {
/*			printf("****** exitAfterPatch\n");*/
			return 1;
		}
		hasMore = traverseToRightEdge(linep, tf->xLR, 
					      &px, &col);
		if (!hasMore) break;
		exitAfterPatch = !hasMore;

/*		printf("~~~~ exitAfterPatch=%d\n", exitAfterPatch);
		printf("**2 px=%d col=%d hasMore=%d\n", px, col, hasMore);
*/
		/* set the new wrap sentury
		 */
		if (col > 0) {
/*			printf("<%c> col=%d is new sentury\n",
				TFCChar(linep + col - 1), col - 1);
*/
			TFCFlags(linep + col - 1) |= MASK_WRAP;
			currentp->breakc++;

/*			printf("chars to move to next line:\n");
			dumpTFCArray(linep + col, NULL);
*/
			if (col > 1) {
				if (TFCFlags(linep + col - delta - 1) &
					MASK_WRAP) {
					TFCFlags(linep + col - delta - 1) &=
						~MASK_WRAP;
/*					printf("XXXXXXX no more\n");*/
					return 1;
				}
			}
		} else {
/*			printf("internal error: tfed.c: scroll_line().\n");*/
			return 0;
		}

		/* count characters to shift down to next visible line
		 */
		currentp->maxFontHeight = currentp->maxFontHeight;
		tf->currentp->maxFontHeight = currentp->maxFontHeight;

		tfcp = currentp->linep;
		pwidth = 0;
		delta = 0;

		for (tfcp += col; TFCChar(tfcp); tfcp++) {
	/*		printf("{%c}", TFCChar(tfcp));*/
			pwidth += TFCWidth(tfcp);
			++delta;
			++col;
			if (TFCFlags(tfcp) & MASK_WRAP) {
				TFCFlags(tfcp) &= ~MASK_WRAP;
				/*printf(" is old sentury\n");*/
				goto done;
			}
		}
		/* push down other lines */
		if (!scrollDownLowerPart(tf, 
			tf->current_row - tf->screen_row_offset,
			currentp->maxFontHeight)){
			renderTF(tf);
		}
		currentp->breakc++;
		tf->currentp->breakc++;
		if (tf->currentp == tf->offsetp) 
			tf->offsetp->breakc = tf->currentp->breakc;
done:

		/* erase the characters that was moved to the next visible line
		 */
/*		printf("*** px=%d py=%d pwidth=%d\n", px, py, pwidth);
		printf("*** paramdx=%d px=%d\n", tf->xLR, px);
*/
		i = tf->xLR - px;
		if (i > 1 && tf->w) {
			XClearArea(display, tf->w, px, py, 
					i, currentp->maxFontHeight, False);
		}
		px = tf->xUL;
		py += currentp->maxFontHeight;
		sy += currentp->maxFontHeight;

/*		printf(">> col=%d px=%d sy=%d pwidth=%d delta=%d\n",
			col, px, sy, pwidth, delta);
*/
	}
	return 1;
}

int scrollLineBackward(tf, delta, col)
	TFStruct *tf;
	int delta;
	int col;
{
	int sy;
	int pwidth = 0;
	TFChar *tfcp, *linep;
	int px, py, i, hasMore = 1;
	int exitAfterPatch = 0;
	int patchstart_col, patchstart_px;
	TFLineNode *currentp = theEditLN;
	int orig_breakc;

	linep = currentp->linep;

	px = tf->csr_px;
	py = tf->csr_py;
	sy = py + currentp->maxFontHeight - currentp->maxFontDescent;
	orig_breakc = currentp->breakc;
	currentp->breakc = 0;

	for (i = 0; i < delta; i++) {
		pwidth += TFCWidth(linep + col + i);
		/*pwidth += TFCWidth(linep + col + i - delta);*/
	}

	for (i = 0; i < col; i++)
		if (TFCFlags(linep + i) & MASK_WRAP) currentp->breakc++;

	col += delta;

	while (hasMore) {

		/* shift line backward
		 */
		if (pwidth == 0) return 1; /* hmm... */
/*
		printf("** displace: pwidth=%d px=%d \n", pwidth, px);
*/
		if (tf->w) {
			XCopyArea(display, tf->w, tf->w, gc_copy, 
				px + pwidth, py, tf->width - px - pwidth + 1,
				currentp->maxFontHeight, px, py);
		}

		/* read till the wrap line break 		
		 */
		for (;;) {
			tfcp = linep + col;
			if (!TFCChar(tfcp)) {
				int diff_breakc;

				currentp->breakc++;
				diff_breakc = orig_breakc - currentp->breakc;

				if (tf->w) {
					XClearArea(display, tf->w,
						px + TFCWidth(tfcp), py, 
						tf->xLR - px,
						currentp->maxFontHeight, False);
				}
/*
				printf("### orig_breakc=%d\n", orig_breakc);
				printf("### breaks=%d\n", currentp->breakc);
				printf("### diff_breakc=%d\n", diff_breakc);
				printf("### current_row=%d\n",tf->current_row);
*/
				if (diff_breakc > 0) {
					int save_breakc = currentp->breakc;

					tf->currentp->breakc = 
						currentp->breakc;
					tf->currentp->maxFontHeight = 
						currentp->maxFontHeight;

					currentp->breakc = orig_breakc;
					scrollUpLowerPart(tf,
						tf->current_row,
						currentp->maxFontHeight);
					currentp->breakc = save_breakc;
				}
				return 1;
			}
/*			printf("... px=%d c=[%d]'%c' w=%d\n",
				px, col, TFCChar(tfcp), TFCWidth(tfcp));
*/
			px += TFCWidth(tfcp);
			col++;

			if (TFCFlags(tfcp) & MASK_WRAP) {
				TFCFlags(tfcp) &= ~MASK_WRAP;
				break;
			}
		}

		/* then start characters-fitting into the remainding space
		 * later, deal with word-fitting.
		 */
		patchstart_col = col;
		patchstart_px = px;
		pwidth = 0;
/*		printf("####### px=%d\n", px);*/
		for (;;) {
			tfcp = linep + col;
/*
			printf("### px=%d c=[%d]'%c' w=%d px+w=%d\n", 
				px, col, TFCChar(tfcp), TFCWidth(tfcp),
				px + TFCWidth(tfcp));
*/
			if (!TFCChar(tfcp)) break;
			if ((px + TFCWidth(tfcp)) > tf->xLR) {
				if (col > 0) {
/*					printf("### new flag: c=[%d]'%c'\n", 
						col-1, TFCChar(tfcp-1));
*/
					TFCFlags(tfcp - 1) |= MASK_WRAP;
				} else {
/*					printf("###?? new flag: c=[%d]'%c'\n", 
						col, TFCChar(tfcp));
*/
					TFCFlags(tfcp) |= MASK_WRAP;
				}
				currentp->breakc++;
				break;
			}
			px += TFCWidth(tfcp);
			pwidth += TFCWidth(tfcp);
			col++;
		}
/*		printf("###### px=%d c=[%d]'%c' pwidhth=%d\n", 
			px, col, TFCChar(tfcp), pwidth);
*/
		/* clear and patch the void created by shifting line backward
		 */
		if (tf->w) {
			XClearArea(display, tf->w,
				patchstart_px, py, 
				tf->xLR - patchstart_px,
				currentp->maxFontHeight, False);
		}
/*		printf("@@@@@ col=%d startcol=%d startpx\n", 
			col, patchstart_col, patchstart_px);
*/
		px = patchstart_px;
		for (i = patchstart_col; i < col; i++) {
/*			printf("## [%d]'%c' px=%d sy=%d width=%d\n", 
				i, TFCChar(linep + i), px, sy,
				TFCWidth(linep + i));
*/
			drawChar(tf, linep + i, px, sy);
			px += TFCWidth(linep + i);
		}
/*		printf(">>> pwidth =%d\n", pwidth);*/

		if (exitAfterPatch) {
/*			printf("****** exitAfterPatch\n");*/
			return 1;
		}

		if (!hasMore) break;
		exitAfterPatch = !hasMore;

/*		printf("~~~~ exitAfterPatch=%d\n", exitAfterPatch);
		printf("**2 px=%d col=%d hasMore=%d\n", px, col, hasMore);
*/
		if (exitAfterPatch) {
/*			printf("****** exitAfterPatch\n");*/
			return 1;
		}

/*		printf("*** px=%d py=%d pwidth=%d\n", px, py, pwidth);
		printf("*** paramdx=%d px=%d\n", tf->xLR, px);
*/
		px = tf->xUL;
		py += currentp->maxFontHeight;
		sy += currentp->maxFontHeight;

/*		printf(">> col=%d px=%d sy=%d pwidth=%d delta=%d\n",
			col, px, sy, pwidth, delta);
*/
	}
	return 1;
}

int tfed_scroll_delta(tf, offsetdir)
	TFStruct *tf;
	int offsetdir;
{
	int i, h, linesToMove, span, limit, py, probepy, fonty;
	TFLineNode *currentp;

	if (!tf->w) return 0;
	if (offsetdir == 0) return 0;
	else if (offsetdir > 0) linesToMove = offsetdir;
	else linesToMove = -offsetdir;

	if (BDPixel == BGPixel) {
		XSetForeground(display, gc_mesh, FGPixel);
		XSetBackground(display, gc_mesh, BGPixel);
		XSetForeground(display, gc_bd, FGPixel);
	} else {
		XSetForeground(display, gc_mesh, BDPixel);
	}
	if (offsetdir < 0) {
		/* scroll page downward
		 */
		span = 0;
		currentp = tf->offsetp;
		for (i = 0; i < linesToMove; i++) {
			span += currentp->maxFontHeight * currentp->breakc;
			if (span > tf->height) return 0;
			currentp = currentp->next;
			if (!currentp) return 0;
		}
		XCopyArea(display, tf->w, tf->w, gc_copy, 
				tf->xUL, 0,
				tf->width, tf->yUL + tf->height - span,
				tf->xUL, span);
		XClearArea(display, tf->w,
				0, 0,
				tf->width, span, False);
		
		currentp = tf->offsetp;
		py = tf->yUL;
		probepy = py + (currentp->maxFontHeight * currentp->breakc);
		fonty = py + currentp->maxFontHeight 
		        - currentp->maxFontDescent;
		for (;;) {
		  /*printf("down span=%d py=%d probepy=%d fonty=%d\n", 
		    span, py, probepy, fonty);*/
			drawLineSeg(tf, currentp, &py, &fonty);
			if (py >= span) break;
			if (!(currentp = currentp->next)) break;
			py = probepy;
			probepy += currentp->maxFontHeight * currentp->breakc;
			fonty = py + currentp->maxFontHeight 
			        - currentp->maxFontDescent;
		}
		return 1;
	} else {
		/* scroll page upward
		 */
		span = 0;
		currentp = tf->offsetp;
		for (i = 0; i < linesToMove; i++) {
			if (currentp->prev) currentp = currentp->prev;
			else break;
			span += currentp->maxFontHeight * currentp->breakc;
			if (span > tf->height) {
/*printf("span>height. not ignored\n");*/
			  return 0;
			}

		}
		py = probepy = tf->yUL;
		limit = tf->yUL + tf->height - span;
		currentp = tf->offsetp;
		for (;;) {
			probepy += currentp->maxFontHeight * currentp->breakc;
			if (probepy >= limit) break;
			py = probepy;
			
			if (!(currentp = currentp->next)) break;
		}
		if (currentp) {
			fonty = py + currentp->maxFontHeight 
		        	- currentp->maxFontDescent;
		} else {
			fonty = py;
		}
		XCopyArea(display, tf->w, tf->w, gc_copy, 
				tf->xUL, tf->yUL + span,
				tf->width, tf->yUL + tf->height - span,
				tf->xUL, tf->yUL);
		XClearArea(display, tf->w,
				tf->xUL, py,
				tf->width, tf->height - py, False);
		if (currentp) {
			for (;;) {
/*printf("up span=%d py=%d probepy=%d fonty=%d\n", span, py, probepy, fonty);*/
				drawLineSeg(tf, currentp, &py, &fonty);
				if (py >= tf->yLR) return 1;
				if (!(currentp = currentp->next)) break;
				py = probepy;
				probepy += currentp->maxFontHeight 
					* currentp->breakc;
				fonty = py + currentp->maxFontHeight 
			        	- currentp->maxFontDescent;
			}
		}
		return 1;
	}
}

int mapFromPixelToCharPosition(tf, px, py, cx, cy, exact_px, exact_py)
	TFStruct *tf;
	int px, py;
	int *cx, *cy;
	int *exact_px, *exact_py;
{
	TFLineNode *currentp;
	TFChar *tfcp;
	int ycheck;

	*cx = 0;
	*cy = 0;
	*exact_py = ycheck = tf->yUL; 
	*exact_px = tf->xUL;

	/* for optimization, if mx is > csr_py then start fron currentp...*/

	for (currentp = tf->offsetp; currentp; currentp = currentp->next) {
		*cx = 0;
		*exact_py = ycheck;
		ycheck += currentp->maxFontHeight;
/*printf("py=%d epy=%d cy=%d ycheck=%d\n", py, *exact_py, *cy, ycheck);*/
		for (tfcp = currentp->linep; tfcp;) {
			if (!TFCChar(tfcp)) {
				if (py >= *exact_py && py < ycheck) {
					return 2;
				}
				break;
			}
			if (py >= *exact_py && py < ycheck) {
/*
printf("* py=%d epy=%d cy=%d ycheck=%d\n", py, *exact_py, *cy, ycheck);
printf("* px=%d epx=%d cx=%d\n", px, *exact_px, *cx);
*/
				*exact_px += TFCWidth(tfcp);

				if (px <= *exact_px) {
					if (*exact_px - px > 
						(TFCWidth(tfcp) / 2)) {
						/* slide to left side */
						*exact_px -= TFCWidth(tfcp);
						return 1;
					} else {
						/* slide to right side */
						if (TFCFlags(tfcp) & MASK_WRAP){
							*exact_px = 
							   tf->xUL; 
							*exact_py = ycheck;
						}
						(*cx)++;
						return 1;
					}
				}
			}
			if (TFCFlags(tfcp) & MASK_WRAP) {
				if (py >= *exact_py && py < ycheck) {
					*exact_px = tf->xUL;
					*exact_py = ycheck;
					(*cx)++;
					return 1;
				}
				*exact_px = tf->xUL; 
				*exact_py = ycheck;
				ycheck += currentp->maxFontHeight;
			}
			(*cx)++;
			tfcp++;
		}
		*exact_px = tf->xUL; 
		(*cy)++;
	}
	return 1;
}

#define VERBOSE_TFED_EXPOSE 0
/*
 * an unsophisticated expose handler (simple mod of renderTF())
 */ 
int tfed_expose(self, x, y, width, height)
	VObj *self;
	int x, y, width, height;
{
	TFStruct *tf = updateEStrUser(self);
	TFLineNode *currentp;
	int probey, yoffset, fontyoffset;
	int bottom;
	int i = 1;

	if (!tf) return 0;
	if (!tf->isRenderAble) return 0;

	currentp = tf->offsetp;
	yoffset = probey = tf->yUL;

/*printf(">> y=%d \n", y);*/

	if (BDPixel == BGPixel) {
		XSetForeground(display, gc_mesh, FGPixel);
		XSetBackground(display, gc_mesh, BGPixel);
		XSetForeground(display, gc_bd, FGPixel);
	} else {
		XSetForeground(display, gc_mesh, BDPixel);
	}

	while (currentp) {
		if (!currentp->linep) return 1;

if (VERBOSE_TFED_EXPOSE) 
	printf(" i = %d... probey=%d  yoffset=%d\n", 
	       i, probey, yoffset);

		probey += currentp->maxFontHeight * currentp->breakc;
		if (probey >= y) break;

		yoffset = probey;
		currentp = currentp->next;
	}
	bottom = y + height;

if (VERBOSE_TFED_EXPOSE) 
	printf("bottom=%d \n", bottom);

	while (currentp) {
		if (!currentp->linep) return 1;

		fontyoffset = yoffset + currentp->maxFontHeight - 
				currentp->maxFontDescent;

		if (yoffset >= bottom) break;

if (VERBOSE_TFED_EXPOSE) 
	printf("*i = %d... bottom=%d  yoffset=%d  fontyoffset=%d\n", 
	       i++, bottom, yoffset, fontyoffset);

		drawLineSeg(tf, currentp, &yoffset, &fontyoffset);

		yoffset = probey;
		currentp = currentp->next;
		if (currentp) 
			probey += currentp->maxFontHeight * currentp->breakc;
	}
	return 1;
}

int tfed_append(tf, str)
	TFStruct *tf;
	char *str;
{
/*	TFLineNode *currentp;*/
	TFLineNode *insertp = tf->currentp;
	TFChar tbuff[TBUFFSIZE]; /*XXX*/
	int buffTagInfo[TAGINFO_SIZE];
	int tbuffi = 0;
	int setTops = 0;
	int tagID = 0;

	tf->building_maxFontHeight = 0;
	tf->building_maxFontDescent = 0;

	if (!tf) return 0;
	if (insertp) {
		if (!TFCChar(insertp->linep) && !insertp->next) {
			insertp = NULL;
			setTops = 1;
		} else {
			while (insertp->next) insertp = insertp->next;
		}
	} else {
		setTops = 1;
	}
	tfed_buildLines(tf->self, &insertp, &(tf->firstp), 
			&str, &(tf->currentFontID), 
			&(tf->lineNodeCount),
			&(tf->lineVisibleCount),
			tbuff, &tbuffi, buffTagInfo, &tagID,
			&(tf->building_maxFontHeight),
			&(tf->building_maxFontDescent), 
			&(tf->building_vspan),
			1);

	if (setTops) {
		tf->offsetp = tf->currentp = tf->firstp;
	}

	if (helper_txtDisp_updateShownInfo(tf)) {
		VObjList *objl;
		for (objl = GET__shownDepend(tf->self); objl; 
			objl = objl->next) {
			if (objl->o) {
				sendMessage1N2int(objl->o,
					"shownInfoV", 
					GET_shownPositionV(tf->self),
					GET_shownSizeV(tf->self));
			}
		}
	}

/*
	currentp = insertp;
	replaceNodeLine(theBuffLN, currentp, 1);
	TFCstrcpy(theBuffLN->linep, currentp);
	TFCstrcpy(theBuffLN->linep + theBuffLN->length, currentp);
	TFCstrcpy(theEditLN->linep + theEditLN->length, tf->insertp->linep);
	replaceNodeLine(currentp, theBuffLN, 0);
*/
	return 1;
}

int LogicOrTFCFlag(tfcp, from, to, val)
	TFChar *tfcp;
	int from;
	int to;
	int val;
{
	int i = from;

	tfcp += from;
	do {
		if (!TFCChar(tfcp)) break;
		TFCFlags(tfcp) |= val;
		tfcp++;
	} while (i < to);
	return i;
}

int LogicAndTFCFlag(tfcp, from, to, val)
	TFChar *tfcp;
	int from;
	int to;
	int val;
{
	int i = from;

	tfcp += from;
	do {
		if (!TFCChar(tfcp)) break;
		TFCFlags(tfcp) &= val;
		tfcp++;
	} while (i < to);
	return i;
}

char *rangeOperation(tf, from_cx, from_cy, to_cx, to_cy, 
			drawP, underlineP, clipP)
	TFStruct *tf;
	int from_cx, from_cy, to_cx, to_cy;
	int drawP, underlineP, clipP;
{
	TFLineNode *currentp = tf->firstp;
	TFChar *tfcp;
	int left, right, i, buffi = 0; 

	if (to_cy == from_cy) {
		if (to_cx < from_cx) {
			i = from_cx;
			from_cx = to_cx;
			to_cx = i;
		}
	} else if (to_cy < from_cy) {
		i = from_cy;
		from_cy = to_cy;
		to_cy = i;

		i = from_cx;
		from_cx = to_cx;
		to_cx = i;
	}
	for (i = 0; i < from_cy; i++) {
		currentp = currentp->next;
		if (!currentp) return NULL; /* error */
	}
	if (i <= to_cy) {
		for (;;) {
			if (from_cy == to_cy) {	
				if (from_cx <= to_cx) {
					left = from_cx;
					right = to_cx;
				} else {
					left = to_cx;
					right = from_cx;
				}
			} else {
				if (i == from_cy) {
					left = from_cx;
					right = currentp->length;
				} else if (i == to_cy) {
					left = 0;
					right = to_cx;
				} else {
					left = 0;
					right = currentp->length;
				}
			}
			tfcp = currentp->linep + left;

			/* yucky code... there ought to be a law...
			 */
			if (underlineP == 0) { 
				do {
					if (!TFCChar(tfcp)) {
						if (clipP) 
							buff[buffi++] = '\n';
						break;
					}
					if (clipP) 
						buff[buffi++] = TFCChar(tfcp);
					tfcp++;
				} while (left++ < right);
			} else if (underlineP == 1) { 
				do {
					if (!TFCChar(tfcp)) {
						if (clipP) 
							buff[buffi++] = '\n';
						break;
					}
					TFCFlags(tfcp) |= MASK_UNDER;
					if (clipP) 
						buff[buffi++] = TFCChar(tfcp);
					tfcp++;
				} while (left++ < right);
			} else if (underlineP == -1) { 
				do {
					if (!TFCChar(tfcp)) {
						if (clipP) 
							buff[buffi++] = '\n';
						break;
					}
					TFCFlags(tfcp) &= ~MASK_UNDER;
					if (clipP) 
						buff[buffi++] = TFCChar(tfcp);
					tfcp++;
				} while (left++ < right);
			}
			if (drawP) {
				drawLineOffset(tf, i - tf->screen_row_offset, 
						1); /*XXX terribly slow...*/
			}
			currentp = currentp->next;
			if (!currentp) break;
			if (++i > to_cy) break;
		}
	}
	if (clipP) {
		buff[buffi] = '\0';
		return buff;
	} else {
		return NULL;
	}
}

int lineFlagSet(tf, ln, cn, mask, op)
	TFStruct *tf;
	int ln, cn;
	int mask;
	int op;
{
	TFLineNode *currentp = tf->firstp;
	TFChar *tfcp;
	int left, right, i;

	if (!currentp) return 0;
	while (ln-- > 0) {
		currentp = currentp->next;
		if (!currentp) return 0;
	}
	tfcp = currentp->linep;
	if (op > 0) {
		for (; TFCChar(tfcp); tfcp++) TFCFlags(tfcp) |= mask;
	} else if (op < 0) {
		for (; TFCChar(tfcp); tfcp++) TFCFlags(tfcp) &= ~mask;
	}
	if (currentp == tf->currentp) {
		replaceNodeLine(theEditLN, tf->currentp, 0);
	}
	return 1;
}


/*
 * Used to set num_of_lines without rendering
 * bug: does not take breakc into account 
 */
int scanVerticalMetrics(tf)
	TFStruct *tf;
{
	TFLineNode *currentp;
	TFChar *linep, *tfcp;
	int yoffset, maxFontHeight, maxFontDescent, pwidthlimit;
	int fontID, lfontID = -1;
	int segpx;
	FontInfo *fip;
	int inViewP = 0;
	int old_num_of_lines;
	int lineNodeCount = 0;
	int lineVisibleCount = 0;

	pwidthlimit = tf->xLR;
	currentp = tf->firstp;
	yoffset = tf->yUL;

	old_num_of_lines = tf->num_of_lines;
	tf->num_of_lines = 0;
/*
*/
	while (currentp) {
		linep = currentp->linep;
		if (!linep) break;

		lineNodeCount++;
		lineVisibleCount++;

		if (currentp == tf->offsetp) inViewP = 1;

		if (!TFCChar(linep)) {
			fip = &fontInfo[TFCFontID(linep)];
			maxFontHeight = currentp->maxFontHeight = 
				fip->maxheight;
			maxFontDescent = currentp->maxFontDescent = 
				fip->descent;
		} else {
			maxFontHeight = 0;
			maxFontDescent = 0;
			currentp->breakc = 1;
			lfontID = -1;
			segpx = tf->xUL;

/*XXX clumsy safety*/
			tfcp = linep;
			if (tfcp->fontID >= maxNumOfFonts) {
				fprintf(stderr, 
			"internal error detected. Trying to recover...\n");
				tf->num_of_lines = old_num_of_lines;
				return 0;
			}
			for (; TFCChar(tfcp); ++tfcp) {
				segpx += TFCWidth(tfcp);
				if (segpx > pwidthlimit) {
					if (tfcp > currentp->linep) {
						TFCFlags(tfcp-1) |= MASK_WRAP;
						currentp->breakc++;
						tf->lineVisibleCount++;
					}
					segpx = tf->xUL;
				}
				if (TFCFontID(tfcp) != lfontID) {
					fontID = TFCFontID(tfcp);
					fip = &fontInfo[fontID];
					if (maxFontHeight < fip->maxheight)
						maxFontHeight = fip->maxheight;
					if (maxFontDescent < fip->descent)
						maxFontDescent = fip->descent;
					lfontID = fontID;
				}
			}
			currentp->maxFontHeight = maxFontHeight;
			currentp->maxFontDescent = maxFontDescent;
		}
		if (inViewP) {
			if (yoffset > tf->height) inViewP = 0;
			tf->num_of_lines += 1;
			yoffset += maxFontHeight;
		}
		currentp = currentp->next;
	}
	
	tf->lineNodeCount = lineNodeCount;
	tf->lineVisibleCount = lineVisibleCount;

	return 1;
}

