%{

#define TRUE 1
#define FALSE 0
#include <stdio.h>
#include "y.tab.h"
#include "ast.h"
#include "math.h"

char c;
%}

DIGIT		[0-9]
LETTER		[A-Za-z_]
IDTAIL		[A-Za-z0-9_.]
IDENT		{LETTER}{IDTAIL}*
SPACE		[ \t\n\f\b]
INTEGER         {SIGN}{DIGIT}+
SIGN            [+-]?
FLOAT           {SIGN}{DIGIT}*\.{DIGIT}*

%%

"'"		return scanChar();
"\""		return scanString();
"+"		return '+';
"-"		return '-';
"%"		return '%';
"*"		return '*';
"="		return '=';
"."		return '.';
":"		return ':';
","		return ',';
"("		return '(';
")"		return ')';
"["		return '[';
"]"		return ']';
"{"		return '{';
"}"		return '}';
";"		return ';';
">"		return '>';
"<"		return '<';
"!"		return '!';
"\\"		return '\\';
"=="		return EQ;
"!="		return NE;
"<="		return LE;
">="		return GE;
"++"		return INC;
"--"		return DEC;
"+="		return PLUS_ASSERT;
"-="		return MINUS_ASSERT;
"%="		return MOD_ASSERT;
"*="		return MULT_ASSERT;
"/="		return DIV_ASSERT;
"&&"		return AND;
"||"		return OR;
"/"		{ if ((c = scanComment()) != NULL) return c; }
"true"		{ yylval.i = 1; return INTCONST; }
"false"		{ yylval.i = 0; return INTCONST; }
"if"		return IF;
"else"		return ELSE;
"for"		return FOR;
"do"		return DO;
"while"		return WHILE;
"switch"	return SWITCH;
"case"		return CASE;
"default"	return DEFAULT;
"break"		return BREAK;
"return"	return RETURN;
"persistent"	return PERSISTENT;
{IDENT}		return scanIdentifier(yytext);
{INTEGER}	{ yylval.i = scanInt(); return INTCONST; }
{FLOAT}         { yylval.f = (float)atof(yytext); return FLOATCONST; }
{SPACE}		;
.		printf("Unknown character: %.1o", yytext[0]);
%%


