/*
 * loader.c
 */
#include <stdio.h>
#ifndef SEEK_SET
#define SEEK_SET 0
#endif
#include <sys/file.h>
#include "mystrings.h"
#include "hash.h"
#include "ident.h"
#include "obj.h"
#include "packet.h"
#include "class.h"
#include "classlist.h"
#include "slotaccess.h"
#include "loader.h"
#include "file.h"
#include "misc.h"

/* this puts a limit on the number of objects in one file */
#define NEWOBJ_SIZE 1000

#define readFileTillChar(fp, tc) \
	while (c = getc(fp)) if (c == EOF || c == tc) break;
char c;

#define VIOLA_PATH_ARRAY_SIZE	32
char *viola_path[VIOLA_PATH_ARRAY_SIZE];

#define DFLT_VIOLA_PATH "/usr/local/lib/WWW/viola/apps" /*PATCHED*/

int init_loader(path)
	char *path;
{
	if (path) {
		if (setViolaPath(path) > 0) {
			if (verbose) 
				fprintf(stderr, "violaPath set to: ``%s''\n", 
					path);
			return 1;
		}
	}
	return 0;
}

/*
 * Returns:
 *	number of paths set.
 *	0, if not set.
 *	-i, if exceed VIOLA_PATH_ARRAY_SIZE (which is = i)
 */
int setViolaPath(newPathStr)
	char *newPathStr;
{
	int i, stri;
	char *cp, pathStr[BUFF_SIZE], buff[BUFF_SIZE];

	for (i = 0, stri = 0; i < VIOLA_PATH_ARRAY_SIZE; i++) {
		SkipBlanks(newPathStr, &stri);
		stri = NextWord(newPathStr, stri, pathStr);
		if (AllBlank(pathStr)) {
			viola_path[i] = NULL;
			return i;
		} else {
			if (viola_path[i]) free(viola_path[i]);
			if (cp = expandPath(pathStr, buff))
				viola_path[i] = SaveString(cp);
		}
	}
	viola_path[VIOLA_PATH_ARRAY_SIZE] = NULL;
	return -i;
}

/*
 * return:	number of objects loaded
 * 		-1 if failed to open object file
 */
int load_object(filename)
	char *filename;
{
	FILE *fp;
	int slotv[100][2], slotc, *slotp;
	int i, status = 1, newObjCount;
	VObj *obj, *newObj[NEWOBJ_SIZE];
	char path[256]; /*XXX*/

	newObjCount = 0;

	for (i = 0; i < VIOLA_PATH_ARRAY_SIZE; i++) {
		if (viola_path[i]) {
			strcpy(path, viola_path[i]);
			strcat(path, "/");
			strcat(path, filename);
			if (access(path, R_OK) == 0) break;
		} else {
			fprintf(stderr, "can't find \"%s\"\n", filename);
			return -1;
		}
	}
	if ((fp = fopen(path, "r")) == NULL) {
		fprintf(stderr, "can't find \"%s\"\n", filename);
		return -1;
	}

	while (status) {
		slotc = 0;
		status = load_objects_slots(fp, slotv, &slotc);
		if (slotc > 0) {
			if (obj = instantiateObj(slotv, &slotc)) {
				putHashEntry(objID2Obj, 
						storeIdent(GET_name(obj)),
						(int)obj);
				newObj[newObjCount++] = obj;
				if (newObjCount > NEWOBJ_SIZE) {
					fprintf(stderr, 
				    "Internal error: newObj[] overflowed.\n");
				}
			} else {
				fprintf(stderr,
					"failed to build object...\n");
			}
		}
	}
/*
	fprintf(stderr, "--------------------------------\n");
	for (i = 0; i < slotc; i++) {
		if (slotv[i][0])
			fprintf(stderr,
				"labelid=%d, content=\"%s\"\n",
				(int)slotv[i][0], 
				(char*)slotv[i][1]);
	}
	fprintf(stderr, "--------------------------------\n");
*/
	/* for all objects just loaded, init them */
	for (i = 0; i < newObjCount; i++) {
		sendMessage1(newObj[i], "init");
	}

	return newObjCount;
}


#define SLOT_LABEL_SIZE 64
/*
 * Return: non-zero if end of file is encountered
 *
 * Size of slot labels are limited to SLOT_LABEL_SIZE characters.
 * Size of slot content has no limitation.
 *
 * someday, the reading ought to be buffer read...
 */
int load_objects_slots(fp, slotv, slotc)
	FILE *fp;
	int (*slotv)[100][2];
	int *slotc;
{
	char label[SLOT_LABEL_SIZE], *dynaBuff;
	int labeli, sloti, dynaBuffi;
	long seekBackPosition = 0;
	int done = 0;
	int llc = 0, lc = 0, c, nc;
	HashEntry *entry;

	for (;;) {
		/* read the slot label */
		labeli = 0;
		llc = 0; lc = 0;
		for (;;) {
			c = getc(fp);		/* XXX optimize this... */

			if (c == EOF) {
				return 0;
			} else if (c == '\\') {
				if (lc == '\\') {
					/* \\comments */
					readFileTillChar(fp, '\n');
					labeli = 0;
					llc = 0; lc = 0;
				} else if (lc == '\n') {
					return 1;
				}
			} else if (c == '{') {
				break;
			} else if (!isspace(c)) {
				label[labeli++] = c;
			}
			if (labeli > SLOT_LABEL_SIZE) {
				label[labeli] = '\0';
				fprintf(stderr,
				      "unreasonably large slot label:\"%s\"\n",
					label);
				return NULL;
			}
			llc = lc; lc = c;
		}
		label[labeli++] = '\0';
/*
		printf("..label = \"%s\"\n", label);
*/
		/* read the slot content */
		sloti = 0;
		llc = 0; lc = 0;
		for (;;) {
			c = getc(fp);
			if (c == EOF) {
				if (lc == '\n') {
					done = 1;
					goto donecontent;
				} else if (lc == '}') {
					--sloti;
					done = 1;
					goto donecontent;
				} else {
					fprintf(stderr, "premature EOF...\n");
					return 0;
				}
			} else if (c == '\\') {
				if (llc == '}' && lc == '\n') {
					nc = getc(fp);
					ungetc(nc, fp);
					if (nc != '*') {
					/* it's not "}"+left comment case */
						goto donecontent;
					}
				}
			}
			if (!seekBackPosition) {
				if (sloti >= BUFF_SIZE - 1) {
					dynaBuffi = sloti;
					seekBackPosition = ftell(fp);
				} else {
					buff[sloti++] = c;
				}
			} else {
				sloti++;
			}
			llc = lc; lc = c;
		}
donecontent:
		if (entry = getHashEntry(symStr2ID, (int)label)) {	
			(*slotv)[*slotc][0] = (int)(entry->val);
		} else {
			fprintf(stderr,	"unknown slot label:\"%s\"\n", label);
			return 0;
		}
/*
		fprintf(stderr,	"slotc = %d\n", *slotc);
		fprintf(stderr, "******label str id = %d\n",
			(*slotv)[*slotc][0]);
*/
		if (seekBackPosition) {
/*
			printf("dynaBuffi = %d\n", dynaBuffi);
			printf("seekBackPosition = %d, sloti = %d\n", 
				seekBackPosition, sloti);
*/
			dynaBuff = (char*)malloc(sizeof(char) * (sloti + 2));
			strncpy(dynaBuff, buff, dynaBuffi);
			if (sloti - dynaBuffi > 0) {
				if (fseek(fp, seekBackPosition - 1, SEEK_SET)
					== -1) return 0;
				if (fread(&dynaBuff[dynaBuffi], sizeof(char),
					  sloti - dynaBuffi + 2, fp) == 0)
					return 0;
			}
			dynaBuff[sloti - 1] = '\0';
/*			printf("dynabuff=\"%s\"\n", dynaBuff);*/
			seekBackPosition = 0;
			(*slotv)[*slotc][1] = (int)dynaBuff;
		} else {
			char *cp = (char*)malloc(sizeof(char) * (sloti - 1));
			buff[sloti - 2] = '\0';
			(*slotv)[*slotc][1] = (int)strcpy(cp, buff);
/*			printf("buff=\"%s\"\n", buff);*/
		}
/*
		fprintf(stderr,
			"** slot label id = %d, slot content=\"%s\"\n",
			(int)(*slotv)[*slotc][0], (char*)(*slotv)[*slotc][1]);
*/
		(*slotc)++;
		if (done) return 1;
	}
}
