/*
 * Copyright 1990 Pei-Yuan Wei.  All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */

/*
 * hash.c
 */
#include <stdio.h>
#include "mystrings.h"
#include "hash.h"

int hash_int(ht, n)
	HashTable *ht;
	int n;
{
	return n % ht->size;
}

int hash_str(ht, str)
	HashTable *ht;
	char *str;
{
	int key = 0;

	while (*str) key += *str++;
	key = key % ht->size;

	return key;
}

HashTable *initHashTable(size, func_hash, func_cmp)
	long size;
	long (*func_hash)();
	long (*func_cmp)();
{
	struct HashTable *ht;
	int i;

	ht = (HashTable*)malloc(sizeof(struct HashTable));
	if (ht) {
		ht->entries = (HashEntry*)malloc(sizeof(struct HashEntry) 
						* size);
		ht->size = size;
		ht->func_hash = func_hash;
		ht->func_cmp = func_cmp;

		for (i = 0; i < size; i++) {
			ht->entries[i].next  = NULL;
			ht->entries[i].label = NULL;
			ht->entries[i].val   = NULL;
		}
	}

	return ht;
}

HashEntry *putHashEntry(ht, label, val)
	HashTable *ht;
	long label;
	long val;
{
	int key;
	HashEntry *entry, *base_entry, *new_entry;

	key = ht->func_hash(ht, label);
	base_entry = &(ht->entries[key]);
/*
	if (ht->func_hash == hash_str) {
		printf("label='%s' \tkey=%ld \tval=%d\n", label, key, val);
	} else {
		printf("label=%d \tkey=%ld \tval='%s'\n", label, key, val);
	}
*/
	if (base_entry->label) {
		for (entry = base_entry; entry->next; entry = entry->next);

		new_entry = (HashEntry*)malloc(sizeof(struct HashEntry));
		if (new_entry) {
			entry->next = new_entry;
			new_entry->label = label;
			new_entry->val = val;
			new_entry->next = NULL;
		} else {
			fprintf(stderr,
				"addHashEntry(): malloc failed.\n");
		}
		entry->next = new_entry;
		return new_entry;
	} else {
		base_entry->label = label;
		base_entry->val   = val;
		base_entry->next  = NULL;
		return base_entry;
	}
}

HashEntry *getHashEntry(ht, label)
	HashTable *ht;
	long label;
{
	int key;
	HashEntry *entry, *base_entry;

	if (!ht) {
		printf("Internal error: ht==NULL\n");
		return 0;
	}
	key = ht->func_hash(ht, label);
	base_entry = &(ht->entries[key]);

	for (entry = base_entry; entry; entry = entry->next) {
		if (entry->label) {
			if (ht->func_cmp(entry->label , label)) {
/*
				if (ht->func_hash == hash_str) {
				     printf("key=%d \tlabel=\"%s\" \tval=%d\n",
					key, (char*)label, entry->val);
				} else {
				     printf("key=%d \tlabel=%d \tval=\"%s\"\n",
					key, entry->label, (char*)entry->val);
				}
*/
				return entry;
			}
		}
	}

	return NULL;
}

void dumpHashTable(ht)
	HashTable *ht;
{
	int i;
	HashEntry *hp;

	printf("size = %d\n", ht->size);

	for (i = 0; i < ht->size; i++) {
		for (hp = &(ht->entries[i]); hp; hp = hp->next)
			if (hp->label)
				if (ht->func_hash == hash_str) {
					printf("%d\tlabel=\"%s\"\tval=%d\n", 
						i, 
						(char*)hp->label,
						(int)hp->val);
				} else {
					printf("%d\tlabel=%d\tval=\"%s\"\n", 
						i,
						(int)hp->label,
						(char*)hp->val);
				}
	}
}
