/*
 * Copyright 1990 Pei-Yuan Wei.	All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */
/*
 * class	: vpane
 * superClass	: pane
 */
#include <stdio.h>
#include <ctype.h>
#include "error.h"
#include "mystrings.h"
#include "hash.h"
#include "ident.h"
#include "obj.h"
#include "packet.h"
#include "class.h"
#include "slotaccess.h"
#include "classlist.h"
#include "cl_vpane.h"
#include "misc.h"
#include "glib.h"

SlotInfo cl_vpane_NCSlots[] = {
	NULL
};
SlotInfo cl_vpane_NPSlots[] = {
	NULL
};
SlotInfo cl_vpane_CSlots[] = {
{
	STR_class,
	PTRS | SLOT_RW,
	(long)"vpane"
},{
	NULL
}
};
SlotInfo cl_vpane_PSlots[] = {
{
	STR__classInfo,
	CLSI,
	(long)&class_vpane
},{
	STR_paneConfig,
 	PTRS,
	(long)"northToSouth"
},{
	STR__paneConfig,
 	LONG,
	PANE_CONFIG_N2S		/* default with N2S */
},{
	NULL
}
};

SlotInfo *slots_vpane[] = {
	(SlotInfo*)cl_vpane_NCSlots,
	(SlotInfo*)cl_vpane_NPSlots,
	(SlotInfo*)cl_vpane_CSlots,
	(SlotInfo*)cl_vpane_PSlots
};

MethodInfo meths_vpane[] = {
	/* local methods */
{
	STR_get,
	meth_vpane_get,
},{
	STR_initialize,
	meth_vpane_initialize
},{
	STR_set,
	meth_vpane_set
},{
	NULL
}
};

ClassInfo class_vpane = {
	slots_vpane,		/* class slot information	*/
	meths_vpane,		/* class methods		*/
	STR_vpane,		/* class identifier number	*/
	&class_pane,		/* super class info		*/
};

int meth_vpane_get(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	return meth_pane_get(self, result, argc, argv);
}

int meth_vpane_initialize(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	return meth_pane_initialize(self, result, argc, argv);
}

int meth_vpane_render(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	return meth_pane_render(self, result, argc, argv);
}

/*
 * returns non-zero if set operation succeded, zero otherwise.
 */
int meth_vpane_set(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	return meth_pane_set(self, result, argc, argv);
}



