/*
 * Copyright 1990 Pei-Yuan Wei.	All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */
/*
 * class	: hpane
 * superClass	: pane
 */
#include <stdio.h>
#include <ctype.h>
#include "error.h"
#include "mystrings.h"
#include "hash.h"
#include "ident.h"
#include "obj.h"
#include "packet.h"
#include "class.h"
#include "slotaccess.h"
#include "classlist.h"
#include "cl_hpane.h"
#include "misc.h"
#include "glib.h"

SlotInfo cl_hpane_NCSlots[] = {
	NULL
};
SlotInfo cl_hpane_NPSlots[] = {
	NULL
};
SlotInfo cl_hpane_CSlots[] = {
{
	STR_class,
	PTRS | SLOT_RW,
	(long)"hpane"
},{
	NULL
}
};
SlotInfo cl_hpane_PSlots[] = {
{
	STR__classInfo,
	CLSI,
	(long)&class_hpane
},{
	STR_paneConfig,
 	PTRS,
	(long)"westToEast"
},{
	STR__paneConfig,
 	LONG,
	PANE_CONFIG_W2E		/* default with W2E */
},{
	NULL
}
};

SlotInfo *slots_hpane[] = {
	(SlotInfo*)cl_hpane_NCSlots,
	(SlotInfo*)cl_hpane_NPSlots,
	(SlotInfo*)cl_hpane_CSlots,
	(SlotInfo*)cl_hpane_PSlots
};

MethodInfo meths_hpane[] = {
	/* local methods */
{
	STR_get,
	meth_hpane_get,
},{
	STR_initialize,
	meth_hpane_initialize
},{
	STR_set,
	meth_hpane_set
},{
	NULL
}
};

ClassInfo class_hpane = {
	slots_hpane,		/* class slot information	*/
	meths_hpane,		/* class methods		*/
	STR_hpane,		/* class identifier number	*/
	&class_pane,		/* super class info		*/
};

int meth_hpane_get(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	return meth_pane_get(self, result, argc, argv);
}

int meth_hpane_initialize(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	return meth_pane_initialize(self, result, argc, argv);
}

int meth_hpane_render(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	return meth_pane_render(self, result, argc, argv);
}

/*
 * returns non-zero if set operation succeded, zero otherwise.
 */
int meth_hpane_set(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	return meth_pane_set(self, result, argc, argv);
}



