/*
 * Copyright 1990 Pei-Yuan Wei.	All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */
/*
 * class	: dial
 * superClass	: field
 */
#include <stdio.h>
#include <ctype.h>
#include "error.h"
#include "mystrings.h"
#include "hash.h"
#include "ident.h"
#include "obj.h"
#include "packet.h"
#include "class.h"
#include "slotaccess.h"
#include "classlist.h"
#include "cl_dial.h"
#include "misc.h"
#include "glib.h"
#include "event.h"

SlotInfo cl_dial_NCSlots[] = {
	NULL
};
SlotInfo cl_dial_NPSlots[] = {
	NULL
};
SlotInfo cl_dial_CSlots[] = {
{
	STR_class,
	PTRS | SLOT_RW,
	(long)"dial"
},{
	NULL
}
};
SlotInfo cl_dial_PSlots[] = {
{
	STR__classInfo,
	CLSI,
	(long)&class_dial
},{
	NULL
}
};

SlotInfo *slots_dial[] = {
	(SlotInfo*)cl_dial_NCSlots,
	(SlotInfo*)cl_dial_NPSlots,
	(SlotInfo*)cl_dial_CSlots,
	(SlotInfo*)cl_dial_PSlots
};

MethodInfo meths_dial[] = {
	/* local methods */
{
	STR_config,
	meth_dial_config
},{
	STR_expose,
	meth_dial_expose
},{
	STR_get,
	meth_dial_get,
},{
	STR_initialize,
	meth_dial_initialize
},{
	STR_render,
	meth_dial_render
},{
	STR_set,
	meth_dial_set
},{
	NULL
}
};

ClassInfo class_dial = {
	slots_dial,		/* class slot information	*/
	meths_dial,		/* class methods		*/
	STR_dial,		/* class identifier number	*/
	&class_field,		/* super class info		*/
};

int meth_dial_config(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	return meth_field_config(self, result, argc, argv);
}

int meth_dial_expose(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	return meth_field_render(self, result, argc, argv);
}

int meth_dial_get(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	return meth_field_get(self, result, argc, argv);
}

int meth_dial_initialize(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	meth_field_initialize(self, result, argc, argv);
	return 1;
}

int meth_dial_render(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	Window w = GET_window(self);
	Pixmap pixmap;

	if (!w) meth_field_render(self, result, argc, argv);
	if (!(w = GET_window(self))) return 0;
	return 1;
}

/*
 * returns non-zero if set operation succeded, zero otherwise.
 */
int meth_dial_set(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	return meth_field_set(self, result, argc, argv);
}








