/*
 * Copyright 1990 1991 Pei-Yuan Wei.  All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */
/*
 * class        : cosmic
 * superClass	: NULL
 */
#include <stdio.h>
#include <sys/file.h>
#include "mystrings.h"
#include "error.h"
#include "hash.h"
#include "ident.h"
#include "obj.h"
#include "vlist.h"
#include "attr.h"
#include "packet.h"
#include "class.h"
#include "classlist.h"
#include "cl_cosmic.h"
#include "slotaccess.h"
#include "cexec.h"
#include "misc.h"

SlotInfo cl_cosmic_NCSlots[] = {
{
	STR_class,
	PTRS | SLOT_RW,
	(long)"cosmic"
},{
	STR_classScript,
	PTRS,
	(long)"\n\
		switch (arg[0]) {\n\
		case \"config\":\n\
			config(arg[1], arg[2], arg[3], arg[4]);\n\
		break;\n\
		case \"expose\":\n\
		case \"render\":\n\
			expose(arg[1], arg[2], arg[3], arg[4]);\n\
			render();\n\
		break;\n\
		case \"init\":\n\
			initialize();\n\
		break;\n\
		default:\n\
			print(\"unknown message, clsss = cosmic: args: \");\n\
			for (i =0; i < arg[]; i++) print(arg[i], \", \");\n\
			print(\"\\n\");\n\
			break;\n\
		}\n\
	",
},{
	STR__classScript,
	PCOD,
	NULL,
},{
	STR__classScriptSize,
	LONG,
	0,
},{
	NULL
}
};
SlotInfo cl_cosmic_NPSlots[] = {
{
	STR__classInfo,
	CLSI,
	(long)&class_cosmic
},{
	NULL
}
};
SlotInfo cl_cosmic_CSlots[] = {
	NULL
};
SlotInfo cl_cosmic_PSlots[] = {
	NULL
};

SlotInfo *slots_cosmic[] = {
	(SlotInfo*)cl_cosmic_NCSlots,
	(SlotInfo*)cl_cosmic_NPSlots,
	(SlotInfo*)cl_cosmic_CSlots,
	(SlotInfo*)cl_cosmic_PSlots
};

MethodInfo meths_cosmic[] = {
{
	STR_clone,
	meth_cosmic_clone
},{
	STR_clone2,
	meth_cosmic_clone2
},{
	STR_create,
	meth_cosmic_create
},{
	STR_debug,
	meth_cosmic_debug
},{
	STR_detach,
	meth_cosmic_detach
},{
	STR_destroy,
	meth_cosmic_destroy
},{
	STR_exit,
	meth_cosmic_exit
},{
	STR_exist,
	meth_cosmic_exist
},{
	STR_freeSelf,
	meth_cosmic_freeSelf
},{
	STR_info,
	meth_cosmic_info
},{
	STR_interpret,
	meth_cosmic_interpret
},{
	STR_object,
	meth_cosmic_object
},{
	STR_pop,
	meth_cosmic_pop
},{
	STR_push,
	meth_cosmic_push
},{
	STR_quit,
	meth_cosmic_quit
},{
	STR_save,
	meth_cosmic_save
},{
	STR_saveAs,
	meth_cosmic_saveAs
},{
	STR_send,
	meth_cosmic_send
},{
	STR_test1,
	meth_cosmic_test1
},{
	STR_test2,
	meth_cosmic_test2
},{
	STR_test3,
	meth_cosmic_test3
},{
	STR_test4,
	meth_cosmic_test4
},{
	STR_tweak,
	meth_cosmic_tweak
},{
	STR_usual,
	meth_cosmic_usual
},{
	NULL
}
};

ClassInfo class_cosmic = {
	slots_cosmic,		/* class slot information	*/
	meths_cosmic,		/* class methods		*/
	STR_cosmic,		/* class identifier number	*/
	NULL,			/* super class			*/
};

void sendInitToChildren(self) 
	VObj *self;
{
	Packet result;
	VObjList *olist;

	if (!callMeth(self, &result, 0, NULL, STR_initialize)) {
		fprintf(stderr, "clone ``%s''not properly initialized\n", 
			GET_name(self));
		/* error */
	}
	for (olist = GET__children(self); olist; olist = olist->next)
		if (olist->o) sendInitToChildren(olist->o);
}

/*
 * clone(clone name suffix)
 * 
 * Make a clone self
 *
 * Result: clone object, and optinally name it
 * Return: 1 if successful, 0 if error occured
 */
int meth_cosmic_clone(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	VObj *cloneObj;

	if (!meth_cosmic_clone2(self, result, argc, argv)) return 0;
	cloneObj = result->info.o;
	if (cloneObj) {
		sendInitToChildren(cloneObj);
		result->type = PKT_OBJ;
		result->info.o = cloneObj;
		return 1;
	}
	result->type = PKT_OBJ;
	result->info.o = NULL;
	return 0;
}

int meth_cosmic_clone2(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	char *suffix;
	VObj *cloneObj;
	char newName[255];

	cloneObj = clone(self);
	suffix = PkInfo2Str(&argv[0]);
	if (!cloneObj || !suffix) {
		result->type = PKT_OBJ;
		result->info.o = NULL;
		return 0;
	}
	sprintf(newName, "%s%s", GET_name(cloneObj), suffix);
	SET_name(cloneObj, saveString(newName));
	putHashEntry(objID2Obj, storeIdent(GET_name(cloneObj)), (int)cloneObj);

	result->type = PKT_OBJ;
	result->info.o = cloneObj;
	return 1;
}

/*
 * create(<attributes list>)
 * 
 * Result: created object
 * Return: 1 if successful, 0 if error occured
 */
int meth_cosmic_create(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	int slotv[100][2], slotc = 0, i;
	char *cp;
	HashEntry *entry;
	VObj *obj;

	result->type = PKT_OBJ;
	result->info.o = NULL;

	for (slotc = 0, i = 0; i < argc; slotc++, i += 2) {
		cp = PkInfo2Str(&argv[i]);
		if (!cp) {
			printf("create(): unknown attribute:");
			dumpPacket(&argv[i]);
			printf("\n");
			return 0;
		}
		entry = getHashEntry(symStr2ID, (int)cp);
		if (!entry) {
			printf("create(): unknown attribute: \"%s\"\n", cp);
			return 0;
		}
		slotv[slotc][0] = (int)(entry->val);
		slotv[slotc][1] = (int)saveString(PkInfo2Str(&argv[i + 1]));
	}
	if (slotc <= 0) return 0;

	if (obj = instantiateObj(slotv, &slotc)) {
		putHashEntry(objID2Obj, storeIdent(GET_name(obj)), (int)obj);
		sendMessage1(obj, "init");
		result->type = PKT_OBJ;
		result->info.o = obj;
		return 1;
	} else {
		fprintf(stderr, "create(): failed to create object.\n");
		return 0;
	}
}

/*
 * detach()
 * 
 * 
 * Result:
 * Return:
 */
int meth_cosmic_detach(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	clearPacket(result);
	return 0;
}

/*
 * debug()
 * 
 * Used to turn on/off various debugging flags.
 *
 * Result:
 * Return:
 */
int meth_cosmic_debug(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	clearPacket(result);
	if (!STRCMP(PkInfo2Str(&argv[0]), "pa")) {
		extern int flag_printAST;
		flag_printAST = PkInfo2Int(&argv[1]);
	} else if (!STRCMP(PkInfo2Str(&argv[0]), "pc")) {
		extern int flag_printPCode;
		flag_printPCode = PkInfo2Int(&argv[1]);
	} else if (!STRCMP(PkInfo2Str(&argv[0]), "pe")) {
		extern int flag_printExec;
		flag_printExec = PkInfo2Int(&argv[1]);
	} else if (!STRCMP(PkInfo2Str(&argv[0]), "dumpPCode")) {
		int pc = 0;
	        union PCode *pcode = GET__script(self);
		int pc_limit = GET__scriptSize(self);
		printPCode(pcode, &pc, pc_limit);
	}
	return 1;
}

/*
 * destroy(object name)
 * 
 * Remove the existance of an object.
 * 
 * Result:
 * Return:
 */
int meth_cosmic_destroy(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	clearPacket(result);
	return 0;
}

/*
 * exit(value)
 * 
 * Exit viola with specified value.
 * 
 * Result: n/a
 * Return: n/a
 */
int meth_cosmic_exit(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	fprintf(stderr, "exit...\n");
	exit(PkInfo2Int(&argv[0]));
}

/*
 * exist(<obj name>)
 * 
 * Determines whether if an object is currently loaded.
 * 
 * Result:
 * Return:
 */
int meth_cosmic_exist(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	HashEntry *entry;

	result->type = PKT_INT;
	if (entry = getHashEntry(symStr2ID, (int)PkInfo2Str(&argv[0]))) {
		if (findObject(entry->val)) {
			result->info.i = 1;
			return 1;
		}
	}
	result->info.i = 0;
	return 1;
}

/*
 * ()
 * 
 * 
 * Result:
 * Return:
 */
int meth_cosmic_freeSelf(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	clearPacket(result);
	free(self);
	/* and remove from object list...*/
	return 1;
}

/*
 * info(<info flag>)
 *
 * Info flags:
 * 	<none> 
 *		Print to stdout slot values for the calling object.
 *	"listAllMethods"
 *		Print to stdout name of methods in all classes.
 *	"listMethods"
 *		Print to stdout name of methods in calling obj's class.
 *	"listSlotsRW"
 *	"listSlotsR"
 *	"listSlotsW"
 *		Print to stdout slot values for the calling object,
 *		filterd by SLOT_R/W flags.
 *	"listAllObjects"
 *		List to stdout name of all loaded objects.
 *
 * Result:
 * Return:
 */
int meth_cosmic_info(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	char *cp;

	clearPacket(result);
	if (argc == 0) {
		return dumpObj(self, fprintf, stdout, 0, 0);
	}
	cp = PkInfo2Str(&argv[0]);
	if (!STRCMP(cp, "listMethods")) {
		extern HashTable *symID2Str;
		ClassInfo *cip;
		MethodInfo *mip;
		FILE *fp;

		if (argc >= 2) {
			cip = getClassInfoByName(PkInfo2Str(&argv[1]));
		} else {
			cip = (ClassInfo*)GET_class(self);
		}
		if (argc == 3) {
			fp = fopen(PkInfo2Str(&argv[2]), "w");
			if (!fp) return 0;
			for (mip = cip->methods; mip->id; mip++)
				fprintf(fp, "%s\n", 
					(char*)getHashEntry(symID2Str,
								mip->id)->val);
			fclose(fp);
		} else {
			char sbuff[255];

			buff[0] ='\0';
			for (mip = cip->methods; mip->id; mip++) {
				sprintf(sbuff, "%s\n", 
					(char*)getHashEntry(symID2Str,
							mip->id)->val);
				strcat(buff, " ");
				strcat(buff, sbuff);
			}
			result->info.s = saveString(buff);
			result->type = PKT_STR;
		}

	} else if (!STRCMP(cp, "listNPSlots")) {
		ClassInfo *cip;
		SlotInfo *sip;
		int i;

		if (argc >= 2) {
			cip = getClassInfoByName(PkInfo2Str(&argv[1]));
		} else {
			cip = (ClassInfo*)GET_class(self);
		}
		buff[0] = '\0';
		sip = cip->slots[1]; /* section 1 is NPSlots */
		for (i = 0; sip[i].id; i++) {
			if (!(sip[i].flags & SLOT_RW)) continue;
			strcat(buff, 
				(char*)getHashEntry(symID2Str, 
					sip[i].id)->val);
			strcat(buff, "\n");
		}	
		result->info.s = saveString(buff);
		result->type = PKT_STR;

	} else if (!STRCMP(cp, "listNCSlots")) {
		ClassInfo *cip;
		SlotInfo *sip;
		int i;

		if (argc >= 2) {
			cip = getClassInfoByName(PkInfo2Str(&argv[1]));
		} else {
			cip = (ClassInfo*)GET_class(self);
		}
		buff[0] = '\0';
		sip = cip->slots[0]; /* section 0 is NCSlots */
		for (i = 0; sip[i].id; i++) {
			strcat(buff, 
				(char*)getHashEntry(symID2Str, 
					sip[i].id)->val);
			strcat(buff, "\n");
		}	
		result->info.s = saveString(buff);
		result->type = PKT_STR;

	} else if (!STRCMP(cp, "listSlotsRW")) {
		return dumpObj(self, fprintf, stdout, SLOT_RW, 0);
	} else if (!STRCMP(cp, "listSlotsR")) {
		return dumpObj(self, fprintf, stdout, SLOT_R, 0);
	} else if (!STRCMP(cp, "listSlotsW")) {
		return dumpObj(self, fprintf, stdout, SLOT_W, 0);
	} else if (!STRCMP(cp, "listAllObjects")) {

	} else if (!STRCMP(cp, "listAllMethods")) {
		extern HashTable *symStr2ID, *symID2Str;
		ClassInfo *cip, *cip2;
		MethodInfo *mip;
		int i;

		for (i = 0; cip = classList[i]; i++) {
			printf("\n%s :\n", 
				(char*)getHashEntry(symID2Str, cip->id)->val);
			for (cip2 = cip; cip2; cip2 = cip2->superClass) {
				for (mip = cip2->methods; mip->id; mip++) {
					printf("%s\n", 
						(char*)getHashEntry(symID2Str,
							mip->id)->val);
				}
			}
			printf("\n");
		}
	}
	return 1;
}

/*
 * interpret(<script> [, ...])
 *
 * Evaluate the arguments as scripts.
 *
 * Result: as effected by script
 * Return: 1 if successful, 0 if error occured
 */
int meth_cosmic_interpret(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	int i;
	extern Packet reg1; /*XXX dangerous */

	clearPacket(result);
	for (i = 0; i < argc; i++) execScript(self, result, argv[i].info.s);
	result->info = reg1.info;
	result->type = reg1.type;

	return 1;
}

/*
 * object(<object name>)
 * 
 * 
 * 
 * Result:
 * Return:
 */
int meth_cosmic_object(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	HashEntry *entry;
	VObj *obj;
	char *cp;

	result->info.o = PkInfo2Obj(&argv[0]);
	result->type = PKT_OBJ;
	return 1;
}

/*
 * pop()
 * 
 * 
 * Result:
 * Return:
 */
int meth_cosmic_pop(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	clearPacket(result);
	return 0;
}

/*
 * ()
 * 
 * 
 * Result:
 * Return:
 */
int meth_cosmic_push(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	clearPacket(result);
	return 0;
}

/*
 * quit();
 *
 * Save stack and exit.
 *
 * Result: unaffected
 * Return: 1 if successful, 0 if error occured
 */
int meth_cosmic_quit(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	fprintf(stderr, "exit...\n");
	exit(0);
}

/*
 * save();
 * 
 * Save the calling object's cluster in the top object's name with ".v"
 * appended.
 *
 * Result: file name under which the objects were saved in
 * Return:
 */
int meth_cosmic_save(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	VObj *parent, *obj = self;
	char fileName[100];
	FILE *fp;
	int stat;

	while (parent = GET__parent(obj)) obj = parent;

	strcpy(fileName, GET_name(obj));
	strcat(fileName, ".v");

	fp = fopen(fileName, "w");
	if (fp) {
		stat = saveSelfAndChildren(obj, fp);
		fclose(fp);
		if (stat) {
			result->type = PKT_STR;
			result->info.s = saveString(fileName);
			return 1;
		}
	}
	clearPacket(result);
	return 0;
}

/*
 * saveAs(filePath);
 * 
 * Save the calling object's cluster in the specified file path. 
 * 
 * Result:
 * Return:
 */
int meth_cosmic_saveAs(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	VObj *parent, *obj = self;
	char *cp, fileName[100];
	FILE *fp;
	int stat;

	if (argc != 1) return 0;

	while (parent = GET__parent(obj)) obj = parent;

	cp = PkInfo2Str(&argv[0]);
	if (!cp) return 0;

	strcpy(fileName, cp);

	fp = fopen(cp, "w");
	if (fp) {
		stat = saveSelfAndChildren(obj, fp);
		fclose(fp);
		if (stat) {
			result->type = PKT_STR;
			result->info.s = saveString(fileName);
			return 1;
		}
	}
	clearPacket(result);
	return stat;
}

/*
 * send(<object name>, <message list ...>)
 * 
 * Send a message for the target object's script to handle.
 *
 * Result:
 * Return:
 */
int meth_cosmic_send(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	VObj *obj;
	char *cp;

	obj = PkInfo2Obj(&argv[0]);
	if (!obj) {
		
	}
	if (obj) {
		if (sendMessagePackets(obj, &argv[1], argc - 1)) {
			extern Packet reg1; /*XXX dangerous */
			result->info = reg1.info;
			result->type = reg1.type;
			return 1;
		}
	}
	clearPacket(result);
	return 0;
}

int meth_cosmic_test1(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
/*	result->type = PKT_INT;
	result->info.i = 100;
*/
	Attr *attrp;
	Packet *packet0 = makePacket();
	Packet *packet1 = makePacket();

	packet0->info.i = 4;
	packet0->type = PKT_INT;
	packet1->info.i = 7;
	packet1->type = PKT_INT;

	result->type = PKT_ATR;
	result->info.a = attrp = makeAttr(0, packet0);
	attrp->next = makeAttr(1, packet1);
	return 1;
}

int meth_cosmic_test2(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	result->type = PKT_INT;
	result->info.i = 200;
}

int meth_cosmic_test3(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	result->type = PKT_INT;
	result->info.i = 300;
}

int meth_cosmic_test4(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	result->type = PKT_INT;
	result->info.i = 400;
}

/*
 * tweak(object name, command string)
 * 
 * Execute command string in context of the target object, bypassing 
 * the target object's script.
 *
 * Result:
 * Return:
 */
int meth_cosmic_tweak(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	VObj *obj;
	int i;
/*
	HashEntry *entry;
		if (entry = getHashEntry(symStr2ID, (int)cp)) {
			if (obj = findObject(entry->val)) {
*/
	obj = PkInfo2Obj(&argv[0]);
	if (obj) {
		extern Packet reg1; /*XXX dangerous */
		for (i = 1; i < argc; i++) {
			char *cp = saveString(PkInfo2Str(&argv[i]));
			execScript(obj, result, cp);
			free(cp);
		}
		result->info = reg1.info;
		result->type = reg1.type;
		return 1;
	}
	clearPacket(result);
	return 0;
}

/*
 * usual()
 * 
 * Execute the default class script for the class of the calling object.
 * 
 * Result: result of the class script
 * Return:
 */
int meth_cosmic_usual(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	extern int stackExecIdx;
	extern int stackBaseIdx;
	int save_stackExecIdx;
	int save_stackBaseIdx;

	save_stackExecIdx = stackExecIdx;
	save_stackBaseIdx = stackBaseIdx;

	stackBaseIdx = stackExecIdx;
	execObjClassScript(self, result);

	stackExecIdx = save_stackExecIdx;
	stackBaseIdx = save_stackBaseIdx;

	return 1;
}

