/*
 * Copyright 1990 Pei-Yuan Wei.	All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */
/*
 * class	: XBM
 * superClass	: field
 */
#include <stdio.h>
#include <ctype.h>
#include "error.h"
#include "mystrings.h"
#include "hash.h"
#include "ident.h"
#include "obj.h"
#include "packet.h"
#include "class.h"
#include "slotaccess.h"
#include "classlist.h"
#include "cl_XBM.h"
#include "misc.h"
#include "glib.h"
#include "event.h"

SlotInfo cl_XBM_NCSlots[] = {
	NULL
};
SlotInfo cl_XBM_NPSlots[] = {
	NULL
};
SlotInfo cl_XBM_CSlots[] = {
{
	STR_class,
	PTRS | SLOT_RW,
	(long)"XBM"
},{
	STR_classScript,
	PTRS,
	(long)"\n\
		switch (arg[0]) {\n\
		case \"mouseMove\":\n\
		case \"enter\":\n\
		case \"leave\":\n\
		case \"keyPress\":\n\
		case \"keyRelease\":\n\
		case \"buttonPress\":\n\
		case \"buttonRelease\":\n\
		case \"shownPositionH\":\n\
		case \"shownPositionV\":\n\
		break;\n\
		case \"config\":\n\
			config(arg[1], arg[2], arg[3], arg[4]);\n\
			/*render();*/\n\
		break;\n\
		case \"expose\":\n\
			expose(arg[1], arg[2], arg[3], arg[4]);\n\
		break;\n\
		case \"render\":\n\
			render();\n\
		break;\n\
		case \"init\":\n\
			initialize();\n\
		break;\n\
		case \"info\":\n\
			info();\n\
		break;\n\
		default:\n\
			print(\"unknown message, clsss = XBM: args: \");\n\
			for (i = 0; i < arg[]; i++) print(arg[i], \", \");\n\
			print(\"\n\");\n\
		break;\n\
		}\n\
	",
},{
	NULL
}
};
SlotInfo cl_XBM_PSlots[] = {
{
	STR__classInfo,
	CLSI,
	(long)&class_XBM
},{
	NULL
}
};

SlotInfo *slots_XBM[] = {
	(SlotInfo*)cl_XBM_NCSlots,
	(SlotInfo*)cl_XBM_NPSlots,
	(SlotInfo*)cl_XBM_CSlots,
	(SlotInfo*)cl_XBM_PSlots
};

MethodInfo meths_XBM[] = {
	/* local methods */
{
	STR_config,
	meth_XBM_config
},{
	STR_expose,
	meth_XBM_expose
},{
	STR_get,
	meth_XBM_get,
},{
	STR_initialize,
	meth_XBM_initialize
},{
	STR_render,
	meth_XBM_render
},{
	STR_set,
	meth_XBM_set
},{
	NULL
}
};

ClassInfo class_XBM = {
	slots_XBM,		/* class slot information	*/
	meths_XBM,		/* class methods		*/
	STR_XBM,		/* class identifier number	*/
	&class_field,		/* super class info		*/
};

int meth_XBM_config(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	return meth_field_config(self, result, argc, argv);
}

int meth_XBM_expose(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	Window w = GET_window(self);
	Pixmap pixmap;

	meth_field_expose(self, result, argc, argv);
	
	if (!(w = GET_window(self))) return 0;
	if (!(pixmap = (Pixmap)GET__label(self))) {
		int width, height, hotx, hoty;
		char *cp;

		if (!(cp = GET_label(self))) return 0;
		pixmap = GLMakeXBMFromASCII(w, cp, &width, &height, 
					    &hotx, &hoty);
		SET__label(self, pixmap);
		SET_width(self, width);
		SET_height(self, height);
	}
	if (pixmap) {
		GLDisplayXBM(w, 0, 0, GET_width(self), GET_height(self),
			     pixmap); 
		result->info.i = 1;
		return 1;
	}
	result->info.i = 0;
	return 0;
}

int meth_XBM_get(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	return meth_field_get(self, result, argc, argv);
}

int meth_XBM_initialize(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	return meth_field_initialize(self, result, argc, argv);
}

/*
 * returns non-zero if set operation succeded, zero otherwise.
 */
int meth_XBM_set(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	int labelID = getIdent(PkInfo2Str(argv));

	switch (labelID) {
	case STR_label: {
		Pixmap pixmap;
		int width, height, hotx, hoty;
		char *cp;

		meth_field_set(self, result, argc, argv);

		if (!(cp = GET_label(self))) return 0;
		pixmap = GLMakeXBMFromASCII(rootWindow, cp,
					    &width, &height, &hotx, &hoty);
		SET__label(self, pixmap);
		SET_width(self, width);
		SET_height(self, height);
		return 1;
		}
	}      
	return meth_field_set(self, result, argc, argv);
}

int meth_XBM_render(self, result, argc, argv)
	VObj *self;
	Packet *result;
	int argc;
	Packet argv[];
{
	Window w = GET_window(self);
	Pixmap pixmap;

	meth_field_render(self, result, argc, argv);
	
	if (!(w = GET_window(self))) return 0;
	if (!(pixmap = (Pixmap)GET__label(self))) {
		int width, height, hotx, hoty;
		char *cp;

		if (!(cp = GET_label(self))) return 0;
		pixmap = GLMakeXBMFromASCII(w, cp, &width, &height, 
					    &hotx, &hoty);
		SET__label(self, pixmap);
		SET_width(self, width);
		SET_height(self, height);
	}
	if (pixmap) {
		GLDisplayXBM(w, 0, 0, GET_width(self), GET_height(self),
			     pixmap); 
		result->info.i = 1;
		return 1;
	}
	result->info.i = 0;
	return 0;
}








