/*
 * cexec.c
 *
 * Pseudo-code execution procedures
 */
/*
 * Copyright 1992 Pei-Yuan Wei. All rights reserved.
 *
 * Permission to use, copy, and/or distribute for any purpose and
 * without fee is hereby granted, provided that both the above copyright
 * notice and this permission notice appear in all copies and derived works.
 * Fees for distribution or use of this software or derived works may only
 * be charged with express written permission of the copyright holder.
 * This software is provided ``as is'' without express or implied warranty.
 */
#include <stdio.h>
#include "hash.h"
#include "obj.h"
#include "packet.h"
#include "class.h"
#include "y.tab.h"
#include "ast.h"
#include "slotaccess.h"
#include "cgen.h"
#include "cexec.h"
#include "vlist.h"
#include "attr.h"
#include "mystrings.h"
#include "ident.h"
#include "scanutils.h"

int i;
Packet reg1;
Packet reg2;
Packet *packetp;
Attr *attrp;
HashEntry *entry;

char *passthru_argument= "";

int flag_printExec = 0;
int flag_vwatch = 0;

#define EXEC_STACK_SIZE_INCREMENT 10000

int	execStackSize = 0;
int	execStackSizeCheck = 0;
Packet	*execStack;
long	stackExecIdx = -1;
long	stackBaseIdx  = -1;
int	arg_strid;
union PCode pcode_buff[5000]; /* limit on maximum opcode size */

int init_cexec() {

	arg_strid = storeIdent("arg"); /* can just dump this is ident list? */
	return incrementExecStack();
}

/* reallocating the stack is unsafe because of the stack's usage ... 
 * oh well, just start out with a large enough stack, I guess.
 * a *real* solution is too expensive.
 */
int incrementExecStack()
{
	Packet *newStack;

	newStack = (Packet*)malloc(sizeof(struct Packet*) * 
				(execStackSize + EXEC_STACK_SIZE_INCREMENT));
	if (!newStack) {
		return 0;
	}
	if (execStackSize > 0) {
		bcopy(newStack, execStack, 
			execStackSize * sizeof(struct Packet*));
	/*	free(execStack);*/
	}
	execStackSize = execStackSize + EXEC_STACK_SIZE_INCREMENT;
	execStackSizeCheck = execStackSize - 100; /* 100 as arbitrary margin */
	execStack = newStack;

	return (int)execStack;
}

int getlistcount(pcode, stackBaseIdx)
	union PCode **pcode;
	int stackBaseIdx;
{
	packetp = execStack[stackBaseIdx - (*(*pcode)++).i].info.p;
	for (i = 0, attrp = packetp->info.a; attrp; attrp = attrp->next) i++;

	return i;
}

dumpStack()
{
	for (i = 0; i < stackExecIdx; i++) {
		printf(": %d\t ", i);
		dumpPacket(&execStack[i]);
		printf("\n");
	}
}

Packet *getlistitem(pcode, stackBaseIdx)
	union PCode **pcode;
	int stackBaseIdx;
{
/*
	printf("****stackExecIdx=%d stackBaseIdx=%d pcode=%d reg=%d\n",
		stackExecIdx, stackBaseIdx, (*(*pcode)).i, reg1.info.i);
	dumpStack();
*/
	packetp = execStack[stackBaseIdx - (*(*pcode)++).i].info.p;
/*
	printf("****packet =");
	dumpPacket(packetp);
	printf("\n");
*/
	attrp = scanAttr(&(packetp->info.a), reg1.info.i);
	if (!attrp) {
		printf("undefined list item (id=%d)\n",	reg1.info.i);
		return NULL;
	}
	packetp = (Packet*)attrp->val;

	return packetp;
}

makeArgList(obj, argc)
	VObj *obj;
	int argc;
{
	int i;

	Attr *attrlist = NULL;
	Attr *varlist = GET__varList(obj);

	if (varlist) {
		attrlist = scanAttr(varlist, arg_strid);
		if (attrlist) {
			/* free attribute list */
			attrlist = NULL; /*XXX*/
		}
	}

	for (i = 0; i < argc; i++) {
		packetp = &(execStack[stackExecIdx - i]);
/*
		printf("arg[%d]=", argc - i - 1);
		dumpPacket(packetp);
		printf("<<<\n");
*/
		attrp = makeAttr(argc - i - 1, (long)packetp);
		prependAttr(&attrlist, attrp);
	}

	if (!varlist) {
		attrp = makeAttr(arg_strid, NULL);
		SET__varList(obj, attrp);
	} else {
		attrp = scanAttr(&varlist, arg_strid);
		if (!attrp) {
			attrp = makeAttr(arg_strid, NULL);
			prependAttr(&varlist, attrp);
		}
	}
	packetp = makePacket();
	packetp->info.a = attrlist;
	packetp->type = PKT_ATR;
	attrp->val = (long)packetp;
}

void dumpVarList(varlist)
	Attr *varlist;
{
	Attr *attrlist;
	Attr *attrp2;
	int i = 0;

	for (attrp = varlist; attrp; attrp = attrp->next) {
		printf("%d) id=%d=\"%s\" ", i, 
		      	attrp->id,
			(char*)getHashEntry(symID2Str, attrp->id));
		packetp = (Packet*)attrp->val;
		if (packetp->type == PKT_ATR) {
			dumpPacket(packetp);
			printf(":\n");
			for (attrp2 = packetp->info.a; attrp2; 
				attrp2 = attrp2->next) {
				printf("\tid=%d,", attrp2->id);
				dumpPacket((Packet*)(attrp2->val));
				printf(";\n");
			}
		} else {
			dumpPacket(packetp);
		}
		printf(";\n");
		i++;
	}
	printf("<\n");
}

/*
 * should optimize this procedure...
 */
Packet *codeExec(self, pcode, pcode_start, pcode_end)
	VObj *self;
	union PCode *pcode;
	union PCode *pcode_start;
	union PCode *pcode_end;
{
	int currBaseIdx = stackBaseIdx;

	while (pcode < pcode_end) {
		extern char *PCodeStr[];

		if (flag_printExec) {
			fprintf(stderr, 
				"pc=%d\tcurrBaseIdx=%d\tstackExecIdx=%d\n",
				pcode - pcode_start,
				currBaseIdx, 
				stackExecIdx);
		}

		switch ((*pcode++).x) {
		case CODE_INTEGER:
			reg1.info.i = (*pcode++).i;
			reg1.type = PKT_INT;
		break;

        	case CODE_CHAR:
			reg1.info.c = (*pcode++).c;
			reg1.type = PKT_CHR;
		break;

		case CODE_FLOAT:
			reg1.info.f = (*pcode++).f;
			reg1.type = PKT_FLT;
		break;

		case CODE_STRING:
			reg1.info.s = (*pcode++).s;
			reg1.type = PKT_STR;
		break;

		case CODE_REF:
			packetp = execStack[currBaseIdx-(*pcode++).i].info.p;
			reg1.info = packetp->info;
/*
			switch (packetp->type) {
			case PKT_INT: reg1.info.i = packetp->info.i; break;
			case PKT_CHR: reg1.info.c = packetp->info.c; break;
			case PKT_FLT: reg1.info.f = packetp->info.f; break;
			case PKT_STR: reg1.info.s = packetp->info.s; break;
			case PKT_OBJ: reg1.info.o = packetp->info.o; break;
			case PKT_ATR: reg1.info.a = packetp->info.a; break;
			default:
				fprintf(stderr, 
					"%d\tid=%d UNKNOWN TYPE\n", 
					pcode - pcode_start - 1, *(pcode-1));
			break;
			}
*/
			reg1.type = packetp->type;
		break;

		case CODE_LIST:
			if (packetp = getlistitem(&pcode, currBaseIdx)) {
				reg1.info = packetp->info;
				reg1.type = packetp->type;
			}
		break;

		case CODE_LISTC:
			reg1.info.i = getlistcount(&pcode, currBaseIdx);
			reg1.type = PKT_INT;
		break;

		case CODE_LIST_REF:
			packetp = execStack[currBaseIdx - (*pcode++).i].info.p;
			if (packetp) {
				reg1.info = packetp->info;
				reg1.type = packetp->type;
			}
		break;
/* DEC */
		case CODE_INC_PRE:
			packetp = execStack[currBaseIdx-(*pcode++).i].info.p;
			reg1.info.i = ++(packetp->info.i);
			reg1.type   = PKT_INT;
		break;

		case CODE_INC_POST:
			packetp = execStack[currBaseIdx-(*pcode++).i].info.p;
			reg1.info.i = (packetp->info.i)++;
			reg1.type   = PKT_INT;
		break;
/* INC */
		case CODE_DEC_PRE:
			packetp = execStack[currBaseIdx-(*pcode++).i].info.p;
			reg1.info.i = --(packetp->info.i);
			reg1.type   = PKT_INT;
		break;

		case CODE_DEC_POST:
			packetp = execStack[currBaseIdx-(*pcode++).i].info.p;
			reg1.info.i = (packetp->info.i)--;
			reg1.type   = PKT_INT;
		break;
/* DIV */
		case CODE_DIV_INT:
			reg2.info.i = (*pcode++).i;
			reg2.type = PKT_INT;
			biOp(CODE_DIV, &reg1, &reg2);
		break;

		case CODE_DIV_CHAR:
			reg2.info.c = (*pcode++).c;
			reg2.type = PKT_CHR;
			biOp(CODE_DIV, &reg1, &reg2);
		break;

		case CODE_DIV_FLOAT:
			reg2.info.f = (*pcode++).f;
			reg2.type = PKT_FLT;
			biOp(CODE_DIV, &reg1, &reg2);
		break;

		case CODE_DIV_REF:
			packetp = execStack[currBaseIdx-(*pcode++).i].info.p;
			reg2.info = packetp->info;
			reg2.type = packetp->type;
			biOp(CODE_DIV, &reg1, &reg2);
		break;

		case CODE_DIV_LISTC:
			reg2.info.i = getlistcount(&pcode, currBaseIdx);
			reg2.type = PKT_INT;
			biOp(CODE_DIV, &reg1, &reg2);
		break;

		case CODE_DIV_LIST:
			if (packetp = getlistitem(&pcode, currBaseIdx)) {
				reg1.info = execStack[stackExecIdx].info;
				reg1.type = execStack[stackExecIdx--].type;
				reg2.info = packetp->info;
				reg2.type = packetp->type;
				biOp(CODE_DIV, &reg1, &reg2);
			}
		break;

		case CODE_DIV_POP:
			reg2.info = reg1.info;
			reg2.type = reg1.type;
			reg1.info = execStack[stackExecIdx].info;
			reg1.type = execStack[stackExecIdx].type;
			--stackExecIdx;
			biOp(CODE_DIV, &reg1, &reg2);
		break;

/* PLUS */
		case CODE_PLUS_INT:
			reg2.info.i = (*pcode++).i;
			reg2.type = PKT_INT;
			biOp(CODE_PLUS, &reg1, &reg2);
		break;

		case CODE_PLUS_CHAR:
			reg2.info.c = (*pcode++).c;
			reg2.type = PKT_CHR;
			biOp(CODE_PLUS, &reg1, &reg2);
		break;

		case CODE_PLUS_FLOAT:
			reg2.info.f = (*pcode++).f;
			reg2.type = PKT_FLT;
			biOp(CODE_PLUS, &reg1, &reg2);
		break;

		case CODE_PLUS_STR:
			reg2.info.s = (*pcode++).s;
			reg2.type = PKT_STR;
			biOp(CODE_PLUS, &reg1, &reg2);
		break;

		case CODE_PLUS_REF:
			packetp = execStack[currBaseIdx-(*pcode++).i].info.p;
			reg2.info = packetp->info;
			reg2.type = packetp->type;
			biOp(CODE_PLUS, &reg1, &reg2);
		break;

		case CODE_PLUS_LISTC:
			reg2.info.i = getlistcount(&pcode, currBaseIdx);
			reg2.type = PKT_INT;
			biOp(CODE_PLUS, &reg1, &reg2);
		break;

		case CODE_PLUS_LIST:
			if (packetp = getlistitem(&pcode, currBaseIdx)) {
				reg1.info = execStack[stackExecIdx].info;
				reg1.type = execStack[stackExecIdx--].type;
				reg2.info = packetp->info;
				reg2.type = packetp->type;
				biOp(CODE_PLUS, &reg1, &reg2);
			}
		break;

		case CODE_PLUS_POP:
			reg2.info = reg1.info;
			reg2.type = reg1.type;
			reg1.info = execStack[stackExecIdx].info;
			reg1.type = execStack[stackExecIdx].type;
			--stackExecIdx;
			biOp(CODE_PLUS, &reg1, &reg2);
		break;

/* MINUS */
		case CODE_MINUS_INT:
			reg2.info.i = (*pcode++).i;
			reg2.type = PKT_INT;
			biOp(CODE_MINUS, &reg1, &reg2);
		break;

		case CODE_MINUS_CHAR:
			reg2.info.c = (*pcode++).c;
			reg2.type = PKT_CHR;
			biOp(CODE_MINUS, &reg1, &reg2);
		break;

		case CODE_MINUS_FLOAT:
			reg2.info.f = (*pcode++).f;
			reg2.type = PKT_FLT;
			biOp(CODE_MINUS, &reg1, &reg2);
		break;

		case CODE_MINUS_REF:
			packetp = execStack[currBaseIdx-(*pcode++).i].info.p;
			reg2.info = packetp->info;
			reg2.type = packetp->type;
			biOp(CODE_MINUS, &reg1, &reg2);
		break;

		case CODE_MINUS_LISTC:
			reg2.info.i = getlistcount(&pcode, currBaseIdx);
			reg2.type = PKT_INT;
			biOp(CODE_MINUS, &reg1, &reg2);
		break;

		case CODE_MINUS_LIST:
			if (packetp = getlistitem(&pcode, currBaseIdx)) {
				reg1.info = execStack[stackExecIdx].info;
				reg1.type = execStack[stackExecIdx--].type;
				reg2.info = packetp->info;
				reg2.type = packetp->type;
				biOp(CODE_MINUS, &reg1, &reg2);
			}
		break;

		case CODE_MINUS_POP:
			reg2.info = reg1.info;
			reg2.type = reg1.type;
			reg1.info = execStack[stackExecIdx].info;
			reg1.type = execStack[stackExecIdx].type;
			--stackExecIdx;
			biOp(CODE_MINUS, &reg1, &reg2);
		break;

/* MULT */
		case CODE_MULT_INT:
			reg2.info.i = (*pcode++).i;
			reg2.type = PKT_INT;
			biOp(CODE_MULT, &reg1, &reg2);
		break;

		case CODE_MULT_CHAR:
			reg2.info.c = (*pcode++).c;
			reg2.type = PKT_CHR;
			biOp(CODE_MULT, &reg1, &reg2);
		break;

		case CODE_MULT_FLOAT:
			reg2.info.f = (*pcode++).f;
			reg2.type = PKT_FLT;
			biOp(CODE_MULT, &reg1, &reg2);
		break;

		case CODE_MULT_REF:
			packetp = execStack[currBaseIdx-(*pcode++).i].info.p;
			reg2.info = packetp->info;
			reg2.type = packetp->type;
			biOp(CODE_MULT, &reg1, &reg2);
		break;

		case CODE_MULT_LISTC:
			reg2.info.i = getlistcount(&pcode, currBaseIdx);
			reg2.type = PKT_INT;
			biOp(CODE_MULT, &reg1, &reg2);
		break;

		case CODE_MULT_LIST:
			if (packetp = getlistitem(&pcode, currBaseIdx)) {
				reg1.info = execStack[stackExecIdx].info;
				reg1.type = execStack[stackExecIdx--].type;
				reg2.info = packetp->info;
				reg2.type = packetp->type;
				biOp(CODE_MULT, &reg1, &reg2);
			}
		break;

		case CODE_MULT_POP:
			reg2.info = reg1.info;
			reg2.type = reg1.type;
			reg1.info = execStack[stackExecIdx].info;
			reg1.type = execStack[stackExecIdx].type;
			--stackExecIdx;
			biOp(CODE_MULT, &reg1, &reg2);
		break;

/* AND && */
		case CODE_AND_INT:
			reg2.info.i = (*pcode++).i;
			reg2.type = PKT_INT;
			biOp(CODE_AND, &reg1, &reg2);
		break;

		case CODE_AND_CHAR:
			reg2.info.c = (*pcode++).c;
			reg2.type = PKT_CHR;
			biOp(CODE_AND, &reg1, &reg2);
		break;

		case CODE_AND_FLOAT:
			reg2.info.f = (*pcode++).f;
			reg2.type = PKT_FLT;
			biOp(CODE_AND, &reg1, &reg2);
		break;

		case CODE_AND_REF:
			packetp = execStack[currBaseIdx-(*pcode++).i].info.p;
			reg2.info = packetp->info;
			reg2.type = packetp->type;
			biOp(CODE_AND, &reg1, &reg2);
		break;

		case CODE_AND_LISTC:
			reg2.info.i = getlistcount(&pcode, currBaseIdx);
			reg2.type = PKT_INT;
			biOp(CODE_AND, &reg1, &reg2);
		break;

		case CODE_AND_LIST:
			if (packetp = getlistitem(&pcode, currBaseIdx)) {
				reg1.info = execStack[stackExecIdx].info;
				reg1.type = execStack[stackExecIdx--].type;
				reg2.info = packetp->info;
				reg2.type = packetp->type;
				biOp(CODE_AND, &reg1, &reg2);
			}
		break;

		case CODE_AND_POP:
			reg2.info = reg1.info;
			reg2.type = reg1.type;
			reg1.info = execStack[stackExecIdx].info;
			reg1.type = execStack[stackExecIdx].type;
			--stackExecIdx;
			biOp(CODE_AND, &reg1, &reg2);
		break;

/* OR || */
		case CODE_OR_INT:
			reg2.info.i = (*pcode++).i;
			reg2.type = PKT_INT;
			biOp(CODE_OR, &reg1, &reg2);
		break;

		case CODE_OR_CHAR:
			reg2.info.c = (*pcode++).c;
			reg2.type = PKT_CHR;
			biOp(CODE_OR, &reg1, &reg2);
		break;

		case CODE_OR_FLOAT:
			reg2.info.f = (*pcode++).f;
			reg2.type = PKT_FLT;
			biOp(CODE_OR, &reg1, &reg2);
		break;

		case CODE_OR_REF:
			packetp = execStack[currBaseIdx-(*pcode++).i].info.p;
			reg2.info = packetp->info;
			reg2.type = packetp->type;
			biOp(CODE_OR, &reg1, &reg2);
		break;

		case CODE_OR_LISTC:
			reg2.info.i = getlistcount(&pcode, currBaseIdx);
			reg2.type = PKT_INT;
			biOp(CODE_OR, &reg1, &reg2);
		break;

		case CODE_OR_LIST:
			if (packetp = getlistitem(&pcode, currBaseIdx)) {
				reg1.info = execStack[stackExecIdx].info;
				reg1.type = execStack[stackExecIdx--].type;
				reg2.info = packetp->info;
				reg2.type = packetp->type;
				biOp(CODE_OR, &reg1, &reg2);
			}
		break;

		case CODE_OR_POP:
			reg2.info = reg1.info;
			reg2.type = reg1.type;
			reg1.info = execStack[stackExecIdx].info;
			reg1.type = execStack[stackExecIdx].type;
			--stackExecIdx;
			biOp(CODE_OR, &reg1, &reg2);
		break;

/* EQ == */
		case CODE_EQ_INT:
			reg2.info.i = (*pcode++).i;
			reg2.type = PKT_INT;
			biOp(CODE_EQ, &reg1, &reg2);
		break;

		case CODE_EQ_CHAR:
			reg2.info.c = (*pcode++).c;
			reg2.type = PKT_CHR;
			biOp(CODE_EQ, &reg1, &reg2);
		break;

		case CODE_EQ_FLOAT:
			reg2.info.f = (*pcode++).f;
			reg2.type = PKT_FLT;
			biOp(CODE_EQ, &reg1, &reg2);
		break;

		case CODE_EQ_STR:
			reg2.info.s = (*pcode++).s;
			reg2.type = PKT_STR;
			biOp(CODE_EQ, &reg1, &reg2);
		break;

		case CODE_EQ_REF:
			packetp = execStack[currBaseIdx-(*pcode++).i].info.p;
			reg2.info = packetp->info;
			reg2.type = packetp->type;
			biOp(CODE_EQ, &reg1, &reg2);
		break;

		case CODE_EQ_LIST:
			if (packetp = getlistitem(&pcode, currBaseIdx)) {
				reg1.info = execStack[stackExecIdx].info;
				reg1.type = execStack[stackExecIdx--].type;
				reg2.info = packetp->info;
				reg2.type = packetp->type;
				biOp(CODE_EQ, &reg1, &reg2);
			}
		break;

		case CODE_EQ_LISTC:
			reg2.info.i = getlistcount(&pcode, currBaseIdx);
			reg2.type = PKT_INT;
			biOp(CODE_EQ, &reg1, &reg2);
		break;

		case CODE_EQ_STACK:
			reg2.info = execStack[stackExecIdx].info;
			reg2.type = execStack[stackExecIdx].type;
			if (reg2.type == 4) {
				/* this is not efficient... should map
				 * PKT_OBJ type into biop.c */
				reg2.type = PKT_STR;
				reg2.info.s = GET_name(reg2.info.o);
			} if (reg2.type == 5) {
				reg2.type = reg2.info.p->type;
				reg2.info = reg2.info.p->info;
/*				dumpPacket(&reg2);
				printf("\n");
*/
			}
			biOp(CODE_EQ, &reg1, &reg2);
		break;

/* NE != */
		case CODE_NE_INT:
			reg2.info.i = (*pcode++).i;
			reg2.type = PKT_INT;
			biOp(CODE_NE, &reg1, &reg2);
		break;

		case CODE_NE_CHAR:
			reg2.info.c = (*pcode++).c;
			reg2.type = PKT_CHR;
			biOp(CODE_NE, &reg1, &reg2);
		break;

		case CODE_NE_FLOAT:
			reg2.info.f = (*pcode++).f;
			reg2.type = PKT_FLT;
			biOp(CODE_NE, &reg1, &reg2);
		break;

		case CODE_NE_STR:
			reg2.info.s = (*pcode++).s;
			reg2.type = PKT_STR;
			biOp(CODE_NE, &reg1, &reg2);
		break;

		case CODE_NE_REF:
			packetp = execStack[currBaseIdx-(*pcode++).i].info.p;
			reg2.info = packetp->info;
			reg2.type = packetp->type;
			biOp(CODE_NE, &reg1, &reg2);
		break;

		case CODE_NE_LIST:
			if (packetp = getlistitem(&pcode, currBaseIdx)) {
				reg1.info = execStack[stackExecIdx].info;
				reg1.type = execStack[stackExecIdx--].type;
				reg2.info = packetp->info;
				reg2.type = packetp->type;
				biOp(CODE_NE, &reg1, &reg2);
			}
		break;

		case CODE_NE_LISTC:
			reg2.info.i = getlistcount(&pcode, currBaseIdx);
			reg2.type = PKT_INT;
			biOp(CODE_NE, &reg1, &reg2);
		break;

		case CODE_NE_POP:
			reg2.info = reg1.info;
			reg2.type = reg1.type;
			reg1.info = execStack[stackExecIdx].info;
			reg1.type = execStack[stackExecIdx].type;
			--stackExecIdx;
			biOp(CODE_NE, &reg1, &reg2);
		break;

/* LT < */
		case CODE_LT_INT:
			reg2.info.i = (*pcode++).i;
			reg2.type = PKT_INT;
			biOp(CODE_LT, &reg1, &reg2);
		break;

		case CODE_LT_CHAR:
			reg2.info.c = (*pcode++).c;
			reg2.type = PKT_CHR;
			biOp(CODE_LT, &reg1, &reg2);
		break;

		case CODE_LT_FLOAT:
			reg2.info.f = (*pcode++).f;
			reg2.type = PKT_FLT;
			biOp(CODE_LT, &reg1, &reg2);
		break;

		case CODE_LT_STR:
			reg2.info.s = (*pcode++).s;
			reg2.type = PKT_STR;
			biOp(CODE_LT, &reg1, &reg2);
		break;

		case CODE_LT_REF:
			packetp = execStack[currBaseIdx-(*pcode++).i].info.p;
			reg2.info = packetp->info;
			reg2.type = packetp->type;
			biOp(CODE_LT, &reg1, &reg2);
		break;

		case CODE_LT_LIST:
			if (packetp = getlistitem(&pcode, currBaseIdx)) {
				reg1.info = execStack[stackExecIdx].info;
				reg1.type = execStack[stackExecIdx--].type;
				reg2.info = packetp->info;
				reg2.type = packetp->type;
				biOp(CODE_LT, &reg1, &reg2);
			}
		break;

		case CODE_LT_LISTC:
			reg2.info.i = getlistcount(&pcode, currBaseIdx);
			reg2.type = PKT_INT;
			biOp(CODE_LT, &reg1, &reg2);
		break;

		case CODE_LT_POP:
			reg2.info = reg1.info;
			reg2.type = reg1.type;
			reg1.info = execStack[stackExecIdx].info;
			reg1.type = execStack[stackExecIdx].type;
			--stackExecIdx;
			biOp(CODE_LT, &reg1, &reg2);
		break;

/* LE <= */
		case CODE_LE_INT:
			reg2.info.i = (*pcode++).i;
			reg2.type = PKT_INT;
			biOp(CODE_LE, &reg1, &reg2);
		break;

		case CODE_LE_CHAR:
			reg2.info.c = (*pcode++).c;
			reg2.type = PKT_CHR;
			biOp(CODE_LE, &reg1, &reg2);
		break;

		case CODE_LE_FLOAT:
			reg2.info.f = (*pcode++).f;
			reg2.type = PKT_FLT;
			biOp(CODE_LE, &reg1, &reg2);
		break;

		case CODE_LE_STR:
			reg2.info.s = (*pcode++).s;
			reg2.type = PKT_STR;
			biOp(CODE_LE, &reg1, &reg2);
		break;

		case CODE_LE_REF:
			packetp = execStack[currBaseIdx-(*pcode++).i].info.p;
			reg2.info = packetp->info;
			reg2.type = packetp->type;
			biOp(CODE_LE, &reg1, &reg2);
		break;

		case CODE_LE_LIST:
			if (packetp = getlistitem(&pcode, currBaseIdx)) {
				reg1.info = execStack[stackExecIdx].info;
				reg1.type = execStack[stackExecIdx--].type;
				reg2.info = packetp->info;
				reg2.type = packetp->type;
				biOp(CODE_LE, &reg1, &reg2);
			}
		break;

		case CODE_LE_LISTC:
			reg2.info.i = getlistcount(&pcode, currBaseIdx);
			reg2.type = PKT_INT;
			biOp(CODE_LE, &reg1, &reg2);
		break;

		case CODE_LE_POP:
			reg2.info = reg1.info;
			reg2.type = reg1.type;
			reg1.info = execStack[stackExecIdx].info;
			reg1.type = execStack[stackExecIdx].type;
			--stackExecIdx;
			biOp(CODE_LE, &reg1, &reg2);
		break;

/* GT > */
		case CODE_GT_INT:
			reg2.info.i = (*pcode++).i;
			reg2.type = PKT_INT;
			biOp(CODE_GT, &reg1, &reg2);
		break;

		case CODE_GT_CHAR:
			reg2.info.c = (*pcode++).c;
			reg2.type = PKT_CHR;
			biOp(CODE_GT, &reg1, &reg2);
		break;

		case CODE_GT_FLOAT:
			reg2.info.f = (*pcode++).f;
			reg2.type = PKT_FLT;
			biOp(CODE_GT, &reg1, &reg2);
		break;

		case CODE_GT_STR:
			reg2.info.s = (*pcode++).s;
			reg2.type = PKT_STR;
			biOp(CODE_GT, &reg1, &reg2);
		break;

		case CODE_GT_REF:
			packetp = execStack[currBaseIdx-(*pcode++).i].info.p;
			reg2.info = packetp->info;
			reg2.type = packetp->type;
			biOp(CODE_GT, &reg1, &reg2);
		break;

		case CODE_GT_LISTC:
			reg2.info.i = getlistcount(&pcode, currBaseIdx);
			reg2.type = PKT_INT;
			biOp(CODE_GT, &reg1, &reg2);
		break;

		case CODE_GT_LIST:
			if (packetp = getlistitem(&pcode, currBaseIdx)) {
				reg1.info = execStack[stackExecIdx].info;
				reg1.type = execStack[stackExecIdx--].type;
				reg2.info = packetp->info;
				reg2.type = packetp->type;
				biOp(CODE_GT, &reg1, &reg2);
			}
		break;

		case CODE_GT_POP:
			reg2.info = reg1.info;
			reg2.type = reg1.type;
			reg1.info = execStack[stackExecIdx].info;
			reg1.type = execStack[stackExecIdx].type;
			--stackExecIdx;
			biOp(CODE_GT, &reg1, &reg2);
		break;

/* GE >= */
		case CODE_GE_INT:
			reg2.info.i = (*pcode++).i;
			reg2.type = PKT_INT;
			biOp(CODE_GE, &reg1, &reg2);
		break;

		case CODE_GE_CHAR:
			reg2.info.c = (*pcode++).c;
			reg2.type = PKT_CHR;
			biOp(CODE_GE, &reg1, &reg2);
		break;

		case CODE_GE_FLOAT:
			reg2.info.f = (*pcode++).f;
			reg2.type = PKT_FLT;
			biOp(CODE_GE, &reg1, &reg2);
		break;

		case CODE_GE_STR:
			reg2.info.s = (*pcode++).s;
			reg2.type = PKT_STR;
			biOp(CODE_GE, &reg1, &reg2);
		break;

		case CODE_GE_REF:
			packetp = execStack[currBaseIdx-(*pcode++).i].info.p;
			reg2.info = packetp->info;
			reg2.type = packetp->type;
			biOp(CODE_GE, &reg1, &reg2);
		break;

		case CODE_GE_LISTC:
			reg2.info.i = getlistcount(&pcode, currBaseIdx);
			reg2.type = PKT_INT;
			biOp(CODE_GE, &reg1, &reg2);
		break;

		case CODE_GE_LIST:
			if (packetp = getlistitem(&pcode, currBaseIdx)) {
				reg1.info = execStack[stackExecIdx].info;
				reg1.type = execStack[stackExecIdx--].type;
				reg2.info = packetp->info;
				reg2.type = packetp->type;
				biOp(CODE_GE, &reg1, &reg2);
			}
		break;

		case CODE_GE_POP:
			reg2.info = reg1.info;
			reg2.type = reg1.type;
			reg1.info = execStack[stackExecIdx].info;
			reg1.type = execStack[stackExecIdx].type;
			--stackExecIdx;
			biOp(CODE_GE, &reg1, &reg2);
		break;

/* CALL */
		case CODE_CALL: {
			int save_stackExecIdx;
			int funcid, argc;

			funcid = (*pcode++).i;
			argc = (*pcode++).i;
/*
			fprintf(stderr, "%d\t%d (id)\n", funcid);
			fprintf(stderr, "%d\t%d (argc)\n", argc);
			fprintf(stderr, 
				">>1 base=%d, idx=%d, func=\"%s\" argc=%d\n",
				currBaseIdx, stackExecIdx, 
				(char*)getHashEntry(symID2Str, funcid)->val,
				argc);

*/
			stackBaseIdx = stackExecIdx;
			save_stackExecIdx = stackExecIdx - argc;

			/* XXX remember to optimize callMeth() */
			if (callMeth(self, &reg1, argc, 
				&execStack[stackExecIdx - argc + 1],
					funcid)) {

			} else if (entry = getHashEntry(objID2Obj, funcid)) {
/*
				printf("found object:%s...\n",
				       GET_name((VObj*)entry->val));
printf("before >>>>> self=%s\n", GET_name(self));
dumpVarList(GET__varList(self));
printf("<<<<<\n");
*/
				makeArgList((VObj*)entry->val, argc);
				execObjScript((VObj*)entry->val);
			} else {
				char fname[64], *oname;
				int length;

				oname = (char*)getHashEntry(symID2Str,
							    funcid)->val;
				strcpy(fname, oname);
				length = strlen(fname);
				if (length >= 2) {
					if (fname[length-2] != '.' ||
					    fname[length-1] != 'v')
						strcat(fname, ".v");
				}
/*
				fprintf(stderr, "accessing %s.\n", fname);
*/
				load_object(fname);
				if (entry = getHashEntry(objID2Obj, 
					storeIdent(oname))) {
/*					printf("!!found object:%s...\n",
					       GET_name((VObj*)entry->val));
*/
					makeArgList((VObj*)entry->val, argc);
					execObjScript((VObj*)entry->val);
				} else {
					fprintf(stderr,
						"obj=%s: unknown call: %s()\n",
						GET_name(self),
						(char*)getHashEntry(symID2Str,
							    funcid)->val);
				}
			}
			stackBaseIdx = currBaseIdx;
			stackExecIdx = save_stackExecIdx;
		} break;
/* BR */
		case CODE_BR:
			pcode += (*pcode).i;
			if (pcode > pcode_end) {
				fprintf(stderr, "seg fault.\n");
				return 0;
			}
		break;
/* BR_NZERO */
		case CODE_BR_NZERO:
			if (reg1.info.i) {
				pcode += (*pcode).i;
			} else {
				pcode++;
			}
			if (pcode > pcode_end) {
				fprintf(stderr, "seg fault.\n");
				return 0;
			}
		break;
/* BR_ZERO */
		case CODE_BR_ZERO:
			if (reg1.info.i) {
				pcode++;
			} else {
				pcode += (*pcode).i;
			}
			if (pcode > pcode_end) {
				fprintf(stderr, "seg fault.\n");
				return 0;
			}
		break;
/* MOVE_TO */
		case CODE_MOVTO_REF:
			packetp = execStack[currBaseIdx-(*pcode++).i].info.p;
			packetp->info = reg1.info;
/*
			switch (reg1.type) {
			case PKT_INT: packetp->info.i = reg1.info.i; break;
			case PKT_CHR: packetp->info.c = reg1.info.c; break;
			case PKT_FLT: packetp->info.f = reg1.info.f; break;
			case PKT_STR: packetp->info.s = reg1.info.s; break;
			case PKT_OBJ: packetp->info.o = reg1.info.o; break;
			case PKT_ATR: packetp->info.a = reg1.info.a; break;
			default:
				fprintf(stderr, 
					"%d\tid=%d UNKNOWN TYPE\n", 
					pcode - pcode_start - 1, *(pcode-1));
			break;
			}
*/
			packetp->type = reg1.type;
		break;

		case CODE_MOVTO_LIST:
			packetp = execStack[currBaseIdx-(*pcode++).i].info.p;
			i = reg1.info.i;
			attrp = scanAttr(&(packetp->info.a), i);
			if (!attrp) {
				/* make the new list node */
				attrp = makeAttr(i, (long)makePacket());
				prependAttr(&(packetp->info.a), attrp);
			}
			packetp = (Packet*)attrp->val;
			reg1.info = execStack[stackExecIdx].info;
			reg1.type = execStack[stackExecIdx--].type;
			packetp->info = reg1.info;
/*
			switch (reg1.type) {
			case PKT_INT: packetp->info.i = reg1.info.i; break;
			case PKT_CHR: packetp->info.c = reg1.info.c; break;
			case PKT_FLT: packetp->info.f = reg1.info.f; break;
			case PKT_STR: packetp->info.s = reg1.info.s; break;
			case PKT_OBJ: packetp->info.o = reg1.info.o; break;
			case PKT_ATR: packetp->info.a = reg1.info.a; break;
			default:
				fprintf(stderr, 
					"%d\tid=%d UNKNOWN TYPE\n", 
					pcode - pcode_start - 1, *(pcode-1));
			break;
			}
*/
			packetp->type = reg1.type;
		break;
/* POP */
		case CODE_POP:
			if (stackExecIdx > execStackSizeCheck) {
				if (!incrementExecStack()) return 0;
				fprintf(stderr,
				     "warning: execution stack overflowed.\n");
			} else {
				reg1.info = execStack[stackExecIdx].info;
				reg1.type = execStack[stackExecIdx].type;
				--stackExecIdx;
			}
		break;
/* PUSH */
		case CODE_PUSH:
			if (stackExecIdx > execStackSizeCheck) {
				if (!incrementExecStack()) return 0;
				fprintf(stderr,
				     "warning: execution stack overflowed.\n");
			} else {
				execStack[++stackExecIdx].info = reg1.info;
				execStack[stackExecIdx].type = reg1.type;
			}
/*
	printf("PUSH::: stackExecIdx=%d currBaseIdx=%d reg=%d\n",
		stackExecIdx, currBaseIdx, reg1.info.i);

	dumpStack();
*/
		break;
/* PUSH_REFP */
		case CODE_PUSH_REFP:
			if (stackExecIdx > execStackSizeCheck) {
				if (!incrementExecStack()) return 0;
				fprintf(stderr,
				     "warning: execution stack overflowed.\n");
			} else {

				Attr *varlist = GET__varList(self);
				int varID = (*pcode++).i;

				/* lookup to see if varID corresponds to
				 * some slot in this object.
				 * If so, make link to that instead of a 
				 * variable...?
				 */
/*???
	SlotInfo **sip;

	sip = GET_classInfo(self)->slookup;
	i = GET_classInfo(self)->totalcount;
	for (; i >= 0; i--) {
		if (sip[i]->id == varID) {
			printf("***** found slot \"%s\"\n", 
			     (char*)getHashEntry(symID2Str, sip[i]->id)->val);
		}
	}
*/
				if (attrp = scanAttr((&varlist), varID)) {
					packetp = (Packet*)attrp->val;
				} else {
					packetp = makePacket();
					prependAttr(&varlist, makeAttr(varID,
							(long)packetp));
					SET__varList(self, varlist);
				}
				execStack[++stackExecIdx].info.p = packetp;
				execStack[stackExecIdx].type = PKT_PKT;
				++currBaseIdx;
			}
		break;

		case CODE_RETURN:
			return &reg1;

		case CODE_BR_EQ:
		case CODE_BR_GE:
		case CODE_BR_GT:
		case CODE_BR_LE:
		case CODE_BR_LT:
		case CODE_BR_NE:
		case CODE_CMP:
		case CODE_GE:
		case CODE_GT:
		case CODE_LE:
		case CODE_LT:
		case CODE_NE:
		case CODE_LOAD:
		case CODE_STMTS:
			fprintf(stderr, 
				"pc=%d, unmplemented pcode=%d\n", 
				pcode - pcode_start - 1, (*(pcode - 1)).x);
		break;
		default:
			fprintf(stderr, 
				"pc=%d, unknown pcode=%d\n", 
				pcode - pcode_start - 1, (*(pcode - 1)).x);
		break;
		}
	}
	return &reg1;
}

Packet *execObjScript(obj)
	VObj *obj;
{
        union PCode *pcode = GET__script(obj);
	int pc_limit;

	if (pcode) {
		pc_limit = GET__scriptSize(obj);
	} else {
		extern AST *theAST;
		int size;

		yylineno = 0;
		yyscriptidx = 0;
		yyscript = GET_script(obj);
		yyobjcontext = GET_name(obj);
		yyscriptcontext = SCRIPT_ORIGIN_OBJ_SCRIPT;

		/* pass 1: build AST */
		clearASTStack();
        	if (yyparse()) return NULL;

/*		if (flag_printAST) printAST(theAST, 0);
*/
		/* collect identifiers and assign reference offset */
		pc_limit = 0;
		if (!assignReferences(theAST, pcode_buff, &pc_limit)) return 0;
		if (flag_printAST) printAST(theAST, 0);

		while (theAST) {
			codeGen(theAST, pcode_buff, &pc_limit);
			theAST = theAST->next;
		}
		size = sizeof(union PCode) * pc_limit;
		pcode = (union PCode*)malloc(size);
		bcopy(pcode_buff, pcode, size);
		SET__script(obj, pcode);
		SET__scriptSize(obj, pc_limit);
	}
	if (flag_printPCode) {
		int pc = 0;
		printPCode(pcode, &pc, pc_limit);
	}
	codeExec(obj, pcode, pcode, pcode + pc_limit);

	return &reg1;
}

Packet *execObjClassScript(obj, result)
	VObj *obj;
	Packet *result;
{
        union PCode *pcode = GET__classScript(obj);
	int pc_limit;

	if (pcode) {
		pc_limit = GET__classScriptSize(obj);
	} else {
		extern AST *theAST;
		int size;

		yylineno = 0;
		yyscriptidx = 0;
		yyscript = GET_classScript(obj);
		yyobjcontext = GET_name(obj);
		yyscriptcontext = SCRIPT_ORIGIN_CLASS_SCRIPT;

		/* pass 1: build AST */
		clearASTStack();
        	if (yyparse()) return NULL;

		if (flag_printAST) printAST(theAST, 0);

		/* collect identifiers and assign reference offset */
		pc_limit = 0;
		if (!assignReferences(theAST, pcode_buff, &pc_limit)) return 0;
		if (flag_printAST) printAST(theAST, 0);

		while (theAST) {
			codeGen(theAST, pcode_buff, &pc_limit);
			theAST = theAST->next;
		}
		size = sizeof(union PCode) * pc_limit;
		pcode = (union PCode*)malloc(size);
		bcopy(pcode_buff, pcode, size);
		SET__classScript(obj, pcode);
		SET__classScriptSize(obj, pc_limit);
	}
	if (flag_printPCode) {
		int pc = 0;
		printPCode(pcode, &pc, pc_limit);
	}
	codeExec(obj, pcode, pcode, pcode + pc_limit);
	copyPacket(result, &reg1);

	return result;
}

Packet *execScript(obj, result, script)
	VObj *obj;
	Packet *result;
	char *script;
{
	union PCode *pcode;
	int size, pc_limit;
	extern AST *theAST;

	yylineno = 0;
	yyscriptidx = 0;
	yyobjcontext = GET_name(obj);
	yyscriptcontext = SCRIPT_ORIGIN_TEMPORARY;
	yyscript = script;

	/* pass 1: build AST */
	clearASTStack();
       	if (yyparse()) return 0;

	if (flag_printAST) printAST(theAST, 0);

	/* collect identifiers and assign reference offset */
	pc_limit = 0;
	if (!assignReferences(theAST, pcode_buff, &pc_limit)) return 0;

	for (; theAST; theAST = theAST->next) 
		codeGen(theAST, pcode_buff, &pc_limit);

	size = sizeof(union PCode) * pc_limit;
	pcode = (union PCode*)malloc(size);
	bcopy(pcode_buff, pcode, size);

	if (flag_printPCode) {
		int pc = 0;
		printPCode(pcode, &pc, pc_limit);
	}
	codeExec(obj, pcode, pcode, pcode + pc_limit);
	copyPacket(result, &reg1);

	free(pcode);

	return result;
}

int sendMessagePackets(self, packets, packetc)
	VObj *self;
	Packet *packets;
	int packetc;
{
	int i;
	int save_stackExecIdx = stackExecIdx;
	int save_stackBaseIdx = stackBaseIdx;

	for (i = 0; i < packetc; i++) {
		execStack[++stackExecIdx].info = packets[i].info;
		execStack[stackExecIdx].type = packets[i].type;
	}
	makeArgList(self, packetc);

	stackBaseIdx = stackExecIdx;
	execObjScript(self);

	stackExecIdx = save_stackExecIdx;
	stackBaseIdx = save_stackBaseIdx;
	return 1;
}

int sendMessageAndInts(self, messg, intArray, intCount)
	VObj *self;
	char *messg;
	int *intArray;
	int intCount;
{
	int i;
	int save_stackExecIdx = stackExecIdx;
	int save_stackBaseIdx = stackBaseIdx;

	execStack[++stackExecIdx].info.s = messg;
	execStack[stackExecIdx].type = PKT_STR;
	for (i = 0; i < intCount; i++) {
		execStack[++stackExecIdx].info.i = intArray[i];
		execStack[stackExecIdx].type = PKT_INT;
	}
	makeArgList(self, intCount + 1);

	stackBaseIdx = stackExecIdx;
	execObjScript(self);

	stackExecIdx = save_stackExecIdx;
	stackBaseIdx = save_stackBaseIdx;
	return 1;
}

/* XXX macrolize later... */
int sendMessage1(self, messg)
	VObj *self;
	char *messg;
{
	int save_stackExecIdx = stackExecIdx;
	int save_stackBaseIdx = stackBaseIdx;

	execStack[++stackExecIdx].info.s = messg;
	execStack[stackExecIdx].type = PKT_STR;
	makeArgList(self, 1);

	stackBaseIdx = stackExecIdx;
	execObjScript(self);

	stackExecIdx = save_stackExecIdx;
	stackBaseIdx = save_stackBaseIdx;
	return 1;
}

int sendMessage1N1int(self, messg, a)
	VObj *self;
	char *messg;
	int a;
{
	int save_stackExecIdx = stackExecIdx;
	int save_stackBaseIdx = stackBaseIdx;

	execStack[++stackExecIdx].info.s = messg;
	execStack[stackExecIdx].type = PKT_STR;
	execStack[++stackExecIdx].info.i = a;
	execStack[stackExecIdx].type = PKT_INT;
	makeArgList(self, 2);

	stackBaseIdx = stackExecIdx;
	execObjScript(self);

	stackExecIdx = save_stackExecIdx;
	stackBaseIdx = save_stackBaseIdx;
	return 1;
}

int sendMessage1N2int(self, messg, a, b)
	VObj *self;
	char *messg;
	int a, b;
{
	int buff[2];

	buff[0] = a;
	buff[1] = b;
	return sendMessageAndInts(self, messg, buff, 2);
}

int sendMessage1N4int(self, messg, a, b, c, d)
	VObj *self;
	char *messg;
	int a, b, c, d;
{
	int buff[4];

	buff[0] = a;
	buff[1] = b;
	buff[2] = c;
	buff[3] = d;
	return sendMessageAndInts(self, messg, buff, 4);
}

int getVariable(varlist, name, retp)
	Attr *varlist;
	char *name;
	char **retp;
{
	HashEntry *entry;
	int varid;
	Packet *pk;

	/* note: if the identifier is not even in the dictionary, then no 
	 * such variable exists -- all variable IDs are entered into the dict
	 */
	if (entry = getHashEntry(symStr2ID, (long)name)) {
		varid = entry->val;
		for (; varlist; varlist = varlist->next) {
			pk = (Packet*)(varlist->val);
/*			printf("id=%d=\"%s\"\n", varlist->id, pk->info.s);*/
			if (varlist->id == varid) {
				*retp = saveString(pk->info.s);
				return 1;
			}
		}
	}
	return 0;
}

int setVariable(varlist, name, valp)
	Attr *varlist;
	char *name;
	char *valp;
{
	return 0;
}

int destroyVariable(varlist, name, retp)
	Attr *varlist;
	char *name;
{
	return 0;
}
