/*		Manage different file formats			HTFormat.c
**		=============================
**
** Bugs:
**	Not reentrant.
**
**	Assumes the incoming stream is ASCII, rather than a local file
**	format, and so ALWAYS converts from ASCII on non-ASCII machines.
**	Therefore, non-ASCII machines can't read local files.
*/

#include "HTUtils.h"
#include "tcp.h"
#include "HTFormat.h"

#include "HTML.h"
#include "HText.h"
#include "HTStyle.h"

extern HTStyleSheet * styleSheet;

/*	File buffering
**	--------------
**
**	The input file is read using the macro which can read from
**	a socket or a file.
**	The input buffer size, if large will give greater efficiency and
**	release the server faster, and if small will save space on PCs etc.
*/
#define INPUT_BUFFER_SIZE 4096		/* Tradeoff */
PRIVATE char input_buffer[INPUT_BUFFER_SIZE];
PRIVATE char * input_pointer;
PRIVATE char * input_limit;
PRIVATE int input_file_number;


/*	Set up the buffering
**
**	These routines are public because they are in fact needed by
**	many parsers, and on PCs and Macs we should not duplicate
**	the static buffer area.
*/
PUBLIC void HTInitInput ARGS1 (int,file_number)
{
    input_file_number = file_number;
    input_pointer = input_limit = input_buffer;
}


PUBLIC char HTGetChararcter NOARGS
{
    char ch;
    do {
	if (input_pointer >= input_limit) {
	    int status = NETREAD(
		    input_file_number, input_buffer, INPUT_BUFFER_SIZE);
	    if (status <= 0) {
		if (status == 0) return (char)EOF;
		if (TRACE) fprintf(stderr,
		    "HTFormat: File read error %d\n", status);
		return (char)EOF; /* -1 is returned by UCX at end of HTTP link */
	    }
	    input_pointer = input_buffer;
	    input_limit = input_buffer + status;
	}
	ch = *input_pointer++;
    } while (ch == (char) 13); /* Ignore ASCII carriage return */
    
    return FROMASCII(ch);
}

/*	Parse a file given format and file number
**	------------
*/
PUBLIC void HTParseFormat ARGS3(
	HTFormat,format,
	HTParentAnchor *,anchor,
	int,file_number)
{
/*	Parse the file
*/
	extern char *srcBuff;					/* PYW */
	extern int srcBuffi, srcBuffSize;			/* PYW */

#ifdef CURSES
      long    bytecount = 0;
#endif
    HTInitInput(file_number);

    srcBuffi = 0;						/* PYW */
    switch (format) {

    case WWW_HTML:		/* Parse HTML */
      {
        HTML_begin(anchor);
	SGML_begin(&HTML_dtd);
	for(;;) {
	    char character;
	    character = HTGetChararcter();
	    if (character == (char)EOF) break;
	    if (srcBuffi == srcBuffSize) srcBuffi = -1;		/* PYW */
	    if (srcBuffi >= 0) srcBuff[srcBuffi++] = character;	/* PYW */
#ifdef CURSES
              if (++bytecount % 1024 == 0) prompt_count(bytecount / 1024);
#endif
    
	    SGML_character(&HTML_dtd, character);           
         }
	SGML_end(&HTML_dtd);
      }
	break;

    case WWW_AU:
    case WWW_XBM:
    case WWW_XPM:
    case WWW_CSH:
    case WWW_VIOLA:
    case WWW_BINARY:	/* save data of unknown type in temp directory */
	{
        HText * text = HText_new(anchor);
	char *tempFile;
	FILE *fp;

	tempFile = tmpnam(NULL);
	fp = fopen(tempFile, "w");
	HText_setStyle(text, HTStyleNamed(styleSheet, "Example"));
	HText_beginAppend(text);
	if (fp) {
		char cc;
		int status;

		srcBuffi = strlen(tempFile);
		strcpy(srcBuff, tempFile);
		HText_appendText(text, "The returned data is saved in ");
		HText_appendText(text, tempFile);

		for(;;) {
			if (input_pointer >= input_limit) {
				status = NETREAD(input_file_number, 
					     input_buffer, INPUT_BUFFER_SIZE);
				if (status <= 0) {
					if (status < 0) {
						if (TRACE) fprintf(stderr,
				    "HTFormat: File read error %d\n", status);
					}
					break;
				}
				input_pointer = input_buffer;
				input_limit = input_buffer + status;
			}
			cc = *input_pointer++;
			fputc(cc, fp);
		}
		fclose(fp);
	} else {
		HText_appendText(text, 
		    "Tried but failed to save the returned data in ");
		HText_appendText(text, tempFile);
	}
        HText_endAppend(text);
	}     
	break;
    default :			/* unknown format -- Parse plain text */
      {
        HText * text = HText_new(anchor);
	HText_setStyle(text, HTStyleNamed(styleSheet, "Example"));
	HText_beginAppend(text);
	for(;;) {
	    char character;
	    character = HTGetChararcter();
	    if (character == (char)EOF) break;
	    if (srcBuffi == srcBuffSize) srcBuffi = -1;		/* PYW */
	    if (srcBuffi >= 0) srcBuff[srcBuffi++] = character;	/* PYW */
#ifdef CURSES
              if (++bytecount % 1024 == 0) prompt_count(bytecount / 1024);
#endif
	    HText_appendCharacter(text, character);           
	}
        HText_endAppend(text);
      }
	break;
	
    } /* end of switch (format) */

    if (srcBuffi == -1) {					/* PYW */
	fprintf(stderr, "HTML source cache overflowed (made invalid).\n");
	srcBuffi = 0;
	srcBuff[0] = '\0';
    } else {
	srcBuff[srcBuffi] = '\0';
    }
}
