\class {vpane}
\name {wais}
\parent {}
\children {wais.top wais.query wais.result}
\script {
	/* WAIS Search Front-end
	 * Author: Pei Y. Wei (wei@xcf.berkeley.edu)
	 */
	switch (arg[0]) {
	case "search":
		wais.TTY("search", arg[1]);
		send("wais.top.title", "setTitle", nthChar(arg[1], 0, 40), "...");
		return;
	break;
	case "dismiss":
		set("visible", 0);
		return;
	break;
	case "render":
		set("visible", 1);
		raise();
		if (get("window")) {
			windowName("ViolaWWW: WAISSearch Front-end");
			iconName("WAISSearch");
		}
		return;
	break;
	case "raise":
		raise();
		return;
	break;
	}
	usual();
}
\width {680}
\height {114}
\
\class {hpane}
\name {wais.top}
\parent {wais}
\children {wais.top.title wais.top.dismiss}
\maxHeight {22}
\
\class {XBMButton}
\name {wais.top.clone}
\parent {wais.top}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		send(get("parent"), "tear");
	break;
	}
	usual();
}
\label {#define tear_width 16
#define tear_height 16
static char tear_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0xfc, 0x0f, 0x0e, 0x0c, 0xfc, 0x0f, 0x0a, 0x0c,
   0xfc, 0x1f, 0x1a, 0x18, 0xf4, 0x3f, 0x3a, 0x70, 0xf4, 0xff, 0xea, 0x0f,
   0x54, 0x15, 0xaa, 0x0a, 0x54, 0x15, 0x00, 0x00};
}
\BDColor {grey20}
\BGColor {grey45}
\FGColor {white}
\
\class {txtLabel}
\name {wais.top.title}
\parent {wais.top}
\label {WAIS Search: (enter keyword below)}
\BDColor {grey20}
\BGColor {grey45}
\FGColor {white}
\font {bold_large}
\script {
	switch (arg[0]) {
	case "setTitle":
		set("label", concatenate("WAIS Search: ", arg[1]));
		render();
		return;
	break;
	}
	usual();
}
\
\class {txtButton}
\name {wais.top.dismiss}
\parent {wais.top}
\label {Dismiss}
\BDColor {white}
\BGColor {grey45}
\FGColor {white}
\maxWidth {100}
\font {normal}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		send("wais", "dismiss");
	break;
	}
	usual();
}
\
\class {hpane}
\name {wais.query}
\parent {wais}
\children {wais.query.label wais.query.tf wais.query.select}
\maxHeight {18}
\
\class {txtLabel}
\name {wais.query.label}
\parent {wais.query}
\label {Enter keywords:}
\BDColor {grey20}
\BGColor {grey45}
\FGColor {white}
\maxWidth {120}
\
\class {txtDisp}
\name {wais.query.tf}
\parent {wais.query}
\script	{
	switch (arg[0]) {
	case "keyPress":
		c = key();
		if (c == '\r') {
			wais.result.tf("clear");
/*
			wais.result.tf("busy");
			cursorShape("busy");
*/

/*			print("issue command:", currentLine(), "\n");*/
			send("wais", "search", currentLine());
			insert('\r');
			insert(c);

			if (cursorRow() != 0) {
				/* a kludgy safe guard to simulate
				 * carriage-return then ctrl-p 
				 */
				insert("\r\16\1");
			}
		} else {
			insert(c);
		}
		return;
	break;
	case "busy":
	case "idle":
		cursorShape(arg[0]);
		return;
	break;
	}
	usual();
}
\maxHeight {18}
\font {any}
\BDColor {grey20}
\BGColor {grey20}
\FGColor {white}
\
\class {txtButton}
\name {wais.query.select}
\parent {wais.query}
\label {Use Selected}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		wais("search", getSelection());
	break;
	}
	usual();
}
\BDColor {white}
\BGColor {grey45}
\FGColor {white}
\maxWidth {100}
\font {normal}
\
\class {hpane}
\name {wais.result}
\parent {wais}
\children {wais.result.sb wais.result.tf}
\
\class {slider}
\name {wais.result.sb}
\parent {wais.result}
\shownNotify {wais.result.tf}
\maxWidth {20}
\BDColor {grey99}
\BGColor {grey45}
\FGColor {grey80}
\
\class {txtDisp}
\name {wais.result.tf}
\parent {wais.result}
\shownDepend {wais.result.sb}
\script	{
	switch (arg[0]) {
	case "buttonRelease":
		if (isBlank(currentLine()) == 1) {
			bell();
		} else {
			if (index >= 0) deHighLight(index);
/*			index = lineRowOffset() + cursorRow();*/
			index = cursorRow();
			highLight(index);
			www("show", nthChar(currentLine(), 29, 999));
		}
		return;
	break;
	case "tip":
		insert('.');
		return;
	break;
	case "add":
		append(arg[1]);
		if (get("window")) render();
		return;
	break;
	case "replace":
		set("content", arg[1]);
		if (get("window")) render();
/*
		wais.query.tf("idle");
		cursorShape("idle");
*/
		return;
	break;
	case "clear":
		set("content", "");
		if (get("window")) render();
		return;
	break;
	case "keyPress":
		bell();
		return;
	break;
	case "enter":
		set("cursor", 0);
		return;
	break;
	case "busy":
	case "idle":
		cursorShape(arg[0]);
		return;
	break;
	case "init":
		index = -1;
	break;
	}
	usual();
}
\font {fixed}
\BGColor {LemonChiffon2}
\FGColor {black}
\BDColor {grey75}
\
\name {wais.TTY}
\class {TTY}
\path {/usr/local/bin/waissearch}
\args {-d /usr/work/viola/ht/projects/viola/index ' '}
\script {
/* \path {/usr/local/bin/waissearch}
 * \args {-d /net/moby/moby_c/wais/common/lib/indexes/wais-docs ' '}
 * \args {-d /net/swindle/usr/users/wei/dist/index ' '}
 */
	switch (arg[0]) {
	case "input":
		in = input();
		begin = findPattern(in, "'");
		if (begin != -1) {
			wais.result.tf("tip");

/*			score = int(nthChar(in, 12, 16));*/

			docScoreNSize = nthChar(in, 1, begin - 1);
			docStr = nthChar(in, begin, 999);

			middle = findPattern(docStr, "   ");

/*
			print("wais.tty: ", in, "\n");
			print("wais.tty: begin=", begin, " middle=", middle, 
				"\n");
*/

			docFile = nthChar(docStr, 1, middle - 3);
			docDir = nthChar(docStr, middle + 1, 999);
			docPath = concatenate(docDir, docFile, '\n');

/*			print("wais.tty: docScoreNSize ", docScoreNSize, "\n");
			print("wais.tty: docFile ``", docFile, "''\n");
			print("wais.tty: docDir  ``", docDir, "''\n");
			print("wais.tty: docPath >>", docPath, "<<\n");
*/
			docList = concatenate(docList, docScoreNSize, docPath);

		} else {
/*
			print("wais.tty:: ", get("inDelimStat"),
				" >>", in, "<<\n");
*/
			if (get("inDelimStat") == 2)
				if (findPattern(in, "[type 0 or") != -1) {

					wais.result.tf("replace", docList);
					docList = "";

					/* input triggered a inDelimStr2 
					 * match, which is where waissearch 
					 * waits for a doc#. However, we want
					 * to skip this query, and make it 
					 * accept new words, so, simulate 
					 * carriage return.
					 */
					output(""); 
				}
		}
		return;
	break;
	case "search":
		print("wais.tty: searching = [", arg[1], "]\n");
		output(arg[1]);
		return;
	break;
	case "init":
		initialize();
                set("inDelimStr1", "\n");
                set("inDelimStr2", "q to quit]: ");
                set("outDelimStr", "\n");
                startClient();
		docList = "";
		return;
	break;
	}
	usual();
}
