\name {ed_TE}
\class {vpane}
\parent {}
\lock {0}
\width {500}
\height {200}
\script {
	switch (arg[0]) {
	case "edit":
		/* arg[1] 	object name
		 * arg[2]	objeet attribute
		 */
		cloneID = cloneID + 1;
		new = clone(cloneID); 	/* ``fork off'' a clone editor */
		send(new, "editData", arg[1], arg[2]);
		return;
	break;
	case "editData":
		render();
		objectListSend("children", "edit", arg[1], arg[2]);
		return;
	break;
	case "apply":
		send(nthChild(1), arg[0]);
		render();
		windowName("Viola Attribute editor");
		return;
	break;
	case "cancel":
		set("visible", 0);  /* this crashses Xserver!*/
/*		destroy();*/
		return;
	break;
	case "insertSelection":
	case "selectEntireText":
	case "outputToFile":
	case "outputToPrinter":
	case "outputToStdout":
	case "showLineNumbers":
		send(nthChild(1), arg[0]);
	break;
	}
	usual();
}
\children {ed_TE.top ed_TE.work}
\
\name {ed_TE.top}
\class {hpane}
\parent {ed_TE}
\children {ed_TE.top.ops ed_TE.top.title ed_TE.top.apply ed_TE.top.cancel}
\script {
	switch (arg[0]) {
	case "apply":
	case "cancel":
		send(get("parent"), arg[0]);
		return;
	break;
	case "edit":
print(">>>>", arg[1], ",", arg[2], ".\n");
		send(nthChild(1), "title", arg[1], arg[2]);
		return;
	break;
	case "insertSelection":
	case "selectEntireText":
	case "outputToFile":
	case "outputToPrinter":
	case "outputToStdout":
	case "showLineNumbers":
		send(get("parent"), arg[0]);
		return;
	break;
	}
	usual();
}
\maxHeight {20}
\
\name {ed_TE.top.ops}
\class {menu}
\parent {ed_TE.top}
\lock {0}
\script {
	usual();
}
\menuConfig {
. {Insert selection buffer}	{send(get("parent"), "insertSelection");}
. {Select entire text}		{send(get("parent"), "selectEntireText");}
. {#Show line numbers}		{send(get("parent"), "showLineNumbers");}
. {Output to file}		{send(get("parent"), "outputToFile");
. {Output to printer}		{send(get("parent"), "outputToPrinter");
. {Output to stdout}		{send(get("parent"), "outputToStdout");
}
\font {normal}
\maxWidth {30}
\BDColor {white}
\BGColor {grey45}
\FGColor {white}
\
\name {ed_TE.top.title}
\class {txtLabel}
\parent {ed_TE.top}
\lock {0}
\script {
	switch (arg[0]) {
	case "title":
print(">>>>>>>>", arg[1], ",", arg[2], ".\n");
		set("label", concatenate(arg[1], ", ", arg[2]));
		return;
	break;
	}
	usual();
}
\font {normal}
\BDColor {white}
\BGColor {grey45}
\FGColor {white}
\
\name {ed_TE.top.apply}
\class {txtButton}
\parent {ed_TE.top}
\label {Apply}
\lock {0}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		send(get("parent"), "apply");
	break;
	}
	usual();
}
\font {normal}
\BDColor {white}
\BGColor {grey45}
\FGColor {white}
\maxWidth {70}
\
\name {ed_TE.top.cancel}
\class {txtButton}
\parent {ed_TE.top}
\lock {0}
\label {Cancel}
\script {
	switch (arg[0]) {
	case "buttonRelease":
		send(get("parent"), "cancel");
	break;
	}
	usual();
}
\font {normal}
\BDColor {white}
\BGColor {grey45}
\FGColor {100 75 75}
\maxWidth {70}
\
\name {ed_TE.work}
\class {hpane}
\parent {ed_TE}
\script {
	switch (arg[0]) {
	case "apply":
	case "insertSelection":
	case "selectEntireText":
	case "outputToFile":
	case "outputToPrinter":
	case "outputToStdout":
		send(nthChild(1), arg[0]);
		return;
	break;
	case "edit":
		send(nthChild(1), "edit", arg[1], arg[2]);
		return;
	break;
	case "showLineNumbers":
		return;
	break;
	}
	usual();
}
\lock {0}
\children {ed_TE.work.sb ed_TE.work.tf}
\
\name {ed_TE.work.sb}
\class {slider}
\parent {ed_TE.work}
\lock {0}
\BDColor {grey99}
\BGColor {grey45}
\FGColor {grey70}
\shownNotify {ed_TE.work.tf}
\maxWidth {15}
\
\name {ed_TE.work.tf}
\parent {ed_TE.work}
\lock {0}
\class {txtDisp}
\script {
	switch (arg[0]) {
	case "apply":
		setSelection(get("content"));
/*		print("*** 1apply: data=", get("content"), "\n");*/
/*		print("*** 2apply: data=", getSelection(), "\n");*/
		tweak(dataSource, concatenate("set(\"", dataAttr, "\", 
						getSelection());"));
		send(dataSource, "render");
		return;
	break;
	case "edit":
		dataSource = arg[1];
		dataAttr = arg[2];
		cc = tweak(arg[1], concatenate("get(\"", dataAttr, "\");"));
/*		print("*** obj=", dataSource, "\n");
		print("*** attr=", dataAttr, "\n");
		print("*** data=", cc, "\n");
*/
		set("content", tweak(dataSource, 
				concatenate("get(\"", dataAttr, "\");")));
		render();
		return;
	break;
	case "insertSelection":
		insert(getSelection());
		return;
	break;
	case "selectEntireText":
		setSelection(get("content"));
		return;
	break;
	case "outputToFile":
		tempFile = makeTempFile();
		print("content saved to file: ", tempFile, "\n");
		saveFile(tempFile, get("content"));
		return;
	break;
	case "outputToPrinter":
		tempFile = makeTempFile();
		saveFile(tempFile, get("content"));
		system(concatenate("lpr ", tempFile));
		return;
	break;
	case "outputToStdout":
		print(get("content"), "\n");
		return;
	break;
	}
	usual();
}
\shownDepend {ed_TE.work.sb}
\font {fixed}
\BGColor {grey24}
\FGColor {cyan1}
\BDColor {black}
\verbatim {1}
\














