#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <ctype.h>

char *ThesLookUp(char *search,char *type,char *file);

static char* prgname;

int main(int argc, char *argv[])
{
char  *ThesRC;
/* initialisation for testing purposes: */
char  *SearchData = "ebu bmw image laber test TEST";
char  *TypeData = "AB af uf Xx Yy Zz";
char  *ThesData = "thes.dat";

  prgname=argv[0];
  if(argc<4){
    fprintf(stderr,"Usage: %s <searchstr> <relstr> <thesfile>\n",prgname);
    fprintf(stderr,"\twhere <searchstr> is a \\n separated list of words,\n");
    fprintf(stderr,"\t<relstr> is a blank separated list of relations,\n");
    fprintf(stderr,"\tand <thesfile> is the name of the thesaurus file.\n");
    exit(-1);
  }   
 
  if (argc >= 2)
    SearchData = argv[1];
  if (argc >= 3)
    TypeData = argv[2];
  if (argc >= 4)
    ThesData = argv[3];

/*
  printf("Search:[%s]\nType: [%s]\nFile : [%s]\n",SearchData,TypeData,ThesData);
*/

  ThesRC = ThesLookUp(SearchData, TypeData, ThesData);

  if (ThesRC)
    printf("%s", ThesRC);
}

/*
 * Thesaurus
 */

#define MAXRETLEN 16384 /* Max. length of output */
#define MAXSEARCH 50    /* Max. number of search terms in input */
#define MAXRELSTR 50    /* Max. number of relation identifiers in input */

char  *ThesLookUp(char *search, char *type, char *file)
{
static char  *outstr=NULL;
char   sterms[MAXSEARCH][256];
char   rterms[MAXRELSTR][3];
int    numS, numT, found = 0, a, b;
FILE   *thesfile;
char   buf[256];
char   buf2[256];
char   *p, *q;

  /* if called for the first time, initialise outstr */
  if(outstr==NULL){
    outstr=malloc(MAXRETLEN);
    if(outstr==NULL){
      fprintf(stderr, "%s: can't malloc() outstr\n",prgname);
      return (outstr);
    }
  }

  /* Open Thesaurus Data File */
  if (!(thesfile = fopen(file, "r"))) {
    fprintf(stderr, "%s: can't open %s for reading\n",prgname,file);
    return (NULL);
  }
  /* Unpack Searchstring */
  assert(strlen(search)<MAXRETLEN);
  strcpy(outstr, search);
  numS=0;
  p=outstr;
  while(*p) {
    for(; *p && isspace(*p); p++); /* skip blank */
    q = p;
    for(; *p && !isspace(*p); p++); /* skip over word */
    if(*p) *p++ = '\0';
    if(numS>MAXSEARCH-1){
      fprintf(stderr,"%s: max. number of search terms exceeded\n",prgname);
      break;
    }
    if(*q) strcpy(sterms[numS++], q);
    else break;
  }
  numS--;

  /* Unpack Typestring */
  assert(strlen(type)<MAXRETLEN);
  strcpy(outstr, type);
  numT=0;
  p=outstr;
  while(*p) {
    for(; *p && isspace(*p); p++); /* skip blank */
    q = p;
    for(; *p && !isspace(*p); p++); /* skip over word */
    if(*p) *p++ = '\0';
    if(numT>MAXRELSTR-1){
      fprintf(stderr,"%s: max. number of relations exceeded\n",prgname);
      break;
    }
    if(*q) strcpy(rterms[numT++], q);
    else break;
  }
  numT--;

  /* Search in Thesaurus File */
  strcpy(outstr, "");
  while (fgets(buf, 256, thesfile)) {
    char *term1, *relterm, *term2, *p;
    buf[strlen(buf)-1] = '\0'; /* delete the '\n' */
    term1 = buf;
    for (;;) {
      if (!(fgets(buf2, 256, thesfile)))
	      break;
      
      buf2[strlen(buf2)-1] = '\0'; /* delete the '\n' */
      for(p=buf2;*p && isspace(*p);p++); 
      if( !*p )break;
      relterm=p;
      for(;*p && !isspace(*p);p++); /* skip past word */
      *p='\0'; 

      for(++p;*p && isspace(*p);p++);
      if( !*p )break;
      term2=p;

      for (a = 0; a <= numS; a++) {
	      if (!strcasecmp(sterms[a],term1)) {
	        for (b = 0; b <= numT; b++) {
	          if (!strcasecmp(rterms[b], relterm)) {
	            found++;
	            strcat(outstr, term2);
	            strcat(outstr, "\n");
	            break;
	          }
	        }
	      }
      }
    }
  }

  fclose(thesfile); 
  return (found?outstr:NULL);
}
