/*
 *  evaluate-expr.c - boolean operations on paths // Nov 23 93
 *  
 *  (C) Stefanie Hoefling (hoefling@igd.fhg.de),
 *      Christian Neuss (neuss@igd.fhg.de)
 *      Fraunhofer IGD 
 *  
 *  arguments:
 *  arg1 = string consisting of '&' and '+' that describes the boolean
 *         operations to perform
 *  
 *  This program computes which files contain words according
 *  to a boolean expression like "term1 and term 2 or term3".
 *  The program expects via standard input a sorted list of paths, 
 *  term numbers (starting with one), and word frequencies, sorted
 *  by path in alphabetical order (actually, they do not have to be
 *  sorted, but must appear as clusters).
 *  Here's a valid example:
 *      "/usr/foo/bar 1 29"
 *      "/usr/foo/bar 3 12"
 *      "/usr/foo/txt 1 965"
 *  output is path and frequencies of all terms that for which the
 *  condition specified holds.
 *
 */
 
#include <stdio.h>
#include <stdlib.h>
#include <strings.h> 
#include <assert.h>
#include <ctype.h> 
#include <sys/param.h> /* MAXPATHLEN */

/* to do: check arguments, better err. h. */

#define MAXEXPR 512 

#ifdef EBUG
#  define dprintf fprintf
#else
#  define dprintf if(0)fprintf
#endif

int readline( int *num, char path[], int *freq);
int boolcompute( char expr[], char terms[] );

int main(int argc, char *argv[])
{
  char path[MAXPATHLEN], lastpath[MAXPATHLEN];
	char expr[MAXEXPR], buf[MAXEXPR];
  int number, freq, relevance=0;

  if(argc!=2){
    dprintf(stderr,"Usage: %s <Boolean expression>\n",argv[0]);
    return 1;
  }
 
  strcpy(expr,argv[1]);
	dprintf(stderr,"expression: '%s'\n", expr);
	
assert(strlen(expr)<MAXEXPR); /* XXX */

  for(;;) {
    static char isfirst=1;
	  int i;
		if( readline( &number, path, &freq)) {
		  if( !isfirst ){
		    /* end of _very_ last path sequence => now evaluate expression */
			  buf[strlen(expr)+1]='\0';
			  if( boolcompute(expr,buf)) {
          printf("%s:%d\n",lastpath,relevance);
			  } 
      }
      return 1;
    }
		if(!isfirst && strcmp(path,lastpath)){
      /* end of last path sequence => now evaluate expression */
			buf[strlen(expr)+1]='\0';
			if( boolcompute(expr,buf)) {
        printf("%s:%d\n",lastpath,relevance);
			} 
		}
		relevance += freq;
		if(isfirst || strcmp(path,lastpath)){
		  /* beginning of new path sequence */
			relevance = freq;
			for(i=0;i<MAXEXPR;i++) buf[i]='0';
			if(number>MAXEXPR) {
			  dprintf(stderr,	"%s: Too many search terms.\n",argv[0]);
			}
    }
		buf[number-1]='1';
    strcpy(lastpath,path);
		isfirst = 0;
  }	

}

int readline( int *num, char path[], int *freq)
{
  char *p, tmpbuf[MAXPATHLEN+128];
  p=gets(tmpbuf);
  if(p==NULL) return 1;
  p=strtok(tmpbuf," \t");
  if(p==NULL) return 1;
  strcpy(path,p);
  p=strtok(NULL," \t");
  *num=atoi(p);\
  p=strtok(NULL," \t");
  *freq=atoi(p);\
  dprintf(stderr,"readline: %s %d %d\n",path,*num,*freq);
  return 0;
}

int boolcompute( char oper[], char terms[] )
{
  char t1, t2;
	int i, result=0;
dprintf(stderr,"boolcompute [%s] [%s] ", oper, terms);
  if(terms[1]=='\0') return 1;
	t1 = terms[0]-'0'; 
  for(i=0; terms[i+1]; i++){
assert(oper[i]);
    t2=terms[i+1]-'0';
    switch(oper[i]){
		  case '+' : 
		    if( t1 ) {
					dprintf(stderr," return %d\n", t1);
				  return 1;
				}
		  	t1 = t2;
		  	break;
		  case '&' :
		    t1 *= t2;
			  break;
		  default :
		    assert(0);
	  }
	}
	dprintf(stderr," return %d\n", t1);
	return t1;
}