/*	$Header: /usr/people/sam/fax/contrib/faxview/RCS/ImageView.h,v 1.12 93/09/15 16:29:04 sam Exp $
/*
 * Copyright (c) 1990, 1991, 1992, 1993 Sam Leffler
 * Copyright (c) 1991, 1992, 1993 Silicon Graphics, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Sam Leffler and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Sam Leffler and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 * IN NO EVENT SHALL SAM LEFFLER OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */
#ifndef	_ImageView_
#define	_ImageView_

#include "Types.h"
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>

class Bitmap;
typedef	unsigned int Contrast;

class ImageView {
public:
    enum {
	EXP50,
	EXP60,
	EXP70,
	EXP80,
	EXP90,
	EXP,
	LINEAR,
    };
private:
    u_int	width;
    u_int	height;
    float	dispResolution;		// display resolution used
    fxBool	haveImage;		// true if an image is setup
    fxBool	needCmap;		// true if a new colormap is needed
    fxBool	putImage;		// update image in server
    fxBool	isopen;			// view has been opened
    Contrast	contrast;		// current contrast
    u_short	photometric;		// current photometric of raster
    u_short	filterHeight;		// filter height in rows
    u_short	stepSrcWidth;		// src image stepping width
    u_short	stepDstWidth;		// dest stepping width
    u_char**	bitstep0;		// horizontal bit stepping (1st byte)
    u_char**	bitstep1;		// horizontal bit stepping (2nd byte)
    u_short*	rowoff;			// row offset for stepping
    u_char*	raster;			// displayed raster
    XImage*	ximage;			// X-style image descriptor
    Widget	widget;
    u_char	cmap[32];		// colormap indexes
    Pixmap	xImagePixmap;
    GC		xWinGc;

    void whiterow(u_char* row);
    void setupStepTables(u_short sw);
    void setupCmap();
    void setupCmap(u_int n, u_short base);

    void setrow1(u_char* row, u_char* cm, u_char* rows[]);
    void setrow2(u_char* row, u_char* cm, u_char* rows[]);
    void setrow3(u_char* row, u_char* cm, u_char* rows[]);
    void setrow4(u_char* row, u_char* cm, u_char* rows[]);
public:
    ImageView(fxBool forceSmall, Widget);
    virtual ~ImageView();

    void open();
    fxBool isOpened() const;
    void update();			// complete repaint
    void expose(XEvent*);		// expose event repair

    void setImage(const Bitmap&, float vres, fxBool doUpdate = TRUE);
    void setPhotometric(u_short, fxBool doUpdate = TRUE);
    void setContrast(Contrast, fxBool doUpdate = TRUE);

    void flip(fxBool doUpdate = TRUE);
    void reverse(fxBool doUpdate = TRUE);
};
inline fxBool ImageView::isOpened() const { return isopen; }
#endif
