PROGRAM DropKick;
USES WinTypes, WinProcs, OWindows, WinDos, ODialogs, OStdDlgs,
	ShellApi, Win31, BWCC, Strings ,OWLCmDlg, CommDlg;

{$R DropKick}
{$D Copyright (c) 1993 by Devin Cook}
{$I DROPKICK.INC}
{$M 16000 , 8192}

{  DropKick Version 1.0 - By Devin Cook (MSD!)                     }
{  If you have any questions or suggestions of even improvements   }
{  email me at dsc@u.washington.edu                                }

{ P.S.  It requires BWCC.DLL }

Var
	INST_NUM : Integer ;

Const

	RUN_NORMAL   =  1 ;
  RUN_ICONED   =  2 ;
  RUN_MAXED    =  3 ;

  DKFileFilter = 'Drop Kick batch files'#0'*.dk'#0#0;
  DKEXEFilter  = 'Executable Files'#0'*.exe;*.bat;*.com;*.pif'#0#0;
  DKICOFilter  = 'Icon files'#0'*.ico;*.dll;*.exe'#0#0;

Type
  DropKick_Record = Record
                      FileName : String[65] ;
                      Directory: String[65] ;
                      Params   : String[65] ;
                      Abortflag: Word ;
                      Waitflag: Word ;
                      RUN_MODE: Byte ;
                    End;

  Setup_Record    = Record
                      Wait_For_File  : Word ;
                      Repeat_Wait    : Word ;
                      Serial_Files   : Word ;
                      Parallel_Files : Word ;
                    End;


  DropKick_Array =  Array[1..6] of DropKick_Record ;

  DropKick_Setup =  Record
											DK_Array : DropKick_Array;
											Setup    : Setup_Record ;
											IFILE    : String ;
                      INUM     : Word ;
                      TITLE    : String ;
                    End;

  DropKick_File  =  File of DropKick_Setup ;

CONST
  AppName : PChar = 'DropKick';

  Blank_DK_Record : Dropkick_Record = ( FileName : '' ;
    Directory : '' ; Params : '' ; AbortFlag : 1 ; WaitFlag : 1 ; RUN_MODE : RUN_NORMAL );


TYPE

  TMyApplication = OBJECT(TApplication)
    PROCEDURE InitMainWindow; virtual;
  END;

  PButtMan = ^TButtMan ;
  TButtMan = Object( TButton )
               Function GetClassName : PChar ;
                 Virtual;
             End;

  PBorStatic = ^TBorStatic ;
  TBorStatic = Object( TStatic )
               Function GetClassName : PChar ;
                 Virtual;
             End;

  PICON =  ^TICON ;
	TICON =  Object( TStatic )
						 Exe_Name : ^String ;
						 Icon_Index : Integer ;
             CONSTRUCTOR Init(AParent: PWindowsObject; AnId: Integer; X,Y,W,H: Integer);
             PROCEDURE WMPAINT( Var MSG : TMessage );
               Virtual wm_First + wm_Paint;
             PROCEDURE PAINT(pDC : hDC ; Var PS : TPaintStruct);
               Virtual;
           End;

  PFILESETTING_DLG = ^TFILESETTING_DLG ;
  TFILESETTING_DLG =	Object( TDialog )
    XFER	:  Record
                      FileName : Array[0..64] of Char ;
                      WorkDir  : Array[0..64] of Char ;
                      Params   : Array[0..64] of Char ;
                      ErrFlag  : Word ;
                      WaitFlag  : Word ;
                      RUN_NORM  : Word ;
                      RUN_ICON  : Word ;
                      RUN_MAX   : Word ;
            End;
    PROCEDURE Clear(Var Msg: TMessage);
      Virtual id_First + ID_CLEAR;
    PROCEDURE Browse(Var Msg: TMessage);
      Virtual id_First + ID_BROWSE;
  End;

  PFILEUPDATE_DLG = ^TFILEUPDATE_DLG ;
  TFILEUPDATE_DLG =	Object( TDialog )
    PROCEDURE SendNo(Var Msg: TMessage);
      Virtual id_first + IDNO;
  End;

  PDropKickWin = ^TDropKickWin;
	TDropKickWin = OBJECT(TWindow)
		XFER   : Record
							 TITLE  : Array[0..64] of Char;
               FNAMES : Array[1..7] of Array[0..12] of Char ;
               Setup  : Setup_Record ;
             End;

    APP_ICON   : PIcon ;
    My_ICON    : HIcon ;

    CONSTRUCTOR Init(AParent : PWindowsObject; AName : PChar);
    PROCEDURE SetUpWindow; Virtual;
    PROCEDURE UpdateFileNames;
    DESTRUCTOR Done; Virtual;
    FUNCTION GetClassName : PChar; Virtual;
    PROCEDURE GetWindowClass(VAR AWndClass: TWndClass);
      Virtual;
    PROCEDURE Browse_ICon(Var Msg: TMessage);
      Virtual id_First + ID_ICON ;
    PROCEDURE idHelp(VAR Msg : TMessage);
      Virtual id_First + idHelp;
    PROCEDURE wmCommand(VAR Msg : TMessage);
      Virtual wm_First + wm_Command;
    PROCEDURE wmDrawItem(VAR Msg : TMessage);
      Virtual wm_First + wm_DrawItem;
    PROCEDURE wmQueryOpen(VAR Msg : TMessage);
      Virtual wm_First + wm_QueryOpen;
    PROCEDURE Edit_Dlg(Var Msg: TMessage ; N : Integer );
    PROCEDURE Edit_1(Var Msg: TMessage);
      Virtual id_First + ID_BTN1;
    PROCEDURE Edit_2(Var Msg: TMessage);
      Virtual id_First + ID_BTN2;
    PROCEDURE Edit_3(Var Msg: TMessage);
      Virtual id_First + ID_BTN3;
    PROCEDURE Edit_4(Var Msg: TMessage);
			Virtual id_First + ID_BTN4;
		PROCEDURE Edit_5(Var Msg: TMessage);
			Virtual id_First + ID_BTN5;
    PROCEDURE Edit_6(Var Msg: TMessage);
      Virtual id_First + ID_BTN6;
    PROCEDURE UP_PRESSED( N : Integer );
    PROCEDURE DN_PRESSED( N : Integer );
    PROCEDURE Load(Var Msg: TMessage);
      Virtual id_First + ID_LOAD;
    PROCEDURE Save(Var Msg: TMessage);
      Virtual id_First + ID_SAVE;
    PROCEDURE OK(Var Msg: TMessage);
      Virtual id_First + ID_OK;
    FUNCTION  Do_Save : Boolean ;
    FUNCTION  CanClose:Boolean;
      Virtual ;
    FUNCTION  Run_Step( RunRec : DropKick_Record ; S : PChar ): Boolean ;
    PROCEDURE AWaken( S : PChar );
    PROCEDURE ActuallyRunIt;
    PROCEDURE RUN_Pressed(Var Msg: TMessage);
      Virtual id_First + ID_RUN;
    PROCEDURE wmDropFiles(VAR Msg : TMessage);
      Virtual wm_First + wm_DropFiles;
    PROCEDURE DefWndProc(Var MSG : TMessage);
      Virtual ;
  END;


Var
  MyApp: TMyApplication;
  The_Setup : DropKick_Setup ;
  Original  : DropKick_Setup ;
  DropFileName : Array[0..256] of Char ;
  RunStep  : Integer ;
  LEAVE_NOW  : BOOLEAN ;
	QUIT_WHEN_FINISHED : BOOLEAN ;

Function FileExists( Filename : String ) : Boolean ;
Var
	f	:	File;
Begin
	{$I-}
	Assign(f, FileName);
	Reset(f);
	Close(f);
	{$I+}
	FileExists := (IOResult = 0) and (FileName <> '');
end;

  Function File_Has_Changed : Boolean ;
  Var
     X : Integer ;
  Begin
    File_Has_Changed := False ;

    For X := 1 to 6 do
      If (The_Setup.DK_Array[X].FileName<>Original.DK_Array[X].FileName) or
         (The_Setup.DK_Array[X].Directory<>Original.DK_Array[X].Directory) or
         (The_Setup.DK_Array[X].Params<>Original.DK_Array[X].Params) or
         (The_Setup.DK_Array[X].AbortFlag<>Original.DK_Array[X].AbortFlag) or
         (The_Setup.DK_Array[X].WaitFlag<>Original.DK_Array[X].WaitFlag) or
         (The_Setup.DK_Array[X].Run_Mode<>Original.DK_Array[X].Run_Mode) then
             File_Has_Changed := TRUE ;

    If (The_Setup.Setup.Wait_For_File<>Original.Setup.Wait_For_File) or
       (The_Setup.Setup.Repeat_Wait<>Original.Setup.Repeat_Wait) or
       (The_Setup.Setup.Serial_Files<>Original.Setup.Serial_Files) or
       (The_Setup.Setup.Parallel_Files<>Original.Setup.Parallel_Files) then
          File_Has_Changed := TRUE ;

    If (The_Setup.IFILE<>Original.IFILE) or
			 (The_Setup.INUM<>Original.INUM) or
			 (The_Setup.TITLE<>Original.TITLE) Then
          File_Has_Changed := TRUE ;
  End;

Procedure Debug_Msg(S : String );
Var
	SA	:	Array[0..255] of Char ;
Begin
	strPCopy( SA , S );
	MessageBox( 0, SA,'Debug',MB_OK+MB_IconInformation);
End;

Procedure Debug_Val(S : String ; V : Integer );
Var
	SA  :	Array[0..255] of Char ;
	SS  :	String ;
Begin
	Str(V,SS);
	SS := S+' '+SS ;
	strPCopy( SA , SS );
	MessageBox( 0, SA,'Debug',MB_OK+MB_IconInformation);
End;

Function Max_Icon( S : String ) : Integer ;
Var
  PC : Array[0..256] of Char ;
  I  : HIcon ;
Begin
  StrPCopy( PC , S );
  I := ExtractIcon( 0 , PC , $FFFF )-1;

  If I<0 then I := 0 ;

  Max_Icon := I ;
End;

  PROCEDURE TFileUpdate_Dlg.SendNo(VAR Msg : TMessage);
  Begin
    EndDlg(idNO);
  End;

  PROCEDURE TFileSetting_Dlg.Clear(VAR Msg : TMessage);
  Begin
    XFER.FileName[0] := #0 ;
    XFER.WorkDir[0]  := #0 ;
    XFER.Params[0] := #0 ;
    XFER.ErrFlag := 1 ;
    TRANSFERDATA( tf_SetData );
  End;

  Procedure TFileSetting_Dlg.Browse(VAR Msg : TMessage);
  Var
    A_File : Array[0..fsPathName] of Char;
    STR1    : Array[0..256] of Char ;
    Dir: array[0..fsDirectory] of Char;
    Name: array[0..fsFileName] of Char;
    Ext: array[0..fsExtension] of Char;
  Begin
    If Application^.ExecDialog(New(PCDFileOpen,
       Init(@Self, ofn_FileMustExist, XFER.FileName, SizeOf(XFER.FileName), DKEXEFilter))) = id_Ok then
    Begin
      FileExpand( STR1 , XFER.FileName );
      StrCopy( XFER.FileName , STR1 );
      FileSplit(STR1, Dir, Name, Ext);
      StrCopy( XFER.WorkDir , Dir );
      TRANSFERDATA( tf_SetData );
    End;
  End;

	CONSTRUCTOR TDropKickWin.Init(AParent : PWindowsObject; AName : PChar);
	Var
    P : PControl ;
    X : Integer ;
    PC: PChar ;
    DC: HDc ;
    TM: TTextMetric;
    W : Integer ;
    H : Integer ;
  Begin
    TWindow.Init(AParent,'Drop Kick Batch File Builder');
    With Attr do
    Begin
      X := 150 ;
      Y := 10 ;
      W := 270 ;
      H := 470 ;
    End;

    DC := GetDC(HWindow);
    If GetTextMetrics(DC,TM)=False then
       Halt;

    W := LoWord(GetTextExtent(DC,'WWWWWWWW.WWW',13));
    H := Tm.tmHeight;

    Attr.W := 158 + W ;

    P := New(PBDivider, Init(@Self, -1, '', 10 , 8 , 137+W , 360 , TRUE , TRUE ));
    P^.Attr.Style := BSS_GROUP OR BSS_LEFT OR WS_CHILD OR WS_VISIBLE ;

    Attr.Style := Attr.Style AND Not( WS_MAXIMIZEBOX OR WS_MINIMIZEBOX OR WS_SIZEBOX );

    TransferBuffer := @XFER;

		XFER.SETUP := The_Setup.Setup ;
		STRPCOPY(XFER.TITLE,The_Setup.Title);

	 P := New(PBorStatic,   Init(@SELF, ID_TITLE, '&TITLE', 26, 226, LoWord(GetTextExtent(DC,'TITLE',5)), H , 6));
    P := New(PEdit, Init(@SELF, ID_TITLE , 'Title', 80, 220, W, H+12, 65 , False ));
    P^.EnableTransfer;

    P := New(PBorStatic,   Init(@SELF, ID_FILESTR1 , '' ,128, 22,  W, H, 13 ));
    P^.EnableTransfer;
    P := New(PBorStatic,   Init(@SELF, ID_FILESTR2 , '' ,128, 56,  W, H, 13 ));
    P^.EnableTransfer;
    P := New(PBorStatic,   Init(@SELF, ID_FILESTR3 , '' ,128, 90,  W, H, 13 ));
    P^.EnableTransfer;
    P := New(PBorStatic,   Init(@SELF, ID_FILESTR4 , '' ,128, 124, W, H, 13 ));
    P^.EnableTransfer;
    P := New(PBorStatic,   Init(@SELF, ID_FILESTR5 , '' ,128, 158, W, H, 13 ));
    P^.EnableTransfer;
    P := New(PBorStatic,   Init(@SELF, ID_FILESTR6 , '' ,128, 192, W, H, 13 ));
    P^.EnableTransfer;

    P := New(PBorStatic,   Init(@SELF, ID_ICONFILE , '', 146, 264, W, H, 13 ));
    P^.EnableTransfer;

    W := LoWord(GetTextExtent(DC,'Wait For FileXXX',16)) ;

    P := New(PCheckBox, Init(@SELF, ID_WAIT, 'Wait For File', 84, 292, W,H+4, Nil));
    P^.EnableTransfer;

    W := LoWord(GetTextExtent(DC,'Repeat WaitXXX',15)) ;
    P := New(PCheckBox, Init(@SELF, ID_REPEAT, 'Repeat Wait', 36, 328, W, H+4, Nil));
    P^.EnableTransfer;
    W := LoWord(GetTextExtent(DC,'ParallelXXX',12)) ;
    P := New(PRadioButton, Init(@SELF, ID_SERIAL, 'Serial', 165, 314, W, H+4, Nil));
    P^.EnableTransfer;
    P := New(PRadioButton, Init(@SELF, ID_PARALLEL, 'Parallel',165, 340, W, H+4, Nil));
		P^.EnableTransfer;

	 P := New(PButtMan, Init(@SELF, ID_BTN1, '&1', 46, 16,  28, 28, TRUE ));
    P^.Attr.Style := P^.Attr.Style OR bs_PushButton OR ws_Group OR ws_TabStop;

	 P := New(PButtMan, Init(@SELF, ID_BTN2, '&2', 46, 50,  28, 28, FALSE ));
    P^.Attr.Style := P^.Attr.Style OR bs_PushButton OR ws_Group OR ws_TabStop;
	 P := New(PButtMan, Init(@SELF, ID_BTN3, '&3', 46, 84,  28, 28, FALSE ));
    P^.Attr.Style :=P^.Attr.Style OR WS_GROUP ;
    P^.Attr.Style := P^.Attr.Style OR bs_PushButton OR ws_Group OR ws_TabStop;
	 P := New(PButtMan, Init(@SELF, ID_BTN4, '&4', 46, 118, 28, 28, FALSE ));
    P^.Attr.Style :=P^.Attr.Style OR WS_GROUP ;
	 P := New(PButtMan, Init(@SELF, ID_BTN5, '&5', 46, 152, 28, 28, FALSE ));
    P^.Attr.Style :=P^.Attr.Style OR WS_GROUP ;
	 P := New(PButtMan, Init(@SELF, ID_BTN6, '&6', 46, 186, 28, 28, FALSE ));
    P^.Attr.Style :=P^.Attr.Style OR WS_GROUP ;

    P := New(PIcon,  Init(@SELF, ID_ICON1 ,80, 14, 32, 32 ));
    PIcon(P)^.Exe_Name := @(The_Setup.DK_Array[1].FileName) ;
    PIcon(P)^.Icon_Index := 0 ;

    P := New(PIcon,  Init(@SELF, ID_ICON2 ,80, 48, 32, 32));
    PIcon(P)^.Exe_Name := @(The_Setup.DK_Array[2].FileName) ;
    PIcon(P)^.Icon_Index := 0 ;

    P := New(PIcon,  Init(@SELF, ID_ICON3 ,80, 82, 32, 32));
    PIcon(P)^.Exe_Name := @(The_Setup.DK_Array[3].FileName) ;
    PIcon(P)^.Icon_Index := 0 ;

    P := New(PIcon,  Init(@SELF, ID_ICON4 ,80, 116, 32, 32));
    PIcon(P)^.Exe_Name := @(The_Setup.DK_Array[4].FileName) ;
    PIcon(P)^.Icon_Index := 0 ;

    P := New(PIcon,  Init(@SELF, ID_ICON5 ,80, 150, 32, 32));
    PIcon(P)^.Exe_Name := @(The_Setup.DK_Array[5].FileName) ;
		PIcon(P)^.Icon_Index := 0 ;

    P := New(PIcon,  Init(@SELF, ID_ICON6 ,80, 184, 32, 32));
    PIcon(P)^.Exe_Name := @(The_Setup.DK_Array[6].FileName) ;
    PIcon(P)^.Icon_Index := 0 ;

	 P := New(PButton, Init(@Self, ID_DN1, 'BorBtn', 26, 30, 16, 16 , FALSE ));
    P^.Attr.Style := P^.Attr.Style OR BBS_OWNERDRAW AND ( NOT WS_TABSTOP );

	 P := New(PButton, Init(@Self, ID_UP2, 'BorBtn', 26, 48, 16, 16 , FALSE ));
    P^.Attr.Style := P^.Attr.Style OR BBS_OWNERDRAW AND ( NOT WS_TABSTOP );

	 P := New(PButton, Init(@Self, ID_DN2, 'BorBtn', 26, 64, 16, 16 , FALSE ));
    P^.Attr.Style := P^.Attr.Style OR BBS_OWNERDRAW AND ( NOT WS_TABSTOP );

	 P := New(PButton, Init(@Self, ID_UP3, 'BorBtn', 26, 82, 16, 16 , FALSE ));
    P^.Attr.Style := P^.Attr.Style OR BBS_OWNERDRAW AND ( NOT WS_TABSTOP );

	 P := New(PButton, Init(@Self, ID_DN3, 'BorBtn', 26, 98, 16, 16 , FALSE ));
    P^.Attr.Style := P^.Attr.Style OR BBS_OWNERDRAW AND ( NOT WS_TABSTOP );

	 P := New(PButton, Init(@Self, ID_UP4, 'BorBtn', 26, 116, 16, 16 , FALSE ));
    P^.Attr.Style := P^.Attr.Style OR BBS_OWNERDRAW AND ( NOT WS_TABSTOP );

	 P := New(PButton, Init(@Self, ID_DN4, 'BorBtn', 26, 132, 16, 16 , FALSE ));
    P^.Attr.Style := P^.Attr.Style OR BBS_OWNERDRAW AND ( NOT WS_TABSTOP );

	 P := New(PButton, Init(@Self, ID_UP5, 'BorBtn', 26, 150, 16, 16 , FALSE ));
    P^.Attr.Style := P^.Attr.Style OR BBS_OWNERDRAW AND ( NOT WS_TABSTOP );

	 P := New(PButton, Init(@Self, ID_DN5, 'BorBtn', 26, 166, 16, 16 , FALSE ));
    P^.Attr.Style := P^.Attr.Style OR BBS_OWNERDRAW AND ( NOT WS_TABSTOP );

	 P := New(PButton, Init(@Self, ID_UP6, 'BorBtn', 26, 184, 16, 16 , FALSE ));
    P^.Attr.Style := P^.Attr.Style OR BBS_OWNERDRAW AND ( NOT WS_TABSTOP );

	 P := New(PButton, Init(@Self, ID_ICON, '&Icon', 54, 254, 36, 36 , FALSE ));

    APP_ICON := New(PIcon,  Init(@SELF, ID_APPICON ,102, 256, 32, 32));
    APP_ICON^.Exe_Name := @(The_Setup.IFile) ;
    APP_ICON^.Icon_Index := The_Setup.INum ;

	 P := New(PButton, Init(@Self, ID_UPICON, 'BorBtn', 34, 256, 16, 16 , FALSE ));
    P^.Attr.Style := P^.Attr.Style OR BBS_OWNERDRAW AND ( NOT WS_TABSTOP );
	 P := New(PButton, Init(@Self, ID_DNICON, 'BorBtn', 34, 272, 16, 16 , FALSE ));
    P^.Attr.Style := P^.Attr.Style OR BBS_OWNERDRAW AND ( NOT WS_TABSTOP );

    P := New(PButton, Init(@Self, IDOK, '', 12, 368, 64, 40, FALSE ));
    P := New(PButton, Init(@Self, ID_RUN, 'RUN', (Attr.W Div 2) -32 , 368, 64, 40, FALSE ));
    P := New(PButton, Init(@Self, 998, '', Attr.W-(64+14), 368, 64, 40, FALSE ));

    P := New(PButtMan, Init(@Self, ID_SAVE, '&SAVE', 12, 412, 64, 23, FALSE ));
    P := New(PButtMan, Init(@Self, ID_NEW , '&NEW', (Attr.W Div 2) -32, 412, 64, 23, FALSE ));
    P := New(PButtMan,Init(@Self, ID_LOAD, '&LOAD', Attr.W-(64+14), 412, 64, 23, FALSE ));

    ReleaseDC(HWindow,DC);

    EnableKbHandler;

    UpDateFileNames;

    {FUCK}
  End;

  PROCEDURE TDropKickWin.SetUpWindow;
  VAR SysMenu : hMenu;
  BEGIN
    TWindow.SetUpWindow;
    SysMenu := GetSystemMenu(hWindow, FALSE);
    RemoveMenu(SysMenu, sc_Restore, mf_ByCommand);
		RemoveMenu(SysMenu, sc_Size, mf_ByCommand);
		RemoveMenu(SysMenu, sc_Minimize, mf_ByCommand);
    RemoveMenu(SysMenu, sc_Maximize, mf_ByCommand);
  END;

  DESTRUCTOR TDropKickWin.Done;
  BEGIN
    DragAcceptFiles(hWindow, FALSE);
    TWindow.Done;
  END;

  FUNCTION TDropKickWin.GetClassName;
  Const
    CName : Array[0..20] of Char = #0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0;
  Var  ST : String;
  BEGIN
    Str( Inst_Num,ST );
    ST := 'DK'+ST+#0 ;
    StrPCopy(CName,ST);
    GetClassName := CName ;
  END;

  PROCEDURE TDropKickWin.GetWindowClass(VAR AWndClass : TWndClass);
  BEGIN
    TWindow.GetWindowClass(AWndClass);
    AWndClass.hIcon := LoadIcon(HInstance, PChar(DK_1));
    My_Icon := AWndClass.hIcon ;
  END;

  PROCEDURE TDropKickWin.wmQueryOpen(VAR Msg : TMessage);
  Var
    PC : Array[0..256] of Char ;
  BEGIN

    If RunStep<7 then
		Begin
			 Msg.Result := $0;
       MessageBox( HWindow,'Sorry!'+#13+#13+'I can''t interupt the Batch!','DROP KICK', MB_ICONSTOP + MB_OK);
       QUIT_WHEN_FINISHED := FALSE ;
       exit ;
    End;

    Msg.Result := $1;

		StrPCopy(PC,'Drop Kick - '+THE_SETUP.TITLE);

		If The_Setup.TITLE = '' then
			SetWindowText( HWindow , 'Drop Kick Batch File Builder')
		Else
			SetWindowText( HWindow , PC );
 END;

	PROCEDURE TDropKickWin.Browse_ICON(VAR Msg : TMessage);
	Var
		A_File : Array[0..fsPathName] of Char;
		STR1    : Array[0..256] of Char ;
    Dir: array[0..fsDirectory] of Char;
    Name: array[0..fsFileName] of Char;
    Ext: array[0..fsExtension] of Char;
    PFD  : PFileDialog ;
  Begin

    TransferData(tf_GetData);
    The_Setup.Setup := Xfer.Setup ;
    The_Setup.Title := StrPas(Xfer.Title);

    StrPCopy(A_File,The_Setup.IFile) ;

    If Application^.ExecDialog(New(PCDFileOpen,
       Init(@Self, ofn_FileMustExist, A_File, SizeOf(A_File), DKIcoFilter))) = id_Ok then
    Begin
      FileExpand( STR1 , A_File );
      The_Setup.IFile := StrPas( STR1 );
      The_Setup.INum := 0 ;
      UpdateFileNames;
    End;
  End;

  PROCEDURE TDropKickWin.wmCommand(VAR Msg : TMessage);
  BEGIN
    If (Msg.LParamLo <> 0) AND ( Msg.LParamHi<> 1 ) then
    Begin
      Case Msg.WParam of
        ID_UP2 : UP_PRESSED(2);
        ID_UP3 : UP_PRESSED(3);
        ID_UP4 : UP_PRESSED(4);
        ID_UP5 : UP_PRESSED(5);
        ID_UP6 : UP_PRESSED(6);
        ID_DN1 : DN_PRESSED(1);
        ID_DN2 : DN_PRESSED(2);
				ID_DN3 : DN_PRESSED(3);
        ID_DN4 : DN_PRESSED(4);
        ID_DN5 : DN_PRESSED(5);

        ID_UPICON : Begin
                      If The_Setup.INum >= Max_Icon(The_Setup.IFile) then
                         Exit ;
                      Inc(The_Setup.INum);
                      If The_Setup.INum > Max_Icon(The_Setup.IFile) then
                         Dec( The_Setup.INum );
                      APP_ICON^.ICON_INDEX := The_Setup.INum ;
                      InValidateRect( APP_ICON^.HWindow , Nil , TRUE );
                    End;
        ID_DNICON : Begin
                      If THE_SETUP.INUM > 0 then
                        Dec(THE_SETUP.INUM);
                      APP_ICON^.ICON_INDEX := The_Setup.INum ;
                      InValidateRect( APP_ICON^.HWindow , Nil , TRUE );
                    End;
        else
            TWindow.wmCommand(MSG);
        End;
    End
    Else
        TWindow.wmCommand(MSG);
  END;

  PROCEDURE TDropKickWin.wmDropFiles(VAR Msg : TMessage);
  Var
    NFiles : Word ;
    THand  : THandle ;
    Buff   : Array[0..1024] of Char ;
    P1     : Array[0..256] of Char ;
    N      : Word ;
  BEGIN
		Msg.Result := 0;

    THand := Msg.wParam ;
    NFiles := DragQueryFile(THand,$FFFF,Buff,1024);

    If The_Setup.Setup.Serial_Files = 1 then
    For N := 0 to NFiles-1 do
    Begin
      DragQueryFile(THand,N,p1,256);
      AWaken(P1);
    End
    Else
    Begin
      DragQueryFile(THand,0,Buff,256);
      For N := 1 to NFiles-1 do
      Begin
        DragQueryFile(THand,N,P1,256);
        StrLCat(Buff,' ',1024);
        StrLCat(Buff,P1,1024);
      End;
      AWaken(Buff);
    End;
    DragFinish(Msg.wParam);
  END;

  PROCEDURE TDropKickWin.wmDrawItem(VAR Msg : TMessage);
  Var
     Pict,ob  : hBitMap ;
     BitDC    : hDC ;
  BEGIN
    WITH PDrawItemStruct(Msg.lParam)^ DO
    Begin
      If CtlType <> odt_Button then Exit ;
      If ( ItemAction AND ( oda_DrawEntire OR oda_Focus ) <> 0 ) then
      Begin
				Case ctlid of
          ID_DN1,ID_DN2,ID_DN3,ID_DN4,ID_DN5,ID_DNICON :
              Begin
                If ( ItemState AND ( ODS_FOCUS OR ODS_SELECTED )) = 0 then
                  Pict := LoadBitMap(hInstance,Pchar(DN1));
                If ( ItemState AND ( ODS_FOCUS OR ODS_SELECTED )) = ODS_SELECTED then
                  Pict := LoadBitMap(hInstance,Pchar(DN2));
                If ( ItemState AND ( ODS_FOCUS OR ODS_SELECTED )) = ODS_FOCUS then
                  Pict := LoadBitMap(hInstance,Pchar(DN1F));
                If ( ItemState AND ( ODS_FOCUS OR ODS_SELECTED )) = (ODS_FOCUS OR ODS_SELECTED) then
                  Pict := LoadBitMap(hInstance,Pchar(DN2F));
              End;
          ID_UP2,ID_UP3,ID_UP4,ID_UP5,ID_UP6,ID_UPICON :
              Begin
                If ( ItemState AND ( ODS_FOCUS OR ODS_SELECTED )) = 0 then
                  Pict := LoadBitMap(hInstance,Pchar(UP1));
                If ( ItemState AND ( ODS_FOCUS OR ODS_SELECTED )) = ODS_SELECTED then
                  Pict := LoadBitMap(hInstance,Pchar(UP2));
                If ( ItemState AND ( ODS_FOCUS OR ODS_SELECTED )) = ODS_FOCUS then
                  Pict := LoadBitMap(hInstance,Pchar(UP1F));
                If ( ItemState AND ( ODS_FOCUS OR ODS_SELECTED )) = (ODS_FOCUS OR ODS_SELECTED) then
                  Pict := LoadBitMap(hInstance,Pchar(UP2F));
              End;
        End;
         bitDC := CreateCompatibleDC(hDC);
         ob := SelectObject(BitDC, Pict);
         BitBlt(hDC, 0 , 0 , 15 , 15 , BitDC , 0 , 0 , SrcCopy );
         SelectObject(BitDC, ob);
         DeleteDC(BitDC);
         DeleteObject(Pict);
      End;
    End;
  END;

  PROCEDURE TDropKickWin.Edit_Dlg(Var Msg: TMessage; N : Integer );
	Var
    ADlg	: PFileSetting_Dlg ;
    Rtrn_Val	: Integer ;
    P           : PControl ;
    X           : Integer ;
Begin

    TransferData(tf_GetData);
    The_Setup.Setup := Xfer.Setup ;
    The_Setup.Title := StrPas(Xfer.Title);

    ADlg := New(PFileSetting_Dlg, Init( @Self , PCHAR(FILE_SETTINGS)));
    ADlg^.TransferBuffer := @(ADlg^.Xfer);

    StrPCopy( ADlg^.XFER.FileName , The_Setup.DK_Array[N].FileName );
    StrPCopy( ADlg^.XFER.WorkDir  , The_Setup.DK_Array[N].Directory );
    StrPCopy( ADlg^.XFER.Params   , The_Setup.DK_Array[N].Params );
    ADlg^.XFER.ErrFlag  := The_Setup.DK_Array[N].AbortFlag ;
    ADlg^.XFER.WaitFlag := The_Setup.DK_Array[N].WaitFlag ;
    ADlg^.XFER.RUN_NORM := 0 ;
    ADlg^.XFER.RUN_ICON := 0 ;
    ADlg^.XFER.RUN_MAX := 0 ;

    Case The_Setup.DK_Array[N].Run_Mode of
      RUN_NORMAL : ADlg^.XFER.RUN_NORM := 1 ;
      RUN_ICONED : ADlg^.XFER.RUN_ICON := 1 ;
      RUN_MAXED  : ADlg^.XFER.RUN_MAX := 1 ;
    End;

    ADlg^.EnableTransfer ;

    P := New(PStatic,      InitResource(ADLG, ID_FILENAME , 65 ));
    P := New(PStatic,      InitResource(ADLG, ID_WorkDir  , 65 ));
    P := New(PStatic,      InitResource(ADLG, ID_ARGS     , 65 ));
    P := New(PCheckBox,    InitResource(ADLG, ID_ERRABORT      ));
		P := New(PCheckBox,    InitResource(ADLG, ID_WAITCOMP      ));
    P := New(PRadioButton, InitResource(ADLG, ID_RUN_NORMAL    ));
    P := New(PRadioButton, InitResource(ADLG, ID_RUN_ICONED    ));
    P := New(PRadioButton, InitResource(ADLG, ID_RUN_MAXED     ));

    Rtrn_Val := Application^.ExecDialog(ADlg);

    If Rtrn_Val = IDOK then
    Begin
      The_Setup.DK_Array[N].FileName  := StrPas( ADlg^.XFER.FileName );
      The_Setup.DK_Array[N].Directory := StrPas( ADlg^.XFER.WorkDir  );
      The_Setup.DK_Array[N].Params    := StrPas( ADlg^.XFER.Params   );
      The_Setup.DK_Array[N].AbortFlag := ADlg^.XFER.ErrFlag ;
      The_Setup.DK_Array[N].WaitFlag  := ADlg^.XFER.WaitFlag ;
      If ADlg^.XFER.RUN_NORM = 1
        Then The_Setup.DK_Array[N].RUN_MODE := RUN_NORMAL ;
      If ADlg^.XFER.RUN_ICON = 1
        Then The_Setup.DK_Array[N].RUN_MODE := RUN_ICONED ;
      If ADlg^.XFER.RUN_MAX = 1
        Then The_Setup.DK_Array[N].RUN_MODE := RUN_MAXED ;
    End;
    UpdateFileNames ;
  End;

  Procedure GetFileName( Dest : PChar ; FileName : String );
  Var
    STR1: Array[0..256] of Char ;
    STR2: Array[0..256] of Char ;
    Dir:  Array[0..fsDirectory] of Char;
    Name: Array[0..fsFileName] of Char;
    Ext:  Array[0..fsExtension] of Char;
  Begin
    StrPCopy( STR1 , FileName );
    FileExpand( STR2 , STR1 );
    FileSplit(STR2, Dir, DEST, Ext);
		StrCat(DEST,Ext);
  End;

  PROCEDURE TDropKickWin.UpDateFileNames;
  BEGIN
    GetFileName( XFER.FNames[1] , The_Setup.DK_Array[1].FileName );
    GetFileName( XFER.FNames[2] , The_Setup.DK_Array[2].FileName );
    GetFileName( XFER.FNames[3] , The_Setup.DK_Array[3].FileName );
    GetFileName( XFER.FNames[4] , The_Setup.DK_Array[4].FileName );
    GetFileName( XFER.FNames[5] , The_Setup.DK_Array[5].FileName );
    GetFileName( XFER.FNames[6] , The_Setup.DK_Array[6].FileName );
    GetFileName( XFER.FNames[7] , The_Setup.IFile );
    APP_ICON^.Icon_Index := The_Setup.INum ;

    TRANSFERDATA( tf_SetData );
    InValidateRect( HWindow , Nil , False );
  END;

  PROCEDURE TDropKickWin.Edit_1(Var Msg: TMessage);
  Begin
    Edit_Dlg(Msg,1);
  End;

  PROCEDURE TDropKickWin.Edit_2(Var Msg: TMessage);
  Begin
    Edit_Dlg(Msg,2);
  End;

  PROCEDURE TDropKickWin.Edit_3(Var Msg: TMessage);
  Begin
    Edit_Dlg(Msg,3);
  End;

  PROCEDURE TDropKickWin.Edit_4(Var Msg: TMessage);
  Begin
		Edit_Dlg(Msg,4);
  End;

  PROCEDURE TDropKickWin.Edit_5(Var Msg: TMessage);
  Begin
    Edit_Dlg(Msg,5);
  End;

  PROCEDURE TDropKickWin.Edit_6(Var Msg: TMessage);
  Begin
    Edit_Dlg(Msg,6);
  End;

  Procedure TDropKickWin.Up_Pressed( N : Integer );
  Var
    DKR : DropKick_Record;
  Begin
    DKR := The_Setup.DK_Array[N-1] ;
    The_Setup.DK_Array[N-1] := The_Setup.DK_Array[N] ;
    The_Setup.DK_Array[N] := DKR ;
    UpDateFileNames ;
  End;

  Procedure TDropKickWin.DN_Pressed( N : Integer );
  Var
    DKR : DropKick_Record;
  Begin
    DKR := The_Setup.DK_Array[N+1] ;
    The_Setup.DK_Array[N+1] := The_Setup.DK_Array[N] ;
    The_Setup.DK_Array[N] := DKR ;
    UpDateFileNames ;
  End;

  Function TDropKickWin.Do_Save : Boolean ;
  Var
		F_Name	: String ;
    F	: DropKick_File;
    A : Integer ;
    A_File :  Array[0..fsPathName] of Char;
    Dir    :  Array[0..fsPathName] of Char;
    Ext	  :  Array[0..8] of Char;
    PFD    :  PFileDialog ;
  Begin
    TransferData(tf_GetData);
    The_Setup.Setup := Xfer.Setup ;
    The_Setup.Title := StrPas(Xfer.Title);

    If DropFileName[0]=#0 then
       StrCopy( A_File , '*.DK' )
    Else
       StrCopy( A_File, DropFileName);

    If Application^.ExecDialog(New(PCDFileSaveAs, Init(@Self,
      ofn_PathMustExist, A_File, SizeOf(A_File), DKFileFilter))) = idOk then
    Begin
      F_Name := StrPas( A_File );

      If FileExists(F_Name) then
        IF MessageBox(hWindow, 'File exists. '+'Overwrite?', A_File, mb_YesNo +
          mb_IconQuestion) <> IDYes THEN
          Begin
            Do_Save := False ;
            Exit;
          End;

      StrCopy( DropFileName , A_File );

      Assign( F , F_Name );

	   {$I-}
			Rewrite(F);
      {$I+}
      A := IORESULT ;
      If A<>0 then
      Begin
        If A=5 then
          MessageBox(hWindow, 'File write access denied!', 'Sorry!', MB_OK + MB_ICONSTOP)
        Else
          MessageBox(hWindow, 'Error writing the file!', 'Sorry!', MB_OK + MB_ICONSTOP);
        Do_Save := False ;
        Exit;
      End;

      Write( F , The_Setup );
      Close(F);

      Do_Save := TRUE ;
      Original := The_Setup ;
      Exit;
    End;

    Do_Save := False ;
  End;

  Procedure TDropKickWin.Save(Var Msg: TMessage);
  Begin
    Do_Save ;
  End;

  Procedure TDropKickWin.Load(Var Msg: TMessage);
  Var
    A_File  : Array[0..fsPathName] of Char;
    F_Name  : String ;
    F	      : DropKick_File ;
  Begin
		If DropFileName[0]=#0 then
       StrCopy( A_File , '*.DK' )
    Else
       StrCopy( A_File, DropFileName);

    If Application^.ExecDialog(New(PCDFileOpen,
       Init(@Self, ofn_FileMustExist, A_File, SizeOf(A_File), DKFileFilter))) = id_Ok then
    Begin
      F_Name := StrPas( A_File );
      If Not( FileExists( F_Name )) then
	     MessageBox( 0,'File Does Not Exist!',AppName,MB_OK+MB_IconStop)
      Else
      Begin
	     StrCopy( DropFileName , A_File );
	     Assign( F , F_Name );
	     Reset(F);
	       Read( F , The_Setup );
	     Close(F);
        Original := The_Setup;
        Xfer.Setup := The_Setup.Setup;
        STRPCOPY(XFER.TITLE,The_Setup.Title);
      End;
    End;
    UpDateFileNames;
  End;

  Function TDropKickWin.CanClose:Boolean ;
  Var
    Rtn_Val : Integer ;
    Msg     : TMessage ;
  Begin
    TransferData(tf_GetData);
    The_Setup.Setup := XFER.Setup;
    The_Setup.Title := StrPas(Xfer.Title);
    CanClose := TRUE ;
		If Not(File_Has_Changed) then
      Exit;

    Rtn_Val := Application^.ExecDialog(New( PFileUpdate_Dlg , Init( @Self , 'SAVE_UPDATE' )));
    if Rtn_Val = IDCANCEL then
    Begin
      CanClose := FALSE ;
      Exit ;
    End;

    If Rtn_Val = IDNO then
    Begin
      CanClose := TRUE ;
      Exit ;
    End;

    CanClose := Do_Save;

  End;

  Procedure TDropKickWin.ActuallyRunIt;
  VAR
    Error : Boolean ;
    PC : Array[0..256] of Char;
  BEGIN

    DestroyIcon( My_Icon );

    StrPCopy(PC,The_Setup.IFile);
    My_Icon := ExtractIcon(HInstance,PC,The_Setup.INum);
    SetClassWord( HWindow , GCW_HICON , My_Icon );

		StrPCopy(PC,'Drop Kick '+#10+THE_SETUP.TITLE);

		If The_Setup.TITLE = '' then
      SetWindowText( HWindow , 'Drop Kick')
    Else
      SetWindowText( HWindow , PC );

    ShowWindow( HWindow , sw_ShowMinNoActive );

    If The_Setup.Setup.Wait_For_File = 1 then
    Begin
       DragAcceptFiles(hWindow, TRUE);
       Exit ;
    End;

    AWaken('');

  End;

  Procedure TDropKickWin.AWaken( S : PChar );
  VAR
    Error : Boolean ;
  Begin
    RunStep := 1 ;
    Error := FALSE ;

    While (RunStep < 7) AND NOT(LEAVE_NOW) do
    Begin
      If ERROR = FALSE then
        ERROR := Not(Run_Step(The_Setup.DK_Array[RunStep],S));
      Inc(RunStep);
    End;                                             

		If The_Setup.Setup.Repeat_Wait = 0 then
    Begin
      DragAcceptFiles( HWindow, FALSE );
      If QUIT_WHEN_FINISHED then
          PostQuitMessage(0)
      Else
          ShowWindow( HWindow , sw_ShowNormal );
    End;

  End;

  FUNCTION TDropKickWin.Run_Step( RunRec : DropKick_Record ; S : PChar ) : Boolean;
  VAR
    W : Array[0..1024] of Char ;
    X : PChar ;
    R : Array[0..1024] of Char ;
    CMDLINE : Array[0..1024] of Char ;
    OrgDir  : Array[0..256] of Char ;
    NewDir  : Array[0..256] of Char ;
    ErrMsg  : Array[0..256] of Char ;
    EH : Word ;
    M  : TMsg ;
  Begin
    Run_Step := TRUE ;

    If RunRec.FileName = '' then
      Exit ;

    StrPCopy(W,RunRec.Params) ;
    While StrPos(W,'%1')<>Nil do
    Begin
      X := StrPos(W,'%1');
      X^ := #0 ;
      StrCopy(R,X+2);
      StrLCat(W,S,1024);
			StrLCat(W,R,1024);
    End;

    StrPCopy( CmdLine ,RunRec.FileName + ' ');
    StrLCat(CmdLine, W ,1024);
    StrPCopy( NewDir  ,RunRec.Directory );
    GetCurDir(OrgDir,0);
    SetCurDir(NewDir);

    Case RunRec.Run_Mode of
      Run_Normal : EH := WinExec(CmdLine,SW_SHOW);
      Run_Iconed : EH := WinExec(CmdLine,SW_SHOWMINIMIZED);
      Run_Maxed  : EH := WinExec(CmdLine,SW_SHOWMAXIMIZED);
    End;

    If EH <32 then
    Begin
      Case EH of
        0        : StrPCopy( ERRMSG, 'Memory Error!' ) ;
        2        : StrPCopy( ERRMSG, 'File was not found!');
        3        : StrPCopy( ERRMSG, 'Path was not found!');
        8        : StrPCopy( ERRMSG, 'Insufficient memory!');
        10,15    : StrPCopy( ERRMSG, 'Wrong Windows version!');
        11,14,19 : StrPCopy( ERRMSG, 'Invalid Executable file!');
        12,13    : StrPCopy( ERRMSG, 'Wrong operating system!');
        20       : StrPCopy( ERRMSG, 'Bad DLL!');
        21       : StrPCopy( ERRMSG, 'Application WIN32!');
      Else
         StrPCopy( ERRMSG, 'Execution Error!');
      End;
      MessageBox( HWindow, ERRMSG, 'DROP KICK', MB_ICONSTOP);
      If RunRec.AbortFlag = 1 then
        Run_Step := FALSE ;
      Exit ;
    End;

    If RunRec.WaitFlag = 1 then
    Begin
      REPEAT
        WHILE PeekMessage(M, 0, 0, 0, PM_REMOVE) DO
        BEGIN
          IF M.Message = WM_QUIT THEN
          BEGIN
            Leave_Now := TRUE ;
            PostQuitMessage(M.wParam);
            Exit;
          END
          ELSE
          BEGIN
            TranslateMessage(M);
            DispatchMessage(M);
          END;
        END;
      UNTIL GetModuleUsage(EH) = 0;
    End;

    SetCurDir(OrgDir);
  End;

  Procedure TDropKickWin.RUN_Pressed( Var MSG : TMessage );
  Begin
    QUIT_WHEN_FINISHED := FALSE ;
    TransferData(tf_GetData);
    The_Setup.Setup := Xfer.Setup ;
    The_Setup.Title := StrPas(Xfer.Title);
    ActuallyRunit ;
  End;

  PROCEDURE TDropKickWin.idHelp(VAR Msg : TMessage);
	BEGIN
		Application^.ExecDialog(New(PDialog,
      Init(@Self, 'DROPHELP')));
  END;

  PROCEDURE TDropKickWin.Ok(Var Msg: TMessage);
  Begin
    If CanClose then PostQuitMessage(0);
  End;

  PROCEDURE TDropKickWin.DefWndProc(Var Msg : TMessage );
  Begin
    If ( Msg.MESSAGE = WM_CTLCOLOR  ) or
			 ( Msg.MESSAGE = WM_NCCREATE  ) or
       ( Msg.MESSAGE = WM_NCDESTROY ) or
       ( Msg.MESSAGE = WM_PAINT     ) or
       ( Msg.MESSAGE = WM_ERASEBKGND) Then
         BWCCDefWindowProc(HWindow,Msg.Message,Msg.wParam,Msg.lParam)
    Else
       TWindow.DefWndProc(Msg);
  End;

Function TButtMan.GetClassName : PChar ;
Begin
  GetClassName := 'Button' ;
End;

Function TBorStatic.GetClassName : PChar ;
Begin
  GetClassName := 'BorStatic' ;
End;

Constructor TIcon.Init(AParent: PWindowsObject; AnId: Integer; X,Y,W,H: Integer);
Begin
	TStatic.Init(AParent,AnID,'',X,Y,W,H,1);
End;

Procedure TIcon.WMPaint( Var MSG : TMessage );
Begin
  TWindow.WMPaint( Msg );
End;

Procedure TIcon.PAINT(pDC : hDC ; Var PS : TPaintStruct);
Var
  TR : TRect ;
  Hi : hIcon ;
  PC : Array[0..256] of Char ;
Begin
	strPcopy(PC,Exe_Name^);
	GetClientRect(hWindow, TR);
	Hi := ExtractIcon(HInstance,PC,ICON_INDEX);
	If Hi<2 then
		Hi := LoadIcon(0,Pchar(IDI_APPLICATION));
	FillRect(pDC,TR,GetStockObject(LTGray_Brush));
	DrawIcon(pDC,0,0,Hi);
	DestroyIcon(Hi);
End;

{--------------------------------------------------}
{ TMyApplication's method implementations:         }
{--------------------------------------------------}
  PROCEDURE TMyApplication.InitMainWindow;
  BEGIN
    MainWindow := New(PDropKickWin, Init(Nil, AppName));
  END;

{--------------------------------------------------}
{ Main program:                                    }
{--------------------------------------------------}
Var
  X : Integer ;
	F : DropKick_File ;
  W : Word ;
  M : TMessage ;
BEGIN

{  If HPrevInst = 0 then
    Inst_Num := 1
  Else
  Begin
    GetInstanceData(HPrevInst, PBYTE(Ofs(Inst_Num)), Sizeof(Inst_Num));
    Inc(Inst_Num);
    MessageBeep(1);
	End;}

  Inst_Num := HInstance ;

  FileMode := 0 ;
  RunStep := 10 ;

  With The_Setup do
  Begin
    For X := 1 to 6 do
      DK_Array[X] := Blank_DK_Record ;

    Setup.Wait_For_File := 0 ;
    Setup.Repeat_Wait := 0 ;
    Setup.Serial_Files := 1 ;
    Setup.Parallel_Files := 0 ;
    IFILE:='DROPKICK.EXE' ;
    INUM := 0 ;
    TITLE:='';
  End;

  Original := The_Setup ;

	DropFileName[0] := #0;

  QUIT_WHEN_FINISHED := FALSE ;

  If ParamCount>0 then
  Begin
    QUIT_WHEN_FINISHED := TRUE ;
		If FileExists(ParamStr(1)) then
		Begin
		 Assign( F , ParamStr(1) );
		 Reset(F);
		 Read( F , The_Setup );
		 Close(F);
      Original := The_Setup ;
      CMDSHOW := SW_MINIMIZE ;
      StrPCopy( DropFileName , ParamStr(1));
    End
  End;

  MyApp.Init(AppName);

  IF QUIT_WHEN_FINISHED Then
  Begin
    If Not(FileExists(ParamStr(1))) then
      MessageBox( MyApp.MainWindow^.HWindow, 'Batch File Not Found!', 'DROP KICK', MB_ICONSTOP)
    Else
    Begin
      PDropKickWin(MyApp.MainWindow)^.Xfer.Setup := The_Setup.Setup;
      PDropKickWin(MyApp.MainWindow)^.UpdateFileNames;
      PDropKickWin(MyApp.MainWindow)^.ActuallyRunit;
    End;
  End;

  LEAVE_NOW := False ;

	MyApp.Run;
  MyApp.Done;
END.
